/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.HashSet;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public class UnitWas {
    private static final Logger logger = Logger.getLogger(UnitWas.class.getName());
    private Unit unit;
    private UnitType type;
    private Unit.Role role;
    private Location loc;
    private GoodsType work;
    private int workAmount;
    private Colony colony;
    private GoodsContainer goodsContainer;
    private TypeCountMap<EquipmentType> equipment;

    public UnitWas(Unit unit) {
        this.unit = unit;
        this.type = unit.getType();
        this.role = unit.getRole();
        this.loc = unit.getLocation();
        this.work = unit.getWorkType();
        this.workAmount = this.getAmount(this.loc, this.work);
        this.colony = unit.getColony();
        this.equipment = new TypeCountMap();
        this.equipment.add(unit.getEquipment());
        if (unit.getGoodsContainer() != null) {
            unit.getGoodsContainer().saveState();
        }
    }

    public void fireChanges() {
        UnitType newType = null;
        Unit.Role newRole = null;
        Location newLoc = null;
        GoodsType newWork = null;
        int newWorkAmount = 0;
        TypeCountMap<EquipmentType> newEquipment = null;
        if (!this.unit.isDisposed()) {
            newLoc = this.unit.getLocation();
            if (this.colony != null) {
                newType = this.unit.getType();
                newRole = this.unit.getRole();
                newWork = this.unit.getWorkType();
                newWorkAmount = newWork == null ? 0 : this.getAmount(newLoc, newWork);
                newEquipment = this.unit.getEquipment();
            }
        }
        if (this.loc != newLoc) {
            FreeColGameObject oldFcgo = (FreeColGameObject)((Object)this.loc);
            oldFcgo.firePropertyChange(this.change(oldFcgo), this.unit, null);
            if (newLoc != null) {
                FreeColGameObject newFcgo = (FreeColGameObject)((Object)newLoc);
                newFcgo.firePropertyChange(this.change(newFcgo), null, this.unit);
            }
        }
        if (this.colony != null) {
            String pc;
            if (this.type != newType && newType != null) {
                pc = Colony.ColonyChangeEvent.UNIT_TYPE_CHANGE.toString();
                this.colony.firePropertyChange(pc, this.type, newType);
            } else if (this.role != newRole && newRole != null) {
                pc = "TILE_UNIT_CHANGE".toString();
                this.colony.firePropertyChange(pc, this.role.toString(), newRole.toString());
            }
            if (this.work == newWork) {
                if (this.work != null && this.workAmount != newWorkAmount) {
                    this.colony.firePropertyChange(this.work.getId(), this.workAmount, newWorkAmount);
                }
            } else {
                if (this.work != null) {
                    this.colony.firePropertyChange(this.work.getId(), this.workAmount, 0);
                }
                if (newWork != null) {
                    this.colony.firePropertyChange(newWork.getId(), 0, newWorkAmount);
                }
            }
        }
        if (newEquipment != null) {
            HashSet<EquipmentType> keys = new HashSet<EquipmentType>();
            keys.addAll(this.equipment.keySet());
            keys.addAll(newEquipment.keySet());
            for (EquipmentType e : keys) {
                int cNew;
                int cOld = this.equipment.getCount(e);
                if (cOld == (cNew = newEquipment.getCount(e))) continue;
                this.unit.firePropertyChange("EQUIPMENT_CHANGE", cOld, cNew);
            }
        }
        if (this.unit.getGoodsContainer() != null) {
            this.unit.getGoodsContainer().fireChanges();
        }
    }

    private String change(FreeColGameObject fcgo) {
        return fcgo instanceof Tile ? "TILE_UNIT_CHANGE" : (fcgo instanceof Europe ? "unitChange" : (fcgo instanceof ColonyTile ? "UNIT_CHANGE" : (fcgo instanceof Building ? "UNIT_CHANGE" : (fcgo instanceof Unit ? "CARGO_CHANGE" : null))));
    }

    private int getAmount(Location location, GoodsType goodsType) {
        if (goodsType != null) {
            if (location instanceof Building) {
                Building building = (Building)location;
                ProductionInfo info = building.getProductionInfo();
                return info == null || info.getProduction() == null || info.getProduction().size() == 0 ? 0 : info.getProduction().get(0).getAmount();
            }
            if (location instanceof ColonyTile) {
                return ((ColonyTile)location).getProductionOf(goodsType);
            }
        }
        return 0;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Location getLocation() {
        return this.loc;
    }

    public GoodsType getWorkType() {
        return this.work;
    }

    public String toString() {
        Tile tile = this.colony.getTile();
        String eqStr = "/";
        for (EquipmentType e : this.equipment.keySet()) {
            eqStr = eqStr + e.toString().substring(16, 17);
        }
        String locStr = this.loc == null ? "" : (this.loc instanceof Building ? ((Building)this.loc).getType().toString().substring(15) : (this.loc instanceof ColonyTile ? tile.getDirection(((ColonyTile)this.loc).getWorkTile()).toString() : (this.loc instanceof Tile ? this.loc.getId() + eqStr : this.loc.getId())));
        Location newLoc = this.unit.getLocation();
        String newEqStr = "/";
        for (EquipmentType e : this.unit.getEquipment().keySet()) {
            newEqStr = newEqStr + e.toString().substring(16, 17);
        }
        String newLocStr = newLoc == null ? "" : (newLoc instanceof Building ? ((Building)newLoc).getType().toString().substring(15) : (newLoc instanceof ColonyTile ? tile.getDirection(((ColonyTile)newLoc).getWorkTile()).toString() : (newLoc instanceof Tile ? newLoc.getId() + newEqStr : newLoc.getId())));
        GoodsType newWork = this.unit.getWorkType();
        int newWorkAmount = newWork == null ? 0 : this.getAmount(newLoc, newWork);
        return String.format("%-30s %-25s -> %-25s", this.unit.getId() + ":" + this.unit.getType().toString().substring(11), locStr + (this.work == null || this.workAmount <= 0 ? "" : "(" + Integer.toString(this.workAmount) + " " + this.work.toString().substring(12) + ")"), newLocStr + (newWork == null || newWorkAmount <= 0 ? "" : "(" + Integer.toString(newWorkAmount) + " " + newWork.toString().substring(12) + ")"));
    }
}

