/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.UnitListOption;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Monarch
extends FreeColGameObject
implements Named {
    private static final Logger logger = Logger.getLogger(Monarch.class.getName());
    public static final int MINIMUM_PRICE = 300;
    public static final int MINIMUM_TAX_RATE = 20;
    private String name;
    private Player player;
    private final List<AbstractUnit> landUnits = new ArrayList<AbstractUnit>();
    private final List<AbstractUnit> navalUnits = new ArrayList<AbstractUnit>();
    private boolean supportSea = false;
    private boolean displeasure = false;
    private int spaceRequired;
    private int capacity;

    public Monarch(Game game, Player player, String name) {
        super(game);
        if (player == null) {
            throw new IllegalStateException("player == null");
        }
        this.player = player;
        this.name = name;
        Specification spec = this.getSpecification();
        List ref = ((UnitListOption)spec.getOption("model.option.refSize")).getOptionValues();
        for (AbstractUnit unit : ref) {
            UnitType unitType = unit.getUnitType(spec);
            if (unitType.hasAbility("model.ability.refUnit")) {
                if (unitType.hasAbility("model.ability.navalUnit")) {
                    this.navalUnits.add(unit);
                    continue;
                }
                this.landUnits.add(unit);
                continue;
            }
            logger.warning("Found REF unit lacking ability \"model.ability.refUnit\": " + unit.toString());
        }
    }

    public Monarch(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Monarch(Game game, String id) {
        super(game, id);
    }

    private void updateSpaceAndCapacity() {
        Specification spec = this.getSpecification();
        this.capacity = 0;
        for (AbstractUnit nu : this.navalUnits) {
            if (!nu.getUnitType(spec).canCarryUnits()) continue;
            this.capacity += nu.getUnitType(spec).getSpace() * nu.getNumber();
        }
        this.spaceRequired = 0;
        for (AbstractUnit lu : this.landUnits) {
            this.spaceRequired += lu.getUnitType(spec).getSpaceTaken() * lu.getNumber();
        }
    }

    public boolean getSupportSea() {
        return this.supportSea;
    }

    public void setSupportSea(boolean supportSea) {
        this.supportSea = supportSea;
    }

    public boolean getDispleasure() {
        return this.displeasure;
    }

    public void setDispleasure(boolean displeasure) {
        this.displeasure = displeasure;
    }

    @Override
    public String getNameKey() {
        return this.name;
    }

    public List<AbstractUnit> getREF() {
        ArrayList<AbstractUnit> result = new ArrayList<AbstractUnit>(this.landUnits);
        result.addAll(this.navalUnits);
        return result;
    }

    public List<AbstractUnit> getREFNavalUnits() {
        return this.navalUnits;
    }

    public List<AbstractUnit> getREFLandUnits() {
        return this.landUnits;
    }

    private int taxMaximum() {
        return this.getSpecification().getIntegerOption("model.option.maximumTax").getValue();
    }

    public List<Player> collectPotentialEnemies() {
        ArrayList<Player> enemies = new ArrayList<Player>();
        if (!this.player.hasAbility("model.ability.ignoreEuropeanWars")) {
            for (Player enemy : this.getGame().getLiveEuropeanPlayers()) {
                if (enemy.isREF()) continue;
                switch (this.player.getStance(enemy)) {
                    case PEACE: 
                    case CEASE_FIRE: {
                        enemies.add(enemy);
                    }
                }
            }
        }
        return enemies;
    }

    public boolean actionIsValid(MonarchAction action) {
        switch (action) {
            case NO_ACTION: {
                return true;
            }
            case RAISE_TAX_ACT: 
            case RAISE_TAX_WAR: {
                return this.player.getTax() < this.taxMaximum();
            }
            case FORCE_TAX: {
                return false;
            }
            case LOWER_TAX_WAR: 
            case LOWER_TAX_OTHER: {
                return this.player.getTax() > 30;
            }
            case WAIVE_TAX: {
                return true;
            }
            case ADD_TO_REF: {
                return true;
            }
            case DECLARE_WAR: {
                return !this.collectPotentialEnemies().isEmpty();
            }
            case SUPPORT_SEA: {
                return this.player.getAttackedByPrivateers() && !this.getSupportSea() && !this.getDispleasure();
            }
            case SUPPORT_LAND: 
            case OFFER_MERCENARIES: {
                return this.player.isAtWar() && !this.getDispleasure();
            }
            case DISPLEASURE: {
                return false;
            }
        }
        throw new IllegalArgumentException("Bogus monarch action: " + (Object)((Object)action));
    }

    public List<RandomChoice<MonarchAction>> getActionChoices() {
        int grace;
        ArrayList<RandomChoice<MonarchAction>> choices = new ArrayList<RandomChoice<MonarchAction>>();
        int dx = 1 + this.getSpecification().getIntegerOption("model.option.monarchMeddling").getValue();
        int turn = this.getGame().getTurn().getNumber();
        if (turn < (grace = (6 - dx) * 10) || this.player.getSettlements().size() == 0 || this.player.getPlayerType() != Player.PlayerType.COLONIAL) {
            return choices;
        }
        this.addIfValid(choices, MonarchAction.NO_ACTION, Math.max(200 - turn, 100));
        this.addIfValid(choices, MonarchAction.RAISE_TAX_ACT, 5 + dx);
        this.addIfValid(choices, MonarchAction.RAISE_TAX_WAR, 5 + dx);
        this.addIfValid(choices, MonarchAction.LOWER_TAX_WAR, 5 - dx);
        this.addIfValid(choices, MonarchAction.LOWER_TAX_OTHER, 5 - dx);
        this.addIfValid(choices, MonarchAction.ADD_TO_REF, 10 + dx);
        this.addIfValid(choices, MonarchAction.DECLARE_WAR, 5 + dx);
        if (this.player.checkGold(300)) {
            this.addIfValid(choices, MonarchAction.OFFER_MERCENARIES, 6 - dx);
        } else if (dx < 3) {
            this.addIfValid(choices, MonarchAction.SUPPORT_LAND, 3 - dx);
        }
        this.addIfValid(choices, MonarchAction.SUPPORT_SEA, 6 - dx);
        return choices;
    }

    private void addIfValid(List<RandomChoice<MonarchAction>> choices, MonarchAction action, int weight) {
        if (this.actionIsValid(action)) {
            choices.add(new RandomChoice<MonarchAction>(action, weight));
        }
    }

    public int raiseTax(Random random) {
        int taxAdjustment = this.getSpecification().getIntegerOption("model.option.taxAdjustment").getValue();
        int turn = this.getGame().getTurn().getNumber();
        int oldTax = this.player.getTax();
        int adjust = Math.max(1, (6 - taxAdjustment) * 10);
        adjust = 1 + Utils.randomInt(logger, "Tax rise", random, 5 + turn / adjust);
        return Math.min(oldTax + adjust, this.taxMaximum());
    }

    public int lowerTax(Random random) {
        int taxAdjustment = this.getSpecification().getIntegerOption("model.option.taxAdjustment").getValue();
        int oldTax = this.player.getTax();
        int adjust = Math.max(1, 10 - taxAdjustment);
        adjust = 1 + Utils.randomInt(logger, "Tax reduction", random, adjust);
        return Math.max(oldTax - adjust, 20);
    }

    public AbstractUnit chooseForREF(Random random) {
        AbstractUnit result = null;
        logger.info("Add to REF: capacity=" + this.capacity + " spaceRequired=" + this.spaceRequired + " => " + (this.capacity < this.spaceRequired + 15 ? "naval" : "land") + " unit");
        if (this.capacity < this.spaceRequired + 15) {
            result = Utils.getRandomMember(logger, "Choose naval", this.navalUnits, random);
            result.setNumber(1);
        } else {
            result = Utils.getRandomMember(logger, "Choose land", this.landUnits, random);
            result.setNumber(Utils.randomInt(logger, "Choose land#", random, 3) + 1);
        }
        return result;
    }

    public void addToREF(AbstractUnit units) {
        Specification spec = this.getSpecification();
        UnitType unitType = spec.getUnitType(units.getId());
        int n = units.getNumber();
        if (unitType.hasAbility("model.ability.navalUnit")) {
            for (AbstractUnit refUnit : this.navalUnits) {
                if (!refUnit.getId().equals(units.getId())) continue;
                refUnit.setNumber(refUnit.getNumber() + n);
                if (!unitType.canCarryUnits()) break;
                this.capacity += unitType.getSpace() * n;
                break;
            }
        } else {
            for (AbstractUnit refUnit : this.landUnits) {
                if (!refUnit.getId().equals(units.getId()) || !refUnit.getRole().equals((Object)units.getRole())) continue;
                refUnit.setNumber(refUnit.getNumber() + n);
                this.spaceRequired += unitType.getSpaceTaken() * n;
                break;
            }
        }
        this.updateSpaceAndCapacity();
    }

    public List<AbstractUnit> getSupport(Random random, boolean naval) {
        Specification spec = this.getSpecification();
        ArrayList<AbstractUnit> support = new ArrayList<AbstractUnit>();
        ArrayList<UnitType> navalTypes = new ArrayList<UnitType>();
        ArrayList<UnitType> bombardTypes = new ArrayList<UnitType>();
        ArrayList<UnitType> mountedTypes = new ArrayList<UnitType>();
        for (UnitType unitType : spec.getUnitTypeList()) {
            if (!unitType.hasAbility("model.ability.supportUnit")) continue;
            if (unitType.hasAbility("model.ability.navalUnit")) {
                navalTypes.add(unitType);
                continue;
            }
            if (unitType.hasAbility("model.ability.bombard")) {
                bombardTypes.add(unitType);
                continue;
            }
            if (!unitType.hasAbility("model.ability.canBeEquipped")) continue;
            mountedTypes.add(unitType);
        }
        if (naval) {
            support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose naval support", navalTypes, random), Unit.Role.DEFAULT, 1));
            this.setSupportSea(true);
            return support;
        }
        int difficulty = spec.getInteger("model.option.monarchSupport");
        switch (difficulty) {
            case 4: {
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose bombard", bombardTypes, random), Unit.Role.DEFAULT, 1));
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose mounted", mountedTypes, random), Unit.Role.DRAGOON, 2));
                break;
            }
            case 3: {
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose mounted", mountedTypes, random), Unit.Role.DRAGOON, 2));
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose soldier", mountedTypes, random), Unit.Role.SOLDIER, 1));
                break;
            }
            case 2: {
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose mounted", mountedTypes, random), Unit.Role.DRAGOON, 2));
                break;
            }
            case 1: {
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose mounted", mountedTypes, random), Unit.Role.DRAGOON, 1));
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose soldier", mountedTypes, random), Unit.Role.SOLDIER, 1));
                break;
            }
            case 0: {
                support.add(new AbstractUnit((UnitType)Utils.getRandomMember(logger, "Choose soldier", mountedTypes, random), Unit.Role.SOLDIER, 1));
                break;
            }
        }
        return support;
    }

    public List<AbstractUnit> getMercenaries(Random random) {
        Specification spec = this.getSpecification();
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>();
        for (UnitType unitType : spec.getUnitTypeList()) {
            if (!unitType.hasAbility("model.ability.mercenaryUnit")) continue;
            unitTypes.add(unitType);
        }
        int mercPrice = spec.getIntegerOption("model.option.mercenaryPrice").getValue();
        ArrayList<AbstractUnit> mercs = new ArrayList<AbstractUnit>();
        int price = 0;
        int limit = unitTypes.size();
        UnitType unitType = null;
        for (int count = 0; count < limit; ++count) {
            int newPrice;
            AbstractUnit au;
            int number;
            unitType = (UnitType)Utils.getRandomMember(logger, "Choose unit", unitTypes, random);
            if (unitType.hasAbility("model.ability.canBeEquipped")) {
                for (number = 3; number > 0; --number) {
                    au = new AbstractUnit(unitType, Unit.Role.DRAGOON, number);
                    newPrice = this.player.getPrice(au) * mercPrice / 100;
                    if (!this.player.checkGold(price + newPrice)) continue;
                    mercs.add(au);
                    price += newPrice;
                    break;
                }
                for (number = 3; number > 0; --number) {
                    au = new AbstractUnit(unitType, Unit.Role.SOLDIER, number);
                    newPrice = this.player.getPrice(au) * mercPrice / 100;
                    if (!this.player.checkGold(price + newPrice)) continue;
                    mercs.add(au);
                    price += newPrice;
                    break;
                }
            } else {
                for (number = 3; number > 0; --number) {
                    au = new AbstractUnit(unitType, Unit.Role.DEFAULT, number);
                    newPrice = this.player.getPrice(au) * mercPrice / 100;
                    if (!this.player.checkGold(price + newPrice)) continue;
                    mercs.add(au);
                    price += newPrice;
                    break;
                }
            }
            unitTypes.remove(unitType);
        }
        if (mercs.isEmpty() && unitType != null) {
            Unit.Role role = unitType.hasAbility("model.ability.canBeEquipped") ? Unit.Role.SOLDIER : Unit.Role.DEFAULT;
            mercs.add(new AbstractUnit(unitType, role, 1));
        }
        return mercs;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Monarch.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("player", this.player.getId());
        out.writeAttribute("name", this.name);
        out.writeAttribute("supportSea", String.valueOf(this.supportSea));
        out.writeAttribute("displeasure", String.valueOf(this.displeasure));
        out.writeStartElement("navalUnits");
        for (AbstractUnit unit : this.navalUnits) {
            unit.toXMLImpl(out);
        }
        out.writeEndElement();
        out.writeStartElement("landUnits");
        for (AbstractUnit unit : this.landUnits) {
            unit.toXMLImpl(out);
        }
        out.writeEndElement();
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.player = (Player)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "player"));
        if (this.player == null) {
            this.player = new Player(this.getGame(), in.getAttributeValue(null, "player"));
        }
        this.name = this.getAttribute(in, "name", this.player.getNation().getRulerNameKey());
        this.supportSea = Monarch.getAttribute(in, "supportSea", false);
        this.displeasure = Monarch.getAttribute(in, "displeasure", false);
        this.navalUnits.clear();
        this.landUnits.clear();
        while (in.nextTag() != 2) {
            AbstractUnit newUnit;
            String childName = in.getLocalName();
            if ("navalUnits".equals(childName)) {
                while (in.nextTag() != 2) {
                    newUnit = new AbstractUnit(in);
                    this.navalUnits.add(newUnit);
                }
                continue;
            }
            if (!"landUnits".equals(childName)) continue;
            while (in.nextTag() != 2) {
                newUnit = new AbstractUnit(in);
                this.landUnits.add(newUnit);
            }
        }
        this.updateSpaceAndCapacity();
        if (!in.getLocalName().equals(Monarch.getXMLElementTagName())) {
            logger.warning("Error parsing xml: expecting closing tag </" + Monarch.getXMLElementTagName() + "> found instead: " + in.getLocalName());
        }
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    public static String getXMLElementTagName() {
        return "monarch";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MonarchAction {
        NO_ACTION,
        RAISE_TAX_ACT,
        RAISE_TAX_WAR,
        FORCE_TAX,
        LOWER_TAX_WAR,
        LOWER_TAX_OTHER,
        WAIVE_TAX,
        ADD_TO_REF,
        DECLARE_WAR,
        SUPPORT_LAND,
        SUPPORT_SEA,
        OFFER_MERCENARIES,
        DISPLEASURE;

    }
}

