/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Modifier
extends Feature
implements Comparable<Modifier> {
    public static final String OFFENCE = "model.modifier.offence";
    public static final String DEFENCE = "model.modifier.defence";
    public static final String OFFENCE_AGAINST = "model.modifier.offenceAgainst";
    public static final String DEFENCE_AGAINST = "model.modifier.defenceAgainst";
    public static final float UNKNOWN = Float.MIN_VALUE;
    public static int BASIC_PRODUCTION_INDEX = 0;
    public static int COLONY_PRODUCTION_INDEX = 10;
    public static int EXPERT_PRODUCTION_INDEX = 20;
    public static int FATHER_PRODUCTION_INDEX = 30;
    public static int IMPROVEMENT_PRODUCTION_INDEX = 40;
    public static int AUTO_PRODUCTION_INDEX = 50;
    public static int BUILDING_PRODUCTION_INDEX = 60;
    public static int NATION_PRODUCTION_INDEX = 70;
    private float value;
    private float increment;
    private Type type;
    private Type incrementType;
    private int index = -1;

    private Modifier() {
    }

    public Modifier(String id, float value, Type type) {
        this.setId(id);
        this.setType(type);
        this.setValue(value);
    }

    public Modifier(String id, FreeColGameObjectType source, float value, Type type) {
        this.setId(id);
        this.setSource(source);
        this.setType(type);
        this.setValue(value);
    }

    public Modifier(Modifier template) {
        super.copy(template);
        this.setType(template.getType());
        this.setValue(template.getValue());
        if (template.hasIncrement()) {
            this.setIncrement(template.getIncrement(), template.getIncrementType(), template.getFirstTurn(), template.getLastTurn());
        }
    }

    public Modifier(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.readFromXMLImpl(in, specification);
    }

    public static Modifier makeTimedModifier(String id, Modifier template, Turn start) {
        Modifier modifier = new Modifier(id, template.getSource(), template.getValue(), template.getType());
        float inc = template.getIncrement();
        modifier.setIncrement(inc, template.getIncrementType(), start, new Turn(start.getNumber() + (int)(template.getValue() / -inc)));
        return modifier;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type newType) {
        this.type = newType;
    }

    public Type getIncrementType() {
        return this.incrementType;
    }

    public void setIncrementType(Type newIncrementType) {
        this.incrementType = newIncrementType;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float newValue) {
        this.value = newValue;
    }

    public float getIncrement() {
        return this.increment;
    }

    public void setIncrement(float newIncrement, Type type, Turn firstTurn, Turn lastTurn) {
        if (firstTurn == null) {
            throw new IllegalArgumentException("Parameter firstTurn must not be 'null'.");
        }
        this.increment = newIncrement;
        this.incrementType = type;
        this.setFirstTurn(firstTurn);
        this.setLastTurn(lastTurn);
    }

    public boolean hasIncrement() {
        return this.incrementType != null;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int newIndex) {
        this.index = newIndex;
    }

    public float applyTo(float number) {
        switch (this.type) {
            case ADDITIVE: {
                return number + this.value;
            }
            case MULTIPLICATIVE: {
                return number * this.value;
            }
            case PERCENTAGE: {
                return number + number * this.value / 100.0f;
            }
        }
        return number;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash += 31 * Float.floatToIntBits(this.value);
        hash += 31 * Float.floatToIntBits(this.increment);
        hash += 31 * (this.type == null ? 0 : this.type.hashCode());
        hash += 31 * (this.incrementType == null ? 0 : this.incrementType.hashCode());
        return hash += 31 * this.index;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Modifier) {
            Modifier modifier = (Modifier)o;
            if (!super.equals(o)) {
                return false;
            }
            if (this.value != modifier.value) {
                return false;
            }
            if (this.increment != modifier.increment) {
                return false;
            }
            if (this.type == null) {
                if (modifier.type != null) {
                    return false;
                }
            } else {
                if (modifier.type == null) {
                    return false;
                }
                if (!this.type.equals((Object)modifier.type)) {
                    return false;
                }
            }
            if (this.incrementType == null) {
                if (modifier.incrementType != null) {
                    return false;
                }
            } else {
                if (modifier.incrementType == null) {
                    return false;
                }
                if (!this.incrementType.equals((Object)modifier.incrementType)) {
                    return false;
                }
            }
            return this.index == modifier.index;
        }
        return false;
    }

    @Override
    public int compareTo(Modifier modifier) {
        if (this.index == modifier.index) {
            return this.type.compareTo(modifier.type);
        }
        return this.index - modifier.index;
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, Modifier.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("value", String.valueOf(this.value));
        out.writeAttribute("type", this.type.toString().toLowerCase(Locale.US));
        if (this.incrementType != null) {
            out.writeAttribute("incrementType", this.incrementType.toString().toLowerCase(Locale.US));
            out.writeAttribute("increment", String.valueOf(this.increment));
        }
        if (this.index >= 0) {
            out.writeAttribute("index", Integer.toString(this.index));
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        super.readAttributes(in, specification);
        String typeString = in.getAttributeValue(null, "type");
        this.setType(Enum.valueOf(Type.class, typeString.toUpperCase(Locale.US)));
        this.value = Float.parseFloat(in.getAttributeValue(null, "value"));
        String incrementString = in.getAttributeValue(null, "incrementType");
        if (incrementString != null) {
            this.setIncrementType(Enum.valueOf(Type.class, incrementString.toUpperCase(Locale.US)));
            this.increment = Float.parseFloat(in.getAttributeValue(null, "increment"));
        }
        this.index = this.getAttribute(in, "index", -1);
    }

    public String toString() {
        return this.getId() + (this.getSource() == null ? " " : " (" + this.getSource().getId() + ") ") + (Object)((Object)this.type) + " " + this.value;
    }

    public static String getXMLElementTagName() {
        return "modifier";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ADDITIVE,
        MULTIPLICATIVE,
        PERCENTAGE;

    }
}

