/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.RandomChoice;

public class LostCityRumour
extends TileItem {
    private static final Logger logger = Logger.getLogger(LostCityRumour.class.getName());
    private RumourType type = null;
    private String name = null;

    public LostCityRumour(Game game, Tile tile) {
        super(game, tile);
    }

    public LostCityRumour(Game game, Tile tile, RumourType type, String name) {
        super(game, tile);
        this.type = type;
        this.name = name;
    }

    public LostCityRumour(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public final RumourType getType() {
        return this.type;
    }

    public final void setType(RumourType newType) {
        this.type = newType;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String newName) {
        this.name = newName;
    }

    public final int getZIndex() {
        return 500;
    }

    public boolean isTileTypeAllowed(TileType tileType) {
        return !tileType.isWater();
    }

    public RumourType chooseType(Unit unit, int difficulty, Random random) {
        int percentNeutral;
        int percentGood;
        int percentBad;
        Tile tile = this.getTile();
        boolean allowLearn = unit != null && !unit.getType().getUnitTypesLearntInLostCity().isEmpty();
        boolean isExpertScout = unit != null && unit.hasAbility("model.ability.expertScout") && unit.hasAbility("model.ability.scoutIndianSettlement");
        boolean hasDeSoto = unit != null && unit.getOwner().hasAbility("model.ability.rumoursAlwaysPositive");
        int[] BAD_EVENT_PERCENTAGE = new int[]{11, 17, 23, 30, 37};
        int[] GOOD_EVENT_PERCENTAGE = new int[]{75, 62, 48, 33, 17};
        int[] BAD_EVENT_MOD = new int[]{-6, -7, -7, -8, -9};
        int[] GOOD_EVENT_MOD = new int[]{14, 15, 16, 18, 20};
        difficulty = Math.max(0, Math.min(BAD_EVENT_PERCENTAGE.length - 1, difficulty));
        if (hasDeSoto) {
            percentBad = 0;
            percentGood = 100;
            percentNeutral = 0;
        } else {
            percentBad = BAD_EVENT_PERCENTAGE[difficulty];
            percentGood = GOOD_EVENT_PERCENTAGE[difficulty];
            if (isExpertScout) {
                percentBad += BAD_EVENT_MOD[difficulty];
                percentGood += GOOD_EVENT_MOD[difficulty];
            }
            percentNeutral = percentBad + percentGood < 100 ? 100 - percentBad - percentGood : 0;
        }
        EnumMap<RumourType, Integer> events = new EnumMap<RumourType, Integer>(RumourType.class);
        events.put(RumourType.NOTHING, 100 * percentNeutral);
        if (tile.getOwner() != null && tile.getOwner().isIndian()) {
            events.put(RumourType.EXPEDITION_VANISHES, 75 * percentBad);
            events.put(RumourType.BURIAL_GROUND, 25 * percentBad);
        } else {
            events.put(RumourType.EXPEDITION_VANISHES, 100 * percentBad);
            events.put(RumourType.BURIAL_GROUND, 0);
        }
        if (allowLearn) {
            events.put(RumourType.LEARN, 30 * percentGood);
            events.put(RumourType.TRIBAL_CHIEF, 30 * percentGood);
            events.put(RumourType.COLONIST, 20 * percentGood);
        } else {
            events.put(RumourType.LEARN, 0);
            events.put(RumourType.TRIBAL_CHIEF, 50 * percentGood);
            events.put(RumourType.COLONIST, 30 * percentGood);
        }
        events.put(RumourType.MOUNDS, 8 * percentGood);
        events.put(RumourType.RUINS, 6 * percentGood);
        events.put(RumourType.CIBOLA, 4 * percentGood);
        events.put(RumourType.FOUNTAIN_OF_YOUTH, 3 * percentGood);
        ArrayList choices = new ArrayList();
        for (Map.Entry entry : events.entrySet()) {
            if ((Integer)entry.getValue() <= 0) continue;
            choices.add(new RandomChoice(entry.getKey(), (Integer)entry.getValue()));
        }
        return (RumourType)((Object)RandomChoice.getWeightedRandom(logger, "Choose rumour", random, choices));
    }

    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(LostCityRumour.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("tile", this.getTile().getId());
        if (this.type != null && (showAll || toSavedGame)) {
            out.writeAttribute("type", this.getType().toString());
        }
        if (this.name != null && (showAll || toSavedGame)) {
            out.writeAttribute("name", this.name);
        }
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.tile = this.getFreeColGameObject(in, "tile", Tile.class);
        String typeString = this.getAttribute(in, "type", null);
        if (typeString != null) {
            this.type = Enum.valueOf(RumourType.class, typeString);
        }
        this.name = this.getAttribute(in, "name", null);
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "lostCityRumour";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RumourType {
        NO_SUCH_RUMOUR,
        BURIAL_GROUND,
        EXPEDITION_VANISHES,
        NOTHING,
        LEARN,
        TRIBAL_CHIEF,
        COLONIST,
        MOUNDS,
        RUINS,
        CIBOLA,
        FOUNTAIN_OF_YOUTH;

    }
}

