/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Turn;

public final class LastSale
extends FreeColObject {
    private Turn when;
    private int price;

    public LastSale() {
    }

    public LastSale(Location where, GoodsType what, Turn when, int price) {
        this(LastSale.makeKey(where, what), when, price);
    }

    public LastSale(String id, Turn when, int price) {
        this.setId(id);
        this.when = when;
        this.price = price;
    }

    public Turn getWhen() {
        return this.when;
    }

    public int getPrice() {
        return this.price;
    }

    public static String makeKey(Location where, GoodsType what) {
        return where.getId() + "-" + what.getId();
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, LastSale.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("when", Integer.toString(this.when.getNumber()));
        out.writeAttribute("price", Integer.toString(this.price));
    }

    public void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.when = new Turn(this.getAttribute(in, "when", 0));
        this.price = this.getAttribute(in, "price", 0);
        super.readChildren(in);
    }

    public String toString() {
        return LastSale.getXMLElementTagName() + "-" + this.getId() + "-" + this.when.toString() + "-" + Integer.toString(this.price);
    }

    public static String getXMLElementTagName() {
        return "lastSale";
    }
}

