/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitDetailPanel
extends ColopediaGameObjectTypePanel<UnitType> {
    private static final int MODIFIERS_PER_ROW = 5;

    public UnitDetailPanel(FreeColClient freeColClient, GUI gui, ColopediaPanel colopediaPanel) {
        super(freeColClient, gui, colopediaPanel, ColopediaAction.PanelType.UNITS.toString(), 0.5);
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        ArrayList<UnitType> units = new ArrayList<UnitType>();
        ArrayList<UnitType> skills = new ArrayList<UnitType>();
        for (UnitType u : this.getSpecification().getUnitTypeList()) {
            if (u.getSkill() <= 0 || u.hasAbility("model.ability.expertSoldier")) {
                units.add(u);
                continue;
            }
            skills.add(u);
        }
        super.addSubTrees(root, "colopediaAction." + (Object)((Object)ColopediaAction.PanelType.UNITS), units);
        super.addSubTrees(root, "colopediaAction." + (Object)((Object)ColopediaAction.PanelType.SKILLS), skills);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        Player player;
        if (this.getId().equals(id) || ("colopediaAction." + (Object)((Object)ColopediaAction.PanelType.SKILLS)).equals(id)) {
            return;
        }
        UnitType type = this.getSpecification().getUnitType(id);
        panel.setLayout((LayoutManager)new MigLayout("wrap 4", "[]20[]40[]20[]"));
        JLabel name = this.localizedLabel(type.getNameKey());
        name.setFont(smallHeaderFont);
        panel.add((Component)name, "span, align center, wrap 40");
        panel.add(this.localizedLabel("colopedia.unit.offensivePower"));
        panel.add((Component)new JLabel(Integer.toString(type.getOffence())), "right");
        panel.add(this.localizedLabel("colopedia.unit.defensivePower"));
        panel.add((Component)new JLabel(Integer.toString(type.getDefence())), "right");
        panel.add(this.localizedLabel("colopedia.unit.movement"));
        panel.add((Component)new JLabel(String.valueOf(type.getMovement() / 3)), "right");
        if (type.canCarryGoods() || type.canCarryUnits()) {
            panel.add(this.localizedLabel("colopedia.unit.capacity"));
            panel.add((Component)new JLabel(Integer.toString(type.getSpace())), "right");
        }
        Europe europe = (player = this.getMyPlayer()) == null ? null : player.getEurope();
        String price = null;
        if (europe != null && europe.getUnitPrice(type) > 0) {
            price = Integer.toString(europe.getUnitPrice(type));
        } else if (type.getPrice() > 0) {
            price = Integer.toString(type.getPrice());
        }
        if (price != null) {
            panel.add(this.localizedLabel("colopedia.unit.price"));
            panel.add((Component)new JLabel(price), "right");
        }
        if (type.hasSkill()) {
            panel.add(this.localizedLabel("colopedia.unit.skill"));
            panel.add((Component)new JLabel(Integer.toString(type.getSkill())), "right");
            ArrayList<BuildingType> schools = new ArrayList<BuildingType>();
            for (BuildingType buildingType : this.getSpecification().getBuildingTypeList()) {
                if (!buildingType.hasAbility("model.ability.teach") || !buildingType.canAdd(type)) continue;
                schools.add(buildingType);
            }
            if (!schools.isEmpty()) {
                panel.add((Component)this.localizedLabel("colopedia.unit.school"), "newline");
                int count = 0;
                for (BuildingType school : schools) {
                    JButton label = this.getButton(school);
                    if (count > 0 && count % 3 == 0) {
                        panel.add((Component)label, "skip");
                    } else {
                        panel.add(label);
                    }
                    ++count;
                }
            }
            ArrayList<IndianNationType> nations = new ArrayList<IndianNationType>();
            for (IndianNationType nation : this.getSpecification().getIndianNationTypes()) {
                for (RandomChoice randomChoice : nation.getSkills()) {
                    if (randomChoice.getObject() != type) continue;
                    nations.add(nation);
                }
            }
            if (!nations.isEmpty()) {
                panel.add((Component)this.localizedLabel("colopedia.unit.natives"), "newline");
                int count = 0;
                for (IndianNationType nation : nations) {
                    JButton jButton = this.getButton(nation);
                    if (count > 0 && count % 3 == 0) {
                        panel.add((Component)jButton, "skip");
                    } else {
                        panel.add(jButton);
                    }
                    ++count;
                }
            }
        }
        if (!type.getAbilitiesRequired().isEmpty()) {
            panel.add((Component)this.localizedLabel("colopedia.unit.requirements"), "newline, top");
            String key = type.getAbilitiesRequired().keySet().iterator().next();
            try {
                JTextPane textPane = UnitDetailPanel.getDefaultTextPane();
                StyledDocument doc = textPane.getStyledDocument();
                this.appendRequiredAbilities(doc, type);
                panel.add((Component)textPane, "span, width 70%");
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        ArrayList<Modifier> bonusList = new ArrayList<Modifier>();
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            bonusList.addAll(type.getModifierSet(goodsType.getId()));
        }
        int bonusNumber = bonusList.size();
        if (bonusNumber > 0) {
            StringTemplate template = StringTemplate.template("colopedia.unit.productionBonus").addAmount("%number%", bonusNumber);
            panel.add((Component)this.localizedLabel(template), "newline 20, top");
            JPanel productionPanel = new JPanel(new GridLayout(0, 5));
            productionPanel.setOpaque(false);
            for (Modifier modifier : bonusList) {
                GoodsType goodsType = this.getSpecification().getGoodsType(modifier.getId());
                String bonus = this.getModifierAsString(modifier);
                productionPanel.add(this.getGoodsButton(goodsType, bonus));
            }
            panel.add((Component)productionPanel, "span");
        }
        if (!type.getGoodsRequired().isEmpty()) {
            panel.add((Component)this.localizedLabel("colopedia.unit.goodsRequired"), "newline 20");
            AbstractGoods goods = type.getGoodsRequired().get(0);
            if (type.getGoodsRequired().size() > 1) {
                panel.add((Component)this.getGoodsButton(goods.getType(), goods.getAmount()), "span, split " + type.getGoodsRequired().size());
                for (int index = 1; index < type.getGoodsRequired().size(); ++index) {
                    goods = type.getGoodsRequired().get(index);
                    panel.add(this.getGoodsButton(goods.getType(), goods.getAmount()));
                }
            } else {
                panel.add(this.getGoodsButton(goods.getType(), goods.getAmount()));
            }
        }
        panel.add((Component)this.localizedLabel("colopedia.unit.description"), "newline 20");
        panel.add((Component)UnitDetailPanel.getDefaultTextArea(Messages.message(type.getDescriptionKey()), 30), "span");
    }
}

