/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.io.Mods;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.OptionGroup;

public final class NewPanel
extends FreeColPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(NewPanel.class.getName());
    private final JLabel ipLabel = this.localizedLabel("host");
    private final JLabel port1Label = this.localizedLabel("port");
    private final JLabel port2Label = this.localizedLabel("startServerOnPort");
    private final JLabel advantageLabel = this.localizedLabel("playerOptions.nationalAdvantages");
    private final JLabel rulesLabel = this.localizedLabel("rules");
    private final JCheckBox publicServer = new JCheckBox(Messages.message("publicServer"));
    private final JTextField name = new JTextField(System.getProperty("user.name", Messages.message("defaultPlayerName")), 20);
    private final JTextField server = new JTextField("127.0.0.1");
    private final JTextField port1 = new JTextField(Integer.toString(FreeCol.getDefaultPort()));
    private final JTextField port2 = new JTextField(Integer.toString(FreeCol.getDefaultPort()));
    private final JRadioButton single = new JRadioButton(Messages.message("singlePlayerGame"), true);
    private final JRadioButton join = new JRadioButton(Messages.message("joinMultiPlayerGame"), false);
    private final JRadioButton start = new JRadioButton(Messages.message("startMultiplayerGame"), false);
    private final JRadioButton meta = new JRadioButton(Messages.message("getServerList") + " (" + "meta.freecol.org" + ")", false);
    private final NationOptions.Advantages[] choices = new NationOptions.Advantages[]{NationOptions.Advantages.SELECTABLE, NationOptions.Advantages.FIXED, NationOptions.Advantages.NONE};
    private final JComboBox nationalAdvantages = new JComboBox<NationOptions.Advantages>(this.choices);
    private final JComboBox specificationBox = new JComboBox();
    private final Component[] joinComponents = new Component[]{this.ipLabel, this.server, this.port1Label, this.port1};
    private final Component[] serverComponents = new Component[]{this.publicServer, this.port2Label, this.port2};
    private final Component[] gameComponents = new Component[]{this.advantageLabel, this.nationalAdvantages, this.rulesLabel, this.specificationBox};
    private final ButtonGroup group = new ButtonGroup();
    private final ConnectController connectController;
    private Specification specification;

    public NewPanel(FreeColClient freeColClient, GUI gui) {
        this(freeColClient, gui, (Specification)null);
    }

    public NewPanel(FreeColClient freeColClient, GUI gui, Specification specification) {
        super(freeColClient, gui);
        this.specification = specification;
        this.connectController = this.getFreeColClient().getConnectController();
        for (FreeColTcFile tc : Mods.getRuleSets()) {
            this.specificationBox.addItem(tc);
            if ((specification != null || !"freecol".equals(tc.getId())) && (specification == null || !specification.getId().equals(tc.getId()))) continue;
            this.specificationBox.setSelectedItem(tc);
        }
        this.specificationBox.setRenderer(new FreeColModFileRenderer());
        JButton cancel = new JButton(Messages.message("cancel"));
        JLabel nameLabel = this.localizedLabel("name");
        this.setCancelComponent(cancel);
        this.nationalAdvantages.setRenderer(new AdvantageRenderer());
        this.group.add(this.single);
        this.group.add(this.join);
        this.group.add(this.start);
        this.group.add(this.meta);
        this.setLayout((LayoutManager)new MigLayout("", "[15]", ""));
        this.add((Component)this.single, "span 3");
        this.add((Component)new JSeparator(1), "spany 7, grow");
        this.add((Component)nameLabel, "span, split 2");
        this.add((Component)this.name, "growx");
        this.add((Component)this.start, "newline, span 3");
        this.add(this.advantageLabel);
        this.add((Component)this.nationalAdvantages, "growx");
        this.add((Component)this.port2Label, "newline, skip");
        this.add((Component)this.port2, "width 60:");
        this.add(this.rulesLabel);
        this.add((Component)this.specificationBox, "growx");
        this.add((Component)this.publicServer, "newline, skip, span 2");
        this.add((Component)this.meta, "newline, span 3");
        this.add((Component)this.join, "newline, span 3");
        this.add((Component)this.ipLabel, "newline, skip, split 2");
        this.add((Component)this.server, "width 80:");
        this.add((Component)this.port1Label, "split 2");
        this.add((Component)this.port1, "width 60:");
        this.add((Component)this.okButton, "newline, span, split 2, tag ok");
        this.add((Component)cancel, "tag cancel");
        this.okButton.setActionCommand(String.valueOf((Object)NewPanelAction.OK));
        cancel.setActionCommand(String.valueOf((Object)NewPanelAction.CANCEL));
        this.single.setActionCommand(String.valueOf((Object)NewPanelAction.SINGLE));
        this.join.setActionCommand(String.valueOf((Object)NewPanelAction.JOIN));
        this.start.setActionCommand(String.valueOf((Object)NewPanelAction.START));
        this.meta.setActionCommand(String.valueOf((Object)NewPanelAction.META_SERVER));
        cancel.addActionListener(this);
        this.single.addActionListener(this);
        this.join.addActionListener(this);
        this.start.addActionListener(this);
        this.meta.addActionListener(this);
        this.single.setSelected(true);
        this.enableComponents();
        this.setSize(this.getPreferredSize());
    }

    public Specification getSpecification() {
        if (this.specification == null) {
            try {
                String tc = ((FreeColModFile)this.specificationBox.getSelectedItem()).getId();
                FreeColTcFile tcData = new FreeColTcFile(tc);
                this.specification = tcData.getSpecification();
            }
            catch (Exception e) {
                logger.warning(e.toString());
            }
        }
        return this.specification;
    }

    public void setSpecification(Specification newSpecification) {
        this.specification = newSpecification;
    }

    private void enableComponents(Component[] components, boolean enable) {
        for (Component c : components) {
            c.setEnabled(enable);
        }
    }

    private void enableComponents() {
        NewPanelAction action = Enum.valueOf(NewPanelAction.class, this.group.getSelection().getActionCommand());
        switch (action) {
            case SINGLE: {
                this.enableComponents(this.joinComponents, false);
                this.enableComponents(this.serverComponents, false);
                this.enableComponents(this.gameComponents, true);
                this.specificationBox.setEnabled(this.specification == null);
                break;
            }
            case JOIN: {
                this.enableComponents(this.joinComponents, true);
                this.enableComponents(this.serverComponents, false);
                this.enableComponents(this.gameComponents, false);
                break;
            }
            case START: {
                this.enableComponents(this.joinComponents, false);
                this.enableComponents(this.serverComponents, true);
                this.enableComponents(this.gameComponents, true);
                this.specificationBox.setEnabled(this.specification == null);
                break;
            }
            case META_SERVER: {
                this.enableComponents(this.joinComponents, false);
                this.enableComponents(this.serverComponents, false);
                this.enableComponents(this.gameComponents, false);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            block3 : switch (Enum.valueOf(NewPanelAction.class, command)) {
                case OK: {
                    NewPanelAction action = Enum.valueOf(NewPanelAction.class, this.group.getSelection().getActionCommand());
                    switch (action) {
                        case SINGLE: {
                            OptionGroup level = this.getGUI().showDifficultyDialog(this.getSpecification());
                            if (level == null) break;
                            this.getSpecification().applyDifficultyLevel(level);
                            NationOptions.Advantages advantages = (NationOptions.Advantages)((Object)this.nationalAdvantages.getSelectedItem());
                            this.connectController.startSingleplayerGame(this.getSpecification(), this.name.getText(), advantages);
                            break block3;
                        }
                        case JOIN: {
                            try {
                                int port = Integer.valueOf(this.port1.getText());
                                this.connectController.joinMultiplayerGame(this.name.getText(), this.server.getText(), port);
                            }
                            catch (NumberFormatException e) {
                                this.port1Label.setForeground(Color.red);
                            }
                            break block3;
                        }
                        case START: {
                            try {
                                int port = Integer.valueOf(this.port2.getText());
                                OptionGroup level = this.getGUI().showDifficultyDialog(this.getSpecification());
                                this.getSpecification().applyDifficultyLevel(level);
                                NationOptions.Advantages advantages = (NationOptions.Advantages)((Object)this.nationalAdvantages.getSelectedItem());
                                this.connectController.startMultiplayerGame(this.getSpecification(), this.publicServer.isSelected(), this.name.getText(), port, advantages, level);
                            }
                            catch (NumberFormatException e) {
                                this.port2Label.setForeground(Color.red);
                            }
                            break block3;
                        }
                        case META_SERVER: {
                            ArrayList<ServerInfo> serverList = this.connectController.getServerList();
                            if (serverList == null) break;
                            this.getGUI().showServerListPanel(this.name.getText(), serverList);
                        }
                    }
                    break;
                }
                case CANCEL: {
                    this.getGUI().removeFromCanvas(this);
                    this.getGUI().showMainPanel();
                    break;
                }
                case SINGLE: 
                case JOIN: 
                case START: 
                case META_SERVER: {
                    this.enableComponents();
                    break;
                }
                default: {
                    logger.warning("Invalid Action command: " + command);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.warning(e.toString());
            e.printStackTrace();
        }
    }

    private class FreeColModFileRenderer
    extends FreeColComboBoxRenderer {
        private FreeColModFileRenderer() {
        }

        public void setLabelValues(JLabel label, Object value) {
            FreeColModFile mod = (FreeColModFile)value;
            label.setText(Messages.message("mod." + mod.getId() + ".name"));
        }
    }

    private class AdvantageRenderer
    extends FreeColComboBoxRenderer {
        private AdvantageRenderer() {
        }

        public void setLabelValues(JLabel label, Object value) {
            label.setText(Messages.message("playerOptions." + value.toString()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NewPanelAction {
        OK,
        CANCEL,
        SINGLE,
        JOIN,
        START,
        META_SERVER;

    }
}

