/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.LabourData;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class CompactLabourReport
extends ReportPanel {
    private int COLONY_COLUMN = 0;
    private int UNIT_TYPE_COLUMN = 1;
    private int WORKING_COLUMN = 2;
    private int BUILDING_COLUMN = 3;
    private int COLONIST_COLUMN = 4;
    private int COLONIST_SUMMARY_COLUMN = 5;
    private int PRODUCTION_SYMBOL_COLUMN = 6;
    private int PRODUCTION_COLUMN = 7;
    private int PRODUCTION_SUMMARY_COLUMN = 8;
    private int NETPRODUCTION_SUMMARY_COLUMN = 9;
    private static final int COLUMNS = 10;
    private LabourData labourData;
    private LabourData.UnitData unitData;
    private boolean showProduction;
    private boolean showNetProduction;
    private boolean showProductionSymbols;
    private boolean showBuildings;
    private final JPanel headerRow = new JPanel(){

        public String getUIClassID() {
            return "ReportPanelUI";
        }
    };

    public CompactLabourReport(FreeColClient freeColClient, GUI gui) {
        this(freeColClient, gui, (LabourData.UnitData)null);
        this.labourData = new LabourData(this.getFreeColClient());
        this.initialize();
    }

    public CompactLabourReport(FreeColClient freeColClient, GUI gui, LabourData.UnitData data) {
        super(freeColClient, gui, data == null ? Messages.message("reportLabourAction.name") : Messages.message("report.labour.details"));
        this.unitData = data;
        this.headerRow.setBorder(new EmptyBorder(20, 20, 0, 20));
        this.headerRow.setOpaque(true);
        this.scrollPane.setColumnHeaderView(this.headerRow);
    }

    public JButton createColonyButton(final Colony colony) {
        String text = colony.getName();
        if (!this.unitData.isSummary() && colony.canTrain(this.unitData.getUnitType())) {
            text = text + "*";
        }
        return this.createButton(text, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CompactLabourReport.this.getGUI().showColonyPanel(colony);
            }
        });
    }

    public void initialize() {
        if (this.isOverview()) {
            this.showProduction = true;
            this.showNetProduction = true;
            this.showProductionSymbols = true;
            this.showBuildings = false;
        } else {
            this.showProduction = this.unitData.showProduction();
            this.showNetProduction = this.unitData.showNetProduction();
            this.showProductionSymbols = false;
            GoodsType expertProduction = this.getGoodsType();
            this.showBuildings = expertProduction != null && !expertProduction.isFarmed() || this.unitData.getTotal().isTraining();
        }
        String layoutConstraints = "fill, insets 0, gap 0 0";
        StringBuilder widths = new StringBuilder();
        widths.append("[175, fill]");
        widths.append(this.isOverview() || !this.unitData.isSummary() ? "[150, fill]" : "[0!]");
        widths.append("[150, fill]");
        widths.append(this.showBuildings ? "[130, fill]" : "[0!]");
        widths.append("[26, fill][33, fill]");
        widths.append(this.showProductionSymbols ? "[50, fill]" : "[0!]");
        widths.append(this.showProduction ? "[30, fill][40, fill]" : "[0!][0!]");
        widths.append(this.showNetProduction ? "[40, fill]" : "[0!]");
        String columnConstraints = widths.toString();
        String rowConstraints = "[fill]";
        this.headerRow.setLayout((LayoutManager)new MigLayout(layoutConstraints, columnConstraints, rowConstraints));
        this.reportPanel.setLayout((LayoutManager)new MigLayout(layoutConstraints, columnConstraints, rowConstraints));
        this.addHeader();
        if (this.isOverview()) {
            this.addUnitTypes();
        } else {
            this.addLocations();
        }
    }

    protected Border createBorder() {
        return new EmptyBorder(0, 20, 20, 20);
    }

    private void addHeader() {
        boolean row = true;
        JLabel empty = new JLabel("");
        empty.setBorder(TOPLEFTCELLBORDER);
        this.headerRow.add((Component)empty, "cell " + this.COLONY_COLUMN + " 1");
        if (this.isOverview() || !this.unitData.isSummary()) {
            JLabel unitType = new JLabel(Messages.message("model.unit.type"));
            unitType.setBorder(TOPCELLBORDER);
            this.headerRow.add((Component)unitType, "cell " + this.UNIT_TYPE_COLUMN + " 1");
        }
        JLabel workingAs = new JLabel(Messages.message("model.unit.workingAs"));
        workingAs.setBorder(TOPCELLBORDER);
        this.headerRow.add((Component)workingAs, "cell " + this.WORKING_COLUMN + " 1");
        if (this.showBuildings) {
            JLabel building = new JLabel(Messages.message("building"));
            building.setBorder(TOPCELLBORDER);
            this.headerRow.add((Component)building, "cell " + this.BUILDING_COLUMN + " 1");
        }
        JLabel colonists = new JLabel(Messages.message("colonists"));
        colonists.setBorder(TOPCELLBORDER);
        this.headerRow.add((Component)colonists, "cell " + this.COLONIST_COLUMN + " 1 2 1");
        if (this.isOverview()) {
            JLabel production = new JLabel(Messages.message("report.production"));
            production.setBorder(TOPCELLBORDER);
            this.headerRow.add((Component)production, "cell " + this.PRODUCTION_SYMBOL_COLUMN + " 1 " + (10 - this.PRODUCTION_SYMBOL_COLUMN) + " 1");
        } else if (this.showProduction) {
            LabourData.UnitData unit = this.unitData;
            GoodsType goods = unit.getExpertProduction();
            JLabel production = new JLabel(this.getLibrary().getGoodsImageIcon(goods));
            production.setBorder(TOPCELLBORDER);
            this.headerRow.add((Component)production, "cell " + this.PRODUCTION_SYMBOL_COLUMN + " 1 " + (10 - this.PRODUCTION_SYMBOL_COLUMN + (this.showNetProduction && goods.isStoredAs() ? 1 : 0)) + " 1");
            if (this.showNetProduction && goods.isStoredAs()) {
                JLabel netProduction = new JLabel(this.getLibrary().getGoodsImageIcon(goods.getStoredAs()));
                netProduction.setBorder(TOPCELLBORDER);
                this.headerRow.add((Component)netProduction, "cell " + this.NETPRODUCTION_SUMMARY_COLUMN + " 1");
            }
        }
        if (!this.isSummary()) {
            ImageIcon icon = this.getUnitIcon(this.unitData.getUnitType());
            this.header.setIcon(icon);
            this.header.setIconTextGap(20);
        }
    }

    private int addLocationData(LabourData.LocationData data, Colony colony, int row) {
        int studentCount;
        Building schoolhouse;
        boolean allColonists = data.getUnitData().isSummary();
        LabourData.UnitData unit = data.getUnitData();
        UnitType unitType = unit.getUnitType();
        String unitName = unit.getUnitName();
        String workingAs = null;
        Building productionBuilding = null;
        if (!allColonists) {
            GoodsType expert;
            workingAs = Messages.message(unitType.getWorkingAsKey());
            if (colony != null && (expert = unitType.getExpertProduction()) != null) {
                productionBuilding = colony.getBuildingForProducing(expert);
            }
        }
        this.addLocationSummary(data, row);
        int buildingStartRow = row;
        int otherAmateurs = data.getOtherWorkingAmateurs().getColonists();
        if (!allColonists && otherAmateurs > 0) {
            this.addRow(data, Messages.message("report.labour.otherUnitType"), workingAs, this.createNonCountedLabel(otherAmateurs), data.getOtherWorkingAmateurs().getProduction(), row);
            ++row;
        }
        int notProducingStartRow = row = this.addRow(data, unitName, allColonists ? Messages.message("report.labour.expertsWorking") : workingAs, data.getWorkingProfessionals().getColonists(), data.getWorkingProfessionals().getProduction(), row);
        if (this.showBuildings) {
            if (productionBuilding != null && row > buildingStartRow) {
                JLabel buildingLabel = this.localizedLabel(productionBuilding.getNameKey());
                buildingLabel.setBorder(CELLBORDER);
                this.reportPanel.add((Component)buildingLabel, "cell " + this.BUILDING_COLUMN + " " + buildingStartRow + " 1 " + (row - buildingStartRow));
                buildingStartRow = row;
            } else {
                this.reportPanel.add((Component)this.createEmptyLabel(), "cell " + this.BUILDING_COLUMN + " " + buildingStartRow + " 1 " + (row - buildingStartRow));
            }
        }
        row = this.addRow(data, unitName, Messages.message(allColonists ? "report.labour.amateursWorking" : "report.labour.workingAsOther"), data.getWorkingAmateurs(), 0, row);
        if (data.getNotWorking() > 0) {
            this.addRow(data, unitName, Messages.message("report.labour.notWorking"), this.createNumberLabel(data.getNotWorking(), "report.labour.notWorking.tooltip"), 0, row);
            ++row;
        }
        Building building = schoolhouse = colony != null && data.isTraining() ? colony.getBuildingWithAbility("model.ability.teach") : null;
        if (this.showBuildings && schoolhouse != null && row > buildingStartRow) {
            this.reportPanel.add((Component)this.createEmptyLabel(), "cell " + this.BUILDING_COLUMN + " " + buildingStartRow + " 1 " + (row - buildingStartRow));
            buildingStartRow = row;
        }
        row = this.addRow(data, unitName, Messages.message("report.labour.teacher"), data.getTeachers(), 0, row);
        if (!allColonists) {
            row = this.addRow(data, data.getOtherStudentsName(), Messages.message(StringTemplate.template("report.labour.learning").addName("%unit%", data.getUnitData().getUnitName())), data.getOtherStudents(), 0, row);
        }
        if ((studentCount = data.getStudents()) > 0) {
            if (allColonists) {
                this.addRow(data, null, Messages.message("report.labour.sutdent"), this.createNonCountedLabel(studentCount), 0, row);
            } else {
                LinkedHashSet<UnitType> resultOfTraining = new LinkedHashSet<UnitType>();
                if (colony != null) {
                    for (Unit teacher : colony.getTeachers()) {
                        Unit student = teacher.getStudent();
                        if (student == null || student.getType() != unitType) continue;
                        resultOfTraining.add(Unit.getUnitTypeTeaching(teacher.getType(), student.getType()));
                    }
                }
                String student = resultOfTraining.size() == 1 ? Messages.message(StringTemplate.template("report.labour.learning").addName("%unit%", (FreeColObject)resultOfTraining.iterator().next())) : Messages.message("report.labour.learningOther");
                this.addRow(data, data.getUnitData().getUnitName(), student, this.createNumberLabel(-studentCount, "report.labour.subtracted.tooltip"), 0, row);
            }
            ++row;
        }
        if (this.showBuildings && row > buildingStartRow) {
            JLabel buildingLabel = new JLabel(schoolhouse != null ? Messages.message(schoolhouse.getNameKey()) : "");
            buildingLabel.setBorder(CELLBORDER);
            this.reportPanel.add((Component)buildingLabel, "cell " + this.BUILDING_COLUMN + " " + buildingStartRow + " 1 " + (row - buildingStartRow));
        }
        if (data.getUnitData().showProduction() && row > notProducingStartRow) {
            this.reportPanel.add((Component)this.createEmptyLabel(), "cell " + this.PRODUCTION_COLUMN + " " + notProducingStartRow + " 1 " + (row - notProducingStartRow));
        }
        return row;
    }

    private void addLocations() {
        LabourData.LocationData unitTotal = this.unitData.getTotal();
        int row = 1;
        JLabel summaryLabel = new JLabel(Messages.message("report.labour.summary"));
        summaryLabel.setBorder(LEFTCELLBORDER);
        this.reportPanel.add((Component)summaryLabel, "cell " + this.COLONY_COLUMN + " " + row + " 1 " + unitTotal.getRowCount());
        row = this.addLocationData(unitTotal, null, row);
        for (Colony colony : this.getSortedColonies()) {
            LabourData.LocationData colonyData = this.unitData.getDetails().get(colony);
            if (colonyData == null) continue;
            this.reportPanel.add((Component)this.createColonyButton(colony), "cell " + this.COLONY_COLUMN + " " + row + " 1 " + colonyData.getRowCount());
            row = this.addLocationData(colonyData, colony, row);
        }
        LabourData.LocationData europe = this.unitData.getUnitsInEurope();
        if (europe.getRowCount() > 0) {
            JButton button = this.createButton(Messages.message(this.getMyPlayer().getEurope().getNameKey()), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CompactLabourReport.this.getGUI().showEuropePanel();
                }
            });
            this.reportPanel.add((Component)button, "cell " + this.COLONY_COLUMN + " " + row + " 1 " + europe.getRowCount());
            row = this.addLocationData(europe, null, row);
        }
        row = this.addNonLinkedLocation(this.unitData.getUnitsOnLand(), "report.onLand", row);
        row = this.addNonLinkedLocation(this.unitData.getUnitsAtSea(), "report.atSea", row);
        this.reportPanel.add((Component)new JLabel(Messages.message("report.labour.canTrain")), "cell 1 " + row + " " + 10 + " 1");
    }

    private void addLocationSummary(LabourData.LocationData data, int row) {
        int rows = data.getRowCount();
        JLabel colonistsLabel = this.createNumberLabel(data.getTotalColonists(), null);
        if (data.getUnitData().isSummary()) {
            if (this.isOverview()) {
                this.reportPanel.add((Component)this.createEmptyLabel(), "cell " + this.UNIT_TYPE_COLUMN + " " + row + " 1 " + rows);
            }
        } else {
            colonistsLabel.setToolTipText(Messages.message(StringTemplate.template("report.labour.unitTotal.tooltip").addName("%unit%", data.getUnitData().getUnitName())));
        }
        this.reportPanel.add((Component)colonistsLabel, "cell " + this.COLONIST_SUMMARY_COLUMN + " " + row + " 1 " + data.getRowCount());
        if (this.showProduction && !data.getUnitData().showProduction()) {
            this.reportPanel.add((Component)this.createEmptyLabel(), "cell " + this.PRODUCTION_SYMBOL_COLUMN + " " + row + " 4 " + rows);
            return;
        }
        if (this.showProduction) {
            JLabel productionLabel = this.createNumberLabel(data.getTotalProduction(), "report.labour.potentialProduction.tooltip");
            if (!data.isTotal() && data.getTotalProduction() == 0) {
                productionLabel.setText("");
            }
            this.reportPanel.add((Component)productionLabel, "cell " + this.PRODUCTION_SUMMARY_COLUMN + " " + row + " 1 " + rows);
        }
        if (this.showNetProduction) {
            int net = data.getNetProduction();
            JLabel netProductionLabel = this.createNumberLabel(net, "report.labour.netProduction.tooltip");
            if (!data.getUnitData().showNetProduction() || !data.isTotal() && net == 0) {
                netProductionLabel.setText("");
                netProductionLabel.setToolTipText("");
            } else if (net >= 0) {
                netProductionLabel.setText("+" + net);
            } else {
                netProductionLabel.setForeground(Color.RED);
            }
            this.reportPanel.add((Component)netProductionLabel, "cell " + this.NETPRODUCTION_SUMMARY_COLUMN + " " + row + " 1 " + rows);
        }
        if (this.showProductionSymbols) {
            JLabel icon = new JLabel();
            icon.setBorder(CELLBORDER);
            GoodsType goods = data.getUnitData().getExpertProduction();
            if (goods != null) {
                icon.setIcon(this.getLibrary().getGoodsImageIcon(goods));
            }
            this.reportPanel.add((Component)icon, "cell " + this.PRODUCTION_SYMBOL_COLUMN + " " + row + " 1 " + rows);
        }
    }

    private int addNonLinkedLocation(LabourData.LocationData data, String messageKey, int row) {
        int rows = data.getRowCount();
        if (rows > 0) {
            JLabel label = new JLabel(Messages.message(messageKey));
            label.setBorder(LEFTCELLBORDER);
            label.setForeground(Color.GRAY);
            this.reportPanel.add((Component)label, "cell " + this.COLONY_COLUMN + " " + row + " 1 " + rows);
            return this.addLocationData(data, null, row);
        }
        return row;
    }

    private int addRow(LabourData.LocationData data, String typeName, String activity, int colonists, int production, int row) {
        if (colonists > 0) {
            this.addRow(data, typeName, activity, this.createNumberLabel(colonists, null), production, row);
            ++row;
        }
        return row;
    }

    private void addRow(LabourData.LocationData data, String typeName, String activity, JLabel colonistLabel, int production, int row) {
        if (!data.getUnitData().isSummary()) {
            JLabel typeLabel = new JLabel(typeName);
            typeLabel.setBorder(CELLBORDER);
            this.reportPanel.add((Component)typeLabel, "cell " + this.UNIT_TYPE_COLUMN + " " + row);
        }
        JLabel activityLabel = new JLabel(activity);
        activityLabel.setBorder(CELLBORDER);
        this.reportPanel.add((Component)activityLabel, "cell " + this.WORKING_COLUMN + " " + row);
        this.reportPanel.add((Component)colonistLabel, "cell " + this.COLONIST_COLUMN + " " + row);
        if (data.getUnitData().showProduction() && production > 0) {
            this.reportPanel.add((Component)this.createNumberLabel(production, "report.labour.potentialProduction.tooltip"), "cell " + this.PRODUCTION_COLUMN + " " + row);
        }
    }

    private void addUnitTypes() {
        int row = 1;
        JButton allColonistsButton = this.createUnitNameButton(Messages.message("report.labour.allColonists"), this.labourData.getSummary());
        this.reportPanel.add((Component)allColonistsButton, "cell " + this.COLONY_COLUMN + " " + row + " 1 " + this.labourData.getSummary().getUnitSummaryRowCount());
        row = this.addLocationData(this.labourData.getSummary().getTotal(), null, row);
        for (UnitType unitType : LabourData.getLabourTypes(this.getMyPlayer())) {
            LabourData.UnitData unitData = this.labourData.getUnitData(unitType);
            JButton unitButton = this.createUnitNameButton(unitData.getUnitName(), unitData);
            int rows = unitData.getUnitSummaryRowCount();
            this.reportPanel.add((Component)unitButton, "cell " + this.COLONY_COLUMN + " " + row + " 1 " + rows);
            if (unitData.hasDetails()) {
                row = this.addLocationData(unitData.getTotal(), null, row);
                continue;
            }
            unitButton.setEnabled(false);
            unitButton.setDisabledIcon(unitButton.getIcon());
            unitButton.setForeground(Color.GRAY);
            this.reportPanel.add((Component)this.createEmptyLabel(), "cell " + this.UNIT_TYPE_COLUMN + " " + row + " " + 9 + " 1");
            ++row;
        }
    }

    private JButton createButton(String name, ActionListener listener) {
        JButton button = new JButton(name);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setOpaque(false);
        button.setHorizontalAlignment(10);
        button.setForeground(LINK_COLOR);
        button.setBorder(LEFTCELLBORDER);
        button.addActionListener(listener);
        return button;
    }

    private JLabel createEmptyLabel() {
        JLabel empty = new JLabel("");
        empty.setBorder(CELLBORDER);
        return empty;
    }

    private JLabel createNonCountedLabel(int otherAmateurs) {
        JLabel label = this.createNumberLabel(otherAmateurs, "report.labour.notCounted.tooltip");
        label.setForeground(Color.GRAY);
        return label;
    }

    private JLabel createNumberLabel(int number, String toolTipKey) {
        JLabel label = new JLabel(String.valueOf(number));
        label.setHorizontalAlignment(11);
        label.setBorder(CELLBORDER);
        if (toolTipKey != null) {
            label.setToolTipText(Messages.message(toolTipKey));
        }
        return label;
    }

    private JButton createUnitNameButton(String name, final LabourData.UnitData unitData) {
        JButton button = this.createButton(name, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CompactLabourReport.this.getGUI().showCompactLabourReport(unitData);
            }
        });
        if (!unitData.isSummary()) {
            button.setIcon(this.getUnitIcon(unitData.getUnitType()));
        }
        return button;
    }

    private GoodsType getGoodsType() {
        return this.isSummary() ? null : this.unitData.getUnitType().getExpertProduction();
    }

    private ImageIcon getUnitIcon(UnitType unit) {
        Unit.Role role = Unit.Role.DEFAULT;
        if (unit.hasAbility("model.ability.expertPioneer")) {
            role = Unit.Role.PIONEER;
        } else if (unit.hasAbility("model.ability.expertMissionary")) {
            role = Unit.Role.MISSIONARY;
        }
        return this.getLibrary().getUnitImageIcon(unit, role);
    }

    private boolean isOverview() {
        return this.unitData == null;
    }

    private boolean isSummary() {
        return this.isOverview() || this.unitData.isSummary();
    }
}

