/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;

public final class ColorCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final Logger logger = Logger.getLogger(ColorCellEditor.class.getName());
    private static final String EDIT = "EDIT";
    private static final String OK = "OK";
    private static final String CANCEL = "CANCEL";
    private final JButton colorEditButton;
    private final JColorChooser colorChooser;
    private final ColorChooserPanel colorChooserPanel;
    private final Canvas canvas;
    private Color currentColor;

    public ColorCellEditor(FreeColClient freeColClient, GUI gui, Canvas canvas) {
        this.canvas = canvas;
        this.colorEditButton = new JButton();
        this.colorEditButton.setActionCommand(EDIT);
        this.colorEditButton.addActionListener(this);
        this.colorEditButton.setBorderPainted(false);
        this.colorChooser = new JColorChooser();
        this.colorChooserPanel = new ColorChooserPanel(freeColClient, gui, this);
        this.colorChooserPanel.setLocation(canvas.getWidth() / 2 - this.colorChooserPanel.getWidth() / 2, canvas.getHeight() / 2 - this.colorChooserPanel.getHeight() / 2);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals(EDIT)) {
            if (!this.canvas.isAncestorOf(this.colorChooserPanel)) {
                this.colorChooser.setColor(this.currentColor);
                this.canvas.addAsFrame(this.colorChooserPanel);
                this.colorChooserPanel.requestFocus();
            }
        } else if (event.getActionCommand().equals(OK)) {
            this.currentColor = this.colorChooser.getColor();
            this.canvas.remove(this.colorChooserPanel);
            this.fireEditingStopped();
        } else if (event.getActionCommand().equals(CANCEL)) {
            this.canvas.remove(this.colorChooserPanel);
            this.fireEditingCanceled();
        } else {
            logger.warning("Invalid action command");
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean hasFocus, int row, int column) {
        this.currentColor = (Color)value;
        return this.colorEditButton;
    }

    public Object getCellEditorValue() {
        return this.currentColor;
    }

    private final class ColorChooserPanel
    extends FreeColPanel {
        public ColorChooserPanel(FreeColClient freeColClient, GUI gui, ActionListener l) {
            super(freeColClient, gui);
            JButton okButton = new JButton(Messages.message("ok"));
            JButton cancelButton = new JButton(Messages.message("cancel"));
            this.setLayout((LayoutManager)new MigLayout("", "", ""));
            this.add(ColorCellEditor.this.colorChooser);
            this.add((Component)okButton, "newline 20, split 2, tag ok");
            this.add((Component)cancelButton, "tag cancel");
            okButton.setActionCommand(ColorCellEditor.OK);
            cancelButton.setActionCommand(ColorCellEditor.CANCEL);
            okButton.addActionListener(l);
            cancelButton.addActionListener(l);
            this.setOpaque(true);
            this.setSize(this.getPreferredSize());
        }
    }
}

