/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.BuildingDetailPanel;
import net.sf.freecol.client.gui.panel.ColopediaTreeCellRenderer;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.client.gui.panel.ConceptDetailPanel;
import net.sf.freecol.client.gui.panel.FatherDetailPanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsDetailPanel;
import net.sf.freecol.client.gui.panel.NationDetailPanel;
import net.sf.freecol.client.gui.panel.NationTypeDetailPanel;
import net.sf.freecol.client.gui.panel.ResourcesDetailPanel;
import net.sf.freecol.client.gui.panel.TerrainDetailPanel;
import net.sf.freecol.client.gui.panel.UnitDetailPanel;

public final class ColopediaPanel
extends FreeColPanel
implements HyperlinkListener,
TreeSelectionListener {
    private static final Logger logger = Logger.getLogger(ColopediaPanel.class.getName());
    private JLabel header;
    private JPanel listPanel;
    private JPanel detailPanel;
    private JTree tree;
    private Map<String, DefaultMutableTreeNode> nodeMap = new HashMap<String, DefaultMutableTreeNode>();

    public ColopediaPanel(FreeColClient freeColClient, GUI gui, String id) {
        super(freeColClient, gui);
        this.setLayout((LayoutManager)new MigLayout("fill", "[200:]unrelated[550:, grow, fill]", "[][grow, fill][]"));
        this.header = ColopediaPanel.getDefaultHeader(Messages.message("menuBar.colopedia"));
        this.add((Component)this.header, "span, align center");
        this.listPanel = new JPanel(){

            public String getUIClassID() {
                return "ColopediaPanelUI";
            }
        };
        this.listPanel.setOpaque(true);
        JScrollPane sl = new JScrollPane(this.listPanel, 22, 30);
        sl.getVerticalScrollBar().setUnitIncrement(16);
        sl.getViewport().setOpaque(false);
        this.add(sl);
        this.detailPanel = new JPanel(){

            public String getUIClassID() {
                return "ColopediaPanelUI";
            }
        };
        this.detailPanel.setOpaque(true);
        JScrollPane detail = new JScrollPane(this.detailPanel, 20, 31);
        detail.getVerticalScrollBar().setUnitIncrement(16);
        detail.getViewport().setOpaque(false);
        this.add((Component)detail, "grow");
        this.add((Component)this.okButton, "newline 20, span, tag ok");
        this.restoreSavedSize(850, 600);
        this.tree = this.buildTree();
        this.select(id);
    }

    ColopediaPanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui);
    }

    private JTree buildTree() {
        String name = Messages.message("menuBar.colopedia");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new ColopediaTreeItem(null, null, name, null));
        new TerrainDetailPanel(this.getFreeColClient(), this.getGUI(), this).addSubTrees(root);
        new ResourcesDetailPanel(this.getFreeColClient(), this.getGUI(), this).addSubTrees(root);
        new GoodsDetailPanel(this.getFreeColClient(), this.getGUI(), this).addSubTrees(root);
        new UnitDetailPanel(this.getFreeColClient(), this.getGUI(), this).addSubTrees(root);
        new BuildingDetailPanel(this.getFreeColClient(), this.getGUI(), this).addSubTrees(root);
        new FatherDetailPanel(this.getFreeColClient(), this.getGUI(), this).addSubTrees(root);
        new NationDetailPanel(this.getFreeColClient(), this.getGUI(), this).addSubTrees(root);
        new NationTypeDetailPanel(this.getFreeColClient(), this.getGUI(), this).addSubTrees(root);
        new ConceptDetailPanel(this.getFreeColClient(), this.getGUI(), this).addSubTrees(root);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(treeModel){

            public Dimension getPreferredSize() {
                return new Dimension(200, super.getPreferredSize().height);
            }
        };
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new ColopediaTreeCellRenderer());
        this.tree.setOpaque(false);
        this.tree.addTreeSelectionListener(this);
        this.listPanel.add(this.tree);
        Enumeration<TreeNode> allNodes = root.depthFirstEnumeration();
        while (allNodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)allNodes.nextElement();
            ColopediaTreeItem item = (ColopediaTreeItem)node.getUserObject();
            this.nodeMap.put(item.getId(), node);
        }
        return this.tree;
    }

    public void valueChanged(TreeSelectionEvent event) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null) {
            this.showDetails((ColopediaTreeItem)node.getUserObject());
        }
    }

    private void showDetails(ColopediaTreeItem nodeItem) {
        this.detailPanel.removeAll();
        if (nodeItem.getPanelType() != null && nodeItem.getId() != null) {
            nodeItem.getPanelType().buildDetail(nodeItem.getId(), this.detailPanel);
        }
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    private void select(String id) {
        DefaultMutableTreeNode node = this.nodeMap.get(id);
        if (node == null) {
            logger.warning("Unable to find node with id '" + id + "'.");
        } else {
            TreePath oldPath = this.tree.getSelectionPath();
            if (oldPath != null && oldPath.getParentPath() != null) {
                this.tree.collapsePath(oldPath.getParentPath());
            }
            TreePath newPath = new TreePath(node.getPath());
            this.tree.scrollPathToVisible(newPath);
            this.tree.expandPath(newPath);
            this.showDetails((ColopediaTreeItem)node.getUserObject());
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.getGUI().removeFromCanvas(this);
        } else {
            this.select(command);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        HyperlinkEvent.EventType type = e.getEventType();
        if (type == HyperlinkEvent.EventType.ACTIVATED) {
            String[] path = e.getURL().getPath().split("/");
            if ("id".equals(path[1])) {
                this.select(path[2]);
            } else if ("action".equals(path[1])) {
                this.getFreeColClient().getActionManager().getFreeColAction(path[2]).actionPerformed(null);
            }
        }
    }
}

