/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.panel.InfoPanel;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.MiniMap;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.resources.ResourceManager;

public final class ClassicMapControls
extends MapControls {
    private JPanel panel;
    private Font arrowFont;
    private ActionManager am;

    public ClassicMapControls(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, false);
        this.am = freeColClient.getActionManager();
        this.arrowFont = ResourceManager.getFont("SimpleFont", 1, 24.0f);
        this.panel = new JPanel((LayoutManager)new MigLayout("wrap 3"));
        MiniMap miniMap = this.getMiniMap();
        this.panel.add((Component)miniMap, "span, width " + miniMap.getWidth() + ", height " + miniMap.getHeight());
        this.panel.add((Component)this.makeButton("NW", "\u2196"), "newline 20");
        this.panel.add(this.makeButton("N", "\u2191"));
        this.panel.add(this.makeButton("NE", "\u2197"));
        this.panel.add(this.makeButton("W", "\u2190"));
        this.panel.add((Component)this.makeButton("E", "\u2192"), "skip");
        this.panel.add(this.makeButton("SW", "\u2199"));
        this.panel.add(this.makeButton("S", "\u2193"));
        this.panel.add((Component)this.makeButton("SE", "\u2198"), "wrap 20");
        for (UnitButton button : this.getUnitButtons()) {
            this.panel.add(button);
        }
        InfoPanel infoPanel = this.getInfoPanel();
        this.panel.add((Component)infoPanel, "newline push, span, width " + infoPanel.getWidth() + ", height " + infoPanel.getHeight());
    }

    private JButton makeButton(String direction, String arrow) {
        JButton button = new JButton(this.am.getFreeColAction("moveAction." + direction));
        button.setFont(this.arrowFont);
        button.setText(arrow);
        return button;
    }

    public boolean isShowing() {
        return this.panel.getParent() != null;
    }

    public void addToComponent(Canvas component) {
        if (this.getFreeColClient().getGame() == null || this.getFreeColClient().getGame().getMap() == null) {
            return;
        }
        int width = (int)this.panel.getPreferredSize().getWidth();
        this.panel.setSize(width, component.getHeight());
        this.panel.setLocation(component.getWidth() - width, 0);
        component.add((Component)this.panel, CONTROLS_LAYER, false);
    }

    public void removeFromComponent(Canvas canvas) {
        canvas.remove(this.panel, false);
    }
}

