/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.option.ModOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModOptionUI
extends OptionUI<ModOption> {
    private JComboBox box = new JComboBox();

    public ModOptionUI(GUI gui, ModOption option, boolean editable) {
        super(gui, option, editable);
        DefaultComboBoxModel<FreeColModFile> model = new DefaultComboBoxModel<FreeColModFile>();
        for (FreeColModFile choice : option.getChoices()) {
            model.addElement(choice);
        }
        this.box.setModel(model);
        this.box.setRenderer(new ChoiceRenderer());
        if (option.getValue() != null) {
            this.box.setSelectedItem(option.getValue());
        }
        this.initialize();
    }

    @Override
    public void updateOption() {
        ((ModOption)this.getOption()).setValue((FreeColModFile)this.box.getSelectedItem());
    }

    @Override
    public void reset() {
        this.box.setSelectedItem(((ModOption)this.getOption()).getValue());
    }

    @Override
    public JComboBox getComponent() {
        return this.box;
    }

    @Override
    public ListCellRenderer getListCellRenderer() {
        return new ChoiceRenderer();
    }

    private class ChoiceRenderer
    extends FreeColComboBoxRenderer {
        private ChoiceRenderer() {
        }

        public void setLabelValues(JLabel label, Object value) {
            FreeColModFile modFile = null;
            if (value instanceof FreeColModFile) {
                modFile = (FreeColModFile)value;
            } else if (value instanceof ModOption) {
                modFile = ((ModOption)value).getValue();
            }
            if (modFile == null) {
                label.setText(value.toString());
            } else {
                String key = "mod." + modFile.getId() + ".name";
                label.setText(Messages.message(key));
                if (Messages.containsKey(key + ".shortDescription")) {
                    label.setToolTipText(Messages.message(key + ".shortDescription"));
                }
            }
        }
    }
}

