/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;

public class ScaleMapAction
extends FreeColAction {
    public static final String id = "scaleMapAction";

    ScaleMapAction(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, id);
    }

    protected boolean shouldBeEnabled() {
        return super.shouldBeEnabled() && this.freeColClient.isMapEditor() && this.freeColClient.getGame() != null && this.freeColClient.getGame().getMap() != null;
    }

    public void actionPerformed(ActionEvent e) {
        MapSize ms = this.showMapSizeDialog();
        if (ms != null) {
            this.scaleMapTo(ms.width, ms.height);
        }
    }

    private MapSize showMapSizeDialog() {
        int COLUMNS = 5;
        Map oldMap = this.freeColClient.getGame().getMap();
        final JTextField inputWidth = new JTextField(Integer.toString(oldMap.getWidth()), 5);
        final JTextField inputHeight = new JTextField(Integer.toString(oldMap.getHeight()), 5);
        final FreeColDialog<MapSize> inputDialog = new FreeColDialog<MapSize>(this.freeColClient, this.gui){

            @Override
            public void requestFocus() {
                inputWidth.requestFocus();
            }
        };
        inputDialog.setLayout(new BoxLayout(inputDialog, 1));
        JPanel buttons = new JPanel();
        buttons.setOpaque(false);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    int width = Integer.parseInt(inputWidth.getText());
                    int height = Integer.parseInt(inputHeight.getText());
                    if (width <= 0 || height <= 0) {
                        throw new NumberFormatException();
                    }
                    inputDialog.setResponse(new MapSize(width, height));
                }
                catch (NumberFormatException nfe) {
                    ScaleMapAction.this.gui.errorMessage("integerAboveZero");
                }
            }
        };
        JButton okButton = new JButton(Messages.message("ok"));
        buttons.add(okButton);
        JButton cancelButton = new JButton(Messages.message("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                inputDialog.setResponse(null);
            }
        });
        buttons.add(cancelButton);
        inputDialog.setCancelComponent(cancelButton);
        okButton.addActionListener(al);
        inputWidth.addActionListener(al);
        inputHeight.addActionListener(al);
        JLabel widthLabel = new JLabel(Messages.message("width"));
        widthLabel.setLabelFor(inputWidth);
        JLabel heightLabel = new JLabel(Messages.message("height"));
        heightLabel.setLabelFor(inputHeight);
        JPanel widthPanel = new JPanel(new FlowLayout());
        widthPanel.setOpaque(false);
        widthPanel.add(widthLabel);
        widthPanel.add(inputWidth);
        JPanel heightPanel = new JPanel(new FlowLayout());
        heightPanel.setOpaque(false);
        heightPanel.add(heightLabel);
        heightPanel.add(inputHeight);
        inputDialog.add(widthPanel);
        inputDialog.add(heightPanel);
        inputDialog.add(buttons);
        inputDialog.setSize(inputDialog.getPreferredSize());
        return this.gui.getCanvas().showFreeColDialog(inputDialog);
    }

    private void scaleMapTo(int width, int height) {
        Game game = this.freeColClient.getGame();
        Map oldMap = game.getMap();
        int oldWidth = oldMap.getWidth();
        int oldHeight = oldMap.getHeight();
        Tile[][] tiles = new Tile[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int oldX = x * oldWidth / width;
                int oldY = y * oldHeight / height;
                Tile importTile = oldMap.getTile(oldX, oldY);
                Tile t = new Tile(game, importTile.getType(), x, y);
                if (importTile.getMoveToEurope() != null) {
                    t.setMoveToEurope(importTile.getMoveToEurope());
                }
                if (t.getTileItemContainer() != null) {
                    t.getTileItemContainer().copyFrom(importTile.getTileItemContainer());
                }
                tiles[x][y] = t;
            }
        }
        Map map = new Map(game, tiles);
        game.setMap(map);
        this.gui.setSelectedTile(map.getTile(0, 0), false);
        this.gui.refresh();
    }

    private class MapSize {
        int width;
        int height;

        MapSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

