/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.SelectableAction;
import net.sf.freecol.client.gui.panel.CornerMapControls;
import net.sf.freecol.client.gui.panel.MapControls;

public class MapControlsAction
extends SelectableAction {
    public static final String id = "mapControlsAction";
    private MapControls mapControls;

    MapControlsAction(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, id, "model.option.displayMapControls");
    }

    public void update() {
        super.update();
        this.showMapControls(this.enabled && this.isSelected());
    }

    public MapControls getMapControls() {
        return this.mapControls;
    }

    public void actionPerformed(ActionEvent e) {
        this.selected = ((AbstractButton)e.getSource()).isSelected();
        this.updateOption(this.selected);
        this.showMapControls(this.enabled && this.selected);
    }

    private void showMapControls(boolean value) {
        if (value && this.getFreeColClient().isInGame()) {
            if (this.mapControls == null) {
                try {
                    String className = this.freeColClient.getClientOptions().getString("model.option.mapControls");
                    Class<?> controls = Class.forName("net.sf.freecol.client.gui.panel." + className);
                    this.mapControls = (MapControls)controls.getConstructor(FreeColClient.class, GUI.class).newInstance(this.getFreeColClient(), this.gui);
                }
                catch (Exception e) {
                    this.mapControls = new CornerMapControls(this.getFreeColClient(), this.gui);
                }
            }
            this.mapControls.update();
        }
        if (this.mapControls != null) {
            if (value) {
                if (!this.mapControls.isShowing()) {
                    this.mapControls.addToComponent(this.gui.getCanvas());
                }
                this.mapControls.update();
            } else if (this.mapControls.isShowing()) {
                this.mapControls.removeFromComponent(this.gui.getCanvas());
            }
        }
    }
}

