/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.WindowedFrameListener;
import net.sf.freecol.common.resources.ResourceManager;

public final class WindowedFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(WindowedFrame.class.getName());
    private Canvas canvas;

    public WindowedFrame() {
        super("FreeCol " + FreeCol.getVersion());
        logger.info("WindowedFrame's JFrame created.");
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ResourceManager.startBackgroundPreloading(WindowedFrame.this.canvas.getSize());
            }
        });
        logger.info("WindowedFrame created.");
    }

    public void setCanvas(FreeColClient freeColClient, Canvas canvas) {
        this.canvas = canvas;
        this.addWindowListener(new WindowedFrameListener(freeColClient));
    }

    public void addComponent(JComponent c) {
        this.canvas.add(c);
    }
}

