/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.util.logging.Logger;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.client.gui.TerrainCursor;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public class ViewMode {
    public static final int MOVE_UNITS_MODE = 0;
    public static final int VIEW_TERRAIN_MODE = 1;
    private static final Logger logger = Logger.getLogger(MapViewer.class.getName());
    private int currentMode;
    private Unit savedActiveUnit;
    private MapViewer mapViewer;

    public ViewMode(MapViewer gui) {
        this.mapViewer = gui;
    }

    public void toggleViewMode() {
        logger.warning("Changing view");
        this.changeViewMode(1 - this.currentMode);
    }

    public void changeViewMode(int newViewMode) {
        if (newViewMode == this.currentMode) {
            logger.warning("Trying to change to the same view mode");
            return;
        }
        this.currentMode = newViewMode;
        switch (this.currentMode) {
            case 0: {
                if (this.mapViewer.getActiveUnit() == null) {
                    this.mapViewer.setActiveUnit(this.savedActiveUnit);
                }
                this.savedActiveUnit = null;
                logger.warning("Change view to Move Units Mode");
                break;
            }
            case 1: {
                this.savedActiveUnit = this.mapViewer.getActiveUnit();
                this.mapViewer.setActiveUnit(null);
                logger.warning("Change view to View Terrain Mode");
            }
        }
    }

    public int getView() {
        return this.currentMode;
    }

    public boolean displayTileCursor(Tile tile) {
        if (this.currentMode == 1) {
            Tile selectedTile = this.mapViewer.getSelectedTile();
            if (selectedTile == null || tile == null) {
                return false;
            }
            if (selectedTile.equals(tile)) {
                TerrainCursor cursor = this.mapViewer.getCursor();
                cursor.setTile(tile);
                return true;
            }
        }
        return false;
    }

    public boolean displayUnitCursor(Unit unit) {
        if (this.currentMode == 0) {
            TerrainCursor cursor = this.mapViewer.getCursor();
            if (unit == this.mapViewer.getActiveUnit() && (cursor.isActive() || unit.getMovesLeft() == 0)) {
                cursor.setTile(unit.getTile());
                return true;
            }
        }
        return false;
    }
}

