/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InputHandler;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.StreamedMessageHandler;
import net.sf.freecol.common.option.MapGeneratorOptions;
import net.sf.freecol.common.option.OptionGroup;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class PreGameInputHandler
extends InputHandler
implements StreamedMessageHandler {
    private static final Logger logger = Logger.getLogger(PreGameInputHandler.class.getName());

    public PreGameInputHandler(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui);
    }

    public synchronized Element handle(Connection connection, Element element) {
        Element reply = null;
        if (element != null) {
            String type = element.getTagName();
            if (type.equals("addPlayer")) {
                reply = this.addPlayer(element);
            } else if (type.equals("removePlayer")) {
                reply = this.removePlayer(element);
            } else if (type.equals("updateGameOptions")) {
                reply = this.updateGameOptions(element);
            } else if (type.equals("updateMapGeneratorOptions")) {
                reply = this.updateMapGeneratorOptions(element);
            } else if (type.equals("chat")) {
                reply = this.chat(element);
            } else if (type.equals("playerReady")) {
                reply = this.playerReady(element);
            } else if (type.equals("updateNation")) {
                reply = this.updateNation(element);
            } else if (type.equals("updateNationType")) {
                reply = this.updateNationType(element);
            } else if (type.equals("setAvailable")) {
                reply = this.setAvailable(element);
            } else if (type.equals("startGame")) {
                reply = this.startGame(element);
            } else if (type.equals("logout")) {
                reply = this.logout(element);
            } else if (type.equals("disconnect")) {
                reply = this.disconnect(element);
            } else if (type.equals("error")) {
                reply = this.error(element);
            } else if (type.equals("multiple")) {
                reply = this.multiple(connection, element);
            } else {
                logger.warning("Message is of unsupported type \"" + type + "\".");
            }
        }
        return reply;
    }

    public void handle(Connection connection, XMLStreamReader in, XMLStreamWriter out) {
        if (in.getLocalName().equals("updateGame")) {
            this.updateGame(connection, in, out);
        } else {
            logger.warning("Unkown (streamed) request: " + in.getLocalName());
        }
    }

    public boolean accepts(String tagName) {
        return tagName.equals("updateGame");
    }

    private Element addPlayer(Element element) {
        Element playerElement;
        Game game = this.getFreeColClient().getGame();
        if (game.getFreeColGameObject((playerElement = (Element)element.getElementsByTagName(Player.getXMLElementTagName()).item(0)).getAttribute("ID")) == null) {
            Player newPlayer = new Player(game, playerElement);
            this.getFreeColClient().getGame().addPlayer(newPlayer);
        } else {
            game.getFreeColGameObject(playerElement.getAttribute("ID")).readFromXMLElement(playerElement);
        }
        this.gui.refreshPlayersTable();
        return null;
    }

    private Element removePlayer(Element element) {
        Game game = this.getFreeColClient().getGame();
        Element playerElement = (Element)element.getElementsByTagName(Player.getXMLElementTagName()).item(0);
        Player player = new Player(game, playerElement);
        this.getFreeColClient().getGame().removePlayer(player);
        this.gui.refreshPlayersTable();
        return null;
    }

    private Element updateGameOptions(Element element) {
        Game game = this.getFreeColClient().getGame();
        Element mgoElement = (Element)element.getElementsByTagName("gameOptions").item(0);
        OptionGroup gameOptions = game.getSpecification().getOptionGroup("gameOptions");
        gameOptions.readFromXMLElement(mgoElement);
        this.gui.updateGameOptions();
        return null;
    }

    private Element updateMapGeneratorOptions(Element element) {
        Element mgoElement = (Element)element.getElementsByTagName(MapGeneratorOptions.getXMLElementTagName()).item(0);
        this.getFreeColClient().getGame().getMapGeneratorOptions().readFromXMLElement(mgoElement);
        this.gui.updateMapGeneratorOptions();
        return null;
    }

    private Element chat(Element element) {
        ChatMessage chatMessage = new ChatMessage(this.getGame(), element);
        this.gui.displayChat(chatMessage.getPlayer().getName(), chatMessage.getMessage(), chatMessage.isPrivate());
        return null;
    }

    private Element playerReady(Element element) {
        Game game = this.getFreeColClient().getGame();
        Player player = (Player)game.getFreeColGameObject(element.getAttribute("player"));
        boolean ready = Boolean.valueOf(element.getAttribute("value"));
        player.setReady(ready);
        this.gui.refreshPlayersTable();
        return null;
    }

    private Element updateNation(Element element) {
        Game game = this.getFreeColClient().getGame();
        Player player = (Player)game.getFreeColGameObject(element.getAttribute("player"));
        Nation nation = this.getGame().getSpecification().getNation(element.getAttribute("value"));
        player.setNation(nation);
        this.gui.refreshPlayersTable();
        return null;
    }

    private Element updateNationType(Element element) {
        Game game = this.getFreeColClient().getGame();
        Player player = (Player)game.getFreeColGameObject(element.getAttribute("player"));
        NationType nationType = this.getGame().getSpecification().getNationType(element.getAttribute("value"));
        player.setNationType(nationType);
        this.gui.refreshPlayersTable();
        return null;
    }

    private Element setAvailable(Element element) {
        Nation nation = this.getGame().getSpecification().getNation(element.getAttribute("nation"));
        NationOptions.NationState state = Enum.valueOf(NationOptions.NationState.class, element.getAttribute("state"));
        this.getFreeColClient().getGame().getNationOptions().setNationState(nation, state);
        this.gui.refreshPlayersTable();
        return null;
    }

    private void updateGame(Connection connection, XMLStreamReader in, XMLStreamWriter out) {
        try {
            in.nextTag();
            this.getFreeColClient().getGame().readFromXML(in);
        }
        catch (XMLStreamException e) {
            logger.warning(e.toString());
        }
    }

    private Element startGame(Element element) {
        new Thread("FreeColClient:Starting game"){

            public void run() {
                while (PreGameInputHandler.this.getFreeColClient().getGame().getMap() == null) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {}
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PreGameInputHandler.this.getFreeColClient().getPreGameController().startGame();
                    }
                });
            }
        }.start();
        return null;
    }

    private Element logout(Element element) {
        Game game = this.getFreeColClient().getGame();
        String playerID = element.getAttribute("player");
        Player player = (Player)game.getFreeColGameObject(playerID);
        game.removePlayer(player);
        this.gui.refreshPlayersTable();
        return null;
    }

    private Element error(Element element) {
        if (element.hasAttribute("messageID")) {
            this.gui.errorMessage(element.getAttribute("messageID"), element.getAttribute("message"));
        } else {
            this.gui.errorMessage(null, element.getAttribute("message"));
        }
        return null;
    }

    public Element multiple(Connection connection, Element element) {
        NodeList nodes = element.getChildNodes();
        Element reply = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            reply = this.handle(connection, (Element)nodes.item(i));
        }
        return reply;
    }
}

