/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.XMLStream;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.generator.LandGenerator;
import net.sf.freecol.server.generator.MapGenerator;
import net.sf.freecol.server.generator.TerrainGenerator;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerRegion;
import net.sf.freecol.server.model.ServerUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMapGenerator
implements MapGenerator {
    private static final Logger logger = Logger.getLogger(SimpleMapGenerator.class.getName());
    private final Random random;
    private final OptionGroup mapGeneratorOptions;
    private final LandGenerator landGenerator;
    private final TerrainGenerator terrainGenerator;
    private static final float MIN_DISTANCE_FROM_POLE = 0.3f;

    public SimpleMapGenerator(Random random, Specification specification) {
        this.random = random;
        this.mapGeneratorOptions = specification.getOptionGroup("mapGeneratorOptions");
        this.landGenerator = new LandGenerator(this.mapGeneratorOptions, random);
        this.terrainGenerator = new TerrainGenerator(this.mapGeneratorOptions, random);
    }

    private int getLand() {
        return this.mapGeneratorOptions.getInteger("model.option.mapWidth") * this.mapGeneratorOptions.getInteger("model.option.mapHeight") * this.mapGeneratorOptions.getInteger("model.option.landMass") / 100;
    }

    @Override
    public void createMap(Game game) throws FreeColException {
        Game importGame;
        File importFile = ((FileOption)this.getMapGeneratorOptions().getOption("model.option.importFile")).getValue();
        if (importFile != null) {
            logger.info("Importing file " + importFile.getPath());
            importGame = this.loadSaveGame(importFile);
        } else {
            importGame = null;
        }
        boolean[][] landMap = importGame != null ? LandGenerator.importLandMap(importGame) : this.landGenerator.createLandMap();
        this.terrainGenerator.createMap(game, importGame, landMap);
        Map map = game.getMap();
        if (map.getRegions() == null || map.getRegions().isEmpty()) {
            this.terrainGenerator.createOceanRegions(map);
            this.terrainGenerator.createLandRegions(map);
        }
        this.createIndianSettlements(map, game.getPlayers());
        this.createEuropeanUnits(map, game.getPlayers());
        this.createLostCityRumours(map, importGame);
    }

    @Override
    public void createEmptyMap(Game game, boolean[][] landMap) {
        this.terrainGenerator.createMap(game, null, landMap);
    }

    private Game loadSaveGame(File importFile) throws FreeColException {
        XMLStream xs = null;
        ServerGame game = null;
        try {
            FreeColSavegameFile fis = new FreeColSavegameFile(importFile);
            xs = FreeColServer.createXMLStreamReader(fis);
            XMLStreamReader xsr = xs.getXMLStreamReader();
            xsr.nextTag();
            int savegameVersion = FreeColServer.getSavegameVersion(xsr);
            logger.info("Found savegame version " + savegameVersion);
            ArrayList<String> serverObjects = null;
            while (xsr.nextTag() != 2) {
                if (xsr.getLocalName().equals("serverObjects")) {
                    serverObjects = new ArrayList<String>();
                    while (xsr.nextTag() != 2) {
                        serverObjects.add(xsr.getLocalName());
                        serverObjects.add(xsr.getAttributeValue(null, "ID"));
                        xsr.nextTag();
                    }
                    continue;
                }
                if (!xsr.getLocalName().equals(Game.getXMLElementTagName())) continue;
                Specification specification = null;
                if (savegameVersion < 9) {
                    logger.info("Compatibility code: providing fresh specification.");
                    specification = new FreeColTcFile("freecol").getSpecification();
                }
                game = new ServerGame(null, xsr, serverObjects, specification);
                if (savegameVersion < 9) {
                    logger.info("Compatibility code: applying difficulty level.");
                    if (game.getDifficultyLevel() == null) {
                        logger.fine("Difficulty level is null");
                        game.getSpecification().applyDifficultyLevel("model.difficulty.medium");
                    } else {
                        logger.fine("Difficulty level is " + game.getDifficultyLevel().getId());
                    }
                }
                game.setCurrentPlayer(null);
                game.checkIntegrity();
            }
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new FreeColException(e.toString());
        }
        catch (FreeColException fe) {
            StringWriter sw = new StringWriter();
            fe.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new FreeColException(fe.toString());
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new FreeColException(e.toString());
        }
        finally {
            if (xs != null) {
                xs.close();
            }
        }
        return game;
    }

    public LandGenerator getLandGenerator() {
        return this.landGenerator;
    }

    public TerrainGenerator getTerrainGenerator() {
        return this.terrainGenerator;
    }

    @Override
    public OptionGroup getMapGeneratorOptions() {
        return this.mapGeneratorOptions;
    }

    private void createLostCityRumours(Map map, Game importGame) {
        boolean importRumours = this.getMapGeneratorOptions().getBoolean("model.option.importRumours");
        if (importGame != null && importRumours) {
            for (Tile importTile : importGame.getMap().getAllTiles()) {
                Map.Position p;
                LostCityRumour rumor = importTile.getLostCityRumour();
                if (rumor == null || !map.isValid(p = importTile.getPosition())) continue;
                Tile t = map.getTile(p);
                t.add(rumor);
            }
        } else {
            int number = this.getLand() / this.getMapGeneratorOptions().getInteger("model.option.rumourNumber");
            int counter = 0;
            if (importGame != null) {
                number = map.getWidth() * map.getHeight() * 25 / 3500;
            }
            int difficulty = map.getGame().getSpecification().getInteger("model.option.rumourDifficulty");
            block1: for (int i = 0; i < number; ++i) {
                for (int tries = 0; tries < 100; ++tries) {
                    Map.Position p = map.getRandomLandPosition(this.random);
                    Tile t = map.getTile(p);
                    if (map.isPolar(t) || !t.isLand() || t.hasLostCityRumour() || t.getSettlement() != null || t.getUnitCount() != 0) continue;
                    LostCityRumour r = new LostCityRumour(t.getGame(), t);
                    if (r.chooseType(null, difficulty, this.random) == LostCityRumour.RumourType.MOUNDS && t.getOwningSettlement() != null) {
                        r.setType(LostCityRumour.RumourType.MOUNDS);
                    }
                    t.addLostCityRumour(r);
                    ++counter;
                    continue block1;
                }
            }
            logger.info("Created " + counter + " lost city rumours of maximum " + number + ".");
        }
    }

    private void createIndianSettlements(final Map map, List<Player> players) {
        Specification spec = map.getGame().getSpecification();
        float shares = 0.0f;
        ArrayList<IndianSettlement> settlements = new ArrayList<IndianSettlement>();
        ArrayList<Player> indians = new ArrayList<Player>();
        HashMap<String, Territory> territoryMap = new HashMap<String, Territory>();
        for (Player player : players) {
            if (!player.isIndian()) continue;
            switch (((IndianNationType)player.getNationType()).getNumberOfSettlements()) {
                case HIGH: {
                    shares += 4.0f;
                    break;
                }
                case AVERAGE: {
                    shares += 3.0f;
                    break;
                }
                case LOW: {
                    shares += 2.0f;
                }
            }
            indians.add(player);
            List<String> regionNames = ((IndianNationType)player.getNationType()).getRegionNames();
            Territory territory = null;
            if (regionNames == null || regionNames.isEmpty()) {
                territory = new Territory(player, map.getRandomLandPosition(this.random));
                territoryMap.put(player.getId(), territory);
                continue;
            }
            for (String name : regionNames) {
                if (territoryMap.get(name) != null) continue;
                ServerRegion region = (ServerRegion)map.getRegion(name);
                territory = region == null ? new Territory(player, map.getRandomLandPosition(this.random)) : new Territory(player, region);
                territoryMap.put(name, territory);
                logger.fine("Allocated region " + name + " for " + player + ". Center is " + territory.getCenter() + ".");
                break;
            }
            if (territory != null) continue;
            logger.warning("Failed to allocate preferred region " + regionNames.get(0) + " for " + player.getNation());
            block12: for (String name : regionNames) {
                Territory otherTerritory = (Territory)territoryMap.get(name);
                for (String otherName : ((IndianNationType)otherTerritory.player.getNationType()).getRegionNames()) {
                    if (territoryMap.get(otherName) != null) continue;
                    ServerRegion foundRegion = otherTerritory.region;
                    otherTerritory.region = (ServerRegion)map.getRegion(otherName);
                    territoryMap.put(otherName, otherTerritory);
                    territory = new Territory(player, foundRegion);
                    territoryMap.put(name, territory);
                    break block12;
                }
            }
            if (territory != null) continue;
            logger.warning("Unable to find free region for " + player.getName());
            territory = new Territory(player, map.getRandomLandPosition(this.random));
            territoryMap.put(player.getId(), territory);
        }
        if (indians.isEmpty()) {
            return;
        }
        int minSettlementDistance = spec.getRangeOption("model.option.settlementNumber").getValue();
        ArrayList<Tile> settlementTiles = new ArrayList<Tile>();
        block14: for (Tile tile : map.getAllTiles()) {
            if (map.isPolar(tile) || !this.suitableForNativeSettlement(tile)) continue;
            for (Tile t : settlementTiles) {
                if (tile.getDistanceTo(t) >= minSettlementDistance) continue;
                continue block14;
            }
            settlementTiles.add(tile);
        }
        Collections.shuffle(settlementTiles, this.random);
        int settlementsToPlace = settlementTiles.size();
        float share = (float)settlementsToPlace / shares;
        if (settlementTiles.size() < indians.size()) {
            logger.warning("There are only " + settlementTiles.size() + " settlement sites." + " This is smaller than " + indians.size() + " the number of tribes.");
        }
        ArrayList<Territory> territories = new ArrayList<Territory>(territoryMap.values());
        int settlementsPlaced = 0;
        block16: for (Territory territory : territories) {
            switch (((IndianNationType)territory.player.getNationType()).getNumberOfSettlements()) {
                case HIGH: {
                    territory.numberOfSettlements = Math.round(4.0f * share);
                    break;
                }
                case AVERAGE: {
                    territory.numberOfSettlements = Math.round(3.0f * share);
                    break;
                }
                case LOW: {
                    territory.numberOfSettlements = Math.round(2.0f * share);
                }
            }
            int radius = territory.player.getNationType().getCapitalType().getClaimableRadius();
            ArrayList<Tile> capitalTiles = new ArrayList<Tile>(settlementTiles);
            while (!capitalTiles.isEmpty()) {
                Tile tile = this.getClosestTile(territory.getCenter(), capitalTiles);
                capitalTiles.remove(tile);
                if (map.getClaimableTiles(territory.player, tile, radius).size() < (2 * radius + 1) * (2 * radius + 1) / 2) continue;
                String name = territory.region == null ? "default region" : territory.region.getNameKey();
                logger.fine("Placing the " + territory.player + " capital in region: " + name + " at Tile: " + tile.getPosition());
                settlements.add(this.placeIndianSettlement(territory.player, true, tile.getPosition(), map));
                --territory.numberOfSettlements;
                territory.position = tile.getPosition();
                settlementTiles.remove(tile);
                ++settlementsPlaced;
                continue block16;
            }
        }
        Collections.sort(settlementTiles, new Comparator<Tile>(){

            @Override
            public int compare(Tile tile1, Tile tile2) {
                int distance1 = Math.min(Math.min(tile1.getX(), map.getWidth() - tile1.getX()), Math.min(tile1.getY(), map.getHeight() - tile1.getY()));
                int distance2 = Math.min(Math.min(tile2.getX(), map.getWidth() - tile2.getX()), Math.min(tile2.getY(), map.getHeight() - tile2.getY()));
                return distance1 - distance2;
            }
        });
        while (!settlementTiles.isEmpty() && !territories.isEmpty()) {
            Territory territory;
            Tile tile = (Tile)settlementTiles.remove(0);
            if (tile.getOwner() != null) continue;
            territory = this.getClosestTerritory(tile, territories);
            int radius = territory.player.getNationType().getSettlementType(false).getClaimableRadius();
            if (map.getClaimableTiles(territory.player, tile, radius).size() <= 2 * radius + 1) continue;
            String name = territory.region == null ? "default region" : territory.region.getNameKey();
            logger.fine("Placing a " + territory.player + " camp in region: " + name + " at Tile: " + tile.getPosition());
            settlements.add(this.placeIndianSettlement(territory.player, false, tile.getPosition(), map));
            ++settlementsPlaced;
            --territory.numberOfSettlements;
            if (territory.numberOfSettlements > 0) continue;
            territories.remove(territory);
        }
        HashMap<UnitType, ArrayList<IndianSettlement>> skills = new HashMap<UnitType, ArrayList<IndianSettlement>>();
        Collections.shuffle(settlements, this.random);
        for (IndianSettlement is : settlements) {
            UnitType skill;
            ArrayList<IndianSettlement> isList;
            ArrayList<Tile> tiles = new ArrayList<Tile>();
            block20: for (Tile tile : is.getOwnedTiles()) {
                for (Tile t : tile.getSurroundingTiles(1)) {
                    if (t.getOwningSettlement() != null) continue;
                    tiles.add(tile);
                    continue block20;
                }
            }
            Collections.shuffle(tiles, this.random);
            int minGrow = is.getType().getMinimumGrowth();
            int maxGrow = is.getType().getMaximumGrowth();
            if (maxGrow > minGrow) {
                Tile tile;
                for (int i = this.random.nextInt(maxGrow - minGrow) + minGrow; i > 0 && (tile = this.findFreeNeighbouringTile(is, tiles, this.random)) != null; --i) {
                    tile.setOwner(is.getOwner());
                    tile.setOwningSettlement(is);
                    tiles.add(tile);
                }
            }
            if ((isList = (ArrayList<IndianSettlement>)skills.get(skill = is.getLearnableSkill())) == null) {
                isList = new ArrayList<IndianSettlement>();
                isList.add(is);
                skills.put(skill, isList);
                continue;
            }
            isList.add(is);
        }
        ArrayList<UnitType> expertsNeeded = new ArrayList<UnitType>();
        for (GoodsType goodsType : spec.getNewWorldGoodsTypeList()) {
            UnitType expert = spec.getExpertForProducing(goodsType);
            if (skills.containsKey(expert)) continue;
            expertsNeeded.add(expert);
        }
        ArrayList isList = new ArrayList(skills.values());
        Comparator<List<IndianSettlement>> listComparator = new Comparator<List<IndianSettlement>>(){

            @Override
            public int compare(List<IndianSettlement> l1, List<IndianSettlement> l2) {
                return l2.size() - l1.size();
            }
        };
        while (!expertsNeeded.isEmpty()) {
            UnitType neededSkill = (UnitType)expertsNeeded.remove(0);
            Collections.sort(isList, listComparator);
            List extras = (List)isList.remove(0);
            UnitType extraSkill = ((IndianSettlement)extras.get(0)).getLearnableSkill();
            ArrayList choices = new ArrayList();
            for (IndianSettlement is : extras) {
                IndianNationType nation = (IndianNationType)is.getOwner().getNationType();
                int cm = is.isCapital() ? 2 : 1;
                RandomChoice<IndianSettlement> rc = null;
                for (RandomChoice<UnitType> c : nation.generateSkillsForTile(is.getTile())) {
                    if (c.getObject() != neededSkill) continue;
                    rc = new RandomChoice<IndianSettlement>(is, c.getProbability() * cm);
                    break;
                }
                choices.add(rc != null ? rc : new RandomChoice<IndianSettlement>(is, 1));
            }
            if (!choices.isEmpty()) {
                IndianSettlement chose = (IndianSettlement)RandomChoice.getWeightedRandom(logger, "expert", this.random, choices);
                logger.finest("At " + chose.getName() + " replaced " + extraSkill + " (one of " + extras.size() + ")" + " by missing " + neededSkill);
                chose.setLearnableSkill(neededSkill);
                extras.remove(chose);
                isList.add(0, extras);
                ArrayList<IndianSettlement> neededList = new ArrayList<IndianSettlement>();
                neededList.add(chose);
                isList.add(neededList);
                continue;
            }
            logger.finest("Game is missing skill: " + neededSkill);
        }
        String msg = "Settlement skills:";
        for (List iss : isList) {
            msg = msg + "  " + iss.size() + " x " + ((IndianSettlement)iss.get(0)).getLearnableSkill();
        }
        logger.info(msg);
        logger.info("Created " + settlementsPlaced + " Indian settlements of maximum " + settlementsToPlace);
    }

    private boolean suitableForNativeSettlement(Tile tile) {
        if (!tile.getType().canSettle()) {
            return false;
        }
        int good = 0;
        int n = 0;
        for (Tile t : tile.getSurroundingTiles(1)) {
            if (t.getType().canSettle()) {
                ++good;
            }
            ++n;
        }
        return good >= n / 2;
    }

    private Tile findFreeNeighbouringTile(IndianSettlement is, List<Tile> tiles, Random random) {
        for (Tile tile : tiles) {
            for (Map.Direction d : Map.Direction.getRandomDirectionArray(random)) {
                Tile t = tile.getNeighbourOrNull(d);
                if (t == null || t.getOwningSettlement() != null || !is.getOwner().canClaimForSettlement(t)) continue;
                return t;
            }
        }
        return null;
    }

    private Tile getClosestTile(Map.Position center, List<Tile> tiles) {
        Tile result = null;
        int minimumDistance = Integer.MAX_VALUE;
        for (Tile tile : tiles) {
            int distance = tile.getPosition().getDistance(center);
            if (distance >= minimumDistance) continue;
            minimumDistance = distance;
            result = tile;
        }
        return result;
    }

    private Territory getClosestTerritory(Tile tile, List<Territory> territories) {
        Territory result = null;
        int minimumDistance = Integer.MAX_VALUE;
        for (Territory territory : territories) {
            int distance = tile.getPosition().getDistance(territory.getCenter());
            if (distance >= minimumDistance) continue;
            minimumDistance = distance;
            result = territory;
        }
        return result;
    }

    private IndianSettlement placeIndianSettlement(Player player, boolean capital, Map.Position position, Map map) {
        String name;
        Tile tile = map.getTile(position);
        String string = name = capital ? player.getCapitalName() : player.getSettlementName();
        if ("".equals(name)) {
            player.installSettlementNames(Messages.getSettlementNames(player), this.random);
            name = capital ? player.getCapitalName() : player.getSettlementName();
        }
        UnitType skill = this.generateSkillForLocation(map, tile, player.getNationType());
        ServerIndianSettlement settlement = new ServerIndianSettlement(map.getGame(), player, name, tile, capital, skill, new HashSet<Player>(), null);
        logger.fine("Generated skill: " + settlement.getLearnableSkill());
        int low = settlement.getType().getMinimumSize();
        int high = settlement.getType().getMaximumSize();
        int unitCount = low + this.random.nextInt(high - low);
        for (int i = 0; i < unitCount; ++i) {
            UnitType unitType = map.getSpecification().getUnitType("model.unit.brave");
            ServerUnit unit = new ServerUnit(map.getGame(), settlement, player, unitType, unitType.getDefaultEquipment());
            unit.setIndianSettlement(settlement);
            if (i == 0) {
                unit.setLocation(tile);
                continue;
            }
            unit.setLocation(settlement);
        }
        settlement.placeSettlement(true);
        if (FreeCol.isInDebugMode()) {
            for (GoodsType goodsType : map.getSpecification().getGoodsTypeList()) {
                if (!goodsType.isNewWorldGoodsType()) continue;
                settlement.addGoods(goodsType, 150);
            }
        }
        return settlement;
    }

    private UnitType generateSkillForLocation(Map map, Tile tile, NationType nationType) {
        List<RandomChoice<UnitType>> skills = ((IndianNationType)nationType).getSkills();
        HashMap<GoodsType, Integer> scale = new HashMap<GoodsType, Integer>();
        for (RandomChoice<UnitType> randomChoice : skills) {
            scale.put(randomChoice.getObject().getExpertProduction(), 1);
        }
        for (Tile tile2 : tile.getSurroundingTiles(1)) {
            for (GoodsType goodsType : scale.keySet()) {
                scale.put(goodsType, (Integer)scale.get(goodsType) + tile2.potential(goodsType, null));
            }
        }
        ArrayList scaledSkills = new ArrayList();
        for (RandomChoice<UnitType> skill3 : skills) {
            UnitType unitType = skill3.getObject();
            int scaleValue = (Integer)scale.get(unitType.getExpertProduction());
            scaledSkills.add(new RandomChoice<UnitType>(unitType, skill3.getProbability() * scaleValue));
        }
        UnitType unitType = (UnitType)RandomChoice.getWeightedRandom(null, null, this.random, scaledSkills);
        if (unitType == null) {
            List<UnitType> unitList = map.getSpecification().getUnitTypesWithAbility("model.ability.expertScout");
            return unitList.get(this.random.nextInt(unitList.size()));
        }
        return unitType;
    }

    private void createEuropeanUnits(Map map, List<Player> players) {
        Game game = map.getGame();
        Specification spec = game.getSpecification();
        int width = map.getWidth();
        int height = map.getHeight();
        int poleDistance = (int)(0.3f * (float)height / 2.0f);
        ArrayList<Player> europeanPlayers = new ArrayList<Player>();
        for (Player player : players) {
            if (player.isREF()) {
                int x = width - 2;
                int y = this.random.nextInt(height - 2 * poleDistance) + poleDistance;
                player.setEntryLocation(map.getTile(x, y));
                continue;
            }
            if (!player.isEuropean()) continue;
            europeanPlayers.add(player);
            logger.finest("found European player " + player);
        }
        List<Map.Position> positions = this.generateStartingPositions(map, europeanPlayers);
        ArrayList<Tile> startingTiles = new ArrayList<Tile>();
        for (int index = 0; index < europeanPlayers.size(); ++index) {
            Player player = (Player)europeanPlayers.get(index);
            Map.Position position = positions.get(index);
            logger.fine("generating units for player " + player);
            ArrayList<ServerUnit> carriers = new ArrayList<ServerUnit>();
            ArrayList<ServerUnit> passengers = new ArrayList<ServerUnit>();
            List<AbstractUnit> unitList = ((EuropeanNationType)player.getNationType()).getStartingUnits();
            for (AbstractUnit startingUnit : unitList) {
                ServerUnit newUnit = new ServerUnit(game, null, player, startingUnit.getUnitType(spec), startingUnit.getEquipment(spec));
                if (newUnit.canCarryUnits() && newUnit.isNaval()) {
                    newUnit.setState(Unit.UnitState.ACTIVE);
                    carriers.add(newUnit);
                    continue;
                }
                newUnit.setState(Unit.UnitState.SENTRY);
                passengers.add(newUnit);
            }
            boolean startAtSea = true;
            if (carriers.isEmpty()) {
                logger.warning("No carriers defined for player " + player);
                startAtSea = false;
            }
            Tile startTile = null;
            int x = position.getX();
            int y = position.getY();
            for (int i = 0; i < 2 * map.getHeight(); ++i) {
                int n = i % 2 == 0 ? i / 2 : -(1 + i / 2);
                startTile = this.findTileFor(map, y + n, x, startAtSea);
                if (startTile == null) continue;
                if (startingTiles.contains(startTile)) {
                    startTile = null;
                    continue;
                }
                startingTiles.add(startTile);
                break;
            }
            if (startTile == null) {
                throw new RuntimeException("Failed to find start tile for player " + player);
            }
            startTile.setExploredBy(player, true);
            player.setEntryLocation(startTile);
            if (startAtSea) {
                for (Unit unit : carriers) {
                    unit.setLocation(startTile);
                }
                block5: for (Unit unit : passengers) {
                    for (Unit unit2 : carriers) {
                        if (unit2.getSpaceLeft() < unit.getSpaceTaken()) continue;
                        unit.setLocation(unit2);
                        continue block5;
                    }
                    unit.setLocation(player.getEurope());
                }
            } else {
                for (Unit unit : passengers) {
                    unit.setLocation(startTile);
                }
            }
            if (!FreeCol.isInFullDebugMode()) continue;
            this.createDebugUnits(map, player, startTile);
        }
    }

    private void createDebugUnits(Map map, Player player, Tile startTile) {
        Game game = map.getGame();
        Specification spec = game.getSpecification();
        UnitType unitType = spec.getUnitType("model.unit.galleon");
        ServerUnit unit4 = new ServerUnit(game, startTile, player, unitType);
        unitType = spec.getUnitType("model.unit.privateer");
        ServerUnit privateer = new ServerUnit(game, startTile, player, unitType);
        unitType = spec.getUnitType("model.unit.freeColonist");
        ServerUnit unit5 = new ServerUnit(game, unit4, player, unitType);
        unitType = spec.getUnitType("model.unit.veteranSoldier");
        ServerUnit unit6 = new ServerUnit(game, unit4, player, unitType);
        unitType = spec.getUnitType("model.unit.jesuitMissionary");
        ServerUnit unit7 = new ServerUnit(game, unit4, player, unitType);
        Tile colonyTile = null;
        Iterator<Map.Position> cti = map.getFloodFillIterator(startTile.getPosition());
        while (cti.hasNext()) {
            Tile tempTile = map.getTile(cti.next());
            if (map.isPolar(tempTile) || !player.canClaimToFoundSettlement(tempTile)) continue;
            colonyTile = tempTile;
            break;
        }
        if (colonyTile == null) {
            logger.warning("Could not find a debug colony site.");
            return;
        }
        for (TileType t : spec.getTileTypeList()) {
            if (t.isWater()) continue;
            colonyTile.setType(t);
            break;
        }
        unitType = spec.getUnitType("model.unit.expertFarmer");
        ServerUnit buildColonyUnit = new ServerUnit(game, colonyTile, player, unitType);
        String colonyName = Messages.message(player.getNationName()) + " Colony";
        ServerColony colony = new ServerColony(game, player, colonyName, colonyTile);
        colony.placeSettlement(true);
        for (Tile tile : colonyTile.getSurroundingTiles(1)) {
            if (tile.getSettlement() != null || tile.getOwner() != null && tile.getOwner().isEuropean()) continue;
            tile.setOwner(player);
            tile.setOwningSettlement(colony);
            if (!tile.hasLostCityRumour()) continue;
            tile.removeLostCityRumour();
        }
        buildColonyUnit.setLocation(colony);
        if (buildColonyUnit.getLocation() instanceof ColonyTile) {
            Tile ct = ((ColonyTile)buildColonyUnit.getLocation()).getWorkTile();
            for (TileType t : spec.getTileTypeList()) {
                if (t.isWater()) continue;
                ct.setType(t);
                TileImprovementType plowType = map.getSpecification().getTileImprovementType("model.improvement.plow");
                TileImprovementType roadType = map.getSpecification().getTileImprovementType("model.improvement.road");
                TileImprovement road = new TileImprovement(game, ct, roadType);
                road.setTurnsToComplete(0);
                TileImprovement plow = new TileImprovement(game, ct, plowType);
                plow.setTurnsToComplete(0);
                ct.setTileItemContainer(new TileItemContainer(game, ct));
                ct.getTileItemContainer().addTileItem(road);
                ct.getTileItemContainer().addTileItem(plow);
                break;
            }
        }
        BuildingType schoolType = spec.getBuildingType("model.building.schoolhouse");
        ServerBuilding schoolhouse = new ServerBuilding(game, colony, schoolType);
        colony.addBuilding(schoolhouse);
        unitType = spec.getUnitType("model.unit.masterCarpenter");
        ServerUnit carpenter = new ServerUnit(game, colonyTile, player, unitType);
        carpenter.setLocation(colony.getBuildingForProducing(unitType.getExpertProduction()));
        unitType = spec.getUnitType("model.unit.elderStatesman");
        ServerUnit statesman = new ServerUnit(game, colonyTile, player, unitType);
        statesman.setLocation(colony.getBuildingForProducing(unitType.getExpertProduction()));
        unitType = spec.getUnitType("model.unit.expertLumberJack");
        ServerUnit lumberjack = new ServerUnit(game, colony, player, unitType);
        if (lumberjack.getLocation() instanceof ColonyTile) {
            Tile lt = ((ColonyTile)lumberjack.getLocation()).getWorkTile();
            for (TileType t : spec.getTileTypeList()) {
                if (!t.isForested()) continue;
                lt.setType(t);
                break;
            }
            lumberjack.setWorkType(lumberjack.getType().getExpertProduction());
        }
        unitType = spec.getUnitType("model.unit.seasonedScout");
        ServerUnit scout = new ServerUnit(game, colonyTile, player, unitType);
        unitType = spec.getUnitType("model.unit.veteranSoldier");
        ServerUnit unit8 = new ServerUnit(game, colonyTile, player, unitType);
        ServerUnit unit9 = new ServerUnit(game, colonyTile, player, unitType);
        unitType = spec.getUnitType("model.unit.artillery");
        ServerUnit unit10 = new ServerUnit(game, colonyTile, player, unitType);
        ServerUnit unit11 = new ServerUnit(game, colonyTile, player, unitType);
        ServerUnit unit12 = new ServerUnit(game, colonyTile, player, unitType);
        unitType = spec.getUnitType("model.unit.treasureTrain");
        ServerUnit unit13 = new ServerUnit(game, colonyTile, player, unitType);
        unit13.setTreasureAmount(10000);
        unitType = spec.getUnitType("model.unit.wagonTrain");
        ServerUnit unit14 = new ServerUnit(game, colonyTile, player, unitType);
        GoodsType cigarsType = spec.getGoodsType("model.goods.cigars");
        Goods cigards = new Goods(game, unit14, cigarsType, 5);
        unit14.add(cigards);
        unitType = spec.getUnitType("model.unit.jesuitMissionary");
        ServerUnit unit15 = new ServerUnit(game, colonyTile, player, unitType);
        ServerUnit unit16 = new ServerUnit(game, colonyTile, player, unitType);
    }

    private List<Map.Position> generateStartingPositions(Map map, List<Player> players) {
        int number = players.size();
        ArrayList<Map.Position> positions = new ArrayList<Map.Position>(number);
        if (number > 0) {
            int west = 0;
            int east = map.getWidth() - 1;
            switch (map.getSpecification().getInteger("model.option.startingPositions")) {
                case 0: {
                    int distance = map.getHeight() / number;
                    int row = distance / 2;
                    for (int index = 0; index < number; ++index) {
                        positions.add(new Map.Position(east, row));
                        row += distance;
                    }
                    Collections.shuffle(positions);
                    break;
                }
                case 1: {
                    int distance = 2 * map.getHeight() / number;
                    int row = distance / 2;
                    for (int index = 0; index < number; ++index) {
                        if (index % 2 == 0) {
                            positions.add(new Map.Position(east, row));
                            continue;
                        }
                        positions.add(new Map.Position(west, row));
                        row += distance;
                    }
                    Collections.shuffle(positions);
                    break;
                }
                case 2: {
                    for (Player player : players) {
                        Nation nation = player.getNation();
                        positions.add(new Map.Position(nation.startsOnEastCoast() ? east : west, map.getRow(nation.getPreferredLatitude())));
                    }
                    break;
                }
            }
        }
        return positions;
    }

    private Tile findTileFor(Map map, int row, int start, boolean startAtSea) {
        Tile tile = null;
        if (0 <= row && row < map.getHeight()) {
            int x;
            Tile firstLand = null;
            int offset = start == 0 ? 1 : -1;
            for (x = start; 0 <= x && x < map.getWidth(); x += offset) {
                tile = map.getTile(x, row);
                if (!tile.isLand()) continue;
                if (startAtSea) {
                    firstLand = tile;
                    start = x - offset;
                    break;
                }
                return tile;
            }
            if (firstLand != null) {
                offset = -offset;
                for (x = start; 0 <= x && x < map.getWidth(); x += offset) {
                    tile = map.getTile(x, row);
                    if (!tile.canMoveToEurope()) continue;
                    return tile;
                }
            }
        }
        return null;
    }

    private class Territory {
        public ServerRegion region;
        public Map.Position position;
        public Player player;
        public int numberOfSettlements;

        public Territory(Player player, Map.Position position) {
            this.player = player;
            this.position = position;
        }

        public Territory(Player player, ServerRegion region) {
            this.player = player;
            this.region = region;
        }

        public Map.Position getCenter() {
            if (this.position == null) {
                return this.region.getCenter();
            }
            return this.position;
        }

        public String toString() {
            return this.player + " territory at " + this.region.toString();
        }
    }
}

