/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class CashInTreasureTrainMission
extends Mission {
    private static final Logger logger = Logger.getLogger(CashInTreasureTrainMission.class.getName());

    public CashInTreasureTrainMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
    }

    public CashInTreasureTrainMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public CashInTreasureTrainMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void dispose() {
        super.dispose();
    }

    public void doMission(Connection connection) {
        Unit unit = this.getUnit();
        Map map = unit.getGame().getMap();
        if (!this.isValid()) {
            return;
        }
        if (!unit.canCashInTreasureTrain()) {
            Map.Direction r;
            GoalDecider destinationDecider = new GoalDecider(){
                private PathNode best = null;

                public PathNode getGoal() {
                    return this.best;
                }

                public boolean hasSubGoals() {
                    return false;
                }

                public boolean check(Unit u, PathNode pathNode) {
                    Tile t = pathNode.getTile();
                    if (u.canCashInTreasureTrain(t)) {
                        this.best = pathNode;
                        return true;
                    }
                    return false;
                }
            };
            PathNode bestPath = map.search(unit, unit.getTile(), destinationDecider, CostDeciders.avoidSettlementsAndBlockingUnits(), Integer.MAX_VALUE);
            if (!(bestPath == null || (r = this.moveTowards(bestPath)) != null && this.moveButDontAttack(r))) {
                return;
            }
        }
        if (unit.canCashInTreasureTrain()) {
            AIMessage.askCashInTreasureTrain(this.getAIUnit());
        }
    }

    public Tile getTransportDestination() {
        return null;
    }

    public int getTransportPriority() {
        if (this.getTransportDestination() != null) {
            return 100;
        }
        return 0;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXML(out, CashInTreasureTrainMission.getXMLElementTagName());
    }

    public static String getXMLElementTagName() {
        return "cashInTreasureTrainMission";
    }
}

