/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTradeItem;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.CashInTreasureTrainMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtColonyMission;
import net.sf.freecol.server.ai.mission.IndianBringGiftMission;
import net.sf.freecol.server.ai.mission.IndianDemandMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EuropeanAIPlayer
extends AIPlayer {
    private static final Logger logger = Logger.getLogger(EuropeanAIPlayer.class.getName());
    private AIStrategy strategy = AIStrategy.NONE;
    private HashMap<String, Integer> sessionRegister = new HashMap();

    public EuropeanAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player.getId());
        this.setPlayer(player);
    }

    public EuropeanAIPlayer(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public EuropeanAIPlayer(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    @Override
    public void startWorking() {
        Player player = this.getPlayer();
        logger.finest("Entering method startWorking: " + player + ", year " + this.getGame().getTurn());
        this.strategy = AIStrategy.TRADE;
        this.sessionRegister.clear();
        this.clearAIUnits();
        this.cheat();
        this.determineStances();
        this.rearrangeWorkersInColonies();
        this.abortInvalidAndOneTimeMissions();
        this.ensureColonyMissions();
        this.secureSettlements();
        this.giveNormalMissions();
        this.bringGifts();
        this.demandTribute();
        this.createAIGoodsInColonies();
        this.createTransportLists();
        this.doMissions();
        this.rearrangeWorkersInColonies();
        this.abortInvalidMissions();
        this.giveNormalMissions();
        this.doMissions();
        this.rearrangeWorkersInColonies();
        this.abortInvalidMissions();
        this.ensureColonyMissions();
        this.clearAIUnits();
    }

    public Iterator<TileImprovementPlan> getTileImprovementPlanIterator() {
        ArrayList<TileImprovementPlan> tileImprovements = new ArrayList<TileImprovementPlan>();
        Iterator<AIColony> acIterator = this.getAIColonyIterator();
        while (acIterator.hasNext()) {
            AIColony ac = acIterator.next();
            Iterator<TileImprovementPlan> it = ac.getTileImprovementPlanIterator();
            while (it.hasNext()) {
                tileImprovements.add(it.next());
            }
        }
        return tileImprovements.iterator();
    }

    public void removeTileImprovementPlan(TileImprovementPlan plan) {
        Iterator<AIColony> colonyIter = this.getAIColonyIterator();
        while (colonyIter.hasNext()) {
            AIColony colony = colonyIter.next();
            if (!colony.removeTileImprovementPlan(plan)) continue;
            return;
        }
        logger.warning("Not found given TileImprovementPlan to remove");
    }

    public AIUnit recruitAIUnitInEurope(int index) {
        AIUnit aiUnit = null;
        Europe europe = this.getPlayer().getEurope();
        int n = europe.getUnitCount();
        String selectAbility = "model.ability.selectRecruit";
        boolean canSelect = this.getPlayer().hasAbility("model.ability.selectRecruit");
        Ability ability = null;
        if (!canSelect) {
            ability = new Ability("model.ability.selectRecruit");
            this.getPlayer().getFeatureContainer().addAbility(ability);
        }
        if (AIMessage.askEmigrate(this.getConnection(), index + 1) && europe.getUnitCount() == n + 1) {
            aiUnit = this.getAIUnit(europe.getUnitList().get(n));
        }
        if (ability != null) {
            this.getPlayer().getFeatureContainer().removeAbility(ability);
        }
        return aiUnit;
    }

    public AIUnit trainAIUnitInEurope(UnitType unitType) {
        if (unitType == null) {
            throw new IllegalArgumentException("Invalid UnitType.");
        }
        AIUnit aiUnit = null;
        Europe europe = this.getPlayer().getEurope();
        int n = europe.getUnitCount();
        if (AIMessage.askTrainUnitInEurope(this.getConnection(), unitType) && europe.getUnitCount() == n + 1) {
            aiUnit = this.getAIUnit(europe.getUnitList().get(n));
        }
        return aiUnit;
    }

    public boolean hasFewColonies() {
        if (!this.getPlayer().canBuildColonies()) {
            return false;
        }
        int numberOfColonies = 0;
        int numberOfWorkers = 0;
        for (Settlement settlement : this.getPlayer().getSettlements()) {
            ++numberOfColonies;
            numberOfWorkers += settlement.getUnitCount();
        }
        boolean result = numberOfColonies <= 2 || numberOfColonies >= 3 && numberOfWorkers / numberOfColonies > numberOfColonies - 2;
        logger.finest("hasFewColonies = " + result);
        return result;
    }

    public Iterator<Wish> getWishIterator() {
        ArrayList<Wish> wishList = new ArrayList<Wish>();
        Iterator<AIColony> ai = this.getAIColonyIterator();
        while (ai.hasNext()) {
            AIColony ac = ai.next();
            Iterator<Wish> wishIterator = ac.getWishIterator();
            while (wishIterator.hasNext()) {
                Wish w = wishIterator.next();
                wishList.add(w);
            }
        }
        Collections.sort(wishList);
        return wishList.iterator();
    }

    public FoundingFather selectFoundingFather(List<FoundingFather> foundingFathers) {
        int age = this.getGame().getTurn().getAge();
        FoundingFather bestFather = null;
        int bestWeight = -1;
        for (FoundingFather father : foundingFathers) {
            if (father == null) continue;
            if (father.hasAbility("model.ability.buildCustomHouse")) {
                return father;
            }
            int weight = father.getWeight(age);
            if (weight <= bestWeight) continue;
            bestWeight = weight;
            bestFather = father;
        }
        return bestFather;
    }

    public boolean acceptTax(int tax) {
        Goods toBeDestroyed = this.getPlayer().getMostValuableGoods();
        if (toBeDestroyed == null) {
            return false;
        }
        GoodsType goodsType = toBeDestroyed.getType();
        if (goodsType.isFoodType() || goodsType.isBreedable()) {
            return false;
        }
        if (goodsType.isMilitaryGoods() || goodsType.isTradeGoods() || goodsType.isBuildingMaterial()) {
            return this.getGame().getTurn().getAge() != 3;
        }
        int averageIncome = 0;
        int numberOfGoods = 0;
        List<GoodsType> goodsTypes = this.getAIMain().getGame().getSpecification().getGoodsTypeList();
        for (GoodsType type : goodsTypes) {
            if (!type.isStorable()) continue;
            averageIncome += this.getPlayer().getIncomeAfterTaxes(type);
            ++numberOfGoods;
        }
        return this.getPlayer().getIncomeAfterTaxes(toBeDestroyed.getType()) <= (averageIncome /= numberOfGoods);
    }

    public boolean acceptIndianDemand(Unit unit, Colony colony, Goods goods, int gold) {
        return this.strategy != AIStrategy.CONQUEST;
    }

    public boolean acceptMercenaryOffer() {
        return this.strategy == AIStrategy.CONQUEST || this.getPlayer().isAtWar();
    }

    @Override
    public boolean acceptDiplomaticTrade(DiplomaticTrade agreement) {
        boolean validOffer = true;
        Player.Stance stance = null;
        int value = 0;
        Iterator<TradeItem> itemIterator = agreement.iterator();
        while (itemIterator.hasNext()) {
            TradeItem item = itemIterator.next();
            if (item instanceof GoldTradeItem) {
                int gold = ((GoldTradeItem)item).getGold();
                if (item.getSource() == this.getPlayer()) {
                    value -= gold;
                    continue;
                }
                value += gold;
                continue;
            }
            if (item instanceof StanceTradeItem) {
                stance = ((StanceTradeItem)item).getStance();
                switch (stance) {
                    case UNCONTACTED: {
                        validOffer = false;
                        break;
                    }
                    case WAR: {
                        break;
                    }
                    case CEASE_FIRE: {
                        value -= 500;
                        break;
                    }
                    case PEACE: {
                        if (agreement.getSender().hasAbility("model.ability.alwaysOfferedPeace")) break;
                        value -= 1000;
                        break;
                    }
                    case ALLIANCE: {
                        value -= 2000;
                    }
                }
                continue;
            }
            if (item instanceof ColonyTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    validOffer = false;
                    break;
                }
                value += 1000;
                continue;
            }
            if (item instanceof UnitTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    validOffer = false;
                    break;
                }
                value += 100;
                continue;
            }
            if (!(item instanceof GoodsTradeItem)) continue;
            Goods goods = ((GoodsTradeItem)item).getGoods();
            if (item.getSource() == this.getPlayer()) {
                value -= this.getPlayer().getMarket().getBidPrice(goods.getType(), goods.getAmount());
                continue;
            }
            value += this.getPlayer().getMarket().getSalePrice(goods.getType(), goods.getAmount());
        }
        if (validOffer) {
            logger.info("Trade value is " + value + ", accept if >=0");
        } else {
            logger.info("Trade offer is considered invalid!");
        }
        return value >= 0 && validOffer;
    }

    @Override
    public void registerSellGoods(Goods goods) {
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + goods.getLocation().getId();
        this.sessionRegister.put(goldKey, null);
    }

    @Override
    public int buyProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method buyProposition");
        Player buyer = unit.getOwner();
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + settlement.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        Integer registered = this.sessionRegister.get(goldKey);
        if (registered == null) {
            int price = ((IndianSettlement)settlement).getPriceToSell(goods) + this.getPlayer().getTension(buyer).getValue();
            Unit missionary = ((IndianSettlement)settlement).getMissionary(buyer);
            if (missionary != null && this.getSpecification().getBoolean("model.option.enhancedMissionaries")) {
                int bonus = missionary.hasAbility("model.ability.expertMissionary") ? 8 : 9;
                price = price * bonus / 10;
            }
            this.sessionRegister.put(goldKey, new Integer(price));
            return price;
        }
        int price = registered;
        if (price < 0 || price == gold) {
            return price;
        }
        if (gold < price * 9 / 10) {
            logger.warning("Cheating attempt: sending a offer too low");
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = this.sessionRegister.get(hagglingKey);
        }
        if (this.getAIRandom().nextInt(3 + haggling) <= 3) {
            this.sessionRegister.put(goldKey, new Integer(gold));
            this.sessionRegister.put(hagglingKey, new Integer(haggling + 1));
            return gold;
        }
        this.sessionRegister.put(goldKey, new Integer(-1));
        return -1;
    }

    @Override
    public int sellProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method sellProposition");
        Player seller = unit.getOwner();
        Colony colony = (Colony)settlement;
        Player otherPlayer = unit.getOwner();
        if (this.getPlayer().atWarWith(otherPlayer)) {
            return -1;
        }
        int amount = colony.getWarehouseCapacity() - colony.getGoodsCount(goods.getType());
        amount = Math.min(amount, goods.getAmount());
        Tension.Level tensionLevel = this.getPlayer().getTension(otherPlayer).getLevel();
        int percentage = (9 - tensionLevel.ordinal()) * 10;
        int netProfits = (100 - this.getPlayer().getTax()) * this.getPlayer().getMarket().getSalePrice(goods.getType(), amount) / 100;
        int price = netProfits * percentage / 100;
        return price;
    }

    private void cheat() {
        logger.finest("Entering method cheat");
        for (GoodsType goodsType : this.getAIMain().getGame().getSpecification().getGoodsTypeList()) {
            this.getPlayer().getMarket().setArrears(goodsType, 0);
        }
        if (this.getAIMain().getFreeColServer().isSingleplayer() && this.getPlayer().getPlayerType() == Player.PlayerType.COLONIAL) {
            Europe europe = this.getPlayer().getEurope();
            List<UnitType> unitTypes = this.getAIMain().getGame().getSpecification().getUnitTypeList();
            if (this.getAIRandom().nextInt(10) == 1) {
                ArrayList<WorkerWish> workerWishes = new ArrayList<WorkerWish>();
                for (Colony colony : this.getPlayer().getColonies()) {
                    AIColony aiColony = this.getAIMain().getAIColony(colony);
                    workerWishes.addAll(aiColony.getWorkerWishes());
                }
                if (!workerWishes.isEmpty()) {
                    Collections.sort(workerWishes);
                    UnitType unitToTrain = ((WorkerWish)workerWishes.get(0)).getUnitType();
                    int unitPrice = europe.getUnitPrice(unitToTrain);
                    if (unitPrice >= 0) {
                        Unit unit;
                        this.getPlayer().modifyGold(unitPrice);
                        AIUnit aiUnit = this.trainAIUnitInEurope(unitToTrain);
                        if (aiUnit != null && (unit = aiUnit.getUnit()) != null && unit.isColonist()) {
                            Specification spec = this.getAIMain().getGame().getSpecification();
                            GoodsType muskets = spec.getGoodsType("model.goods.muskets");
                            GoodsType horses = spec.getGoodsType("model.goods.horses");
                            this.getPlayer().modifyGold(this.getPlayer().getMarket().getBidPrice(muskets, 50));
                            this.getPlayer().modifyGold(this.getPlayer().getMarket().getBidPrice(horses, 50));
                            EquipmentType horsesEq = spec.getEquipmentType("model.equipment.horses");
                            EquipmentType musketsEq = spec.getEquipmentType("model.equipment.muskets");
                            AIMessage.askEquipUnit(this.getAIUnit(unit), horsesEq, 1);
                            AIMessage.askEquipUnit(this.getAIUnit(unit), musketsEq, 1);
                        }
                    }
                }
            }
            if (this.getAIRandom().nextInt(40) == 21) {
                int total = 0;
                ArrayList<UnitType> navalUnits = new ArrayList<UnitType>();
                for (UnitType unitType : unitTypes) {
                    if (!unitType.hasAbility("model.ability.navalUnit") || !unitType.hasPrice()) continue;
                    navalUnits.add(unitType);
                    total += europe.getUnitPrice(unitType);
                }
                UnitType unitToPurchase = null;
                int random = this.getAIRandom().nextInt(total);
                total = 0;
                for (UnitType unitType : navalUnits) {
                    if (random >= (total += unitType.getPrice())) continue;
                    unitToPurchase = unitType;
                    break;
                }
                this.getPlayer().modifyGold(europe.getUnitPrice(unitToPurchase));
                this.trainAIUnitInEurope(unitToPurchase);
            }
        }
    }

    private void ensureColonyMissions() {
        logger.finest("Entering method ensureColonyMissions");
        for (AIUnit au : this.getAIUnits()) {
            Unit u;
            if (au.hasMission() || !((u = au.getUnit()).getLocation() instanceof WorkLocation)) continue;
            AIColony ac = this.getAIColony(u.getColony());
            if (ac == null) {
                logger.warning("No AIColony for unit: " + u + " at: " + u.getLocation());
                continue;
            }
            au.setMission(new WorkInsideColonyMission(this.getAIMain(), au, ac));
        }
    }

    private void rearrangeWorkersInColonies() {
        logger.finest("Entering method rearrangeWorkersInColonies");
        Iterator<AIColony> ci = this.getAIColonyIterator();
        while (ci.hasNext()) {
            AIColony c = ci.next();
            if (c.getColony().getOwner() != this.getPlayer()) continue;
            ArrayList<Tile> oldWorkTiles = new ArrayList<Tile>();
            for (ColonyTile colonyTile : c.getColony().getColonyTiles()) {
                if (colonyTile.isEmpty()) continue;
                oldWorkTiles.add(colonyTile.getWorkTile());
            }
            c.rearrangeWorkers(this.getConnection());
        }
    }

    private void secureSettlements() {
        for (Colony colony : this.getPlayer().getColonies()) {
            this.equipSoldiersOutsideColony(colony);
            this.reOrganizeSoldiersOfColony(colony);
        }
    }

    void equipSoldiersOutsideColony(Colony colony) {
        boolean colonyHasArmedUnits = false;
        boolean canArmUnit = false;
        EquipmentType musketsEqType = this.getAIMain().getGame().getSpecification().getEquipmentType("model.equipment.muskets");
        EquipmentType horsesEqType = this.getAIMain().getGame().getSpecification().getEquipmentType("model.equipment.horses");
        Comparator<Unit> comp = Unit.getSkillLevelComparator();
        ArrayList<Unit> unarmedExpertSoldiers = new ArrayList<Unit>();
        ArrayList<Unit> unarmedColonists = new ArrayList<Unit>();
        ArrayList<Unit> unmountedSoldiers = new ArrayList<Unit>();
        for (Unit unit : colony.getTile().getUnitList()) {
            boolean isArmed = unit.isArmed();
            boolean isMounted = unit.isMounted();
            boolean isExpertSoldier = unit.hasAbility("model.ability.expertSoldier");
            if (isExpertSoldier) {
                if (isArmed) {
                    colonyHasArmedUnits = true;
                    if (isMounted) continue;
                    unmountedSoldiers.add(unit);
                    continue;
                }
                unarmedExpertSoldiers.add(unit);
                continue;
            }
            if (unit.isArmed()) {
                colonyHasArmedUnits = true;
                if (isMounted) continue;
                unmountedSoldiers.add(unit);
                continue;
            }
            unarmedColonists.add(unit);
        }
        for (Unit unit : unarmedExpertSoldiers) {
            canArmUnit = colony.canBuildEquipment(musketsEqType);
            boolean isMounted = unit.isMounted();
            if (!canArmUnit) continue;
            AIMessage.askEquipUnit(this.getAIUnit(unit), musketsEqType, 1);
            colonyHasArmedUnits = true;
            if (isMounted) continue;
            unmountedSoldiers.add(unit);
        }
        if (!colonyHasArmedUnits) {
            canArmUnit = colony.canBuildEquipment(musketsEqType);
            if (!canArmUnit || unarmedColonists.size() == 0) {
                return;
            }
            Collections.sort(unarmedColonists, comp);
            for (Unit unit : unarmedColonists) {
                if (!unit.canBeEquippedWith(musketsEqType)) continue;
                this.cheatEquipmentGoods(colony, musketsEqType, 1);
                AIMessage.askEquipUnit(this.getAIUnit(unit), musketsEqType, 1);
                if (unit.isMounted()) break;
                unmountedSoldiers.add(unit);
                break;
            }
        }
        comp = new Comparator<Unit>(){

            @Override
            public int compare(Unit unit1, Unit unit2) {
                boolean isUnit1Expert = unit1.hasAbility("model.ability.expertSoldier");
                boolean isUnit2Expert = unit2.hasAbility("model.ability.expertSoldier");
                if (isUnit1Expert && !isUnit2Expert) {
                    return -1;
                }
                if (!isUnit1Expert && isUnit2Expert) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(unmountedSoldiers, comp);
        while (unmountedSoldiers.size() > 0 && colony.canBuildEquipment(horsesEqType)) {
            Unit soldier = (Unit)unmountedSoldiers.remove(0);
            this.cheatEquipmentGoods(colony, horsesEqType, 1);
            AIMessage.askEquipUnit(this.getAIUnit(soldier), horsesEqType, 1);
        }
    }

    private void cheatEquipmentGoods(Colony colony, EquipmentType type, int amount) {
        for (AbstractGoods goods : type.getGoodsRequired()) {
            GoodsType goodsType = goods.getType();
            int n = amount * goods.getAmount() - colony.getGoodsCount(goodsType);
            if (n <= 0) continue;
            colony.addGoods(goodsType, n);
        }
    }

    void reOrganizeSoldiersOfColony(Colony colony) {
        ArrayList<Unit> unarmedExpertSoldiers = new ArrayList<Unit>();
        ArrayList<Unit> armedNonExpertSoldiers = new ArrayList<Unit>();
        ArrayList<Unit> colonistsInside = new ArrayList<Unit>();
        Comparator<Unit> comp = Unit.getSkillLevelComparator();
        Comparator<Unit> reverseComp = Collections.reverseOrder(comp);
        for (Unit unit : colony.getTile().getUnitList()) {
            boolean isArmed = unit.isArmed();
            boolean isExpertSoldier = unit.hasAbility("model.ability.expertSoldier");
            if (isExpertSoldier) {
                if (isArmed) continue;
                unarmedExpertSoldiers.add(unit);
                continue;
            }
            if (!isArmed) continue;
            armedNonExpertSoldiers.add(unit);
        }
        Collections.sort(armedNonExpertSoldiers, reverseComp);
        for (Unit unit : unarmedExpertSoldiers) {
            if (armedNonExpertSoldiers.size() == 0) {
                return;
            }
            Unit otherSoldier = (Unit)armedNonExpertSoldiers.remove(0);
            this.switchEquipmentWith(unit, otherSoldier);
            unit.setState(Unit.UnitState.ACTIVE);
            otherSoldier.setState(Unit.UnitState.ACTIVE);
            this.getAIUnit(unit).setMission(null);
            this.getAIUnit(otherSoldier).setMission(null);
        }
        if (armedNonExpertSoldiers.size() == 0) {
            return;
        }
        colonistsInside.addAll(colony.getUnitList());
        Collections.sort(colonistsInside, comp);
        for (Unit unit : armedNonExpertSoldiers) {
            if (colonistsInside.size() == 0) {
                return;
            }
            Unit unitInside = (Unit)colonistsInside.remove(0);
            if (unit.getSkillLevel() <= unitInside.getSkillLevel()) {
                return;
            }
            Location loc = unitInside.getLocation();
            unitInside.setLocation(colony.getTile());
            this.switchEquipmentWith(unit, unitInside);
            unit.setLocation(loc);
            this.getAIUnit(unit).setMission(null);
            this.getAIUnit(unitInside).setMission(null);
        }
    }

    public void removeAllEquipment(Unit unit) {
        AIUnit aiUnit = this.getAIUnit(unit);
        Set<EquipmentType> kit = unit.getEquipment().keySet();
        for (EquipmentType type : new ArrayList<EquipmentType>(kit)) {
            AIMessage.askEquipUnit(aiUnit, type, -unit.getEquipmentCount(type));
        }
    }

    public void switchEquipmentWith(Unit unit1, Unit unit2) {
        if (!unit1.isColonist() || !unit2.isColonist()) {
            throw new IllegalArgumentException("Both units need to be colonists to switch equipment");
        }
        if (unit1.getTile() != unit2.getTile()) {
            throw new IllegalStateException("Units can only switch equipment in the same location");
        }
        if (unit1.getSettlement() == null) {
            throw new IllegalStateException("Units can only switch equipment in a settlement");
        }
        ArrayList<EquipmentType> equipList1 = new ArrayList<EquipmentType>(unit1.getEquipment().keySet());
        ArrayList<EquipmentType> equipList2 = new ArrayList<EquipmentType>(unit2.getEquipment().keySet());
        this.removeAllEquipment(unit1);
        this.removeAllEquipment(unit2);
        for (EquipmentType equip : equipList2) {
            AIMessage.askEquipUnit(this.getAIUnit(unit1), equip, 1);
        }
        for (EquipmentType equip : equipList1) {
            AIMessage.askEquipUnit(this.getAIUnit(unit2), equip, 1);
        }
    }

    protected void giveNormalMissions() {
        logger.finest("Entering method giveNormalMissions");
        HashMap<UnitType, ArrayList<Wish>> workerWishes = new HashMap<UnitType, ArrayList<Wish>>();
        for (UnitType unitType : this.getAIMain().getGame().getSpecification().getUnitTypeList()) {
            workerWishes.put(unitType, new ArrayList());
        }
        Iterator<AIColony> aIterator = this.getAIColonyIterator();
        while (aIterator.hasNext()) {
            Iterator<Wish> wIterator = aIterator.next().getWishIterator();
            while (wIterator.hasNext()) {
                Wish w = wIterator.next();
                if (!(w instanceof WorkerWish) || w.getTransportable() != null) continue;
                ((ArrayList)workerWishes.get(((WorkerWish)w).getUnitType())).add(w);
            }
        }
        boolean fewColonies = this.hasFewColonies();
        boolean isPioneerReq = PioneeringMission.getPlayerPioneers(this).size() == 0;
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            boolean isExpert;
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.hasMission()) continue;
            Unit unit = aiUnit.getUnit();
            if (unit.isUninitialized()) {
                logger.warning("Trying to assign a mission to an uninitialized object: " + unit.getId());
                continue;
            }
            if (unit.getState() == Unit.UnitState.IN_COLONY && unit.getSettlement().getUnitCount() <= 1) continue;
            if (PrivateerMission.isValid(aiUnit)) {
                aiUnit.setMission(new PrivateerMission(this.getAIMain(), aiUnit));
                continue;
            }
            if (unit.isCarrier()) {
                aiUnit.setMission(new TransportMission(this.getAIMain(), aiUnit));
                continue;
            }
            if (unit.canCarryTreasure()) {
                aiUnit.setMission(new CashInTreasureTrainMission(this.getAIMain(), aiUnit));
                continue;
            }
            if (ScoutingMission.isValid(aiUnit)) {
                aiUnit.setMission(new ScoutingMission(this.getAIMain(), aiUnit));
                continue;
            }
            if (unit.isOffensiveUnit() || unit.isDefensiveUnit()) {
                boolean isPastStart;
                Player owner = unit.getOwner();
                boolean bl = isPastStart = this.getGame().getTurn().getNumber() > 5 && !owner.getSettlements().isEmpty();
                if (!unit.isColonist() || isPastStart) {
                    this.giveMilitaryMission(aiUnit);
                    continue;
                }
            }
            boolean isPioneer = unit.hasAbility("model.ability.improveTerrain") || unit.hasAbility("model.ability.expertPioneer");
            boolean bl = isExpert = unit.getSkillLevel() > 0;
            if ((isPioneer || isPioneerReq && !isExpert) && PioneeringMission.isValid(aiUnit)) {
                aiUnit.setMission(new PioneeringMission(this.getAIMain(), aiUnit));
                isPioneerReq = false;
                continue;
            }
            if (unit.isColonist()) {
                this.giveColonistMission(aiUnit, fewColonies, workerWishes);
            }
            if (aiUnit.hasMission()) continue;
            if (aiUnit.getUnit().isOffensiveUnit()) {
                aiUnit.setMission(new UnitWanderHostileMission(this.getAIMain(), aiUnit));
                continue;
            }
            aiUnit.setMission(new IdleAtColonyMission(this.getAIMain(), aiUnit));
        }
    }

    private void giveColonistMission(AIUnit aiUnit, boolean fewColonies, java.util.Map<UnitType, ArrayList<Wish>> workerWishes) {
        Unit unit = aiUnit.getUnit();
        HashMap<Location, Integer> distances = new HashMap<Location, Integer>(121);
        for (ArrayList<Wish> al : workerWishes.values()) {
            for (Wish w : al) {
                if (distances.containsKey(w.getDestination())) continue;
                distances.put(w.getDestination(), unit.getTurnsToReach(w.getDestination()));
            }
        }
        ArrayList<Wish> wishList = workerWishes.get(unit.getType());
        Wish bestWish = null;
        int bestTurns = Integer.MAX_VALUE;
        for (int i = 0; i < wishList.size(); ++i) {
            WorkerWish ww = (WorkerWish)wishList.get(i);
            if (ww.getTransportable() != null) {
                wishList.remove(i);
                --i;
                continue;
            }
            int turns = this.getScaledTurns(distances, ww.getDestination());
            if (bestWish != null && ww.getValue() - turns * 2 <= bestWish.getValue() - bestTurns * 2) continue;
            bestWish = ww;
            bestTurns = turns;
        }
        if (bestWish != null) {
            bestWish.setTransportable(aiUnit);
            aiUnit.setMission(new WishRealizationMission(this.getAIMain(), aiUnit, bestWish));
            return;
        }
        Tile colonyTile = null;
        if (this.getPlayer().canBuildColonies() && unit.canBuildColony() && (colonyTile = BuildColonyMission.findColonyLocation(aiUnit.getUnit())) != null) {
            bestTurns = unit.getTurnsToReach(colonyTile);
        }
        if (!fewColonies || colonyTile == null || bestTurns > 10) {
            for (ArrayList<Wish> wishes : workerWishes.values()) {
                for (int j = 0; j < wishes.size(); ++j) {
                    WorkerWish ww = (WorkerWish)wishes.get(j);
                    if (ww.getTransportable() != null) {
                        wishes.remove(j);
                        --j;
                        continue;
                    }
                    int turns = this.getScaledTurns(distances, ww.getDestination());
                    if (bestWish != null && ww.getValue() - turns * 2 <= bestWish.getValue() - bestTurns * 2) continue;
                    bestWish = ww;
                    bestTurns = turns;
                }
            }
        }
        if (bestWish != null) {
            bestWish.setTransportable(aiUnit);
            aiUnit.setMission(new WishRealizationMission(this.getAIMain(), aiUnit, bestWish));
            return;
        }
        if (colonyTile != null) {
            BuildColonyMission mission = new BuildColonyMission(this.getAIMain(), aiUnit, colonyTile, this.getPlayer().getColonyValue(colonyTile));
            aiUnit.setMission(mission);
            boolean isUnitOnCarrier = aiUnit.getUnit().isOnCarrier();
            if (isUnitOnCarrier) {
                AIUnit carrier = this.getAIUnit((Unit)aiUnit.getUnit().getLocation());
                Mission carrierMission = carrier.getMission();
                if (carrierMission == null) {
                    carrierMission = new TransportMission(this.getAIMain(), carrier);
                } else if (!(carrierMission instanceof TransportMission)) {
                    throw new IllegalStateException("Carrier carrying unit not on a transport mission");
                }
                ((TransportMission)carrierMission).addToTransportList(aiUnit);
            }
            return;
        }
    }

    private int getScaledTurns(java.util.Map<Location, Integer> distances, Location destination) {
        int turns = distances.get(destination);
        if (turns == Integer.MAX_VALUE) {
            return destination.getTile() == null ? 5 : 10;
        }
        return Math.min(5, turns);
    }

    private void bringGifts() {
        logger.finest("Entering method bringGifts");
        if (!this.getPlayer().isIndian()) {
            return;
        }
        block0: for (IndianSettlement indianSettlement : this.getPlayer().getIndianSettlements()) {
            if (this.getAIRandom().nextInt(10) != 1) continue;
            int alreadyAssignedUnits = 0;
            Iterator<Unit> ownedUnits = indianSettlement.getOwnedUnitsIterator();
            while (ownedUnits.hasNext()) {
                if (!(this.getAIUnit(ownedUnits.next()).getMission() instanceof IndianBringGiftMission)) continue;
                ++alreadyAssignedUnits;
            }
            if (alreadyAssignedUnits > 1) continue;
            ArrayList<Colony> nearbyColonies = new ArrayList<Colony>();
            for (Tile t : indianSettlement.getTile().getSurroundingTiles(5)) {
                if (t.getColony() == null || !IndianBringGiftMission.isValidMission(this.getPlayer(), t.getColony().getOwner())) continue;
                nearbyColonies.add(t.getColony());
            }
            if (nearbyColonies.size() <= 0) continue;
            Colony target = (Colony)nearbyColonies.get(this.getAIRandom().nextInt(nearbyColonies.size()));
            Iterator<Unit> it2 = indianSettlement.getOwnedUnitsIterator();
            AIUnit chosenOne = null;
            while (it2.hasNext()) {
                PathNode pn;
                chosenOne = this.getAIUnit(it2.next());
                if (!(chosenOne.getUnit().getLocation() instanceof Tile) || !chosenOne.getUnit().canCarryGoods() || chosenOne.getMission() != null && !(chosenOne.getMission() instanceof UnitWanderHostileMission) || (pn = chosenOne.getUnit().findPath(indianSettlement.getTile(), target.getTile())) == null || pn.getTotalTurns() > 5) continue;
                chosenOne.setMission(new IndianBringGiftMission(this.getAIMain(), chosenOne, target));
                continue block0;
            }
        }
    }

    private void demandTribute() {
        logger.finest("Entering method demandTribute");
        if (!this.getPlayer().isIndian()) {
            return;
        }
        block0: for (IndianSettlement indianSettlement : this.getPlayer().getIndianSettlements()) {
            if (this.getAIRandom().nextInt(10) != 1) continue;
            int alreadyAssignedUnits = 0;
            Iterator<Unit> ownedUnits = indianSettlement.getOwnedUnitsIterator();
            while (ownedUnits.hasNext()) {
                if (!(this.getAIUnit(ownedUnits.next()).getMission() instanceof IndianDemandMission)) continue;
                ++alreadyAssignedUnits;
            }
            if (alreadyAssignedUnits > 1) continue;
            ArrayList<Colony> nearbyColonies = new ArrayList<Colony>();
            for (Tile t : indianSettlement.getTile().getSurroundingTiles(5)) {
                if (t.getColony() == null) continue;
                nearbyColonies.add(t.getColony());
            }
            if (nearbyColonies.size() <= 0) continue;
            int targetTension = Integer.MIN_VALUE;
            Settlement target = null;
            for (int i = 0; i < nearbyColonies.size(); ++i) {
                Colony t = (Colony)nearbyColonies.get(i);
                Player to = t.getOwner();
                if (!this.getPlayer().hasContacted(to) || !indianSettlement.hasContactedSettlement(to)) continue;
                int tension = 1 + this.getPlayer().getTension(to).getValue() + indianSettlement.getAlarm(to).getValue();
                tension = this.getAIRandom().nextInt(tension);
                if (tension <= targetTension) continue;
                targetTension = tension;
                target = t;
            }
            if (target == null) continue;
            Iterator<Unit> it2 = indianSettlement.getOwnedUnitsIterator();
            AIUnit chosenOne = null;
            while (it2.hasNext()) {
                PathNode pn;
                chosenOne = this.getAIUnit(it2.next());
                if (!(chosenOne.getUnit().getLocation() instanceof Tile) || !chosenOne.getUnit().canCarryGoods() || chosenOne.getMission() != null && !(chosenOne.getMission() instanceof UnitWanderHostileMission) || (pn = chosenOne.getUnit().findPath(indianSettlement.getTile(), target.getTile())) == null || pn.getTotalTurns() > 5) continue;
                Player tp = target.getOwner();
                int tension = 1 + this.getPlayer().getTension(tp).getValue() + indianSettlement.getAlarm(tp).getValue();
                if (this.getAIRandom().nextInt(tension) <= Tension.Level.HAPPY.getLimit()) continue;
                chosenOne.setMission(new IndianDemandMission(this.getAIMain(), chosenOne, (Colony)target));
                continue block0;
            }
        }
    }

    private void createAIGoodsInColonies() {
        logger.finest("Entering method createAIGoodsInColonies");
        Iterator<AIColony> ci = this.getAIColonyIterator();
        while (ci.hasNext()) {
            AIColony c = ci.next();
            c.createAIGoods();
        }
    }

    protected int getColonyDefenders(Colony colony) {
        int defenders = 0;
        for (AIUnit au : this.getAIUnits()) {
            Mission m = au.getMission();
            if (m == null || !(m instanceof DefendSettlementMission) || ((DefendSettlementMission)m).getSettlement() != colony || au.getUnit().getColony() != colony) continue;
            ++defenders;
        }
        return defenders;
    }

    public int getDefendColonyMissionValue(Unit unit, Colony colony, int turns) {
        if (unit == null || colony == null) {
            return Integer.MIN_VALUE;
        }
        int value = 10025 - 10 * turns;
        int defenders = this.getColonyDefenders(colony);
        value -= 500 * defenders;
        if (colony.hasStockade()) {
            value = defenders > colony.getStockade().getLevel() + 1 ? 20 - defenders : (value -= 1000 * colony.getStockade().getLevel());
        }
        return Math.max(0, value);
    }

    public int getUnitSeekAndDestroyMissionValue(Unit unit, Tile newTile, int turns) {
        if (!this.isTargetValidForSeekAndDestroy(unit, newTile)) {
            return Integer.MIN_VALUE;
        }
        Settlement settlement = newTile.getSettlement();
        Unit defender = newTile.getDefendingUnit(unit);
        int value = 10020 - turns * 100;
        if (settlement != null) {
            IndianSettlement is;
            Tension tension;
            if (settlement instanceof Colony) {
                Colony colony = (Colony)settlement;
                value += 50 * colony.getUnitCount();
                if (colony.hasStockade()) {
                    value -= 1000 * colony.getStockade().getLevel();
                }
            } else if (settlement instanceof IndianSettlement && (tension = (is = (IndianSettlement)settlement).getAlarm(unit.getOwner())) != null) {
                value += tension.getValue();
            }
        } else if (defender != null) {
            CombatModel combatModel = unit.getGame().getCombatModel();
            float off = combatModel.getOffencePower(unit, defender);
            float def = combatModel.getDefencePower(unit, defender);
            Unit train = this.getBestTreasureTrain(newTile);
            if (train != null) {
                value += Math.min(train.getTreasureAmount() / 10, 50);
            }
            if (defender.getType().getOffence() > 0) {
                value = (int)((float)value + (200.0f - def * 2.0f - (float)(turns * 50)));
            }
            value = (int)((float)value + (combatModel.getOffencePower(defender, unit) - combatModel.getDefencePower(defender, unit)));
            if (!defender.isNaval() && defender.hasAbility("model.ability.expertSoldier") && !defender.isArmed()) {
                value = (int)((float)value + (10.0f - def * 2.0f - (float)(turns * 25)));
            }
            if (value < 0) {
                value = 0;
            }
        }
        logger.finest("getUnitSeekAndDestroyMissionValue " + unit.getId() + " v " + (settlement != null ? settlement.getId() : (defender != null ? defender.getId() : "none")) + " = " + value);
        return value;
    }

    public Ownable chooseMilitaryTarget(AIUnit aiUnit) {
        Tile targetTile;
        int value;
        GoalDecider targetDecider;
        PathNode newTarget;
        PathNode last;
        Colony colony;
        int value2;
        AIMain aiMain = this.getAIMain();
        Player player = this.getPlayer();
        Object mission = null;
        final Unit unit = aiUnit.getUnit();
        Map map = aiMain.getGame().getMap();
        Unit carrier = !unit.isOnCarrier() ? null : (Unit)unit.getLocation();
        Ownable bestTarget = null;
        int bestValue = Integer.MIN_VALUE;
        Tile startTile = (carrier != null ? carrier : unit).getTile();
        if (startTile == null) {
            startTile = (carrier != null ? carrier : unit).getFullEntryLocation();
        }
        if (startTile == null) {
            logger.warning("chooseMilitaryTarget failed, no tile for: " + unit);
            return null;
        }
        if (unit.getColony() != null) {
            bestTarget = unit.getColony();
            bestValue = this.getDefendColonyMissionValue(unit, (Colony)bestTarget, 0);
        }
        GoalDecider gd = new GoalDecider(){
            private PathNode best = null;
            private int bestValue = 0;

            public PathNode getGoal() {
                return this.best;
            }

            public boolean hasSubGoals() {
                return true;
            }

            private int getValue(PathNode pathNode) {
                Colony colony = pathNode.getTile().getColony();
                return colony == null || colony.getOwner() != unit.getOwner() ? Integer.MIN_VALUE : EuropeanAIPlayer.this.getDefendColonyMissionValue(unit, colony, pathNode.getTurns());
            }

            public boolean check(Unit u, PathNode pathNode) {
                int value = this.getValue(pathNode);
                if (value > this.bestValue) {
                    this.bestValue = value;
                    this.best = pathNode;
                    return true;
                }
                return false;
            }
        };
        int MAXIMUM_TURNS_TO_SETTLEMENT = 10;
        PathNode bestPath = map.search(unit, startTile, gd, CostDeciders.avoidIllegal(), 10, carrier);
        if (bestPath != null && (value2 = this.getDefendColonyMissionValue(unit, colony = (last = bestPath.getLastNode()).getTile().getColony(), last.getTurns())) > bestValue) {
            bestTarget = colony;
            bestValue = value2;
        }
        Location bestExistingTarget = null;
        int bestDistance = Integer.MAX_VALUE;
        for (AIUnit au : this.getAIUnits()) {
            UnitSeekAndDestroyMission usdm;
            int distance;
            Unit u = au.getUnit();
            if (u.getTile() == null || !(au.getMission() instanceof UnitSeekAndDestroyMission) || (distance = unit.getTurnsToReach(startTile, (usdm = (UnitSeekAndDestroyMission)au.getMission()).getTarget().getTile())) >= bestDistance) continue;
            bestExistingTarget = usdm.getTarget();
            bestDistance = distance;
        }
        if (bestExistingTarget != null && (value = this.getUnitSeekAndDestroyMissionValue(unit, bestExistingTarget.getTile(), bestDistance)) > bestValue) {
            bestValue = value;
            bestTarget = (Ownable)((Object)bestExistingTarget);
        }
        if ((newTarget = map.search(unit, startTile, targetDecider = new GoalDecider(){
            private PathNode bestTarget = null;
            private int bestNewTargetValue = Integer.MIN_VALUE;

            public PathNode getGoal() {
                return this.bestTarget;
            }

            public boolean hasSubGoals() {
                return true;
            }

            private int getValue(PathNode pathNode) {
                Tile tile = pathNode.getTile();
                return EuropeanAIPlayer.this.isTargetValidForSeekAndDestroy(unit, tile) ? EuropeanAIPlayer.this.getUnitSeekAndDestroyMissionValue(unit, tile, pathNode.getTurns()) : Integer.MIN_VALUE;
            }

            public boolean check(Unit u, PathNode pathNode) {
                int value = this.getValue(pathNode);
                if (value > this.bestNewTargetValue) {
                    this.bestTarget = pathNode;
                    this.bestNewTargetValue = value;
                    return true;
                }
                return false;
            }
        }, CostDeciders.avoidIllegal(), Integer.MAX_VALUE, carrier)) != null && (value = this.getUnitSeekAndDestroyMissionValue(unit, targetTile = newTarget.getLastNode().getTile(), newTarget.getTotalTurns())) > bestValue) {
            bestValue = value;
            bestTarget = targetTile.getSettlement() != null ? targetTile.getSettlement() : (this.getBestTreasureTrain(targetTile) != null ? this.getBestTreasureTrain(targetTile) : targetTile.getDefendingUnit(unit));
        }
        return bestValue > 0 ? bestTarget : null;
    }

    public void giveMilitaryMission(AIUnit aiUnit) {
        Mission mission;
        logger.finest("Entering giveMilitaryMission for: " + aiUnit.getUnit());
        AIMain aiMain = this.getAIMain();
        Player player = this.getPlayer();
        Ownable bestTarget = this.chooseMilitaryTarget(aiUnit);
        if (bestTarget == null) {
            mission = new UnitWanderHostileMission(aiMain, aiUnit);
        } else if (bestTarget instanceof Settlement && ((Settlement)bestTarget).getOwner() == player) {
            Settlement settlement = (Settlement)bestTarget;
            mission = new DefendSettlementMission(aiMain, aiUnit, settlement);
        } else {
            mission = new UnitSeekAndDestroyMission(aiMain, aiUnit, (Location)((Object)bestTarget));
        }
        aiUnit.setMission(mission);
        logger.finest("giveMilitaryMission found: " + mission + " for unit: " + aiUnit);
    }

    private int getTurns(Transportable t, TransportMission tm) {
        if (t.getTransportDestination() != null && t.getTransportDestination().getTile() == tm.getUnit().getTile()) {
            return 0;
        }
        PathNode path = tm.getPath(t);
        return path == null ? -1 : path.getTotalTurns();
    }

    private void createTransportLists() {
        logger.finest("Entering method createTransportLists");
        if (!this.getPlayer().isEuropean()) {
            return;
        }
        ArrayList<AIObject> transportables = new ArrayList<AIObject>();
        for (AIUnit au : this.getAIUnits()) {
            if (au.getUnit().isNaval() || au.getTransport() != null || au.getTransportDestination() == null) continue;
            transportables.add(au);
        }
        Iterator<AIColony> aci = this.getAIColonyIterator();
        while (aci.hasNext()) {
            AIColony ac = aci.next();
            Iterator<AIGoods> iterator = ac.getAIGoodsIterator();
            while (iterator.hasNext()) {
                AIGoods ag = iterator.next();
                if (ag.getTransportDestination() == null || ag.getTransport() != null) continue;
                transportables.add(ag);
            }
        }
        for (Transportable transportable : transportables) {
            transportable.increaseTransportPriority();
        }
        Collections.sort(transportables, new Comparator<Transportable>(){

            @Override
            public int compare(Transportable o1, Transportable o2) {
                if (o1 == o2) {
                    return 0;
                }
                int result = o2.getTransportPriority() - o1.getTransportPriority();
                return result == 0 ? o1.getId().compareTo(o2.getId()) : result;
            }
        });
        ArrayList<TransportMission> availableMissions = new ArrayList<TransportMission>();
        for (AIUnit au : this.getAIUnits()) {
            if (!au.hasMission() || !(au.getMission() instanceof TransportMission) || au.getUnit().getSpaceLeft() <= 0) continue;
            availableMissions.add((TransportMission)au.getMission());
        }
        for (Transportable t : new ArrayList(transportables)) {
            Location transportableLoc = t.getTransportLocatable().getLocation();
            boolean onCarrier = transportableLoc instanceof Unit;
            if (!onCarrier) continue;
            AIUnit carrierAI = this.getAIUnit((Unit)transportableLoc);
            Mission m = carrierAI.getMission();
            if (m instanceof TransportMission) {
                ((TransportMission)m).addToTransportList(t);
            }
            transportables.remove(t);
        }
        while (!transportables.isEmpty() && !availableMissions.isEmpty()) {
            Transportable transportable = (Transportable)transportables.remove(0);
            TransportMission bestTransport = null;
            int bestTransportSpace = 0;
            int bestTransportTurns = Integer.MAX_VALUE;
            for (TransportMission tm : availableMissions) {
                int transportSpace = tm.getAvailableSpace(transportable);
                if (transportSpace <= 0 || transportable instanceof AIUnit && !tm.getUnit().canCarryUnits()) continue;
                if (transportable.getTransportSource().getTile() == tm.getUnit().getTile()) {
                    if (bestTransportTurns <= 0 && (bestTransportTurns != 0 || transportSpace <= bestTransportSpace)) continue;
                    bestTransport = tm;
                    bestTransportSpace = transportSpace;
                    bestTransportTurns = 0;
                    continue;
                }
                int totalTurns = this.getTurns(transportable, tm);
                if (totalTurns <= 0 || totalTurns >= bestTransportTurns && (totalTurns != bestTransportTurns || transportSpace <= bestTransportSpace)) continue;
                bestTransport = tm;
                bestTransportSpace = transportSpace;
                bestTransportTurns = totalTurns;
            }
            if (bestTransport == null) {
                logger.finest("Transport failed for: " + transportable);
                continue;
            }
            bestTransport.addToTransportList(transportable);
            logger.finest("Transport found for: " + transportable + " using: " + bestTransport + "  unit: " + bestTransport.getUnit());
            for (int i = 0; i < transportables.size(); ++i) {
                Transportable t2 = (Transportable)transportables.get(i);
                if (t2.getTransportLocatable().getLocation() != transportable.getTransportLocatable().getLocation() || bestTransport.getAvailableSpace(t2) <= 0) continue;
                transportables.remove(t2);
                bestTransport.addToTransportList(t2);
                logger.finest("Transport piggyback for: " + t2 + " using: " + transportable);
            }
        }
    }

    private Unit getBestTreasureTrain(Tile tile) {
        Unit best = null;
        for (Unit unit : tile.getUnitList()) {
            if (!unit.canCarryTreasure() || best != null && best.getTreasureAmount() >= unit.getTreasureAmount()) continue;
            best = unit;
        }
        return best;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AIStrategy {
        NONE,
        TRADE,
        IMMIGRATION,
        COOPERATION,
        CONQUEST;

    }
}

