/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.AbstractUnitOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitListOption
extends AbstractOption<List<AbstractUnitOption>> {
    private static Logger logger = Logger.getLogger(UnitListOption.class.getName());
    private List<AbstractUnitOption> value = new ArrayList<AbstractUnitOption>();
    private int maximumNumber = Integer.MAX_VALUE;

    public UnitListOption(String id) {
        super(id);
    }

    public UnitListOption(XMLStreamReader in) throws XMLStreamException {
        super("NO_ID");
        this.readFromXML(in);
    }

    public int getMaximumValue() {
        return this.maximumNumber;
    }

    public void setMaximumValue(int maximumNumber) {
        this.maximumNumber = maximumNumber;
    }

    @Override
    public List<AbstractUnitOption> getValue() {
        return this.value;
    }

    @Override
    public void setValue(List<AbstractUnitOption> value) {
        List<AbstractUnitOption> oldValue = this.value;
        this.value = value;
        if (!((Object)value).equals(oldValue) && this.isDefined) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(UnitListOption.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        out.writeAttribute("maximumNumber", Integer.toString(this.maximumNumber));
        for (AbstractUnitOption option : this.value) {
            option.toXML(out);
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        if (id == null && this.getId().equals("NO_ID")) {
            throw new XMLStreamException("invalid <" + UnitListOption.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        if (this.getId() == "NO_ID") {
            this.setId(id);
        }
        this.maximumNumber = this.getAttribute(in, "maximumNumber", 1);
        while (in.nextTag() != 2) {
            if (!AbstractUnitOption.getXMLElementTagName().equals(in.getLocalName())) continue;
            this.value.add(new AbstractUnitOption(in));
            in.nextTag();
        }
    }

    public static String getXMLElementTagName() {
        return "unitListOption";
    }
}

