/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractUnitOption
extends AbstractOption<AbstractUnit> {
    private static Logger logger = Logger.getLogger(AbstractUnitOption.class.getName());
    private static final Specification.TypeSelector DEFAULT_SELECTOR = Specification.TypeSelector.UNITS;
    private AbstractUnit value;
    private int minimumNumber = 1;
    private int maximumNumber = 1;
    private boolean selectRole = true;
    private Specification.TypeSelector validTypes = DEFAULT_SELECTOR;
    private List<String> choices;

    public AbstractUnitOption(String id) {
        super(id);
    }

    public AbstractUnitOption(XMLStreamReader in) throws XMLStreamException {
        super("NO_ID");
        this.readFromXML(in);
    }

    public int getMinimumValue() {
        return this.minimumNumber;
    }

    public void setMinimumValue(int minimumNumber) {
        this.minimumNumber = minimumNumber;
    }

    public int getMaximumValue() {
        return this.maximumNumber;
    }

    public void setMaximumValue(int maximumNumber) {
        this.maximumNumber = maximumNumber;
    }

    @Override
    public AbstractUnit getValue() {
        return this.value;
    }

    @Override
    public void setValue(AbstractUnit value) {
        AbstractUnit oldValue = this.value;
        this.value = value;
        if (!value.equals(oldValue) && this.isDefined) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    public boolean getSelectRole() {
        return this.selectRole;
    }

    public void setSelectRole(boolean value) {
        this.selectRole = value;
    }

    public Specification.TypeSelector getValidTypes() {
        return this.validTypes;
    }

    public void setValidTypes(Specification.TypeSelector value) {
        if (value == null || value == Specification.TypeSelector.BUILDINGS || value == Specification.TypeSelector.FOUNDING_FATHERS) {
            this.validTypes = DEFAULT_SELECTOR;
            logger.warning("Invalid type selector for AbstractUnit: " + (Object)((Object)value) + ". Falling back to default selector: " + (Object)((Object)this.validTypes));
        } else {
            this.validTypes = value;
        }
    }

    public final List<String> getChoices() {
        return this.choices;
    }

    public final void setChoices(List<String> newChoices) {
        this.choices = newChoices;
    }

    public void generateChoices(Specification specification) {
        if (this.validTypes == null) {
            if (this.choices == null || this.choices.isEmpty()) {
                this.choices = new ArrayList<String>();
                this.choices.add(this.value.getId());
            }
        } else {
            for (FreeColGameObjectType object : specification.getTypes(this.validTypes)) {
                this.choices.add(object.getId());
            }
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(AbstractUnitOption.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        out.writeAttribute("minimumNumber", Integer.toString(this.minimumNumber));
        out.writeAttribute("maximumNumber", Integer.toString(this.maximumNumber));
        out.writeAttribute("selectRole", Boolean.toString(this.selectRole));
        if (this.validTypes != null) {
            out.writeAttribute("validTypes", this.validTypes.toString());
        }
        this.value.toXML(out);
        if (this.choices != null && !this.choices.isEmpty()) {
            for (String choice : this.choices) {
                out.writeStartElement("choice");
                out.writeAttribute("value", choice);
                out.writeEndElement();
            }
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        if (id == null && this.getId().equals("NO_ID")) {
            throw new XMLStreamException("invalid <" + AbstractUnitOption.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        if (this.getId() == "NO_ID") {
            this.setId(id);
        }
        this.minimumNumber = this.getAttribute(in, "minimumNumber", 1);
        this.maximumNumber = this.getAttribute(in, "maximumNumber", 1);
        this.selectRole = AbstractUnitOption.getAttribute(in, "selectRole", true);
        this.setValidTypes(this.getAttribute(in, "validTypes", Specification.TypeSelector.class, DEFAULT_SELECTOR));
        while (in.nextTag() != 2) {
            if (AbstractUnit.getXMLElementTagName().equals(in.getLocalName())) {
                this.value = new AbstractUnit(in);
            } else if ("choice".equals(in.getLocalName())) {
                this.choices.add(in.getAttributeValue(null, "value"));
            }
            in.nextTag();
        }
    }

    public static String getXMLElementTagName() {
        return "unitOption";
    }
}

