/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.option.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOption<T>
extends FreeColObject
implements Option {
    private static Logger logger = Logger.getLogger(AbstractOption.class.getName());
    private String optionGroup = "";
    protected boolean isDefined = false;
    protected boolean previewEnabled = false;

    public AbstractOption(String id) {
        this.setId(id);
    }

    @Override
    public boolean isPreviewEnabled() {
        return this.previewEnabled;
    }

    public void setPreviewEnabled(boolean previewEnabled) {
        this.previewEnabled = previewEnabled;
    }

    public String getGroup() {
        return this.optionGroup;
    }

    public void setGroup(String group) {
        this.optionGroup = group == null ? "" : group;
    }

    public abstract T getValue();

    public abstract void setValue(T var1);

    protected void setValue(String valueString, String defaultValueString) {
        logger.warning("Unsupported method: setValue.");
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.readAttributes(in);
        while (in.nextTag() != 2) {
            this.readChild(in);
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        String defaultValue = in.getAttributeValue(null, "defaultValue");
        String value = in.getAttributeValue(null, "value");
        if (id == null && this.getId().equals("NO_ID")) {
            throw new XMLStreamException("invalid <" + AbstractOption.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        if (defaultValue == null && value == null) {
            throw new XMLStreamException("invalid <" + AbstractOption.getXMLElementTagName() + "> tag : no value nor default value found.");
        }
        if (this.getId() == "NO_ID") {
            this.setId(id);
        }
        this.setValue(value, defaultValue);
    }
}

