/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceType
extends FreeColGameObjectType {
    private int minValue;
    private int maxValue;

    public ResourceType(String id, Specification specification) {
        super(id, specification);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public Set<Modifier> getProductionModifier(GoodsType goodsType, UnitType unitType) {
        return this.getFeatureContainer().getModifierSet(goodsType.getId(), unitType);
    }

    public GoodsType getBestGoodsType() {
        GoodsType bestType = null;
        float bestValue = 0.0f;
        for (Modifier modifier : this.getFeatureContainer().getModifiers()) {
            GoodsType goodsType = this.getSpecification().getGoodsType(modifier.getId());
            float value = (float)goodsType.getInitialSellPrice() * modifier.applyTo(100.0f);
            if (bestType != null && !(value > bestValue)) continue;
            bestType = goodsType;
            bestValue = value;
        }
        return bestType;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, ResourceType.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.maxValue > -1) {
            out.writeAttribute("maximum-value", Integer.toString(this.maxValue));
            out.writeAttribute("minimum-value", Integer.toString(this.minValue));
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        if (this.hasAttribute(in, "maximum-value")) {
            this.maxValue = Integer.parseInt(in.getAttributeValue(null, "maximum-value"));
            this.minValue = this.getAttribute(in, "minimum-value", 0);
        } else {
            this.maxValue = -1;
            this.minValue = -1;
        }
    }

    public static String getXMLElementTagName() {
        return "resource-type";
    }
}

