/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomRange {
    private static Logger logger = Logger.getLogger(RandomRange.class.getName());
    private int probability = 0;
    private int minimum = 0;
    private int maximum = 0;
    private int factor = 1;
    private List<Scope> scopes = new ArrayList<Scope>();

    public RandomRange() {
    }

    public RandomRange(int probability, int minimum, int maximum, int factor) {
        this.probability = probability;
        this.minimum = minimum;
        this.maximum = maximum;
        this.factor = factor;
    }

    public RandomRange(XMLStreamReader in) throws XMLStreamException {
        this.readFromXML(in);
    }

    public final int getProbability() {
        return this.probability;
    }

    public final void setProbability(int newProbability) {
        this.probability = newProbability;
    }

    public final int getMinimum() {
        return this.minimum;
    }

    public final void setMinimum(int newMinimum) {
        this.minimum = newMinimum;
    }

    public final int getMaximum() {
        return this.maximum;
    }

    public final void setMaximum(int newMaximum) {
        this.maximum = newMaximum;
    }

    public final int getFactor() {
        return this.factor;
    }

    public final void setFactor(int newFactor) {
        this.factor = newFactor;
    }

    public int getRange() {
        return this.maximum - this.minimum;
    }

    public int getRandomLimit() {
        return this.getRange() * 100 / this.factor;
    }

    public int getAmount(int random) {
        int value = this.minimum + random;
        if (value <= this.maximum) {
            return value * this.factor;
        }
        return 0;
    }

    public int getAmount(String prefix, Random random, boolean continuous) {
        if (this.probability >= 100 || this.probability > 0 && Utils.randomInt(logger, prefix + " check-for-zero", random, 100) < this.probability) {
            if (continuous) {
                int r = Utils.randomInt(logger, prefix + " random-range", random, this.getRange() * this.factor);
                return r + this.minimum * this.factor;
            }
            int r = Utils.randomInt(logger, prefix + " random-range", random, this.getRange());
            return this.getAmount(r);
        }
        return 0;
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    public RandomRange clone() {
        return new RandomRange(this.probability, this.maximum, this.minimum, this.factor);
    }

    public void readFromXML(XMLStreamReader in) throws XMLStreamException {
        this.probability = Integer.parseInt(in.getAttributeValue(null, "probability"));
        this.minimum = Integer.parseInt(in.getAttributeValue(null, "minimum"));
        this.maximum = Integer.parseInt(in.getAttributeValue(null, "maximum"));
        this.factor = Integer.parseInt(in.getAttributeValue(null, "factor"));
        this.scopes.clear();
        while (in.nextTag() != 2) {
            String nodeName = in.getLocalName();
            if (!"scope".equals(nodeName)) continue;
            this.scopes.add(new Scope(in));
        }
    }

    public void toXML(XMLStreamWriter out, String tag) throws XMLStreamException {
        out.writeStartElement(tag);
        out.writeAttribute("probability", Integer.toString(this.probability));
        out.writeAttribute("minimum", Integer.toString(this.minimum));
        out.writeAttribute("maximum", Integer.toString(this.maximum));
        out.writeAttribute("factor", Integer.toString(this.factor));
        for (Scope scope : this.scopes) {
            scope.toXML(out);
        }
        out.writeEndElement();
    }
}

