/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoodsContainer
extends FreeColGameObject
implements Ownable {
    private static final Logger logger = Logger.getLogger(Location.class.getName());
    public static final int CARGO_SIZE = 100;
    public static final String STORED_GOODS_TAG = "storedGoods";
    public static final String OLD_STORED_GOODS_TAG = "oldStoredGoods";
    private Map<GoodsType, Integer> storedGoods = new HashMap<GoodsType, Integer>();
    private Map<GoodsType, Integer> oldStoredGoods = new HashMap<GoodsType, Integer>();
    private final Location parent;

    public GoodsContainer(Game game, Location parent) {
        super(game);
        if (parent == null) {
            throw new IllegalArgumentException("Location of GoodsContainer must not be null!");
        }
        this.parent = parent;
    }

    public GoodsContainer(Game game, Location parent, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        if (parent == null) {
            throw new IllegalArgumentException("Location of GoodsContainer must not be null!");
        }
        this.parent = parent;
        this.readFromXML(in);
    }

    public GoodsContainer(Game game, Location parent, Element e) {
        super(game, e);
        if (parent == null) {
            throw new IllegalArgumentException("Location of GoodsContainer must not be null!");
        }
        this.parent = parent;
        this.readFromXMLElement(e);
    }

    @Override
    public Player getOwner() {
        return this.parent instanceof Ownable ? ((Ownable)((Object)this.parent)).getOwner() : null;
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException("Can not set GoodsContainer owner");
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        this.storedGoods.clear();
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        objects.addAll(super.disposeList());
        return objects;
    }

    @Override
    public void dispose() {
        this.disposeList();
    }

    public boolean addGoods(AbstractGoods g) {
        return this.addGoods(g.getType(), g.getAmount());
    }

    public boolean addGoods(GoodsType type, int amount) {
        int oldAmount = this.getGoodsCount(type);
        int newAmount = oldAmount + amount;
        if (newAmount < 0) {
            throw new IllegalStateException("Operation would leave " + newAmount + " goods of type " + type.getNameKey() + " in Location " + this.parent);
        }
        if (newAmount == 0) {
            this.storedGoods.remove(type);
        } else {
            this.storedGoods.put(type, newAmount);
        }
        return true;
    }

    public Goods removeGoods(AbstractGoods g) {
        return this.removeGoods(g.getType(), g.getAmount());
    }

    public Goods removeGoods(GoodsType type) {
        return this.removeGoods(type, Integer.MAX_VALUE);
    }

    public Goods removeGoods(GoodsType type, int amount) {
        Goods removedGoods;
        int oldAmount = this.getGoodsCount(type);
        int newAmount = oldAmount - amount;
        if (newAmount > 0) {
            removedGoods = new Goods(this.getGame(), this.parent, type, amount);
            this.storedGoods.put(type, newAmount);
        } else {
            removedGoods = new Goods(this.getGame(), this.parent, type, oldAmount);
            this.storedGoods.remove(type);
        }
        return removedGoods;
    }

    public void removeAbove(int newAmount) {
        for (GoodsType goodsType : this.storedGoods.keySet()) {
            if (!goodsType.isStorable() || goodsType.limitIgnored() || this.storedGoods.get(goodsType) <= newAmount) continue;
            this.setAmount(goodsType, newAmount);
        }
    }

    public void setAmount(GoodsType goodsType, int newAmount) {
        if (newAmount == 0) {
            this.storedGoods.remove(goodsType);
        } else {
            this.storedGoods.put(goodsType, newAmount);
        }
    }

    public void removeAll() {
        this.storedGoods.clear();
    }

    public boolean hasReachedCapacity(int amount) {
        for (GoodsType goodsType : this.storedGoods.keySet()) {
            if (!goodsType.isStorable() || goodsType.limitIgnored() || this.storedGoods.get(goodsType) <= amount) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Goods g) {
        throw new UnsupportedOperationException();
    }

    public int getGoodsCount(GoodsType type) {
        if (this.storedGoods.containsKey(type)) {
            return this.storedGoods.get(type);
        }
        return 0;
    }

    public int getOldGoodsCount(GoodsType type) {
        if (this.oldStoredGoods.containsKey(type)) {
            return this.oldStoredGoods.get(type);
        }
        return 0;
    }

    public Goods getGoods(GoodsType goodsType) {
        return new Goods(this.getGame(), this.parent, goodsType, this.getGoodsCount(goodsType));
    }

    public int getGoodsCount() {
        int count = 0;
        for (Integer amount : this.storedGoods.values()) {
            if (amount % 100 == 0) {
                count += amount / 100;
                continue;
            }
            count += amount / 100 + 1;
        }
        return count;
    }

    public Iterator<Goods> getGoodsIterator() {
        return this.getGoods().iterator();
    }

    public List<Goods> getGoods() {
        ArrayList<Goods> totalGoods = new ArrayList<Goods>();
        for (GoodsType goodsType : this.storedGoods.keySet()) {
            for (int amount = this.storedGoods.get(goodsType).intValue(); amount > 0; amount -= 100) {
                totalGoods.add(new Goods(this.getGame(), this.parent, goodsType, amount >= 100 ? 100 : amount));
            }
        }
        return totalGoods;
    }

    public List<Goods> getCompactGoods() {
        ArrayList<Goods> totalGoods = new ArrayList<Goods>();
        for (Map.Entry<GoodsType, Integer> entry : this.storedGoods.entrySet()) {
            if (entry.getValue() <= 0) continue;
            totalGoods.add(new Goods(this.getGame(), this.parent, entry.getKey(), entry.getValue()));
        }
        return totalGoods;
    }

    public List<Goods> getFullGoods() {
        ArrayList<Goods> totalGoods = new ArrayList<Goods>();
        for (GoodsType goodsType : this.storedGoods.keySet()) {
            totalGoods.add(new Goods(this.getGame(), this.parent, goodsType, this.storedGoods.get(goodsType)));
        }
        return totalGoods;
    }

    public void saveState() {
        this.oldStoredGoods.clear();
        for (Map.Entry<GoodsType, Integer> entry : this.storedGoods.entrySet()) {
            this.oldStoredGoods.put(entry.getKey(), new Integer(entry.getValue()));
        }
    }

    public boolean hasChanged() {
        for (GoodsType type : this.getSpecification().getGoodsTypeList()) {
            int newCount;
            int oldCount = this.getOldGoodsCount(type);
            if (oldCount == (newCount = this.getGoodsCount(type))) continue;
            return true;
        }
        return false;
    }

    public void fireChanges() {
        for (GoodsType type : this.getSpecification().getGoodsTypeList()) {
            int newCount;
            int oldCount = this.getOldGoodsCount(type);
            if (oldCount == (newCount = this.getGoodsCount(type))) continue;
            this.firePropertyChange(type.getId(), oldCount, newCount);
        }
        this.oldStoredGoods.clear();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(GoodsContainer.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        if (showAll || toSavedGame || player == this.getOwner()) {
            this.writeStorage(out, STORED_GOODS_TAG, this.storedGoods);
            this.writeStorage(out, OLD_STORED_GOODS_TAG, this.oldStoredGoods);
        }
        out.writeEndElement();
    }

    private void writeStorage(XMLStreamWriter out, String tag, Map<GoodsType, Integer> storage) throws XMLStreamException {
        if (!storage.isEmpty()) {
            out.writeStartElement(tag);
            for (Map.Entry<GoodsType, Integer> entry : storage.entrySet()) {
                out.writeStartElement(Goods.getXMLElementTagName());
                out.writeAttribute("type", entry.getKey().getId());
                out.writeAttribute("amount", entry.getValue().toString());
                out.writeEndElement();
            }
            out.writeEndElement();
        }
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.storedGoods.clear();
        this.oldStoredGoods.clear();
        while (in.nextTag() != 2) {
            Map<GoodsType, Integer> storage;
            if (in.getLocalName().equals(STORED_GOODS_TAG)) {
                storage = this.storedGoods;
            } else {
                if (!in.getLocalName().equals(OLD_STORED_GOODS_TAG)) continue;
                storage = this.oldStoredGoods;
            }
            while (in.nextTag() != 2) {
                if (in.getLocalName().equals(Goods.getXMLElementTagName())) {
                    GoodsType goodsType = this.getGame().getSpecification().getGoodsType(in.getAttributeValue(null, "type"));
                    Integer amount = new Integer(in.getAttributeValue(null, "amount"));
                    storage.put(goodsType, amount);
                }
                in.nextTag();
            }
        }
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("GoodsContainer with: ");
        for (Map.Entry<GoodsType, Integer> entry : this.storedGoods.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue() + ", ");
        }
        return sb.toString();
    }

    public static String getXMLElementTagName() {
        return "goodsContainer";
    }
}

