/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildQueue;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.PlayerExploredTile;
import net.sf.freecol.common.model.ProductionCache;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Colony
extends Settlement
implements Nameable {
    private static final Logger logger = Logger.getLogger(Colony.class.getName());
    public static final String BUILD_QUEUE_TAG = "buildQueueItem";
    public static final String POPULATION_QUEUE_TAG = "populationQueueItem";
    public static final String REARRANGE_WORKERS = "rearrangeWorkers";
    public static final int LIBERTY_PER_REBEL = 200;
    public static final Ability HAS_PORT = new Ability("model.ability.hasPort");
    public static final FreeColGameObjectType SOL_MODIFIER_SOURCE = new FreeColGameObjectType("model.source.solModifier");
    protected final List<ColonyTile> colonyTiles = new ArrayList<ColonyTile>();
    protected final Map<String, Building> buildingMap = new HashMap<String, Building>();
    protected final Map<String, ExportData> exportData = new HashMap<String, ExportData>();
    protected int sonsOfLiberty;
    protected int oldSonsOfLiberty;
    protected int tories;
    protected int oldTories;
    protected int productionBonus;
    protected int immigration;
    protected int liberty;
    protected boolean landLocked = true;
    protected int unitCount = -1;
    protected String stockadeKey = null;
    protected Turn established = new Turn(0);
    protected BuildQueue<BuildableType> buildQueue = new BuildQueue(this, BuildQueue.CompletionAction.REMOVE_EXCEPT_LAST, 500, new BuildableType[0]);
    protected BuildQueue<UnitType> populationQueue = new BuildQueue(this, BuildQueue.CompletionAction.SHUFFLE, 300, (BuildableType[])new UnitType[0]);
    private ProductionCache productionCache = new ProductionCache(this);

    protected Colony() {
    }

    protected Colony(Game game, Player owner, String name, Tile tile) {
        super(game, owner, name, tile);
    }

    public Colony(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Colony(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Colony(Game game, String id) {
        super(game, id);
    }

    @Override
    public String getNameFor(Player player) {
        return this.getName();
    }

    @Override
    public String getImageKey() {
        if (this.isUndead()) {
            return "undead";
        }
        int unitCount = this.getUnitCount();
        String key = unitCount <= 3 ? "small" : (unitCount <= 7 ? "medium" : "large");
        String stockade = this.getStockadeKey();
        if (stockade != null) {
            key = key + stockade;
        }
        return "model.settlement." + key + ".image";
    }

    public boolean isAutomaticBuild(BuildingType buildingType) {
        float value = this.owner.getFeatureContainer().applyModifier(100.0f, "model.modifier.buildingPriceBonus", buildingType, this.getGame().getTurn());
        return value == 0.0f && this.canBuild(buildingType);
    }

    public void addBuilding(Building building) {
        BuildingType buildingType = building.getType().getFirstLevel();
        this.buildingMap.put(buildingType.getId(), building);
        this.getFeatureContainer().add(building.getType().getFeatureContainer());
        this.invalidateCache();
    }

    public boolean removeBuilding(Building building) {
        BuildingType buildingType = building.getType().getFirstLevel();
        boolean result = this.buildingMap.remove(buildingType.getId()) != null;
        this.getFeatureContainer().remove(building.getType().getFeatureContainer());
        this.invalidateCache();
        return result;
    }

    public boolean canReducePopulation() {
        return (float)this.getUnitCount() > FeatureContainer.applyModifierSet(0.0f, this.getGame().getTurn(), this.getModifierSet("model.modifier.minimumColonySize"));
    }

    public void updatePopulation(int difference) {
        int population = this.getUnitCount();
        if (population > 0) {
            this.getTile().updatePlayerExploredTiles();
            this.updateSoL();
            this.updateProductionBonus();
        }
    }

    public ExportData getExportData(GoodsType goodsType) {
        ExportData result = this.exportData.get(goodsType.getId());
        if (result == null) {
            result = new ExportData(goodsType);
            this.setExportData(result);
        }
        return result;
    }

    public final void setExportData(ExportData newExportData) {
        this.exportData.put(newExportData.getId(), newExportData);
    }

    public int getExportAmount(GoodsType goodsType) {
        int exportable;
        int present = this.getGoodsContainer().getGoodsCount(goodsType);
        return present < (exportable = this.getExportData(goodsType).getExportLevel()) ? 0 : present - exportable;
    }

    public int getImportAmount(GoodsType goodsType) {
        int capacity;
        int present = this.getGoodsContainer().getGoodsCount(goodsType);
        return present > (capacity = this.getWarehouseCapacity()) ? 0 : capacity - present;
    }

    public boolean isLandLocked() {
        return this.landLocked;
    }

    @Override
    public boolean isConnected() {
        for (Tile t : this.getTile().getSurroundingTiles(1)) {
            if (!t.isConnected()) continue;
            return true;
        }
        return false;
    }

    public boolean isUndead() {
        Iterator<Unit> unitIterator = this.getUnitIterator();
        return unitIterator.hasNext() && unitIterator.next().isUndead();
    }

    @Override
    public void changeOwner(Player owner) {
        super.changeOwner(owner);
        for (ExportData exportDatum : this.exportData.values()) {
            exportDatum.setExported(false);
        }
        this.updatePopulation(0);
    }

    public void setUnitCount(int unitCount) {
        this.unitCount = unitCount;
    }

    public List<Building> getBuildingsForProducing(GoodsType goodsType) {
        ArrayList<Building> buildings = new ArrayList<Building>();
        for (Building building : this.getBuildings()) {
            if (building.getGoodsOutputType() != goodsType) continue;
            buildings.add(building);
        }
        return buildings;
    }

    public List<Building> getBuildingsForConsuming(GoodsType goodsType) {
        ArrayList<Building> buildings = new ArrayList<Building>();
        for (Building building : this.getBuildings()) {
            if (building.getGoodsInputType() != goodsType) continue;
            buildings.add(building);
        }
        return buildings;
    }

    public Building getBuildingForProducing(GoodsType goodsType) {
        List<Building> buildings = this.getBuildingsForProducing(goodsType);
        return buildings.isEmpty() ? null : buildings.get(0);
    }

    public Building getBuildingForConsuming(GoodsType goodsType) {
        List<Building> buildings = this.getBuildingsForConsuming(goodsType);
        return buildings.isEmpty() ? null : buildings.get(0);
    }

    public List<WorkLocation> getWorkLocations() {
        ArrayList<WorkLocation> result = new ArrayList<WorkLocation>(this.colonyTiles);
        result.addAll(this.buildingMap.values());
        return result;
    }

    public List<Building> getBuildings() {
        return new ArrayList<Building>(this.buildingMap.values());
    }

    public List<ColonyTile> getColonyTiles() {
        return this.colonyTiles;
    }

    public boolean isTileInUse(Tile tile) {
        ColonyTile colonyTile = this.getColonyTile(tile);
        return colonyTile != null && !colonyTile.isEmpty();
    }

    public Building getBuilding(BuildingType type) {
        return this.buildingMap.get(type.getFirstLevel().getId());
    }

    public Building getBuildingWithAbility(String ability) {
        for (Building building : this.buildingMap.values()) {
            if (!building.getType().hasAbility(ability)) continue;
            return building;
        }
        return null;
    }

    public ColonyTile getColonyTile(Tile t) {
        for (ColonyTile c : this.colonyTiles) {
            if (c.getWorkTile() != t) continue;
            return c;
        }
        return null;
    }

    public void incrementLiberty(int amount) {
        this.liberty += amount;
    }

    public void incrementImmigration(int amount) {
        this.immigration += amount;
    }

    public Turn getEstablished() {
        return this.established;
    }

    public void setEstablished(Turn newEstablished) {
        this.established = newEstablished;
    }

    @Override
    public boolean add(Locatable locatable) {
        return locatable instanceof Unit ? this.addUnit((Unit)locatable, null) : super.add(locatable);
    }

    @Override
    public boolean remove(Locatable locatable) {
        return locatable instanceof Unit ? this.removeUnit((Unit)locatable) : super.remove(locatable);
    }

    public WorkLocation getWorkLocationFor(Unit unit) {
        Occupation occupation = this.getOccupationFor(unit);
        if (occupation == null) {
            logger.warning("Could not find a WorkLocation for: " + unit.toString() + " in: " + this.getName());
            return null;
        }
        if (occupation.workType != null) {
            unit.setWorkType(occupation.workType);
        }
        return occupation.workLocation;
    }

    public boolean addUnit(Unit unit, WorkLocation loc) {
        if (!unit.hasAbility("model.ability.person")) {
            return false;
        }
        if (loc == null) {
            loc = this.getWorkLocationFor(unit);
        }
        for (WorkLocation w : this.getWorkLocations()) {
            if (w != loc || !w.add(unit)) continue;
            Player owner = unit.getOwner();
            owner.modifyScore(unit.getType().getScoreValue());
            this.updatePopulation(1);
            unit.setState(Unit.UnitState.IN_COLONY);
            if (owner.isAI()) {
                this.firePropertyChange(REARRANGE_WORKERS, true, false);
            }
            return true;
        }
        return false;
    }

    public boolean removeUnit(Unit unit) {
        Player owner = unit.getOwner();
        for (WorkLocation w : this.getWorkLocations()) {
            if (!w.contains(unit) || !w.remove(unit)) continue;
            Unit teacher = unit.getTeacher();
            if (teacher != null) {
                teacher.setStudent(null);
                unit.setTeacher(null);
            }
            owner.modifyScore(-unit.getType().getScoreValue());
            this.updatePopulation(-1);
            unit.setState(Unit.UnitState.ACTIVE);
            if (owner.isAI()) {
                this.firePropertyChange(REARRANGE_WORKERS, true, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addGoods(AbstractGoods goods) {
        return this.addGoods(goods.getType(), goods.getAmount());
    }

    @Override
    public boolean addGoods(GoodsType type, int amount) {
        super.addGoods(type, amount);
        this.productionCache.invalidate(type);
        this.modifySpecialGoods(type, amount);
        return true;
    }

    @Override
    public Goods removeGoods(GoodsType type, int amount) {
        Goods removed = super.removeGoods(type, amount);
        this.productionCache.invalidate(type);
        this.modifySpecialGoods(type, -removed.getAmount());
        return removed;
    }

    @Override
    public Goods removeGoods(AbstractGoods goods) {
        return this.removeGoods(goods.getType(), goods.getAmount());
    }

    @Override
    public Goods removeGoods(GoodsType type) {
        Goods removed = super.removeGoods(type);
        this.productionCache.invalidate(type);
        this.modifySpecialGoods(type, -removed.getAmount());
        return removed;
    }

    protected void modifySpecialGoods(GoodsType goodsType, int amount) {
        Set<Modifier> immigrationModifiers;
        FeatureContainer container = goodsType.getFeatureContainer();
        Set<Modifier> libertyModifiers = container.getModifierSet("model.modifier.liberty");
        if (!libertyModifiers.isEmpty()) {
            int newLiberty = (int)FeatureContainer.applyModifierSet(amount, this.getGame().getTurn(), libertyModifiers);
            this.incrementLiberty(newLiberty);
            this.getOwner().incrementLiberty(newLiberty);
        }
        if (!(immigrationModifiers = container.getModifierSet("model.modifier.immigration")).isEmpty()) {
            int newImmigration = (int)FeatureContainer.applyModifierSet(amount, this.getGame().getTurn(), immigrationModifiers);
            this.incrementImmigration(newImmigration);
            this.getOwner().incrementImmigration(newImmigration);
        }
    }

    @Override
    public int getUnitCount() {
        int count = 0;
        if (this.unitCount != -1) {
            return this.unitCount;
        }
        for (WorkLocation w : this.getWorkLocations()) {
            count += w.getUnitCount();
        }
        return count;
    }

    @Override
    public List<Unit> getUnitList() {
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (WorkLocation wl : this.getWorkLocations()) {
            units.addAll(wl.getUnitList());
        }
        return units;
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.getUnitList().iterator();
    }

    @Override
    public boolean contains(Locatable locatable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        if (locatable instanceof Unit && ((Unit)locatable).getOwner() == this.getOwner()) {
            return true;
        }
        return locatable instanceof Goods;
    }

    public boolean canTrain(Unit unit) {
        return this.canTrain(unit.getType());
    }

    public boolean canTrain(UnitType unitType) {
        if (!this.hasAbility("model.ability.teach")) {
            return false;
        }
        for (Building building : this.buildingMap.values()) {
            if (!building.canTeach() || !building.canAdd(unitType)) continue;
            return true;
        }
        return false;
    }

    public List<Unit> getTeachers() {
        ArrayList<Unit> teachers = new ArrayList<Unit>();
        for (Building building : this.buildingMap.values()) {
            if (!building.canTeach()) continue;
            teachers.addAll(building.getUnitList());
        }
        return teachers;
    }

    public Unit findTeacher(Unit student) {
        if (this.getSpecification().getBoolean("model.option.allowStudentSelection")) {
            return null;
        }
        for (Building building : this.getBuildings()) {
            if (!building.canTeach()) continue;
            for (Unit unit : building.getUnitList()) {
                if (unit.getStudent() != null || !student.canBeStudent(unit)) continue;
                return unit;
            }
        }
        return null;
    }

    public Unit findStudent(Unit teacher) {
        if (this.getSpecification().getBoolean("model.option.allowStudentSelection")) {
            return null;
        }
        Unit student = null;
        GoodsType expertProduction = teacher.getType().getExpertProduction();
        int skillLevel = Integer.MAX_VALUE;
        for (Unit potentialStudent : this.getUnitList()) {
            if (potentialStudent.getTeacher() != null || !potentialStudent.canBeStudent(teacher) || student != null && potentialStudent.getSkillLevel() >= skillLevel && (potentialStudent.getSkillLevel() != skillLevel || potentialStudent.getWorkType() != expertProduction)) continue;
            student = potentialStudent;
            skillLevel = student.getSkillLevel();
        }
        return student;
    }

    @Override
    public Unit getDefendingUnit(Unit attacker) {
        List<Unit> unitList = this.getUnitList();
        if (this.unitCount != -1 && unitList.isEmpty()) {
            return null;
        }
        Unit defender = null;
        float defencePower = -1.0f;
        for (Unit nextUnit : unitList) {
            float tmpPower = this.getGame().getCombatModel().getDefencePower(attacker, nextUnit);
            if (!(tmpPower > defencePower) && defender != null) continue;
            defender = nextUnit;
            defencePower = tmpPower;
        }
        if (defender == null) {
            throw new IllegalStateException("Colony " + this.getName() + " contains no units!");
        }
        return defender;
    }

    public boolean canBePillaged(Unit attacker) {
        return !this.hasStockade() && attacker.hasAbility("model.ability.pillageUnprotectedColony") && (!this.getBurnableBuildingList().isEmpty() || !this.getShipList().isEmpty() || !this.getLootableGoodsList().isEmpty() && attacker.getType().canCarryGoods() && attacker.getSpaceLeft() != 0 || this.canBePlundered());
    }

    public boolean canBePlundered() {
        return this.owner.checkGold(1);
    }

    public boolean isUnderSiege() {
        int friendlyUnits = 0;
        int enemyUnits = 0;
        for (ColonyTile colonyTile : this.colonyTiles) {
            for (Unit unit : colonyTile.getWorkTile().getUnitList()) {
                if (unit.getOwner() == this.getOwner()) {
                    if (!unit.isDefensiveUnit()) continue;
                    ++friendlyUnits;
                    continue;
                }
                if (!this.getOwner().atWarWith(unit.getOwner()) || !unit.isOffensiveUnit()) continue;
                ++enemyUnits;
            }
        }
        return enemyUnits > friendlyUnits;
    }

    public List<Building> getBurnableBuildingList() {
        ArrayList<Building> buildingList = new ArrayList<Building>();
        for (Building building : this.getBuildings()) {
            if (!building.canBeDamaged()) continue;
            buildingList.add(building);
        }
        return buildingList;
    }

    public List<Unit> getShipList() {
        ArrayList<Unit> shipList = new ArrayList<Unit>();
        for (Unit u : this.getTile().getUnitList()) {
            if (!u.isNaval()) continue;
            shipList.add(u);
        }
        return shipList;
    }

    public List<Goods> getLootableGoodsList() {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (Goods goods : this.getGoodsContainer().getGoods()) {
            if (!goods.getType().isStorable()) continue;
            goodsList.add(goods);
        }
        return goodsList;
    }

    @Override
    public RandomRange getPlunderRange(Unit attacker) {
        int upper;
        if (this.canBePlundered() && (upper = this.owner.getGold() * (this.getUnitCount() + 1) / (this.owner.getColoniesPopulation() + 1)) > 0) {
            return new RandomRange(100, 0, upper, 1);
        }
        return null;
    }

    public List<UnitType> getBuildableUnits() {
        ArrayList<UnitType> buildableUnits = new ArrayList<UnitType>();
        List<UnitType> unitTypes = this.getSpecification().getUnitTypeList();
        for (UnitType unitType : unitTypes) {
            if (unitType.getGoodsRequired().isEmpty() || !this.canBuild(unitType)) continue;
            buildableUnits.add(unitType);
        }
        return buildableUnits;
    }

    public BuildableType getCurrentlyBuilding() {
        return this.buildQueue.getCurrentlyBuilding();
    }

    public void setCurrentlyBuilding(BuildableType buildable) {
        this.buildQueue.setCurrentlyBuilding(buildable);
    }

    public int getTurnsToComplete(BuildableType buildable) {
        return this.getTurnsToComplete(buildable, null);
    }

    public int getTurnsToComplete(BuildableType buildable, AbstractGoods needed) {
        int result = 0;
        boolean goodsMissing = false;
        boolean goodsBeingProduced = false;
        boolean productionMissing = false;
        ProductionInfo info = this.productionCache.getProductionInfo(this.buildQueue);
        for (AbstractGoods requiredGoods : buildable.getGoodsRequired()) {
            int amountNeeded = requiredGoods.getAmount();
            int amountAvailable = this.getGoodsCount(requiredGoods.getType());
            if (amountAvailable >= amountNeeded) continue;
            goodsMissing = true;
            int amountProduced = this.productionCache.getNetProductionOf(requiredGoods.getType());
            if (info != null) {
                for (AbstractGoods consumed : info.getConsumption()) {
                    if (consumed.getType() != requiredGoods.getType()) continue;
                    amountProduced += consumed.getAmount();
                    break;
                }
            }
            if (amountProduced <= 0) {
                productionMissing = true;
                if (needed == null) continue;
                needed.setType(requiredGoods.getType());
                needed.setAmount(requiredGoods.getAmount());
                continue;
            }
            goodsBeingProduced = true;
            int amountRemaining = amountNeeded - amountAvailable;
            int eta = amountRemaining / amountProduced;
            if (amountRemaining % amountProduced != 0) {
                ++eta;
            }
            result = Math.max(result, eta);
        }
        return !goodsMissing ? 0 : (!goodsBeingProduced ? Integer.MIN_VALUE : (productionMissing ? -result : result));
    }

    public List<BuildableType> getBuildQueue() {
        return this.buildQueue.getValues();
    }

    public void setBuildQueue(List<BuildableType> newBuildQueue) {
        this.buildQueue.setValues(newBuildQueue);
    }

    public int getLiberty() {
        return this.liberty;
    }

    public void addLiberty(int amount) {
        if (FreeCol.isInDebugMode()) {
            this.getOwner().incrementLiberty(amount);
            List<GoodsType> libertyTypeList = this.getSpecification().getLibertyGoodsTypeList();
            if (this.getMembers() <= this.getUnitCount() + 1 && amount > 0 && !libertyTypeList.isEmpty()) {
                this.addGoods(libertyTypeList.get(0), amount);
            }
            this.updateSoL();
        }
    }

    public int getImmigration() {
        return this.immigration;
    }

    @Override
    public int getConsumptionOf(GoodsType goodsType) {
        int result = super.getConsumptionOf(goodsType);
        if (this.getSpecification().getGoodsType("model.goods.bells").equals(goodsType)) {
            result -= this.getSpecification().getIntegerOption("model.option.unitsThatUseNoBells").getValue().intValue();
        }
        return Math.max(0, result);
    }

    @Override
    public int getSoL() {
        return this.sonsOfLiberty;
    }

    public void updateSoL() {
        int units = this.getUnitCount();
        this.oldSonsOfLiberty = this.sonsOfLiberty;
        this.oldTories = this.tories;
        this.sonsOfLiberty = this.calculateMembership(units);
        this.tories = units - this.getMembers();
    }

    public int calculateMembership(int units) {
        if (units <= 0) {
            return 0;
        }
        int membership = this.liberty * 100 / (200 * units);
        if (membership < 0) {
            membership = 0;
        } else if (membership > 100) {
            membership = 100;
        }
        return membership;
    }

    public int getMembers() {
        float result = (float)(this.sonsOfLiberty * this.getUnitCount()) / 100.0f;
        return Math.round(result);
    }

    public int getTory() {
        return 100 - this.getSoL();
    }

    public int getProductionBonus() {
        return this.productionBonus;
    }

    public Modifier getProductionModifier(GoodsType goodsType) {
        Modifier result = new Modifier(goodsType.getId(), SOL_MODIFIER_SOURCE, this.productionBonus, Modifier.Type.ADDITIVE);
        result.setIndex(Modifier.COLONY_PRODUCTION_INDEX);
        return result;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.name(this.getName());
    }

    @Override
    public StringTemplate getLocationNameFor(Player player) {
        return StringTemplate.name(this.getNameFor(player));
    }

    public int getFoodProduction() {
        int result = 0;
        for (GoodsType foodType : this.getSpecification().getFoodGoodsTypeList()) {
            result += this.getProductionOf(foodType);
        }
        return result;
    }

    @Override
    public int getProductionOf(GoodsType goodsType) {
        int amount = 0;
        for (WorkLocation workLocation : this.getWorkLocations()) {
            amount += workLocation.getProductionOf(goodsType);
        }
        return amount;
    }

    public WorkLocation getVacantWorkLocationFor(Unit unit) {
        Occupation occupation = this.getOccupationFor(unit);
        if (occupation == null) {
            return null;
        }
        return occupation.workLocation;
    }

    private Occupation getOccupationFor(Unit unit) {
        ColonyTile colonyTile;
        for (AbstractGoods consumption : unit.getType().getConsumedGoods()) {
            if (!consumption.getType().isFoodType() || this.productionCache.getNetProductionOf(consumption.getType()) >= consumption.getAmount()) continue;
            ArrayList<GoodsType> rawTypes = new ArrayList<GoodsType>();
            for (GoodsType type : this.getSpecification().getGoodsTypeList()) {
                if (type.getStoredAs() != consumption.getType()) continue;
                rawTypes.add(type);
            }
            rawTypes.add(consumption.getType());
            ColonyTile bestTile = null;
            GoodsType bestWork = null;
            int bestAmount = 0;
            block8: for (ColonyTile tile : this.colonyTiles) {
                switch (tile.getNoAddReason(unit)) {
                    case NONE: 
                    case ALREADY_PRESENT: {
                        for (GoodsType type : rawTypes) {
                            int amount = tile.getProductionOf(unit, type);
                            if (amount <= bestAmount) continue;
                            bestAmount = amount;
                            bestWork = type;
                            bestTile = tile;
                        }
                        continue block8;
                    }
                }
            }
            if (bestAmount > 0) {
                return new Occupation(bestTile, bestWork);
            }
            for (GoodsType type : rawTypes) {
                Building building = this.getBuildingForProducing(type);
                if (building == null) continue;
                switch (building.getNoAddReason(unit)) {
                    case NONE: 
                    case ALREADY_PRESENT: {
                        return new Occupation(building, type);
                    }
                }
            }
        }
        GoodsType expertProduction = unit.getType().getExpertProduction();
        if (expertProduction == null) {
            if (unit.getExperience() > 0 && (expertProduction = unit.getWorkType()) != null && expertProduction.isFarmed() && (colonyTile = this.getVacantColonyTileFor(unit, false, expertProduction)) != null) {
                return new Occupation(colonyTile, expertProduction);
            }
        } else if (expertProduction.isFarmed()) {
            colonyTile = this.getVacantColonyTileFor(unit, false, expertProduction);
            if (colonyTile != null) {
                return new Occupation(colonyTile, expertProduction);
            }
        } else {
            Building building = this.getBuildingFor(unit);
            if (building != null) {
                return new Occupation(building, building.getGoodsOutputType());
            }
        }
        ColonyTile bestTile = null;
        GoodsType bestType = null;
        int bestProduction = 0;
        for (GoodsType foodType : this.getSpecification().getFoodGoodsTypeList()) {
            int production;
            ColonyTile colonyTile2 = this.getVacantColonyTileFor(unit, false, foodType);
            if (colonyTile2 == null || (production = colonyTile2.getProductionOf(unit, foodType)) <= bestProduction) continue;
            bestProduction = production;
            bestTile = colonyTile2;
            bestType = foodType;
        }
        if (bestTile != null) {
            return new Occupation(bestTile, bestType);
        }
        Building building = this.getBuildingFor(unit);
        if (building != null) {
            return new Occupation(building, building.getGoodsOutputType());
        }
        return null;
    }

    public Building getBuildingFor(Unit unit) {
        ArrayList<Building> buildings = new ArrayList<Building>();
        GoodsType expertProduction = unit.getType().getExpertProduction();
        if (expertProduction != null && !expertProduction.isFarmed()) {
            buildings.addAll(this.getBuildingsForProducing(expertProduction));
        }
        buildings.addAll(this.getBuildings());
        for (Building building : buildings) {
            switch (building.getNoAddReason(unit)) {
                case NONE: 
                case ALREADY_PRESENT: {
                    if (building.getGoodsInputType() != null && this.getGoodsCount(building.getGoodsInputType()) <= 0) break;
                    return building;
                }
            }
        }
        return null;
    }

    public ColonyTile getVacantColonyTileFor(Unit unit, boolean allowClaim, GoodsType ... goodsTypes) {
        ColonyTile bestPick = null;
        int highestProduction = 0;
        block3: for (ColonyTile colonyTile : this.colonyTiles) {
            switch (colonyTile.getNoAddReason(unit)) {
                case NONE: 
                case ALREADY_PRESENT: {
                    Tile workTile = colonyTile.getWorkTile();
                    if (workTile.getOwningSettlement() != this && (!allowClaim || this.owner.getLandPrice(workTile) != 0)) break;
                    for (GoodsType goodsType : goodsTypes) {
                        int potential = colonyTile.getProductionOf(unit, goodsType);
                        if (potential <= highestProduction) continue;
                        highestProduction = potential;
                        bestPick = colonyTile;
                    }
                    continue block3;
                }
            }
        }
        return bestPick;
    }

    public boolean canBreed(GoodsType goodsType) {
        int breedingNumber = goodsType.getBreedingNumber();
        return breedingNumber < Integer.MAX_VALUE && breedingNumber <= this.getGoodsCount(goodsType);
    }

    public boolean canBuild() {
        return this.canBuild(this.getCurrentlyBuilding());
    }

    public boolean canBuild(BuildableType buildableType) {
        return this.getNoBuildReason(buildableType) == NoBuildReason.NONE;
    }

    public NoBuildReason getNoBuildReason(BuildableType buildableType) {
        if (buildableType == null) {
            return NoBuildReason.NOT_BUILDING;
        }
        if (buildableType.getGoodsRequired().isEmpty()) {
            return NoBuildReason.NOT_BUILDABLE;
        }
        if (buildableType.getPopulationRequired() > this.getUnitCount()) {
            return NoBuildReason.POPULATION_TOO_SMALL;
        }
        Map<String, Boolean> requiredAbilities = buildableType.getAbilitiesRequired();
        for (Map.Entry<String, Boolean> entry : requiredAbilities.entrySet()) {
            if (this.hasAbility(entry.getKey()) == entry.getValue().booleanValue()) continue;
            return NoBuildReason.MISSING_ABILITY;
        }
        if (buildableType.getLimits() != null) {
            for (Limit limit : buildableType.getLimits()) {
                if (limit.evaluate(this)) continue;
                return NoBuildReason.LIMIT_EXCEEDED;
            }
        }
        if (buildableType instanceof BuildingType) {
            BuildingType newBuildingType = (BuildingType)buildableType;
            Building colonyBuilding = this.getBuilding(newBuildingType);
            if (colonyBuilding == null ? newBuildingType.getUpgradesFrom() != null : colonyBuilding.getType().getUpgradesTo() != newBuildingType) {
                return NoBuildReason.WRONG_UPGRADE;
            }
        } else if (buildableType instanceof UnitType && !buildableType.hasAbility("model.ability.bornInColony") && !this.hasAbility("model.ability.build", buildableType)) {
            return NoBuildReason.MISSING_BUILD_ABILITY;
        }
        return NoBuildReason.NONE;
    }

    public int getPriceForBuilding() {
        return this.getPriceForBuilding(this.getCurrentlyBuilding());
    }

    public int getPriceForBuilding(BuildableType type) {
        return this.priceGoodsForBuilding(this.getGoodsForBuilding(type));
    }

    public int priceGoodsForBuilding(HashMap<GoodsType, Integer> required) {
        int price = 0;
        Market market = this.getOwner().getMarket();
        for (GoodsType goodsType : required.keySet()) {
            int amount = required.get(goodsType);
            if (goodsType.isStorable()) {
                price += market.getBidPrice(goodsType, amount) * 110 / 100;
                continue;
            }
            price += goodsType.getPrice() * amount;
        }
        return price;
    }

    public HashMap<GoodsType, Integer> getGoodsForBuilding(BuildableType type) {
        HashMap<GoodsType, Integer> result = new HashMap<GoodsType, Integer>();
        for (AbstractGoods goods : type.getGoodsRequired()) {
            GoodsType goodsType = goods.getType();
            int remaining = goods.getAmount() - this.getGoodsCount(goodsType);
            if (remaining <= 0) continue;
            result.put(goodsType, new Integer(remaining));
        }
        return result;
    }

    public boolean canPayToFinishBuilding() {
        return this.canPayToFinishBuilding(this.getCurrentlyBuilding());
    }

    public boolean canPayToFinishBuilding(BuildableType buildableType) {
        return buildableType != null && this.getOwner().checkGold(this.getPriceForBuilding(buildableType));
    }

    public Collection<StringTemplate> getWarnings(GoodsType goodsType, int amount, int production) {
        Building buildingForConsuming;
        Building buildingForProducing;
        BuildableType currentlyBuilding;
        LinkedList<StringTemplate> result = new LinkedList<StringTemplate>();
        if (goodsType.isFoodType() && goodsType.isStorable()) {
            if (amount + production < 0) {
                result.add(StringTemplate.template("model.colony.famineFeared").addName("%colony%", this.getName()).addAmount("%number%", 0));
            }
        } else {
            int waste = amount + production - this.getWarehouseCapacity();
            if (waste > 0 && !this.getExportData(goodsType).isExported() && !goodsType.limitIgnored()) {
                result.add(StringTemplate.template("model.building.warehouseSoonFull").add("%goods%", goodsType.getNameKey()).addName("%colony%", this.getName()).addAmount("%amount%", waste));
            }
        }
        if ((currentlyBuilding = this.getCurrentlyBuilding()) != null) {
            for (AbstractGoods goods : currentlyBuilding.getGoodsRequired()) {
                if (!goods.getType().equals(goodsType) || amount >= goods.getAmount()) continue;
                result.add(StringTemplate.template("model.colony.buildableNeedsGoods").addName("%colony%", this.getName()).add("%buildable%", currentlyBuilding.getNameKey()).addAmount("%amount%", goods.getAmount() - amount).add("%goodsType%", goodsType.getNameKey()));
            }
        }
        if ((buildingForProducing = this.getBuildingForProducing(goodsType)) != null) {
            this.addInsufficientProductionMessage(result, this.productionCache.getProductionInfo(buildingForProducing));
        }
        if ((buildingForConsuming = this.getBuildingForConsuming(goodsType)) != null && !buildingForConsuming.getGoodsOutputType().isStorable()) {
            this.addInsufficientProductionMessage(result, this.productionCache.getProductionInfo(buildingForConsuming));
        }
        return result;
    }

    private void addInsufficientProductionMessage(List<StringTemplate> warnings, ProductionInfo info) {
        int missingOutput;
        if (info != null && !info.getMaximumProduction().isEmpty() && (missingOutput = info.getMaximumProduction().get(0).getAmount() - info.getProduction().get(0).getAmount()) > 0) {
            GoodsType outputType = info.getProduction().get(0).getType();
            GoodsType inputType = info.getConsumption().isEmpty() ? null : info.getConsumption().get(0).getType();
            int missingInput = info.getMaximumConsumption().get(0).getAmount() - info.getConsumption().get(0).getAmount();
            warnings.add(StringTemplate.template("model.colony.insufficientProduction").addAmount("%outputAmount%", missingOutput).add("%outputType%", outputType.getNameKey()).addName("%colony%", this.getName()).addAmount("%inputAmount%", missingInput).add("%inputType%", inputType.getNameKey()));
        }
    }

    public int governmentChange(int unitCount) {
        int veryBadGovernment = this.getSpecification().getIntegerOption("model.option.veryBadGovernmentLimit").getValue();
        int badGovernment = this.getSpecification().getIntegerOption("model.option.badGovernmentLimit").getValue();
        int rebelPercent = this.calculateMembership(unitCount);
        int rebelCount = Math.round(0.01f * (float)rebelPercent * (float)unitCount);
        int loyalistCount = unitCount - rebelCount;
        int result = 0;
        if (rebelPercent >= 100) {
            if (this.sonsOfLiberty < 100) {
                result = 1;
            }
        } else if (rebelPercent >= 50) {
            if (this.sonsOfLiberty >= 100) {
                result = -1;
            } else if (this.sonsOfLiberty < 50) {
                result = 1;
            }
        } else if (this.sonsOfLiberty >= 50) {
            result = -1;
        } else if (loyalistCount > veryBadGovernment) {
            if (this.tories <= veryBadGovernment) {
                result = -1;
            }
        } else if (loyalistCount > badGovernment) {
            if (this.tories <= badGovernment) {
                result = -1;
            } else if (this.tories > veryBadGovernment) {
                result = 1;
            }
        } else if (this.tories > badGovernment) {
            result = 1;
        }
        return result;
    }

    public ModelMessage checkForGovMgtChangeMessage() {
        int veryBadGovernment = this.getSpecification().getIntegerOption("model.option.veryBadGovernmentLimit").getValue();
        int badGovernment = this.getSpecification().getIntegerOption("model.option.badGovernmentLimit").getValue();
        String msgId = null;
        ModelMessage.MessageType msgType = ModelMessage.MessageType.GOVERNMENT_EFFICIENCY;
        if (this.sonsOfLiberty == 100) {
            if (this.oldSonsOfLiberty < 100) {
                msgId = "model.colony.SoL100";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
            }
        } else if (this.sonsOfLiberty >= 50) {
            if (this.oldSonsOfLiberty == 100) {
                msgId = "model.colony.lostSoL100";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
            } else if (this.oldSonsOfLiberty < 50) {
                msgId = "model.colony.SoL50";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
            }
        } else {
            if (this.oldSonsOfLiberty >= 50) {
                msgId = "model.colony.lostSoL50";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
            }
            if (this.tories > veryBadGovernment) {
                if (this.oldTories <= veryBadGovernment) {
                    msgId = "model.colony.veryBadGovernment";
                }
            } else if (this.tories > badGovernment) {
                if (this.oldTories <= badGovernment) {
                    msgId = "model.colony.badGovernment";
                } else if (this.oldTories > veryBadGovernment) {
                    msgId = "model.colony.governmentImproved1";
                }
            } else if (this.oldTories > badGovernment) {
                msgId = "model.colony.governmentImproved2";
            }
        }
        GoodsType bells = this.getSpecification().getGoodsType("model.goods.bells");
        return msgId == null ? null : new ModelMessage(msgType, msgId, this, bells).addName("%colony%", this.getName());
    }

    protected void updateProductionBonus() {
        int newBonus;
        int veryBadGovernment = this.getSpecification().getIntegerOption("model.option.veryBadGovernmentLimit").getValue();
        int badGovernment = this.getSpecification().getIntegerOption("model.option.badGovernmentLimit").getValue();
        int n = this.sonsOfLiberty >= 100 ? 2 : (this.sonsOfLiberty >= 50 ? 1 : (this.tories > veryBadGovernment ? -2 : (newBonus = this.tories > badGovernment ? -1 : 0)));
        if (this.getOwner().isAI()) {
            newBonus = Math.max(0, newBonus);
        }
        if (this.productionBonus != newBonus) {
            this.invalidateCache();
        }
        this.productionBonus = newBonus;
    }

    @Override
    public boolean propagateAlarm(Player player, int addToAlarm) {
        return false;
    }

    @Override
    public int getGoodsCapacity() {
        return (int)this.getFeatureContainer().applyModifier(0.0f, "model.modifier.warehouseStorage", null, this.getGame().getTurn());
    }

    public Building getWarehouse() {
        for (Building building : this.buildingMap.values()) {
            if (building.getType().getModifierSet("model.modifier.warehouseStorage").isEmpty()) continue;
            return building;
        }
        return null;
    }

    @Override
    public Colony getColony() {
        return this;
    }

    public boolean hasStockade() {
        return this.getStockade() != null;
    }

    public Building getStockade() {
        for (Building building : this.buildingMap.values()) {
            if (building.getType().getModifierSet("model.modifier.defence").isEmpty()) continue;
            return building;
        }
        return null;
    }

    public String getStockadeKey() {
        return this.stockadeKey != null ? this.stockadeKey : this.getTrueStockadeKey();
    }

    public String getTrueStockadeKey() {
        Building stockade = this.getStockade();
        return stockade == null ? null : stockade.getType().getId().substring("model.building".length());
    }

    @Override
    public final Set<Modifier> getModifierSet(String id) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        result.addAll(this.getFeatureContainer().getModifierSet(id, null, this.getGame().getTurn()));
        if (this.owner != null) {
            result.addAll(this.owner.getFeatureContainer().getModifierSet(id, null, this.getGame().getTurn()));
        }
        return result;
    }

    @Override
    public boolean hasAbility(String id) {
        return this.hasAbility(id, null);
    }

    public boolean hasAbility(String id, FreeColGameObjectType type) {
        HashSet<Ability> colonyAbilities = new HashSet<Ability>(this.getFeatureContainer().getAbilitySet(id, type, this.getGame().getTurn()));
        Set<Ability> playerAbilities = this.owner.getFeatureContainer().getAbilitySet(id, type, this.getGame().getTurn());
        colonyAbilities.addAll(playerAbilities);
        return FeatureContainer.hasAbility(colonyAbilities);
    }

    public boolean canBombardEnemyShip() {
        if (this.isLandLocked()) {
            return false;
        }
        return this.hasAbility("model.ability.bombardShips");
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        for (WorkLocation workLocation : this.getWorkLocations()) {
            objects.addAll(((FreeColGameObject)workLocation).disposeList());
        }
        TileItemContainer container = this.getTile().getTileItemContainer();
        TileImprovement road = container.getRoad();
        if (road != null && road.isVirtual()) {
            container.removeTileItem(road);
        }
        objects.addAll(super.disposeList());
        return objects;
    }

    @Override
    public void dispose() {
        this.disposeList();
    }

    public int getNetProductionOf(GoodsType goodsType) {
        return this.productionCache.getNetProductionOf(goodsType);
    }

    public boolean isProductive(WorkLocation workLocation) {
        ProductionInfo info = this.productionCache.getProductionInfo(workLocation);
        return info != null && info.getProduction() != null && !info.getProduction().isEmpty() && info.getProduction().get(0).getAmount() > 0;
    }

    public int getAdjustedNetProductionOf(GoodsType goodsType) {
        int result = this.productionCache.getNetProductionOf(goodsType);
        block0: for (BuildQueue queue : new BuildQueue[]{this.buildQueue, this.populationQueue}) {
            ProductionInfo info = this.productionCache.getProductionInfo(queue);
            if (info == null) continue;
            for (AbstractGoods goods : info.getConsumption()) {
                if (goods.getType() != goodsType) continue;
                result += goods.getAmount();
                continue block0;
            }
        }
        return result;
    }

    public ProductionInfo getProductionInfo(Object object) {
        return this.productionCache.getProductionInfo(object);
    }

    public void invalidateCache() {
        logger.finest("invalidating production cache");
        this.productionCache.invalidate();
    }

    protected TypeCountMap<GoodsType> getProductionMap() {
        return this.productionCache.getProductionMap();
    }

    public List<Consumer> getConsumers() {
        ArrayList<Consumer> result = new ArrayList<Consumer>();
        result.addAll(this.getUnitList());
        result.addAll(this.buildingMap.values());
        result.add(this.buildQueue);
        result.add(this.populationQueue);
        Collections.sort(result, Consumer.COMPARATOR);
        return result;
    }

    public void getColonyTileTodo(List<Tile> exploreTiles, List<Tile> clearTiles, List<Tile> plowTiles, List<Tile> roadTiles) {
        Specification spec = this.getSpecification();
        TileImprovementType clearImprovement = spec.getTileImprovementType("model.improvement.clearForest");
        TileImprovementType plowImprovement = spec.getTileImprovementType("model.improvement.plow");
        TileImprovementType roadImprovement = spec.getTileImprovementType("model.improvement.road");
        Tile tile = this.getTile();
        for (Tile t : this.getTile().getSurroundingTiles(1)) {
            if (!t.hasLostCityRumour()) continue;
            exploreTiles.add(t);
        }
        block1: for (ColonyTile ct : this.getColonyTiles()) {
            TileType newType;
            Tile t = ct.getWorkTile();
            if (t == null) continue;
            if ((t.getTileItemContainer() == null || t.getTileItemContainer().getImprovement(plowImprovement) == null) && plowImprovement.isTileTypeAllowed(t.getType())) {
                if (ct.isColonyCenterTile()) {
                    plowTiles.add(t);
                } else {
                    for (Unit u : ct.getUnitList()) {
                        if (u == null || u.getWorkType() == null || plowImprovement.getBonus(u.getWorkType()) <= 0) continue;
                        plowTiles.add(t);
                        break;
                    }
                }
            }
            if (ct.isColonyCenterTile() || ct.isEmpty()) continue;
            TileType oldType = t.getType();
            if ((t.getTileItemContainer() == null || t.getTileItemContainer().getImprovement(clearImprovement) == null) && clearImprovement.isTileTypeAllowed(t.getType()) && (newType = clearImprovement.getChange(oldType)) != null) {
                for (Unit u : ct.getUnitList()) {
                    if (newType.getProductionOf(u.getWorkType(), u.getType()) <= oldType.getProductionOf(u.getWorkType(), u.getType())) continue;
                    clearTiles.add(t);
                    break;
                }
            }
            if (t.getRoad() != null || !roadImprovement.isTileTypeAllowed(t.getType())) continue;
            for (Unit u : ct.getUnitList()) {
                if (roadImprovement.getBonus(u.getWorkType()) <= 0) continue;
                roadTiles.add(t);
                continue block1;
            }
        }
    }

    public Unit getBetterExpert(Unit expert) {
        GoodsType production = expert.getWorkType();
        GoodsType expertise = expert.getType().getExpertProduction();
        Unit bestExpert = null;
        int bestImprovement = 0;
        if (production == null || expertise == null || production == expertise) {
            return null;
        }
        for (Unit nonExpert : this.getUnitList()) {
            int improvement;
            ColonyTile nwl;
            if (nonExpert.getWorkType() != expertise || nonExpert.getType() == expert.getType()) continue;
            int expertProductionNow = 0;
            int nonExpertProductionNow = 0;
            int expertProductionPotential = 0;
            int nonExpertProductionPotential = 0;
            Building ewl = expert.getWorkLocation();
            if (ewl != null) {
                expertProductionNow = ((WorkLocation)ewl).getProductionOf(expert, expertise);
                nonExpertProductionPotential = ((WorkLocation)ewl).getProductionOf(nonExpert, expertise);
            }
            if ((nwl = nonExpert.getWorkTile()) != null) {
                nonExpertProductionNow = ((WorkLocation)nwl).getProductionOf(nonExpert, expertise);
                expertProductionPotential = ((WorkLocation)nwl).getProductionOf(expert, expertise);
            }
            if ((improvement = expertProductionPotential + nonExpertProductionPotential - expertProductionNow - nonExpertProductionNow) <= bestImprovement) continue;
            bestImprovement = improvement;
            bestExpert = nonExpert;
        }
        return bestExpert;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        boolean full = showAll || toSavedGame || player == this.getOwner();
        out.writeStartElement(Colony.getXMLElementTagName());
        super.writeAttributes(out);
        out.writeAttribute("established", Integer.toString(this.established.getNumber()));
        if (full) {
            out.writeAttribute("sonsOfLiberty", Integer.toString(this.sonsOfLiberty));
            out.writeAttribute("oldSonsOfLiberty", Integer.toString(this.oldSonsOfLiberty));
            out.writeAttribute("tories", Integer.toString(this.tories));
            out.writeAttribute("oldTories", Integer.toString(this.oldTories));
            out.writeAttribute("liberty", Integer.toString(this.liberty));
            out.writeAttribute("immigration", Integer.toString(this.immigration));
            out.writeAttribute("productionBonus", Integer.toString(this.productionBonus));
            out.writeAttribute("landLocked", Boolean.toString(this.landLocked));
            for (ExportData exportData : this.exportData.values()) {
                exportData.toXML(out);
            }
            for (Modifier modifier : this.getFeatureContainer().getModifiers()) {
                if (!modifier.hasIncrement()) continue;
                modifier.toXML(out);
            }
            for (WorkLocation workLocation : this.getWorkLocations()) {
                workLocation.toXML(out, player, showAll, toSavedGame);
            }
            for (BuildableType buildableType : this.buildQueue.getValues()) {
                out.writeStartElement(BUILD_QUEUE_TAG);
                out.writeAttribute("id", buildableType.getId());
                out.writeEndElement();
            }
            for (UnitType unitType : this.populationQueue.getValues()) {
                out.writeStartElement(POPULATION_QUEUE_TAG);
                out.writeAttribute("id", unitType.getId());
                out.writeEndElement();
            }
        } else {
            PlayerExploredTile pet = this.getTile().getPlayerExploredTile(player);
            if (pet != null) {
                if (pet.getColonyUnitCount() > 0) {
                    out.writeAttribute("unitCount", Integer.toString(pet.getColonyUnitCount()));
                }
                if (pet.getColonyStockadeKey() != null) {
                    out.writeAttribute("stockadeKey", pet.getColonyStockadeKey());
                }
            }
        }
        super.writeChildren(out);
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.owner.addSettlement(this);
        this.established = new Turn(this.getAttribute(in, "established", 0));
        this.sonsOfLiberty = this.getAttribute(in, "sonsOfLiberty", 0);
        this.oldSonsOfLiberty = this.getAttribute(in, "oldSonsOfLiberty", 0);
        this.tories = this.getAttribute(in, "tories", 0);
        this.oldTories = this.getAttribute(in, "oldTories", 0);
        this.liberty = this.getAttribute(in, "liberty", 0);
        this.immigration = this.getAttribute(in, "immigration", 0);
        this.productionBonus = this.getAttribute(in, "productionBonus", 0);
        this.landLocked = Colony.getAttribute(in, "landLocked", true);
        if (!this.landLocked) {
            this.getFeatureContainer().addAbility(HAS_PORT);
        }
        this.unitCount = this.getAttribute(in, "unitCount", -1);
        this.stockadeKey = in.getAttributeValue(null, "stockadeKey");
        this.colonyTiles.clear();
        this.buildingMap.clear();
        this.exportData.clear();
        this.buildQueue.clear();
        this.populationQueue.clear();
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(ColonyTile.getXMLElementTagName())) {
                ColonyTile ct = this.updateFreeColGameObject(in, ColonyTile.class);
                this.colonyTiles.add(ct);
                continue;
            }
            if (in.getLocalName().equals(Building.getXMLElementTagName())) {
                Building building = this.updateFreeColGameObject(in, Building.class);
                this.addBuilding(building);
                continue;
            }
            if (in.getLocalName().equals(ExportData.getXMLElementTagName())) {
                ExportData data = new ExportData();
                data.readFromXML(in);
                this.exportData.put(data.getId(), data);
                continue;
            }
            if (Modifier.getXMLElementTagName().equals(in.getLocalName())) {
                Modifier modifier = new Modifier(in, this.getSpecification());
                this.getFeatureContainer().addModifier(modifier);
                continue;
            }
            if ("buildQueue".equals(in.getLocalName())) {
                int size = this.getAttribute(in, "xLength", 0);
                if (size > 0) {
                    for (int x = 0; x < size; ++x) {
                        String typeId = in.getAttributeValue(null, "x" + Integer.toString(x));
                        this.buildQueue.add(this.getSpecification().getType(typeId, BuildableType.class));
                    }
                }
                in.nextTag();
                continue;
            }
            if (BUILD_QUEUE_TAG.equals(in.getLocalName())) {
                String id = in.getAttributeValue(null, "id");
                this.buildQueue.add(this.getSpecification().getType(id, BuildableType.class));
                in.nextTag();
                continue;
            }
            if (POPULATION_QUEUE_TAG.equals(in.getLocalName())) {
                String id = in.getAttributeValue(null, "id");
                this.populationQueue.add((UnitType)((BuildableType)this.getSpecification().getType(id, UnitType.class)));
                in.nextTag();
                continue;
            }
            super.readChild(in);
        }
        if (this.populationQueue.isEmpty()) {
            for (UnitType unitType : this.getSpecification().getUnitTypesWithAbility("model.ability.bornInColony")) {
                GoodsType food = this.getSpecification().getGoodsType("model.goods.food");
                List<AbstractGoods> required = unitType.getGoodsRequired();
                boolean found = false;
                for (AbstractGoods goods : required) {
                    if (goods.getType() != food) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    required.add(new AbstractGoods(food, 200));
                    unitType.setGoodsRequired(required);
                }
                this.populationQueue.add(unitType);
            }
        }
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    public static String getXMLElementTagName() {
        return "colony";
    }

    private class Occupation {
        public WorkLocation workLocation;
        public GoodsType workType;

        public Occupation(WorkLocation workLocation, GoodsType workType) {
            this.workLocation = workLocation;
            this.workType = workType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoBuildReason {
        NONE,
        NOT_BUILDING,
        NOT_BUILDABLE,
        POPULATION_TOO_SMALL,
        MISSING_BUILD_ABILITY,
        MISSING_ABILITY,
        WRONG_UPGRADE,
        LIMIT_EXCEEDED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColonyChangeEvent {
        POPULATION_CHANGE,
        PRODUCTION_CHANGE,
        BONUS_CHANGE,
        WAREHOUSE_CHANGE,
        BUILD_QUEUE_CHANGE,
        UNIT_TYPE_CHANGE;

    }
}

