/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.GoodsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectAmountDialog
extends FreeColDialog<Integer>
implements ActionListener {
    private static Logger logger = Logger.getLogger(SelectAmountDialog.class.getName());
    private static final int SELECT_CANCEL = -1;
    private static final int[] amounts = new int[]{20, 40, 50, 60, 80, 100};
    private final JTextArea question;
    private final JComboBox comboBox;

    public SelectAmountDialog(Canvas parent, GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        super(parent);
        int index;
        this.setFocusCycleRoot(true);
        this.question = SelectAmountDialog.getDefaultTextArea(Messages.message("goodsTransfer.text"));
        if (needToPay) {
            int gold = this.getMyPlayer().getGold();
            int price = this.getMyPlayer().getMarket().getCostToBuy(goodsType);
            available = Math.min(available, gold / price);
        }
        int defaultIndex = -1;
        Vector<Integer> values = new Vector<Integer>();
        for (index = 0; index < amounts.length; ++index) {
            if (amounts[index] < available) {
                if (amounts[index] == defaultAmount) {
                    defaultIndex = index;
                }
            } else {
                if (available == defaultAmount) {
                    defaultIndex = index;
                }
                values.add(available);
                break;
            }
            values.add(amounts[index]);
        }
        if (defaultAmount > 0 && defaultIndex < 0) {
            for (index = 0; index < values.size(); ++index) {
                if (defaultAmount >= (Integer)values.get(index)) continue;
                values.insertElementAt(new Integer(defaultAmount), index);
                defaultIndex = index;
                break;
            }
        }
        this.comboBox = new JComboBox(values);
        this.comboBox.setEditable(true);
        if (defaultIndex >= 0) {
            this.comboBox.setSelectedIndex(defaultIndex);
        }
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectAmountDialog.this.setResponse(new Integer(-1));
            }
        });
        this.setLayout((LayoutManager)new MigLayout("wrap 1", "", ""));
        this.add(this.question);
        this.add((Component)this.comboBox, "wrap 20, growx");
        this.add((Component)this.okButton, "span, split 2, tag ok");
        this.add((Component)this.cancelButton, "tag cancel");
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void requestFocus() {
        this.cancelButton.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if ("OK".equals(event.getActionCommand())) {
            Object item = this.comboBox.getSelectedItem();
            if (item instanceof Integer) {
                this.setResponse((Integer)item);
            } else if (item instanceof String) {
                try {
                    this.setResponse(Integer.valueOf((String)item));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

