/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportMilitaryPanel
extends ReportPanel {
    private List<String> colonyNames;
    private List<String> otherNames;
    private TypeCountMap<UnitType> soldiers = new TypeCountMap();
    private TypeCountMap<UnitType> dragoons = new TypeCountMap();
    private TypeCountMap<UnitType> scouts = new TypeCountMap();
    private TypeCountMap<UnitType> others = new TypeCountMap();
    private Map<String, ArrayList<Unit>> locations;

    public ReportMilitaryPanel(Canvas parent) {
        super(parent, Messages.message("reportMilitaryAction.name"));
        this.gatherData();
        Player player = this.getMyPlayer();
        this.reportPanel.setLayout((LayoutManager)new MigLayout("fillx, wrap 12", "", ""));
        this.reportPanel.add((Component)new JLabel(Messages.message(player.getNation().getRefNation().getId() + ".name")), "span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        List<AbstractUnit> refUnits = this.getController().getREFUnits();
        if (refUnits != null) {
            for (AbstractUnit unit : refUnits) {
                if (unit.getUnitType(this.getSpecification()).hasAbility("model.ability.navalUnit")) continue;
                this.reportPanel.add((Component)this.createUnitTypeLabel(unit), "sg");
            }
        }
        this.reportPanel.add((Component)this.localizedLabel(StringTemplate.template("report.military.forces").addStringTemplate("%nation%", player.getNationName())), "newline, span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        ArrayList<AbstractUnit> units = new ArrayList<AbstractUnit>();
        ArrayList<AbstractUnit> scoutUnits = new ArrayList<AbstractUnit>();
        ArrayList<AbstractUnit> dragoonUnits = new ArrayList<AbstractUnit>();
        ArrayList<AbstractUnit> soldierUnits = new ArrayList<AbstractUnit>();
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (!unitType.isAvailableTo(player) || unitType.hasAbility("model.ability.navalUnit") || !unitType.hasAbility("model.ability.expertSoldier") && unitType.getOffence() <= 0) continue;
            if (unitType.hasAbility("model.ability.canBeEquipped")) {
                scoutUnits.add(new AbstractUnit(unitType, Unit.Role.SCOUT, this.scouts.getCount(unitType)));
                dragoonUnits.add(new AbstractUnit(unitType, Unit.Role.DRAGOON, this.dragoons.getCount(unitType)));
                soldierUnits.add(new AbstractUnit(unitType, Unit.Role.SOLDIER, this.soldiers.getCount(unitType)));
                continue;
            }
            units.add(new AbstractUnit(unitType, Unit.Role.DEFAULT, this.others.getCount(unitType)));
        }
        UnitType defaultType = this.getSpecification().getUnitType("model.unit.freeColonist");
        dragoonUnits.add(new AbstractUnit(defaultType, Unit.Role.DRAGOON, this.dragoons.getCount(defaultType)));
        soldierUnits.add(new AbstractUnit(defaultType, Unit.Role.SOLDIER, this.soldiers.getCount(defaultType)));
        scoutUnits.add(new AbstractUnit(defaultType, Unit.Role.SCOUT, this.scouts.getCount(defaultType)));
        units.addAll(dragoonUnits);
        units.addAll(soldierUnits);
        units.addAll(scoutUnits);
        for (AbstractUnit unit : units) {
            this.reportPanel.add((Component)this.createUnitTypeLabel(unit), "sg");
        }
        this.reportPanel.add((Component)new JSeparator(0), "newline, span, growx, wrap 40");
        for (String locationName : this.colonyNames) {
            this.handleLocation(locationName, true);
        }
        if (player.getEurope() != null) {
            String europeName = Messages.message(player.getEurope().getNameKey());
            this.handleLocation(europeName, true);
            this.otherNames.remove(europeName);
        }
        Collections.sort(this.otherNames);
        for (String locationName : this.otherNames) {
            this.handleLocation(locationName, false);
        }
        this.revalidate();
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return new Dimension(750, 600);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private void gatherData() {
        Player player = this.getMyPlayer();
        this.locations = new HashMap<String, ArrayList<Unit>>();
        List<Colony> colonies = this.getSortedColonies();
        this.colonyNames = new ArrayList<String>();
        for (Colony colony : colonies) {
            this.colonyNames.add(colony.getName());
        }
        this.otherNames = new ArrayList<String>();
        if (player.getEurope() != null) {
            this.otherNames.add(Messages.message(player.getEurope().getNameKey()));
        }
        UnitType defaultType = this.getSpecification().getUnitType("model.unit.freeColonist");
        for (Unit unit : player.getUnits()) {
            if (!unit.isOffensiveUnit() || unit.isNaval()) continue;
            UnitType unitType = defaultType;
            if (unit.getType().getOffence() > 0 || unit.hasAbility("model.ability.expertSoldier")) {
                unitType = unit.getType();
            }
            switch (unit.getRole()) {
                case DRAGOON: {
                    this.dragoons.incrementCount(unitType, 1);
                    break;
                }
                case SOLDIER: {
                    this.soldiers.incrementCount(unitType, 1);
                    break;
                }
                default: {
                    this.others.incrementCount(unitType, 1);
                }
            }
            String locationName = this.getLocationNameFor(unit);
            ArrayList<Unit> unitList = this.locations.get(locationName);
            if (unitList == null) {
                unitList = new ArrayList();
                this.locations.put(locationName, unitList);
            }
            unitList.add(unit);
            if (this.colonyNames.contains(locationName) || this.otherNames.contains(locationName)) continue;
            this.otherNames.add(locationName);
        }
    }

    private void handleLocation(String location, boolean makeButton) {
        JComponent component;
        List unitList = this.locations.get(location);
        if (makeButton) {
            JButton button = FreeColPanel.getLinkButton(location, null, location);
            button.addActionListener(this);
            component = button;
        } else {
            component = new JLabel(location);
        }
        this.reportPanel.add((Component)component, "newline, span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        if (unitList == null) {
            this.reportPanel.add((Component)new JLabel(Messages.message("none")), "sg");
        } else {
            Collections.sort(unitList, ReportPanel.getUnitTypeComparator());
            for (Unit unit : unitList) {
                UnitLabel unitLabel = new UnitLabel(unit, this.getCanvas(), true);
                if (unit.getDestination() != null) {
                    String destination = Messages.message(unit.getDestination().getLocationNameFor(this.getMyPlayer()));
                    unitLabel.setToolTipText("<html>" + unitLabel.getToolTipText() + "<br>" + Messages.message(StringTemplate.template("goingTo").addName("%location%", destination)) + "</html>");
                }
                this.reportPanel.add((Component)unitLabel, "sg");
            }
        }
    }
}

