/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorPanel
extends FreeColDialog<Boolean> {
    private static final Logger logger = Logger.getLogger(ErrorPanel.class.getName());
    private static final String SHOW = "show";

    public ErrorPanel(Canvas parent, String message) {
        super(parent);
        this.setLayout((LayoutManager)new MigLayout());
        JButton showButton = new JButton(Messages.message("errorMessage.showLogFile"));
        showButton.setActionCommand(SHOW);
        showButton.addActionListener(this);
        this.add((Component)ErrorPanel.getDefaultTextArea(message, 40), "wrap 20");
        this.add((Component)this.okButton, "split 2, tag ok");
        this.add(showButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorPanel(Canvas parent) {
        super(parent);
        File logFile = new File(FreeCol.getLogFile());
        byte[] buffer = new byte[(int)logFile.length()];
        BufferedInputStream logFileStream = null;
        String message = null;
        try {
            logFileStream = new BufferedInputStream(new FileInputStream(logFile));
            logFileStream.read(buffer);
            message = new String(buffer);
        }
        catch (Exception e) {
        }
        finally {
            if (logFileStream != null) {
                try {
                    logFileStream.close();
                }
                catch (IOException e) {}
            }
        }
        this.setLayout((LayoutManager)new MigLayout());
        JTextArea textArea = ErrorPanel.getDefaultTextArea(message, 40);
        textArea.setFocusable(true);
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea, 20, 31);
        scrollPane.getViewport().setOpaque(false);
        this.add((Component)scrollPane, "height 200:200:, wrap 20");
        this.add((Component)this.okButton, "tag ok");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (SHOW.equals(command)) {
            this.getCanvas().showFreeColPanel(new ErrorPanel(this.getCanvas()));
        } else {
            super.actionPerformed(event);
        }
    }
}

