/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.client.gui.panel.WorkProductionPanel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;

public final class DragListener
extends MouseAdapter {
    private static final Logger logger = Logger.getLogger(DragListener.class.getName());
    private final FreeColPanel parentPanel;
    private final Canvas canvas;

    public DragListener(FreeColPanel parentPanel) {
        this.parentPanel = parentPanel;
        this.canvas = parentPanel.getCanvas();
    }

    public void mousePressed(MouseEvent e) {
        JComponent comp = (JComponent)e.getSource();
        if (e.getButton() == 3 || e.isPopupTrigger()) {
            if (this.parentPanel.isEditable()) {
                int elements;
                JPopupMenu menu = null;
                if (comp instanceof UnitLabel) {
                    menu = this.getUnitMenu((UnitLabel)comp);
                } else if (comp instanceof GoodsLabel) {
                    menu = this.getGoodsMenu((GoodsLabel)comp);
                } else if (comp instanceof MarketLabel && this.parentPanel instanceof EuropePanel) {
                    GoodsType goodsType = ((MarketLabel)comp).getType();
                    if (this.canvas.getFreeColClient().getInGameController().payArrears(goodsType)) {
                        ((EuropePanel)this.parentPanel).revalidate();
                        ((EuropePanel)this.parentPanel).refresh();
                    }
                }
                if (menu != null && (elements = menu.getSubElements().length) > 0) {
                    int lastIndex = menu.getComponentCount() - 1;
                    if (menu.getComponent(lastIndex) instanceof JPopupMenu.Separator) {
                        menu.remove(lastIndex);
                    }
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        menu.show(this.canvas, 0, 0);
                    } else {
                        menu.show(comp, e.getX(), e.getY());
                    }
                }
            }
        } else {
            TransferHandler handler = comp.getTransferHandler();
            if (e.isShiftDown()) {
                if (comp instanceof GoodsLabel) {
                    ((GoodsLabel)comp).setPartialChosen(true);
                } else if (comp instanceof MarketLabel) {
                    ((MarketLabel)comp).setPartialChosen(true);
                }
            } else if (e.isAltDown()) {
                if (comp instanceof GoodsLabel) {
                    ((GoodsLabel)comp).toEquip(true);
                } else if (comp instanceof MarketLabel) {
                    ((MarketLabel)comp).toEquip(true);
                }
            } else if (comp instanceof GoodsLabel) {
                ((GoodsLabel)comp).setPartialChosen(false);
            } else if (comp instanceof MarketLabel) {
                ((MarketLabel)comp).setPartialChosen(false);
                ((MarketLabel)comp).setAmount(100);
            }
            if (comp instanceof UnitLabel && ((UnitLabel)comp).getUnit().isCarrier()) {
                ColonyPanel colonyPanel;
                Unit u = ((UnitLabel)comp).getUnit();
                if (this.parentPanel instanceof EuropePanel) {
                    if (!u.isAtSea()) {
                        ((EuropePanel)this.parentPanel).setSelectedUnitLabel((UnitLabel)comp);
                    }
                } else if (this.parentPanel instanceof ColonyPanel && (colonyPanel = (ColonyPanel)this.parentPanel).getSelectedUnit() != u) {
                    colonyPanel.setSelectedUnit(u);
                    colonyPanel.updateInPortPanel();
                }
            }
            if (handler != null) {
                handler.exportAsDrag(comp, e, 1);
            }
        }
    }

    public JPopupMenu getUnitMenu(UnitLabel unitLabel) {
        ImageLibrary imageLibrary = this.parentPanel.getLibrary();
        Unit tempUnit = unitLabel.getUnit();
        JPopupMenu menu = new JPopupMenu("Unit");
        ImageIcon unitIcon = imageLibrary.getUnitImageIcon(tempUnit, 0.66);
        JMenuItem name = new JMenuItem(Messages.message(tempUnit.getLabel()) + " (" + Messages.message("menuBar.colopedia") + ")", unitIcon);
        name.setActionCommand(UnitLabel.UnitAction.COLOPEDIA.toString());
        name.addActionListener(unitLabel);
        menu.add(name);
        menu.addSeparator();
        if (tempUnit.isCarrier() && this.addCarrierItems(unitLabel, menu)) {
            menu.addSeparator();
        }
        if (tempUnit.getLocation().getTile() != null && tempUnit.getLocation().getTile().getColony() != null) {
            if (this.addWorkItems(unitLabel, menu)) {
                menu.addSeparator();
            }
            if (this.addEducationItems(unitLabel, menu)) {
                menu.addSeparator();
            }
            if (tempUnit.getLocation() instanceof WorkLocation) {
                if (tempUnit.getColony().canReducePopulation()) {
                    JMenuItem menuItem = new JMenuItem(Messages.message("leaveTown"));
                    menuItem.setActionCommand(UnitLabel.UnitAction.LEAVE_TOWN.toString());
                    menuItem.addActionListener(unitLabel);
                    menu.add(menuItem);
                }
            } else if (this.addCommandItems(unitLabel, menu)) {
                menu.addSeparator();
            }
        } else if (tempUnit.getLocation() instanceof Europe && this.addCommandItems(unitLabel, menu)) {
            menu.addSeparator();
        }
        if (tempUnit.hasAbility("model.ability.canBeEquipped") && this.addEquipmentItems(unitLabel, menu)) {
            menu.addSeparator();
        }
        return menu;
    }

    private boolean addCarrierItems(UnitLabel unitLabel, JPopupMenu menu) {
        Unit tempUnit = unitLabel.getUnit();
        if (tempUnit.getSpaceLeft() < tempUnit.getType().getSpace()) {
            JMenuItem menuItem;
            JMenuItem cargo = new JMenuItem(Messages.message("cargoOnCarrier"));
            menu.add(cargo);
            for (Unit passenger : tempUnit.getUnitList()) {
                menuItem = new JMenuItem("    " + Messages.message(passenger.getLabel()));
                menuItem.setFont(menuItem.getFont().deriveFont(2));
                menu.add(menuItem);
            }
            for (Goods goods : tempUnit.getGoodsList()) {
                menuItem = new JMenuItem("    " + Messages.message(goods.getLabel(true)));
                menuItem.setFont(menuItem.getFont().deriveFont(2));
                menu.add(menuItem);
            }
            return true;
        }
        return false;
    }

    private boolean addWorkItems(UnitLabel unitLabel, JPopupMenu menu) {
        JMenuItem menuItem;
        final Unit tempUnit = unitLabel.getUnit();
        ImageLibrary imageLibrary = this.parentPanel.getLibrary();
        Colony colony = tempUnit.getLocation().getColony();
        boolean separatorNeeded = false;
        ColonyTile also = tempUnit.getWorkLocation2() instanceof ColonyTile ? (ColonyTile)tempUnit.getWorkLocation2() : null;
        List<GoodsType> farmedGoods = this.canvas.getSpecification().getFarmedGoodsTypeList();
        for (GoodsType goodsType : farmedGoods) {
            ColonyTile bestTile = colony.getVacantColonyTileFor(tempUnit, false, goodsType);
            if (also != null) {
                int alsoProd = also.getProductionOf(tempUnit, goodsType);
                if (bestTile == null) {
                    if (alsoProd > 0) {
                        bestTile = also;
                    }
                } else if (alsoProd > bestTile.getProductionOf(tempUnit, goodsType)) {
                    bestTile = also;
                }
            }
            if (bestTile == null) continue;
            int maxpotential = bestTile.getProductionOf(tempUnit, goodsType);
            String text = Messages.message(StringTemplate.template(goodsType.getId() + ".workAs").addAmount("%amount%", maxpotential));
            JMenuItem menuItem2 = new JMenuItem(text, imageLibrary.getScaledGoodsImageIcon(goodsType, 0.66f));
            menuItem2.setActionCommand(UnitLabel.UnitAction.WORK_TILE.toString() + ":" + goodsType.getId());
            menuItem2.addActionListener(unitLabel);
            menu.add(menuItem2);
            separatorNeeded = true;
        }
        for (Building building : colony.getBuildings()) {
            switch (building.getNoAddReason(tempUnit)) {
                case NONE: 
                case ALREADY_PRESENT: {
                    GoodsType goodsType = building.getGoodsOutputType();
                    String locName = Messages.message(building.getNameKey());
                    JMenuItem menuItem3 = new JMenuItem(locName);
                    if (goodsType != null) {
                        menuItem3.setIcon(imageLibrary.getScaledGoodsImageIcon(goodsType, 0.66f));
                        StringTemplate t = StringTemplate.template("model.goods.goodsAmount").addAmount("%amount%", building.getAdditionalProductionNextTurn(tempUnit)).addName("%goods%", goodsType);
                        locName = locName + " (" + Messages.message(t) + ")";
                        menuItem3.setText(locName);
                    }
                    menuItem3.setActionCommand(UnitLabel.UnitAction.WORK_BUILDING.toString() + ":" + building.getType().getId());
                    menuItem3.addActionListener(unitLabel);
                    menu.add(menuItem3);
                    separatorNeeded = true;
                    break;
                }
            }
        }
        if (tempUnit.getWorkTile() != null) {
            menuItem = new JMenuItem(Messages.message("showProduction"));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DragListener.this.canvas.showSubPanel(new WorkProductionPanel(DragListener.this.canvas, tempUnit));
                }
            });
            menu.add(menuItem);
            separatorNeeded = true;
        } else if (tempUnit.getWorkLocation() != null) {
            menuItem = new JMenuItem(Messages.message("showProductivity"));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DragListener.this.canvas.showSubPanel(new WorkProductionPanel(DragListener.this.canvas, tempUnit));
                }
            });
            menu.add(menuItem);
            separatorNeeded = true;
        }
        return separatorNeeded;
    }

    private boolean addEducationItems(UnitLabel unitLabel, JPopupMenu menu) {
        boolean separatorNeeded = false;
        Unit unit = unitLabel.getUnit();
        ImageLibrary imageLibrary = this.parentPanel.getLibrary();
        if (unit.getSpecification().getBoolean("model.option.allowStudentSelection")) {
            for (Unit teacher : unit.getColony().getTeachers()) {
                if (!unit.canBeStudent(teacher) || !(unit.getLocation() instanceof WorkLocation)) continue;
                JMenuItem menuItem = null;
                ImageIcon teacherIcon = imageLibrary.getUnitImageIcon(teacher, 0.5);
                if (teacher.getStudent() != unit) {
                    menuItem = new JMenuItem(Messages.message("assignToTeacher"), teacherIcon);
                    menuItem.setActionCommand(UnitLabel.UnitAction.ASSIGN.toString() + ":" + teacher.getId());
                    menuItem.addActionListener(unitLabel);
                } else {
                    String teacherName = Messages.message(teacher.getType().getNameKey());
                    menuItem = new JMenuItem(Messages.message(StringTemplate.template("menu.unit.apprentice").addName("%unit%", teacherName)), teacherIcon);
                    menuItem.setEnabled(false);
                }
                menu.add(menuItem);
                separatorNeeded = true;
            }
        }
        if (unit.getTurnsOfTraining() > 0 && unit.getStudent() != null) {
            JMenuItem menuItem = new JMenuItem(Messages.message("menuBar.teacher") + ": " + unit.getTurnsOfTraining() + "/" + unit.getNeededTurnsOfTraining());
            menuItem.setEnabled(false);
            menu.add(menuItem);
            separatorNeeded = true;
        }
        int experience = unit.getExperience();
        GoodsType goods = unit.getExperienceType();
        if (experience > 0 && goods != null) {
            UnitType expertType = this.canvas.getSpecification().getExpertForProducing(goods);
            if (unit.getType().canBeUpgraded(expertType, UnitTypeChange.ChangeType.EXPERIENCE)) {
                int maxExperience = unit.getType().getMaximumExperience();
                double probability = (double)(unit.getType().getUnitTypeChange(expertType).getProbability(UnitTypeChange.ChangeType.EXPERIENCE) * experience) / (double)maxExperience;
                String jobName = Messages.message(goods.getWorkingAsKey());
                ImageIcon expertIcon = imageLibrary.getUnitImageIcon(expertType, 0.5);
                JMenuItem experienceItem = new JMenuItem(Messages.message(StringTemplate.template("menu.unit.experience").addName("%job%", jobName)) + " " + experience + "/" + maxExperience + " (" + FreeColPanel.getModifierFormat().format(probability) + "%)", expertIcon);
                experienceItem.setEnabled(false);
                menu.add(experienceItem);
                separatorNeeded = true;
            }
        }
        return separatorNeeded;
    }

    private boolean addCommandItems(UnitLabel unitLabel, JPopupMenu menu) {
        final Unit tempUnit = unitLabel.getUnit();
        boolean isUnitAtSea = tempUnit.isAtSea();
        JMenuItem menuItem = new JMenuItem(Messages.message("activateUnit"));
        menuItem.setActionCommand(UnitLabel.UnitAction.ACTIVATE_UNIT.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled(tempUnit.getState() != Unit.UnitState.ACTIVE && !isUnitAtSea);
        menu.add(menuItem);
        if (!(tempUnit.getLocation() instanceof Europe)) {
            menuItem = new JMenuItem(Messages.message("fortifyUnit"));
            menuItem.setActionCommand(UnitLabel.UnitAction.FORTIFY.toString());
            menuItem.addActionListener(unitLabel);
            menuItem.setEnabled(tempUnit.getMovesLeft() > 0 && tempUnit.getState() != Unit.UnitState.FORTIFIED && tempUnit.getState() != Unit.UnitState.FORTIFYING);
            menu.add(menuItem);
        }
        Unit.UnitState unitState = tempUnit.getState();
        menuItem = new JMenuItem(Messages.message("sentryUnit"));
        menuItem.setActionCommand(UnitLabel.UnitAction.SENTRY.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled(unitState != Unit.UnitState.SENTRY && !isUnitAtSea);
        menu.add(menuItem);
        boolean hasTradeRoute = tempUnit.getTradeRoute() != null;
        menuItem = new JMenuItem(Messages.message("clearUnitOrders"));
        menuItem.setActionCommand(UnitLabel.UnitAction.CLEAR_ORDERS.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled((unitState != Unit.UnitState.ACTIVE || hasTradeRoute) && !isUnitAtSea);
        menu.add(menuItem);
        menuItem = new JMenuItem(Messages.message("assignTradeRoute"));
        menuItem.setActionCommand(UnitLabel.UnitAction.ASSIGN_TRADE_ROUTE.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled(tempUnit.isCarrier() && !hasTradeRoute);
        menu.add(menuItem);
        if (tempUnit.canCarryTreasure() && tempUnit.canCashInTreasureTrain()) {
            menuItem = new JMenuItem(Messages.message("cashInTreasureTrain.order"));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DragListener.this.canvas.getFreeColClient().getInGameController().checkCashInTreasureTrain(tempUnit);
                }
            });
            menu.add(menuItem);
        }
        return true;
    }

    private boolean addEquipmentItems(final UnitLabel unitLabel, JPopupMenu menu) {
        UnitType newUnitType;
        final Unit tempUnit = unitLabel.getUnit();
        final InGameController igc = this.canvas.getFreeColClient().getInGameController();
        ImageLibrary imageLibrary = this.parentPanel.getLibrary();
        boolean separatorNeeded = false;
        if (tempUnit.getEquipment().size() > 1) {
            JMenuItem newItem = new JMenuItem(Messages.message("model.equipment.removeAll"));
            newItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HashMap<EquipmentType, Integer> equipment = new HashMap<EquipmentType, Integer>(tempUnit.getEquipment().getValues());
                    for (Map.Entry entry : equipment.entrySet()) {
                        igc.equipUnit(tempUnit, (EquipmentType)entry.getKey(), -((Integer)entry.getValue()).intValue());
                    }
                    unitLabel.updateIcon();
                }
            });
            menu.add(newItem);
        }
        EquipmentType horses = null;
        EquipmentType muskets = null;
        for (EquipmentType equipmentType : this.canvas.getSpecification().getEquipmentTypeList()) {
            EquipmentType type;
            JMenuItem newItem;
            int count = tempUnit.getEquipment().getCount(equipmentType);
            if (count > 0) {
                newItem = new JMenuItem(Messages.message(equipmentType.getId() + ".remove"));
                if (!equipmentType.getGoodsRequired().isEmpty()) {
                    GoodsType goodsType = equipmentType.getGoodsRequired().get(0).getType();
                    newItem.setIcon(imageLibrary.getScaledGoodsImageIcon(goodsType, 0.66f));
                }
                final int items = count;
                type = equipmentType;
                newItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        igc.equipUnit(tempUnit, type, -items);
                        unitLabel.updateIcon();
                    }
                });
                menu.add(newItem);
            }
            if (!tempUnit.canBeEquippedWith(equipmentType) || count != 0) continue;
            newItem = null;
            count = equipmentType.getMaximumCount() - count;
            if (equipmentType.getGoodsRequired().isEmpty()) {
                newItem = new JMenuItem();
                newItem.setText(Messages.message(equipmentType.getId() + ".add"));
            } else if (tempUnit.isInEurope() && tempUnit.getOwner().getEurope().canBuildEquipment(equipmentType)) {
                int price = 0;
                newItem = new JMenuItem();
                for (AbstractGoods goodsRequired : equipmentType.getGoodsRequired()) {
                    price += tempUnit.getOwner().getMarket().getBidPrice(goodsRequired.getType(), goodsRequired.getAmount());
                    newItem.setIcon(imageLibrary.getScaledGoodsImageIcon(goodsRequired.getType(), 0.66f));
                }
                while (!tempUnit.getOwner().checkGold(count * price)) {
                    --count;
                }
                newItem.setText(Messages.message(equipmentType.getId() + ".add") + " (" + Messages.message(StringTemplate.template("goldAmount").addAmount("%amount%", count * price)) + ")");
            } else if (tempUnit.getColony() != null && tempUnit.getColony().canBuildEquipment(equipmentType)) {
                newItem = new JMenuItem();
                for (AbstractGoods goodsRequired : equipmentType.getGoodsRequired()) {
                    int present = tempUnit.getColony().getGoodsCount(goodsRequired.getType()) / goodsRequired.getAmount();
                    if (present < count) {
                        count = present;
                    }
                    newItem.setIcon(imageLibrary.getScaledGoodsImageIcon(goodsRequired.getType(), 0.66f));
                }
                newItem.setText(Messages.message(equipmentType.getId() + ".add"));
            }
            if (newItem == null) continue;
            if ("model.equipment.horses".equals(equipmentType.getId())) {
                horses = equipmentType;
            } else if ("model.equipment.muskets".equals(equipmentType.getId())) {
                muskets = equipmentType;
            }
            final int items = count;
            type = equipmentType;
            newItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    igc.equipUnit(tempUnit, type, items);
                    unitLabel.updateIcon();
                }
            });
            menu.add(newItem);
        }
        if (horses != null && muskets != null && horses.isCompatibleWith(muskets)) {
            final EquipmentType horseType = horses;
            final EquipmentType musketType = muskets;
            JMenuItem newItem = new JMenuItem(Messages.message("model.equipment.dragoon"), imageLibrary.getUnitImageIcon(tempUnit.getType(), Unit.Role.DRAGOON, 0.3333333333333333));
            newItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    igc.equipUnit(tempUnit, horseType, 1);
                    igc.equipUnit(tempUnit, musketType, 1);
                    unitLabel.updateIcon();
                }
            });
            menu.add(newItem);
        }
        if (separatorNeeded = true) {
            menu.addSeparator();
            separatorNeeded = false;
        }
        if ((newUnitType = tempUnit.getType().getTargetType(UnitTypeChange.ChangeType.CLEAR_SKILL, tempUnit.getOwner())) != null) {
            JMenuItem menuItem = new JMenuItem(Messages.message("clearSpeciality"), imageLibrary.getUnitImageIcon(newUnitType, 0.3333333333333333));
            menuItem.setActionCommand(UnitLabel.UnitAction.CLEAR_SPECIALITY.toString());
            menuItem.addActionListener(unitLabel);
            menu.add(menuItem);
            if (tempUnit.getLocation() instanceof Building && !((Building)tempUnit.getLocation()).canAdd(newUnitType)) {
                menuItem.setEnabled(false);
            }
            separatorNeeded = true;
        }
        return separatorNeeded;
    }

    public JPopupMenu getGoodsMenu(GoodsLabel goodsLabel) {
        final Goods goods = goodsLabel.getGoods();
        final InGameController inGameController = this.canvas.getFreeColClient().getInGameController();
        ImageLibrary imageLibrary = this.parentPanel.getLibrary();
        JPopupMenu menu = new JPopupMenu("Cargo");
        JMenuItem name = new JMenuItem(Messages.message(goods.getNameKey()) + " (" + Messages.message("menuBar.colopedia") + ")", imageLibrary.getScaledGoodsImageIcon(goods.getType(), 0.66f));
        name.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DragListener.this.canvas.showPanel(new ColopediaPanel(DragListener.this.canvas, ColopediaPanel.PanelType.GOODS, goods.getType()));
            }
        });
        menu.add(name);
        if (!(goods.getLocation() instanceof Colony)) {
            if (this.canvas.getFreeColClient().getMyPlayer().canTrade(goods)) {
                JMenuItem unload = new JMenuItem(Messages.message("unload"));
                unload.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        inGameController.unloadCargo(goods, false);
                        if (DragListener.this.parentPanel instanceof CargoPanel) {
                            CargoPanel cargoPanel = (CargoPanel)DragListener.this.parentPanel;
                            cargoPanel.initialize();
                        }
                        DragListener.this.parentPanel.revalidate();
                    }
                });
                menu.add(unload);
            } else if (goods.getLocation() instanceof Unit && ((Unit)goods.getLocation()).isInEurope()) {
                JMenuItem pay = new JMenuItem(Messages.message("boycottedGoods.payArrears"));
                pay.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        inGameController.payArrears(goods);
                        if (DragListener.this.parentPanel instanceof CargoPanel) {
                            CargoPanel cargoPanel = (CargoPanel)DragListener.this.parentPanel;
                            cargoPanel.initialize();
                        }
                        DragListener.this.parentPanel.revalidate();
                    }
                });
                menu.add(pay);
            }
            JMenuItem dump = new JMenuItem(Messages.message("dumpCargo"));
            dump.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    inGameController.unloadCargo(goods, true);
                    if (DragListener.this.parentPanel instanceof CargoPanel) {
                        ((CargoPanel)DragListener.this.parentPanel).initialize();
                    }
                    DragListener.this.parentPanel.revalidate();
                }
            });
            menu.add(dump);
        }
        return menu;
    }
}

