/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChooseFoundingFatherDialog
extends FreeColDialog<FoundingFather>
implements ActionListener {
    private static final Logger logger = Logger.getLogger(ChooseFoundingFatherDialog.class.getName());
    private final JTabbedPane tb;
    private final List<FoundingFather> possibleFathers;

    public ChooseFoundingFatherDialog(Canvas parent, List<FoundingFather> possibleFoundingFathers) {
        super(parent);
        this.possibleFathers = possibleFoundingFathers;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setFocusCycleRoot(false);
        this.tb = new JTabbedPane(1);
        boolean hasSelectedTab = false;
        for (int index = 0; index < possibleFoundingFathers.size(); ++index) {
            FoundingFather father = possibleFoundingFathers.get(index);
            FoundingFatherPanel panel = new FoundingFatherPanel(father.getType());
            panel.initialize(father);
            this.tb.addTab(Messages.message(father.getTypeKey()), null, panel, null);
            if (!hasSelectedTab && panel.isEnabled()) {
                this.tb.setSelectedIndex(index);
                hasSelectedTab = true;
            }
            panel.addMouseListener(FreeColPanel.createEventForwardingMouseListener(this));
            panel.addMouseMotionListener(FreeColPanel.createEventForwardingMouseMotionListener(this));
        }
        this.add((Component)this.tb, "Center");
        this.setSize(this.tb.getPreferredSize());
    }

    @Override
    public void requestFocus() {
        this.tb.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String id = event.getActionCommand();
        for (FoundingFather father : this.possibleFathers) {
            if (!father.getId().equals(id)) continue;
            this.setResponse(father);
            return;
        }
        this.setResponse(null);
    }

    protected class FoundingFatherPanel
    extends JPanel {
        private FoundingFather foundingFather = null;
        private JLabel header;
        private JTextArea description;
        private JTextArea text;
        private JButton ok;

        public FoundingFatherPanel(FoundingFather.FoundingFatherType type) {
            this.setLayout(new BorderLayout());
            this.header = FreeColPanel.getDefaultHeader("");
            this.add((Component)this.header, "North");
            JPanel contentPanel = this.createContentPanel(type);
            this.add((Component)contentPanel, "Center");
            JPanel p3 = new JPanel(new BorderLayout());
            p3.setOpaque(false);
            p3.setBorder(new EmptyBorder(0, 160, 20, 160));
            this.ok = new JButton(Messages.message("chooseThisFoundingFather"));
            this.ok.addActionListener(ChooseFoundingFatherDialog.this);
            this.ok.setSize(this.ok.getPreferredSize());
            FreeColPanel.enterPressesWhenFocused(this.ok);
            p3.add((Component)this.ok, "Center");
            this.add((Component)p3, "South");
        }

        private JPanel createContentPanel(FoundingFather.FoundingFatherType type) {
            JPanel p1 = new JPanel();
            p1.setLayout(new BorderLayout(20, 20));
            p1.setOpaque(false);
            p1.setBorder(new EmptyBorder(20, 20, 20, 20));
            Image image = ResourceManager.getImage("FoundingFather." + type.toString().toLowerCase());
            JLabel imageLabel = image != null ? new JLabel(new ImageIcon(image)) : new JLabel();
            JPanel imagePanel = new JPanel(new BorderLayout());
            imagePanel.add((Component)imageLabel, "North");
            p1.add((Component)imagePanel, "West");
            JPanel p2 = new JPanel(new BorderLayout());
            p2.setOpaque(false);
            JScrollPane scrollPane = new JScrollPane(p2, 20, 31);
            scrollPane.getViewport().setOpaque(false);
            scrollPane.getVerticalScrollBar().setUnitIncrement(16);
            scrollPane.setOpaque(false);
            scrollPane.setBorder(null);
            p1.add((Component)scrollPane, "Center");
            this.setPreferredSize(new Dimension(570, 400));
            this.description = new JTextArea();
            this.description.setBorder(null);
            this.description.setOpaque(false);
            this.description.setLineWrap(true);
            this.description.setEditable(false);
            this.description.setWrapStyleWord(true);
            this.description.setFocusable(false);
            p2.add((Component)this.description, "North");
            this.text = new JTextArea();
            this.text.setBorder(null);
            this.text.setOpaque(false);
            this.text.setLineWrap(true);
            this.text.setEditable(false);
            this.text.setWrapStyleWord(true);
            this.text.setFocusable(false);
            p2.add((Component)this.text, "Center");
            return p1;
        }

        public void requestFocus() {
            this.ok.requestFocus();
        }

        public void initialize(FoundingFather father) {
            this.foundingFather = father;
            if (father != null) {
                this.header.setText(Messages.message(father.getNameKey()));
                this.description.setText(Messages.message(father.getDescriptionKey()));
                this.text.setText("\n[" + Messages.message(father.getId() + ".birthAndDeath") + "] " + Messages.message(father.getId() + ".text"));
                this.ok.setActionCommand(father.getId());
            }
        }

        public boolean isEnabled() {
            return this.foundingFather != null;
        }
    }
}

