/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;

public final class AdvantageCellRenderer
implements TableCellRenderer {
    private NationOptions.Advantages advantages;

    public AdvantageCellRenderer(NationOptions.Advantages advantages) {
        this.advantages = advantages;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label;
        Player player = (Player)table.getValueAt(row, 4);
        NationType nationType = ((Nation)table.getValueAt(row, 0)).getType();
        switch (this.advantages) {
            case FIXED: {
                label = new JLabel(Messages.message(nationType.getNameKey()));
                break;
            }
            case SELECTABLE: {
                if (player == null) {
                    return new JLabel(Messages.message(nationType.getNameKey()));
                }
                return new JLabel(Messages.message(player.getNationType().getNameKey()));
            }
            default: {
                label = new JLabel(Messages.message("model.nationType.none.name"));
            }
        }
        if (player != null && player.isReady()) {
            label.setForeground(Color.GRAY);
        } else {
            label.setForeground(table.getForeground());
        }
        label.setBackground(table.getBackground());
        return label;
    }
}

