/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.DisplayTileTextAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.menu.FreeColMenuBar;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.OptionGroup;

public class MapEditorMenuBar
extends FreeColMenuBar {
    private static final Logger logger = Logger.getLogger(MapEditorMenuBar.class.getName());

    public MapEditorMenuBar(FreeColClient freeColClient) {
        super(freeColClient);
        this.reset();
    }

    public void reset() {
        this.removeAll();
        this.buildGameMenu();
        this.buildViewMenu();
        this.buildToolsMenu();
        this.buildColopediaMenu();
        this.update();
    }

    private void buildGameMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.game"));
        menu.setOpaque(false);
        menu.setMnemonic(71);
        menu.add(this.getMenuItem("newAction"));
        menu.add(this.getMenuItem("newEmptyMapAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("openAction"));
        menu.add(this.getMenuItem("saveAction"));
        JMenuItem playItem = new JMenuItem(Messages.message("startGame"));
        playItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                File saveGameFile = new File(FreeCol.getAutosaveDirectory(), "tempMap.fsg");
                OptionGroup options = MapEditorMenuBar.this.freeColClient.getGame().getMapGeneratorOptions();
                FileOption fileOption = (FileOption)options.getOption("model.option.importFile");
                fileOption.setValue(saveGameFile);
                MapEditorMenuBar.this.freeColClient.getMapEditorController().saveGame(saveGameFile);
                MapEditorMenuBar.this.freeColClient.getCanvas().newGame();
            }
        });
        menu.add(playItem);
        menu.addSeparator();
        menu.add(this.getMenuItem("preferencesAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("showMainAction"));
        menu.add(this.getMenuItem("saveAndQuitAction"));
        this.add(menu);
    }

    private void buildViewMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.view"));
        menu.setOpaque(false);
        menu.setMnemonic(86);
        menu.add(this.getCheckBoxMenuItem("mapControlsAction"));
        menu.add(this.getCheckBoxMenuItem("displayGridAction"));
        menu.add(this.getCheckBoxMenuItem("changeWindowedModeAction"));
        menu.addSeparator();
        ButtonGroup tileTextGroup = new ButtonGroup();
        for (DisplayTileTextAction.DisplayText type : DisplayTileTextAction.DisplayText.values()) {
            menu.add(this.getRadioButtonMenuItem("displayTileTextAction." + (Object)((Object)type), tileTextGroup));
        }
        menu.addSeparator();
        menu.add(this.getMenuItem("zoomInAction"));
        menu.add(this.getMenuItem("zoomOutAction"));
        this.add(menu);
    }

    private void buildToolsMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.tools"));
        menu.setOpaque(false);
        menu.setMnemonic(84);
        menu.add(this.getMenuItem("scaleMapAction"));
        menu.add(this.getMenuItem("determineHighSeasAction"));
        this.add(menu);
    }
}

