/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;

public final class ImageLibrary {
    private static final Logger logger = Logger.getLogger(ImageLibrary.class.getName());
    public static final String UNIT_SELECT = "unitSelect.image";
    public static final String DELETE = "delete.image";
    public static final String PLOWED = "model.improvement.plow.image";
    public static final String TILE_TAKEN = "tileTaken.image";
    public static final String TILE_OWNED_BY_INDIANS = "nativeLand.image";
    public static final String LOST_CITY_RUMOUR = "lostCityRumour.image";
    public static final String DARKNESS = "halo.dark.image";
    private final float scalingFactor;

    public ImageLibrary() {
        this(1.0f);
    }

    public ImageLibrary(float scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    public float getScalingFactor() {
        return this.scalingFactor;
    }

    public ImageLibrary getScaledImageLibrary(float scalingFactor) throws FreeColException {
        return new ImageLibrary(scalingFactor);
    }

    public Image getImage(FreeColGameObjectType type) {
        return ResourceManager.getImage(type.getId() + ".image", this.scalingFactor);
    }

    public Image getImage(FreeColGameObjectType type, double scale) {
        return ResourceManager.getImage(type.getId() + ".image", scale);
    }

    public Image getFoundingFatherImage(FoundingFather father) {
        return ResourceManager.getImage(father.getId() + ".image");
    }

    public Image getMonarchImage(Nation nation) {
        return ResourceManager.getImage(nation.getId() + ".monarch.image");
    }

    public ImageIcon getMonarchImageIcon(Nation nation) {
        return ResourceManager.getImageIcon(nation.getId() + ".monarch.image");
    }

    public ImageIcon getCoatOfArmsImageIcon(Nation nation) {
        return ResourceManager.getImageIcon(nation.getId() + ".image");
    }

    public Image getCoatOfArmsImage(Nation nation) {
        return this.getCoatOfArmsImage(nation, this.scalingFactor);
    }

    public Image getCoatOfArmsImage(Nation nation, double scale) {
        return ResourceManager.getImage(nation.getId() + ".image", scale);
    }

    public Image getBonusImage(Tile tile) {
        if (tile.hasResource()) {
            return this.getBonusImage(tile.getTileItemContainer().getResource().getType());
        }
        return null;
    }

    public Image getBonusImage(ResourceType type) {
        return this.getBonusImage(type, this.scalingFactor);
    }

    public Image getBonusImage(ResourceType type, double scale) {
        return ResourceManager.getImage(type.getId() + ".image", scale);
    }

    public ImageIcon getBonusImageIcon(ResourceType type) {
        return new ImageIcon(this.getBonusImage(type));
    }

    public ImageIcon getScaledBonusImageIcon(ResourceType type, float scale) {
        return new ImageIcon(this.getBonusImage(type, scale));
    }

    public Image getCompoundTerrainImage(TileType type, double scale) {
        Image forestImage;
        Image terrainImage = this.getTerrainImage(type, 0, 0, scale);
        Image overlayImage = this.getOverlayImage(type, 0, 0, scale);
        Image image = forestImage = type.isForested() ? this.getForestImage(type, scale) : null;
        if (overlayImage == null && forestImage == null) {
            return terrainImage;
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        int width = terrainImage.getWidth(null);
        int height = terrainImage.getHeight(null);
        if (overlayImage != null) {
            height = Math.max(height, overlayImage.getHeight(null));
        }
        if (forestImage != null) {
            height = Math.max(height, forestImage.getHeight(null));
        }
        BufferedImage compositeImage = gc.createCompatibleImage(width, height, 3);
        Graphics2D g = compositeImage.createGraphics();
        g.drawImage(terrainImage, 0, height - terrainImage.getHeight(null), null);
        if (overlayImage != null) {
            g.drawImage(overlayImage, 0, height - overlayImage.getHeight(null), null);
        }
        if (forestImage != null) {
            g.drawImage(forestImage, 0, height - forestImage.getHeight(null), null);
        }
        g.dispose();
        return compositeImage;
    }

    public Image getOverlayImage(TileType type, int x, int y) {
        return this.getOverlayImage(type, x, y, this.scalingFactor);
    }

    public Image getOverlayImage(TileType type, int x, int y, double scale) {
        String key = type.getId() + ".overlay" + (x + y) % 2 + ".image";
        if (ResourceManager.hasResource(key)) {
            return ResourceManager.getImage(key, scale);
        }
        return null;
    }

    public Image getTerrainImage(TileType type, int x, int y) {
        return this.getTerrainImage(type, x, y, this.scalingFactor);
    }

    public Image getTerrainImage(TileType type, int x, int y, double scale) {
        String key = type == null ? "model.tile.unexplored" : type.getId();
        int index = y % 8 <= 2 || (x + y) % 2 == 0 ? 0 : 1;
        return ResourceManager.getImage(key + ".center" + index + ".image", scale);
    }

    public Image getBorderImage(TileType type, Map.Direction direction, int x, int y) {
        String key = type == null ? "model.tile.unexplored" : type.getId();
        String index = y % 8 <= 2 || (x + y) % 2 == 0 ? "_even" : "_odd";
        return ResourceManager.getImage(key + ".border_" + (Object)((Object)direction) + index + ".image", this.scalingFactor);
    }

    public Image getRiverMouthImage(Map.Direction direction, int magnitude, int x, int y) {
        String key = "delta_" + (Object)((Object)direction) + (magnitude == 1 ? "_small" : "_large");
        return ResourceManager.getImage(key, this.scalingFactor);
    }

    public Image getRiverImage(int index) {
        return this.getRiverImage(index, this.scalingFactor);
    }

    public Image getRiverImage(int index, double scale) {
        return ResourceManager.getImage("river" + index, scale);
    }

    public Image getBeachEdgeImage(int index) {
        return ResourceManager.getImage("model.tile.beach.edge" + index, this.scalingFactor);
    }

    public Image getBeachCornerImage(int index) {
        return ResourceManager.getImage("model.tile.beach.corner" + index, this.scalingFactor);
    }

    public Image getForestImage(TileType type) {
        return this.getForestImage(type, this.scalingFactor);
    }

    public Image getForestImage(TileType type, double scale) {
        return ResourceManager.getImage(type.getId() + ".forest", scale);
    }

    public Image getMiscImage(String id) {
        return this.getMiscImage(id, this.scalingFactor);
    }

    public Image getMiscImage(String id, double scale) {
        return ResourceManager.getImage(id, scale);
    }

    public ImageIcon getMiscImageIcon(String id) {
        return new ImageIcon(this.getMiscImage(id));
    }

    public Image getGoodsImage(GoodsType goodsType) {
        return this.getGoodsImage(goodsType, this.scalingFactor);
    }

    public Image getGoodsImage(GoodsType goodsType, double scale) {
        return ResourceManager.getImage(goodsType.getId() + ".image", scale);
    }

    public ImageIcon getGoodsImageIcon(GoodsType goodsType) {
        return ResourceManager.getImageIcon(goodsType.getId() + ".image");
    }

    public ImageIcon getScaledGoodsImageIcon(GoodsType type, double scale) {
        return new ImageIcon(this.getGoodsImage(type, scale));
    }

    public Color getColor(Player player) {
        return ResourceManager.getColor(player.getNationID() + ".color");
    }

    public Image getColorChip(Ownable ownable, double scale) {
        return ResourceManager.getChip(ownable.getOwner().getNationID() + ".chip", scale);
    }

    public Image getMissionChip(Ownable ownable, boolean expertMission, double scale) {
        if (expertMission) {
            return ResourceManager.getChip(ownable.getOwner().getNationID() + ".mission.expert.chip", scale);
        }
        return ResourceManager.getChip(ownable.getOwner().getNationID() + ".mission.chip", scale);
    }

    public Image getAlarmChip(Tension.Level alarm, boolean visited, double scale) {
        if (visited) {
            return ResourceManager.getChip("alarmChip.visited." + alarm.toString().toLowerCase(), scale);
        }
        return ResourceManager.getChip("alarmChip." + alarm.toString().toLowerCase(), scale);
    }

    public int getTerrainImageWidth(TileType type) {
        return this.getTerrainImage(type, 0, 0).getWidth(null);
    }

    public int getTerrainImageHeight(TileType type) {
        return this.getTerrainImage(type, 0, 0).getHeight(null);
    }

    public int getCompoundTerrainImageHeight(TileType type) {
        int height = this.getTerrainImageHeight(type);
        if (type != null) {
            Image overlayImage = this.getOverlayImage(type, 0, 0);
            if (overlayImage != null) {
                height = Math.max(height, overlayImage.getHeight(null));
            }
            if (type.isForested()) {
                height = Math.max(height, this.getForestImage(type).getHeight(null));
            }
        }
        return height;
    }

    public Image getSettlementImage(SettlementType settlementType) {
        return this.getSettlementImage(settlementType, (double)this.scalingFactor);
    }

    public Image getSettlementImage(SettlementType settlementType, double scale) {
        return ResourceManager.getImage(settlementType.getId() + ".image", scale);
    }

    public Image getSettlementImage(Settlement settlement) {
        return this.getSettlementImage(settlement, (double)this.scalingFactor);
    }

    public Image getSettlementImage(Settlement settlement, double scale) {
        return ResourceManager.getImage(settlement.getImageKey(), scale);
    }

    public ImageIcon getUnitImageIcon(Unit unit) {
        return this.getUnitImageIcon(unit.getType(), unit.getRole(), unit.hasNativeEthnicity(), false, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(Unit unit, double scale) {
        return this.getUnitImageIcon(unit.getType(), unit.getRole(), unit.hasNativeEthnicity(), false, scale);
    }

    public ImageIcon getUnitImageIcon(Unit unit, boolean grayscale) {
        return this.getUnitImageIcon(unit.getType(), unit.getRole(), unit.hasNativeEthnicity(), grayscale, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(Unit unit, boolean grayscale, double scale) {
        return this.getUnitImageIcon(unit.getType(), unit.getRole(), unit.hasNativeEthnicity(), grayscale, scale);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType) {
        return this.getUnitImageIcon(unitType, Unit.Role.DEFAULT, false, false, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, double scale) {
        return this.getUnitImageIcon(unitType, Unit.Role.DEFAULT, false, false, scale);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, Unit.Role role) {
        return this.getUnitImageIcon(unitType, role, false, false, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, Unit.Role role, double scale) {
        return this.getUnitImageIcon(unitType, role, false, false, scale);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, boolean grayscale) {
        return this.getUnitImageIcon(unitType, Unit.Role.DEFAULT, false, grayscale, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, boolean grayscale, double scale) {
        return this.getUnitImageIcon(unitType, Unit.Role.DEFAULT, false, grayscale, scale);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, Unit.Role role, boolean grayscale) {
        return this.getUnitImageIcon(unitType, role, false, grayscale, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, Unit.Role role, boolean grayscale, double scale) {
        return this.getUnitImageIcon(unitType, role, false, grayscale, scale);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, Unit.Role role, boolean nativeEthnicity, boolean grayscale, double scale) {
        if (unitType.getId().equals("model.unit.indianConvert") || unitType.getId().equals("model.unit.brave")) {
            nativeEthnicity = false;
        } else {
            for (Map.Entry<String, Boolean> entry : unitType.getAbilitiesRequired().entrySet()) {
                if (!entry.getKey().equals("model.ability.native") || !entry.getValue().booleanValue()) continue;
                nativeEthnicity = false;
            }
        }
        String key = unitType.getId() + (role == Unit.Role.DEFAULT ? "" : "." + role.getId()) + (nativeEthnicity ? ".native" : "") + ".image";
        Image image = null;
        image = grayscale ? ResourceManager.getGrayscaleImage(key, scale) : ResourceManager.getImage(key, scale);
        if (image == null) {
            logger.finest("No image found for image for " + key);
            if (nativeEthnicity) {
                return this.getUnitImageIcon(unitType, role, false, grayscale, scale);
            }
            logger.warning("Failed to retrieve image for " + key);
            return null;
        }
        return new ImageIcon(image);
    }

    public static void drawTiledImage(String resource, Graphics g, JComponent c, Insets insets) {
        int dy;
        int dx;
        int ymin;
        int xmin;
        int width = c.getWidth();
        int height = c.getHeight();
        Image image = ResourceManager.getImage(resource);
        if (insets == null) {
            xmin = 0;
            ymin = 0;
        } else {
            xmin = insets.left;
            ymin = insets.top;
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        if (image != null && (dx = image.getWidth(null)) > 0 && (dy = image.getHeight(null)) > 0) {
            int xmax = xmin + width;
            int ymax = ymin + height;
            for (int x = xmin; x < xmax; x += dx) {
                for (int y = ymin; y < ymax; y += dy) {
                    g.drawImage(image, x, y, null);
                }
            }
        } else {
            g.setColor(c.getBackground());
            g.fillRect(xmin, ymin, width, height);
        }
    }

    private String getPathType(Unit unit) {
        if (unit.isNaval()) {
            return "naval";
        }
        if (unit.isMounted()) {
            return "horse";
        }
        if (unit.getType().hasSkill() || unit.isUndead()) {
            return "foot";
        }
        return "wagon";
    }

    public Image getPathImage(Unit u) {
        if (u == null) {
            return null;
        }
        return ResourceManager.getImage("path." + this.getPathType(u) + ".image");
    }

    public Image getPathNextTurnImage(Unit u) {
        if (u == null) {
            return null;
        }
        return ResourceManager.getImage("path." + this.getPathType(u) + ".nextTurn.image");
    }
}

