/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;

public final class CanvasMouseMotionListener
implements MouseMotionListener {
    private static final Logger logger = Logger.getLogger(CanvasMouseMotionListener.class.getName());
    private Tile lastTile;
    private final Canvas canvas;
    private final GUI gui;
    private final Map map;
    private ScrollThread scrollThread;
    private static final int DRAG_SCROLLSPACE = 100;
    private static final int AUTO_SCROLLSPACE = 1;

    public CanvasMouseMotionListener(Canvas canvas, GUI g, Map m) {
        this.canvas = canvas;
        this.gui = g;
        this.map = m;
        this.scrollThread = null;
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.canvas.getFreeColClient().getClientOptions().getBoolean("model.option.autoScroll")) {
            this.auto_scroll(e.getX(), e.getY());
        } else if (this.scrollThread != null) {
            this.scrollThread.stopScrolling();
            this.scrollThread = null;
        }
        if (this.gui.isGotoStarted()) {
            Tile tile;
            if (this.gui.getActiveUnit() == null) {
                this.gui.stopGoto();
            }
            if ((tile = this.gui.convertToMapTile(e.getX(), e.getY())) != null && this.lastTile != tile) {
                this.lastTile = tile;
                if (this.gui.getActiveUnit() != null && this.gui.getActiveUnit().getTile() != tile) {
                    PathNode dragPath = this.gui.getActiveUnit().findPath(tile);
                    this.gui.setGotoPath(dragPath);
                } else {
                    this.gui.setGotoPath(null);
                }
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.canvas.getFreeColClient().getClientOptions().getBoolean("model.option.mapScrollOnDrag")) {
            this.drag_scroll(e.getX(), e.getY());
        } else if (this.scrollThread != null) {
            this.scrollThread.stopScrolling();
            this.scrollThread = null;
        }
        Tile tile = this.gui.convertToMapTile(e.getX(), e.getY());
        if (tile != null && (e.getModifiers() & 0x10) == 16) {
            if (this.gui.isGotoStarted()) {
                if (this.gui.getActiveUnit() == null) {
                    this.gui.stopGoto();
                } else if (this.lastTile != tile) {
                    this.lastTile = tile;
                    if (this.gui.getActiveUnit().getTile() != tile) {
                        PathNode dragPath = this.gui.getActiveUnit().findPath(tile);
                        this.gui.setGotoPath(dragPath);
                    } else {
                        this.gui.setGotoPath(null);
                    }
                }
            } else {
                this.gui.startGoto();
            }
        }
    }

    private void auto_scroll(int x, int y) {
        this.scroll(x, y, 1);
    }

    private void drag_scroll(int x, int y) {
        this.scroll(x, y, 100);
    }

    private void scroll(int x, int y, int scrollspace) {
        Map.Direction direction;
        if (x < scrollspace && y < scrollspace) {
            direction = Map.Direction.NW;
        } else if (x >= this.gui.getWidth() - scrollspace && y < scrollspace) {
            direction = Map.Direction.NE;
        } else if (x >= this.gui.getWidth() - scrollspace && y >= this.gui.getHeight() - scrollspace) {
            direction = Map.Direction.SE;
        } else if (x < scrollspace && y >= this.gui.getHeight() - scrollspace) {
            direction = Map.Direction.SW;
        } else if (y < scrollspace) {
            direction = Map.Direction.N;
        } else if (x >= this.gui.getWidth() - scrollspace) {
            direction = Map.Direction.E;
        } else if (y >= this.gui.getHeight() - scrollspace) {
            direction = Map.Direction.S;
        } else if (x < scrollspace) {
            direction = Map.Direction.W;
        } else {
            if (this.scrollThread != null) {
                this.scrollThread.stopScrolling();
                this.scrollThread = null;
            }
            return;
        }
        if (this.scrollThread != null) {
            this.scrollThread.setDirection(direction);
        } else {
            this.scrollThread = new ScrollThread(this.map, this.gui);
            this.scrollThread.setDirection(direction);
            this.scrollThread.start();
        }
    }

    private class ScrollThread
    extends Thread {
        private final Map map;
        private final GUI gui;
        private Map.Direction direction;
        private boolean cont;

        public ScrollThread(Map m, GUI g) {
            super("FreeColClient:Mouse scroller");
            this.map = m;
            this.gui = g;
            this.cont = true;
        }

        public void setDirection(Map.Direction d) {
            this.direction = d;
        }

        public void stopScrolling() {
            this.cont = false;
        }

        public void run() {
            do {
                try {
                    ScrollThread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            try {
                                int x;
                                int y;
                                Tile t = ScrollThread.this.gui.getFocus();
                                if (t == null) {
                                    return;
                                }
                                if ((t = t.getNeighbourOrNull(ScrollThread.this.direction)) == null) {
                                    return;
                                }
                                if (ScrollThread.this.gui.isMapNearTop(t.getY()) && ScrollThread.this.gui.isMapNearTop(ScrollThread.this.gui.getFocus().getY())) {
                                    if (t.getY() > ScrollThread.this.gui.getFocus().getY()) {
                                        y = t.getY();
                                        while (ScrollThread.this.gui.isMapNearTop(y += 2)) {
                                        }
                                    } else {
                                        y = ScrollThread.this.gui.getFocus().getY();
                                    }
                                } else if (ScrollThread.this.gui.isMapNearBottom(t.getY()) && ScrollThread.this.gui.isMapNearBottom(ScrollThread.this.gui.getFocus().getY())) {
                                    if (t.getY() < ScrollThread.this.gui.getFocus().getY()) {
                                        y = t.getY();
                                        while (ScrollThread.this.gui.isMapNearBottom(y -= 2)) {
                                        }
                                    } else {
                                        y = ScrollThread.this.gui.getFocus().getY();
                                    }
                                } else {
                                    y = t.getY();
                                }
                                if (ScrollThread.this.gui.isMapNearLeft(t.getX(), t.getY()) && ScrollThread.this.gui.isMapNearLeft(ScrollThread.this.gui.getFocus().getX(), ScrollThread.this.gui.getFocus().getY())) {
                                    if (t.getX() > ScrollThread.this.gui.getFocus().getX()) {
                                        x = t.getX();
                                        while (ScrollThread.this.gui.isMapNearLeft(++x, y)) {
                                        }
                                    } else {
                                        x = ScrollThread.this.gui.getFocus().getX();
                                    }
                                } else if (ScrollThread.this.gui.isMapNearRight(t.getX(), t.getY()) && ScrollThread.this.gui.isMapNearRight(ScrollThread.this.gui.getFocus().getX(), ScrollThread.this.gui.getFocus().getY())) {
                                    if (t.getX() < ScrollThread.this.gui.getFocus().getX()) {
                                        x = t.getX();
                                        while (ScrollThread.this.gui.isMapNearRight(--x, y)) {
                                        }
                                    } else {
                                        x = ScrollThread.this.gui.getFocus().getX();
                                    }
                                } else {
                                    x = t.getX();
                                }
                                ScrollThread.this.gui.setFocus(ScrollThread.this.map.getTile(x, y));
                            }
                            catch (Exception e) {
                                logger.log(Level.WARNING, "Exception while scrolling!", e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    logger.log(Level.WARNING, "Scroll thread caught error", e);
                    this.cont = false;
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Scroll thread interrupted", e);
                    this.cont = false;
                }
            } while (this.cont);
        }
    }
}

