/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.CanvasMapEditorMouseListener;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.MapControlsAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.menu.MapEditorMenuBar;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.panel.MapGeneratorOptionsDialog;
import net.sf.freecol.client.gui.panel.MiniMap;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.generator.MapGenerator;

public final class MapEditorController {
    private static final Logger logger = Logger.getLogger(MapEditorController.class.getName());
    private final FreeColClient freeColClient;
    private MapEditorTransformPanel.MapTransform currentMapTransform = null;

    public MapEditorController(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
    }

    public void startMapEditor() {
        String tc = "freecol";
        try {
            FreeColTcFile tcData = new FreeColTcFile("freecol");
            Specification specification = tcData.getSpecification();
            this.freeColClient.setMapEditor(true);
            FreeColServer freeColServer = new FreeColServer(specification, false, false, 0, null);
            this.freeColClient.setFreeColServer(freeColServer);
            this.freeColClient.setGame(freeColServer.getGame());
            this.freeColClient.setMyPlayer(null);
            this.freeColClient.playSound(null);
            Canvas canvas = this.freeColClient.getCanvas();
            GUI gui = this.freeColClient.getGUI();
            canvas.closeMainPanel();
            canvas.closeMenus();
            this.freeColClient.setInGame(true);
            gui.scaleMap(2.0f);
            this.freeColClient.getFrame().setJMenuBar(new MapEditorMenuBar(this.freeColClient));
            JInternalFrame f = this.freeColClient.getCanvas().addAsToolBox(new MapEditorTransformPanel(canvas));
            f.setLocation(f.getX(), 50);
            canvas.repaint();
            CanvasMapEditorMouseListener listener = new CanvasMapEditorMouseListener(canvas, gui);
            canvas.addMouseListener(listener);
            canvas.addMouseMotionListener(listener);
        }
        catch (NoRouteToServerException e) {
            this.freeColClient.getCanvas().errorMessage("server.noRouteToServer");
            return;
        }
        catch (IOException e) {
            this.freeColClient.getCanvas().errorMessage("server.couldNotStart");
            return;
        }
    }

    public void setMapTransform(MapEditorTransformPanel.MapTransform mt) {
        this.currentMapTransform = mt;
        MapControlsAction mca = (MapControlsAction)this.freeColClient.getActionManager().getFreeColAction("mapControlsAction");
        if (mca.getMapControls() != null) {
            mca.getMapControls().update(mt);
        }
    }

    public MapEditorTransformPanel.MapTransform getMapTransform() {
        return this.currentMapTransform;
    }

    public void transform(Tile t) {
        if (this.currentMapTransform != null) {
            this.currentMapTransform.transform(t);
        }
    }

    public void newMap() {
        Canvas canvas = this.freeColClient.getCanvas();
        Game game = this.freeColClient.getGame();
        MapGenerator mapGenerator = this.freeColClient.getFreeColServer().getMapGenerator();
        OptionGroup group = this.freeColClient.getGame().getMapGeneratorOptions();
        if ((group = canvas.showFreeColDialog(new MapGeneratorOptionsDialog(canvas, group, true, true))) == null) {
            return;
        }
        try {
            if (game.getSpecification().getDifficultyLevel() == null) {
                game.getSpecification().applyDifficultyLevel("model.difficulty.medium");
            }
            mapGenerator.createMap(game);
            this.freeColClient.getGUI().setFocus(game.getMap().getTile(1, 1));
            this.freeColClient.getActionManager().update();
            canvas.refresh();
        }
        catch (FreeColException e) {
            canvas.closeMenus();
            canvas.errorMessage(e.getMessage());
        }
    }

    public void saveGame() {
        Canvas canvas = this.freeColClient.getCanvas();
        String fileName = "my_map.fsg";
        File file = canvas.showSaveDialog(FreeCol.getSaveDirectory(), fileName);
        if (file != null) {
            this.saveGame(file);
        }
    }

    public void saveGame(final File file) {
        final Canvas canvas = this.freeColClient.getCanvas();
        canvas.showStatusPanel(Messages.message("status.savingGame"));
        Thread t = new Thread("FreeColClient:Saving Map"){

            public void run() {
                try {
                    MiniMap miniMap = new MiniMap(MapEditorController.this.freeColClient);
                    miniMap.setTileSize(24);
                    int width = MapEditorController.this.freeColClient.getGame().getMap().getWidth() * 24 + 12;
                    int height = MapEditorController.this.freeColClient.getGame().getMap().getHeight() * 24 / 4;
                    BufferedImage image = new BufferedImage(width, height, 2);
                    Graphics2D g2d = image.createGraphics();
                    miniMap.paintMap(g2d, width, height);
                    double scaledWidth = Math.min(64 * width / height, 128);
                    BufferedImage scaledImage = new BufferedImage((int)scaledWidth, 64, 2);
                    scaledImage.createGraphics().drawImage(image, 0, 0, (int)scaledWidth, 64, null);
                    MapEditorController.this.freeColClient.getFreeColServer().saveGame(file, "mapEditor", null, scaledImage);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            canvas.closeStatusPanel();
                            canvas.requestFocusInWindow();
                        }
                    });
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            canvas.errorMessage("couldNotSaveGame");
                        }
                    });
                }
            }
        };
        t.start();
    }

    public void loadGame() {
        Canvas canvas = this.freeColClient.getCanvas();
        File file = canvas.showLoadDialog(FreeCol.getSaveDirectory());
        if (file == null) {
            return;
        }
        if (!file.isFile()) {
            canvas.errorMessage("fileNotFound");
            return;
        }
        this.loadGame(file);
    }

    public void loadGame(File file) {
        final Canvas canvas = this.freeColClient.getCanvas();
        final File theFile = file;
        this.freeColClient.setMapEditor(true);
        canvas.showStatusPanel(Messages.message("status.loadingGame"));
        Runnable loadGameJob = new Runnable(){

            public void run() {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ErrorJob
                implements Runnable {
                    private final String message;
                    final /* synthetic */ Canvas val$canvas;
                    final /* synthetic */ MapEditorController this$0;

                    ErrorJob(String message) {
                        this.this$0 = mapEditorController;
                        this.val$canvas = canvas;
                        this.message = message;
                    }

                    public void run() {
                        this.val$canvas.closeMenus();
                        this.val$canvas.errorMessage(this.message);
                    }
                }
                FreeColServer freeColServer = null;
                try {
                    freeColServer = new FreeColServer(new FreeColSavegameFile(theFile), 0, "MapEditor");
                    MapEditorController.this.freeColClient.setFreeColServer(freeColServer);
                    MapEditorController.this.freeColClient.setGame(freeColServer.getGame());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            canvas.closeStatusPanel();
                            MapEditorController.this.freeColClient.getGUI().setFocus(MapEditorController.this.freeColClient.getGame().getMap().getTile(1, 1));
                            MapEditorController.this.freeColClient.getActionManager().update();
                            canvas.refresh();
                        }
                    });
                }
                catch (NoRouteToServerException e) {
                    MapEditorController.this.reloadMainPanel();
                    SwingUtilities.invokeLater(new ErrorJob(MapEditorController.this, "server.noRouteToServer", canvas));
                }
                catch (FileNotFoundException e) {
                    MapEditorController.this.reloadMainPanel();
                    SwingUtilities.invokeLater(new ErrorJob(MapEditorController.this, "fileNotFound", canvas));
                }
                catch (IOException e) {
                    MapEditorController.this.reloadMainPanel();
                    SwingUtilities.invokeLater(new ErrorJob(MapEditorController.this, "server.couldNotStart", canvas));
                }
                catch (FreeColException e) {
                    MapEditorController.this.reloadMainPanel();
                    SwingUtilities.invokeLater(new ErrorJob(MapEditorController.this, e.getMessage(), canvas));
                }
            }
        };
        this.freeColClient.worker.schedule(loadGameJob);
    }

    private void reloadMainPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MapEditorController.this.freeColClient.getCanvas().closeMainPanel();
                MapEditorController.this.freeColClient.getCanvas().showMainPanel();
                MapEditorController.this.freeColClient.playSound("sound.intro.general");
            }
        });
    }
}

