/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;

public class ServerColonyTile
extends ColonyTile
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerColonyTile.class.getName());

    public ServerColonyTile(Game game, String id) {
        super(game, id);
    }

    public ServerColonyTile(Game game, Colony colony, Tile workTile) {
        super(game);
        this.setColony(colony);
        this.workTile = workTile;
        this.colonyCenterTile = this.getTile() == workTile;
        this.getUnitList().clear();
    }

    public void csNewTurn(Random random, ChangeSet cs) {
        Resource resource;
        logger.finest("ServerColonyTile.csNewTurn, for " + this.toString());
        Colony colony = this.getColony();
        ServerPlayer owner = (ServerPlayer)colony.getOwner();
        Tile workTile = this.getWorkTile();
        Unit unit = this.getUnit();
        if (!this.isColonyCenterTile() && unit != null && this.canBeWorked() && (resource = workTile.expendResource(unit.getWorkType(), unit.getType(), colony)) != null) {
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WARNING, "model.tile.resourceExhausted", colony).add("%resource%", resource.getNameKey()).addName("%colony%", colony.getName()));
            cs.add(ChangeSet.See.perhaps(), workTile);
        }
    }

    public String getServerXMLElementTagName() {
        return "serverColonyTile";
    }
}

