/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class UnitWanderHostileMission
extends Mission {
    private static final Logger logger = Logger.getLogger(UnitWanderHostileMission.class.getName());

    public UnitWanderHostileMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
    }

    public UnitWanderHostileMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public UnitWanderHostileMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void doMission(Connection connection) {
        Unit unit = this.getUnit();
        if (!(unit.getLocation() instanceof Tile)) {
            return;
        }
        PathNode pathToTarget = null;
        if (unit.isOffensiveUnit()) {
            pathToTarget = this.findTarget(5);
        }
        if (pathToTarget != null) {
            Map.Direction direction = this.moveTowards(pathToTarget);
            if (direction != null && unit.getMoveType(direction).isAttack()) {
                AIMessage.askAttack(this.getAIUnit(), direction);
            }
        } else {
            this.moveRandomly(connection);
        }
    }

    public boolean isValid() {
        return super.isValid();
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(UnitWanderHostileMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "unitWanderHostileMission";
    }
}

