/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import org.w3c.dom.Element;

public class TransportMission
extends Mission {
    private static final Logger logger = Logger.getLogger(TransportMission.class.getName());
    private static final String ELEMENT_TRANSPORTABLE = "transportable";
    private static final int MINIMUM_GOLD_TO_STAY_IN_EUROPE = 600;
    private ArrayList<Transportable> transportList = new ArrayList();

    public TransportMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
        if (!this.getUnit().isCarrier()) {
            logger.warning("Only carriers can transport unit/goods.");
            throw new IllegalArgumentException("Only carriers can transport unit/goods.");
        }
    }

    public TransportMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public TransportMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    private void updateTransportList() {
        Unit carrier = this.getUnit();
        Iterator<Unit> ui = carrier.getUnitIterator();
        while (ui.hasNext()) {
            Unit u = ui.next();
            AIUnit aiUnit = this.getAIMain().getAIUnit(u);
            if (aiUnit == null) {
                logger.warning("Could not find ai unit");
                continue;
            }
            this.addToTransportList(aiUnit);
        }
        LinkedList<Transportable> ts = new LinkedList<Transportable>();
        for (Transportable t : new LinkedList<Transportable>(this.transportList)) {
            if (ts.contains(t) || this.isCarrying(t)) {
                if (t.getTransportDestination() == null) {
                    this.removeFromTransportList(t);
                }
            } else if (t.getTransportSource() == null) {
                this.removeFromTransportList(t);
            }
            ts.add(t);
        }
    }

    private boolean isCarrying(Transportable t) {
        return t.getTransportLocatable().getLocation() == this.getUnit();
    }

    public void dispose() {
        ArrayList<Transportable> cargoList = new ArrayList<Transportable>();
        ArrayList<Transportable> scheduledCargoList = new ArrayList<Transportable>();
        for (Transportable t : this.transportList) {
            if (this.isCarrying(t)) {
                cargoList.add(t);
                continue;
            }
            scheduledCargoList.add(t);
        }
        for (Transportable t : cargoList) {
            ((AIObject)((Object)t)).dispose();
        }
        for (Transportable t : scheduledCargoList) {
            t.setTransport(null);
        }
        super.dispose();
    }

    public boolean isOnTransportList(Transportable newTransportable) {
        for (int i = 0; i < this.transportList.size(); ++i) {
            if (this.transportList.get(i) != newTransportable) continue;
            return true;
        }
        return false;
    }

    public void removeFromTransportList(Transportable transportable) {
        Iterator<Transportable> ti = this.transportList.iterator();
        while (ti.hasNext()) {
            Transportable t = ti.next();
            if (t != transportable) continue;
            ti.remove();
            if (transportable.getTransport() != this.getAIUnit()) continue;
            transportable.setTransport(null);
        }
    }

    public void addToTransportList(Transportable newTransportable) {
        int distToDestination;
        Transportable t1;
        int i;
        Unit carrier = this.getUnit();
        if (newTransportable.getTransportLocatable() instanceof Unit && ((Unit)newTransportable.getTransportLocatable()).isCarrier()) {
            throw new IllegalArgumentException("You cannot add a carrier to the transport list.");
        }
        Location newSource = newTransportable.getTransportSource();
        Location newDestination = newTransportable.getTransportDestination();
        if (newDestination == null) {
            if (newTransportable instanceof AIGoods) {
                logger.warning("No destination for goods: " + newTransportable.getTransportLocatable().toString());
                return;
            }
            logger.warning("No destination for: " + newTransportable.getTransportLocatable().toString());
            return;
        }
        if (newSource == null && !this.isCarrying(newTransportable)) {
            logger.warning("No source for: " + newTransportable.getTransportLocatable().toString());
            return;
        }
        if (this.isOnTransportList(newTransportable)) {
            return;
        }
        int bestSourceIndex = -1;
        if (!this.isCarrying(newTransportable)) {
            int distToSource;
            if (carrier.getLocation().getTile() == newSource.getTile()) {
                distToSource = 0;
            } else {
                Tile t = carrier.getTile() != null ? carrier.getTile() : carrier.getFullEntryLocation();
                distToSource = this.getDistanceTo(newTransportable, t, true);
                if (distToSource == Integer.MIN_VALUE) {
                    return;
                }
            }
            bestSourceIndex = 0;
            int bestSourceDistance = distToSource;
            for (i = 1; i < this.transportList.size() && bestSourceDistance > 0; ++i) {
                t1 = this.transportList.get(i - 1);
                if ((t1.getTransportSource() == null || t1.getTransportSource().getTile() != newSource.getTile()) && (t1.getTransportDestination() == null || t1.getTransportDestination().getTile() != newSource.getTile())) continue;
                bestSourceIndex = i;
                bestSourceDistance = 0;
            }
            for (i = 1; i < this.transportList.size() && bestSourceDistance > 0; ++i) {
                t1 = this.transportList.get(i - 1);
                if (this.isCarrying(t1)) {
                    distToDestination = this.getDistanceTo(newTransportable, t1.getTransportDestination(), true);
                    if (distToDestination == Integer.MIN_VALUE || distToDestination > bestSourceDistance) continue;
                    bestSourceIndex = i;
                    bestSourceDistance = distToDestination;
                    continue;
                }
                distToSource = this.getDistanceTo(newTransportable, t1.getTransportSource(), true);
                if (distToSource == Integer.MIN_VALUE || distToSource > bestSourceDistance) continue;
                bestSourceIndex = i;
                bestSourceDistance = distToSource;
            }
            this.transportList.add(bestSourceIndex, newTransportable);
        }
        int bestDestinationIndex = bestSourceIndex + 1;
        int bestDestinationDistance = Integer.MAX_VALUE;
        if (bestSourceIndex == -1) {
            bestDestinationIndex = 0;
            if (carrier.getTile() == newSource.getTile()) {
                bestDestinationDistance = 0;
            } else {
                int distToCarrier = this.getDistanceTo(newTransportable, carrier.getTile(), false);
                if (distToCarrier != Integer.MIN_VALUE) {
                    bestDestinationDistance = distToCarrier;
                }
            }
        }
        for (i = Math.max(bestSourceIndex, 1); i < this.transportList.size() && bestDestinationDistance > 0; ++i) {
            t1 = this.transportList.get(i - 1);
            if (t1.getTransportSource().getTile() != newDestination.getTile() && t1.getTransportDestination().getTile() != newDestination.getTile()) continue;
            bestDestinationIndex = i;
            bestDestinationDistance = 0;
        }
        for (i = Math.max(bestSourceIndex, 1); i < this.transportList.size() && bestDestinationDistance > 0; ++i) {
            t1 = this.transportList.get(i - 1);
            if (this.isCarrying(t1)) {
                distToDestination = this.getDistanceTo(newTransportable, t1.getTransportDestination(), false);
                if (distToDestination == Integer.MIN_VALUE || distToDestination > bestDestinationDistance) continue;
                bestDestinationIndex = i;
                bestDestinationDistance = distToDestination;
                continue;
            }
            int distToSource = this.getDistanceTo(newTransportable, t1.getTransportSource(), false);
            if (distToSource == Integer.MIN_VALUE || distToSource > bestDestinationDistance) continue;
            bestDestinationIndex = i;
            bestDestinationDistance = distToSource;
        }
        this.transportList.add(bestDestinationIndex, newTransportable);
        if (newTransportable.getTransport() != this.getAIUnit()) {
            newTransportable.setTransport(this.getAIUnit());
        }
    }

    private int getDistanceTo(Transportable t, Location start, boolean source) {
        PathNode path = this.getPath(t, start, source);
        if (path == null) {
            return Integer.MIN_VALUE;
        }
        return path.getTotalTurns();
    }

    private boolean canAttackEnemyShips() {
        Unit carrier = this.getUnit();
        return carrier.getTile() != null && carrier.isNaval() && carrier.isOffensiveUnit();
    }

    private boolean hasCargo() {
        Unit carrier = this.getUnit();
        return carrier.getGoodsCount() + carrier.getUnitCount() > 0;
    }

    private boolean attackIfEnemyShipIsBlocking(Connection connection, Map.Direction direction) {
        Tile newTile;
        Unit defender;
        Unit carrier = this.getUnit();
        if (this.canAttackEnemyShips() && carrier.getMoveType(direction) == Unit.MoveType.ATTACK_UNIT && this.canAttackPlayer((defender = (newTile = carrier.getTile().getNeighbourOrNull(direction)).getDefendingUnit(carrier)).getOwner())) {
            AIMessage.askAttack(this.getAIUnit(), direction);
        }
        return this.isValid();
    }

    private boolean attackEnemyShips(Connection connection) {
        Map.Direction direction;
        if (!this.canAttackEnemyShips()) {
            return true;
        }
        Unit carrier = this.getUnit();
        if (this.hasCargo() && !carrier.getOwner().isREF()) {
            return true;
        }
        PathNode pathToTarget = this.findNavalTarget(0);
        if (pathToTarget != null && (direction = this.moveTowards(pathToTarget)) != null && carrier.getMoveType(direction) == Unit.MoveType.ATTACK_UNIT) {
            AIMessage.askAttack(this.getAIUnit(), direction);
        }
        return this.isValid();
    }

    private boolean canAttackPlayer(Player target) {
        return this.getUnit().getOwner().atWarWith(target) || this.getUnit().hasAbility("model.ability.piracy");
    }

    protected PathNode findNavalTarget(int maxTurns) {
        if (!this.getUnit().isOffensiveUnit()) {
            throw new IllegalStateException("A target can only be found for offensive units. You tried with: " + this.getUnit().toString());
        }
        if (!this.getUnit().isNaval()) {
            throw new IllegalStateException("A target can only be found for naval units. You tried with: " + this.getUnit().toString());
        }
        GoalDecider gd = new GoalDecider(){
            private PathNode bestTarget = null;
            private int bestValue = 0;

            public PathNode getGoal() {
                return this.bestTarget;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit unit, PathNode pathNode) {
                Tile newTile = pathNode.getTile();
                Unit defender = newTile.getDefendingUnit(unit);
                if (newTile.isLand() || defender == null || defender.getOwner() == unit.getOwner()) {
                    return false;
                }
                if (!TransportMission.this.canAttackPlayer(defender.getOwner())) {
                    return false;
                }
                int value = 1 + defender.getUnitCount() + defender.getGoodsCount();
                if (value > this.bestValue) {
                    this.bestTarget = pathNode;
                    this.bestValue = value;
                }
                return true;
            }
        };
        return this.getGame().getMap().search(this.getUnit(), this.getUnit().getTile(), gd, CostDeciders.avoidSettlements(), maxTurns);
    }

    public void doMission(Connection connection) {
        Unit carrier;
        logger.finest("Doing transport mission for unit " + this.getUnit() + "(" + this.getUnit().getId() + ")");
        if (this.transportList == null || this.transportList.size() <= 0) {
            this.updateTransportList();
        }
        if ((carrier = this.getUnit()).getMovesLeft() == 0) {
            return;
        }
        if (carrier.isBetweenEuropeAndNewWorld()) {
            return;
        }
        if (carrier.isInEurope()) {
            this.inEurope(connection);
            return;
        }
        if (!this.attackEnemyShips(connection)) {
            return;
        }
        this.restockCargoAtDestination(connection);
        if (!this.attackEnemyShips(connection)) {
            return;
        }
        boolean transportListChanged = false;
        boolean moreWork = true;
        for (int i = 0; i < this.transportList.size() && moreWork || i == 0; ++i) {
            Destination destination;
            boolean canMoveToEurope;
            if (carrier.getMovesLeft() == 0) {
                return;
            }
            moreWork = false;
            if (transportListChanged) {
                i = 0;
                transportListChanged = false;
            }
            boolean bl = canMoveToEurope = (destination = this.getNextStop()) != null && destination.moveToEurope() && carrier.canMoveToEurope();
            if (destination == null || destination.getPath() == null && !canMoveToEurope) {
                String carrierLoc = "";
                if (carrier.getLocation() instanceof Europe) {
                    carrierLoc = "Europe";
                } else {
                    Tile carrierTile = carrier.getTile();
                    carrierLoc = carrierTile.toString();
                    if (carrierTile.getColony() != null) {
                        carrierLoc = carrierLoc + " (" + carrierTile.getColony().getName() + ")";
                    }
                }
                logger.info("Could not get a next move for unit " + carrier + "(" + carrier.getId() + "), staying put at " + carrierLoc);
                return;
            }
            if (destination.isAtDestination()) {
                transportListChanged = this.restockCargoAtDestination(connection);
                continue;
            }
            if (canMoveToEurope) {
                this.moveUnitToEurope();
                return;
            }
            PathNode path = destination.getPath();
            boolean moveToEurope = destination.moveToEurope();
            Map.Direction r = this.moveTowards(path);
            if (r != null && carrier.getMoveType(r).isProgress()) {
                if (carrier.getMoveType(r) == Unit.MoveType.MOVE_HIGH_SEAS && moveToEurope) {
                    this.moveUnitToEurope();
                } else if (!this.moveButDontAttack(r)) {
                    return;
                }
                if (!(carrier.getLocation() instanceof Europe)) {
                    moreWork = true;
                }
            }
            if (r != null && !this.attackIfEnemyShipIsBlocking(connection, r)) {
                return;
            }
            transportListChanged = this.restockCargoAtDestination(connection);
            if (this.attackEnemyShips(connection)) continue;
            return;
        }
    }

    public Destination getNextStop() {
        Unit unit = this.getUnit();
        if (this.transportList.size() == 0 && !this.hasCargo()) {
            logger.info(unit + "(" + unit.getId() + ") has nothing to transport, moving to default destination");
            return this.getDefaultDestination();
        }
        ArrayList<Location> unavailLoc = new ArrayList<Location>();
        for (Transportable transportable : this.transportList) {
            Location destLoc = null;
            PathNode path = null;
            destLoc = this.isCarrying(transportable) ? transportable.getTransportDestination() : transportable.getTransportLocatable().getLocation();
            if (destLoc == null || unavailLoc.contains(destLoc)) continue;
            if (destLoc == unit.getLocation() || destLoc instanceof Colony && destLoc.getTile() == unit.getTile()) {
                return new Destination();
            }
            PathNode pathNode = path = destLoc instanceof Europe ? unit.findPathToEurope() : this.getPath(transportable);
            if (path == null) {
                unavailLoc.add(destLoc);
                continue;
            }
            logger.finest("Transporting " + transportable.getId() + " to " + destLoc);
            boolean moveToEurope = destLoc instanceof Europe;
            return new Destination(moveToEurope, path);
        }
        logger.warning("No destination available, stay put");
        return null;
    }

    Destination getDefaultDestination() {
        Unit unit = this.getUnit();
        PathNode path = null;
        if (unit.getLocation() instanceof Europe) {
            return new Destination();
        }
        if (unit.getTile() == null) {
            throw new IllegalStateException("Unit not on the map: " + unit.getId());
        }
        if (unit.getSettlement() != null) {
            return new Destination();
        }
        path = this.findNearestColony(unit);
        if (path != null) {
            return new Destination(false, path);
        }
        if (unit.isNaval() && unit.getOwner().canMoveToEurope()) {
            if (unit.canMoveToEurope()) {
                return new Destination(true, null);
            }
            path = unit.findPathToEurope();
            if (path != null) {
                return new Destination(true, path);
            }
        }
        logger.warning("Could not get default destination for " + unit);
        return null;
    }

    private void buyCargo(Connection connection) {
        AIColony ac;
        AIUnit newUnit;
        int space;
        AIPlayer aiPlayer = this.getAIMain().getAIPlayer(this.getUnit().getOwner());
        if (!this.getUnit().isInEurope()) {
            throw new IllegalStateException("Carrier not in Europe");
        }
        if (aiPlayer.hasFewColonies()) {
            Unit carrier = this.getUnit();
            Tile colonyTile = BuildColonyMission.findColonyLocation(carrier);
            for (space = this.getAvailableSpace(); colonyTile != null && space > 0; --space) {
                newUnit = this.getCheapestUnitInEurope(connection);
                if (newUnit != null) {
                    if (newUnit.getUnit().isColonist() && !newUnit.getUnit().isArmed() && !newUnit.getUnit().isMounted() && newUnit.getUnit().getRole() != Unit.Role.PIONEER) {
                        int colonyValue = aiPlayer.getPlayer().getColonyValue(colonyTile);
                        newUnit.setMission(new BuildColonyMission(this.getAIMain(), newUnit, colonyTile, colonyValue));
                    }
                    this.addToTransportList(newUnit);
                    continue;
                }
                return;
            }
        }
        ArrayList<AIColony> aiColonies = new ArrayList<AIColony>();
        for (int i = 0; i < this.transportList.size(); ++i) {
            Transportable t = this.transportList.get(i);
            if (t.getTransportDestination() == null || t.getTransportDestination().getTile() == null || t.getTransportDestination().getTile().getColony() == null || t.getTransportDestination().getTile().getColony().getOwner() != this.getUnit().getOwner()) continue;
            ac = this.getAIMain().getAIColony(t.getTransportDestination().getTile().getColony());
            aiColonies.add(ac);
        }
        Iterator<Wish> highValueWishIterator = this.getAIMain().getAIPlayer(this.getUnit().getOwner()).getWishIterator();
        while (highValueWishIterator.hasNext()) {
            AIColony ac2;
            Colony c;
            Wish w = highValueWishIterator.next();
            if (w.getTransportable() != null) continue;
            if (w instanceof WorkerWish && w.getDestination() instanceof Colony) {
                WorkerWish ww = (WorkerWish)w;
                c = (Colony)ww.getDestination();
                ac2 = this.getAIMain().getAIColony(c);
                if (aiColonies.contains(ac2)) continue;
                aiColonies.add(ac2);
                continue;
            }
            if (w instanceof GoodsWish && w.getDestination() instanceof Colony) {
                GoodsWish gw = (GoodsWish)w;
                c = (Colony)gw.getDestination();
                ac2 = this.getAIMain().getAIColony(c);
                if (aiColonies.contains(ac2)) continue;
                aiColonies.add(ac2);
                continue;
            }
            logger.warning("Unknown type of wish: " + w);
        }
        for (int i = 0; i < aiColonies.size(); ++i) {
            ac = (AIColony)aiColonies.get(i);
            int space2 = this.getAvailableSpace(this.getUnit().getType(), this.getUnit().getOwner().getEurope(), ac.getColony());
            Iterator<Wish> wishIterator = ac.getWishIterator();
            while (space2 > 0 && wishIterator.hasNext()) {
                Wish w = wishIterator.next();
                if (w.getTransportable() != null) continue;
                if (w instanceof WorkerWish) {
                    WorkerWish ww = (WorkerWish)w;
                    AIUnit newUnit2 = this.getUnitInEurope(connection, ww.getUnitType());
                    if (newUnit2 == null) continue;
                    newUnit2.setMission(new WishRealizationMission(this.getAIMain(), newUnit2, ww));
                    ww.setTransportable(newUnit2);
                    this.addToTransportList(newUnit2);
                    --space2;
                    continue;
                }
                if (w instanceof GoodsWish) {
                    GoodsWish gw = (GoodsWish)w;
                    AIGoods ag = this.buyGoodsInEurope(connection, gw.getGoodsType(), 100, gw.getDestination());
                    if (ag == null) continue;
                    gw.setTransportable(ag);
                    this.addToTransportList(ag);
                    --space2;
                    continue;
                }
                logger.warning("Unknown type of wish: " + w);
            }
        }
        for (space = this.getAvailableSpace(); space > 0 && (newUnit = this.getCheapestUnitInEurope(connection)) != null; --space) {
            this.addToTransportList(newUnit);
        }
    }

    public AIGoods buyGoodsInEurope(Connection connection, GoodsType type, int amount, Location destination) {
        Market market;
        AIPlayer aiPlayer = this.getAIMain().getAIPlayer(this.getUnit().getOwner());
        Player player = aiPlayer.getPlayer();
        if (player.checkGold((market = player.getMarket()).getBidPrice(type, amount))) {
            boolean success = AIMessage.askBuyGoods(this.getAIUnit(), type, amount);
            if (!success) {
                return null;
            }
            AIGoods ag = new AIGoods(this.getAIMain(), this.getUnit(), type, amount, destination);
            return ag;
        }
        return null;
    }

    private AIUnit getUnitInEurope(Connection connection, UnitType unitType) {
        AIPlayer aiPlayer = this.getAIMain().getAIPlayer(this.getUnit().getOwner());
        Player player = aiPlayer.getPlayer();
        Europe europe = player.getEurope();
        if (!this.getUnit().isInEurope()) {
            throw new IllegalStateException("Carrier not in Europe");
        }
        Iterator<Unit> ui = europe.getUnitIterator();
        while (ui.hasNext()) {
            Unit u = ui.next();
            if (unitType != null && unitType != u.getType()) continue;
            return this.getAIMain().getAIUnit(u);
        }
        int price = -1;
        if (unitType.hasPrice() && europe.getUnitPrice(unitType) >= 0) {
            price = europe.getUnitPrice(unitType);
        }
        if (player.checkGold(player.getRecruitPrice()) && price > player.getRecruitPrice()) {
            for (int i = 0; i < 3; ++i) {
                if (europe.getRecruitable(i) != unitType) continue;
                return aiPlayer.recruitAIUnitInEurope(i);
            }
        }
        if (price > 0 && player.checkGold(price)) {
            return aiPlayer.trainAIUnitInEurope(unitType);
        }
        return null;
    }

    private AIUnit getCheapestUnitInEurope(Connection connection) {
        AIPlayer aiPlayer = this.getAIMain().getAIPlayer(this.getUnit().getOwner());
        Player player = aiPlayer.getPlayer();
        Europe europe = player.getEurope();
        if (!this.getUnit().isInEurope()) {
            throw new IllegalStateException("Carrier not in Europe");
        }
        if (!player.canRecruitUnits()) {
            return null;
        }
        Iterator<Unit> ui = europe.getUnitIterator();
        while (ui.hasNext()) {
            Unit u = ui.next();
            if (u.isCarrier() || this.getAIMain().getAIUnit(u).getTransport() != null) continue;
            return this.getAIMain().getAIUnit(u);
        }
        int priceTrained = 0;
        UnitType cheapestTrained = null;
        List<UnitType> unitTypes = this.getAIMain().getGame().getSpecification().getUnitTypesTrainedInEurope();
        for (UnitType unitType : unitTypes) {
            int price = europe.getUnitPrice(unitType);
            if (cheapestTrained != null && price >= priceTrained) continue;
            cheapestTrained = unitType;
            priceTrained = price;
        }
        if (player.checkGold(player.getRecruitPrice()) && cheapestTrained != null && player.getRecruitPrice() < priceTrained) {
            return aiPlayer.recruitAIUnitInEurope(1);
        }
        if (cheapestTrained != null && player.checkGold(priceTrained)) {
            return aiPlayer.trainAIUnitInEurope(cheapestTrained);
        }
        return null;
    }

    public PathNode getPath(Transportable transportable) {
        return this.getPath(transportable, this.getUnit().getTile(), !this.isCarrying(transportable));
    }

    private PathNode getPath(Transportable transportable, Location start, boolean source) {
        PathNode path;
        Location destination;
        Unit carrier = this.getUnit();
        if (this.isCarrying(transportable) && source) {
            throw new IllegalStateException("Cannot find the path to the source while the transportable is on the carrier.");
        }
        Locatable locatable = transportable.getTransportLocatable();
        if (start == null || start.getTile() == null) {
            start = this.getUnit().getFullEntryLocation();
        }
        if ((destination = source ? locatable.getLocation() : transportable.getTransportDestination()) == null) {
            return null;
        }
        if (destination instanceof Europe) {
            path = this.findPathToEurope(start.getTile());
        } else if (locatable instanceof Unit && this.isCarrying(transportable)) {
            path = this.getGame().getMap().findPath((Unit)locatable, start.getTile(), destination.getTile(), carrier);
            if (path == null || path.getTransportDropNode().previous == null) {
                path = null;
            } else {
                path.getTransportDropNode().previous.next = null;
            }
        } else {
            path = this.getGame().getMap().findPath(carrier, start.getTile(), destination.getTile());
        }
        return path;
    }

    public int getAvailableSpace(Transportable t) {
        if (t.getTransportLocatable() instanceof Unit) {
            Unit u = (Unit)t.getTransportLocatable();
            return this.getAvailableSpace(u.getType(), t.getTransportSource(), t.getTransportDestination());
        }
        return this.getAvailableSpace(null, t.getTransportSource(), t.getTransportDestination());
    }

    public int getAvailableSpace(UnitType unitType, Location source, Location destination) {
        return Math.max(0, this.getUnit().getSpaceLeft() - this.transportList.size());
    }

    public int getAvailableSpace() {
        return Math.max(0, this.getUnit().getSpaceLeft() - this.transportList.size());
    }

    private boolean restockCargoAtDestination(Connection connection) {
        return this.unloadCargoAtDestination(connection) || this.loadCargoAtDestination(connection);
    }

    private boolean unloadCargoAtDestination(Connection connection) {
        Map map = this.getGame().getMap();
        Unit carrier = this.getUnit();
        boolean transportListChanged = false;
        if (carrier.isBetweenEuropeAndNewWorld()) {
            return false;
        }
        for (Transportable t : new ArrayList<Transportable>(this.transportList)) {
            if (!this.isCarrying(t)) continue;
            if (t instanceof AIUnit) {
                AIUnit au = (AIUnit)t;
                Unit u = au.getUnit();
                Mission mission = au.getMission();
                String reason = null;
                boolean unload = false;
                if (mission == null || !mission.isValid()) {
                    unload = true;
                    reason = "No valid mission";
                } else if (au.getTransportDestination() == null) {
                    unload = true;
                    reason = "No destination";
                } else if (au.getTransportDestination() instanceof Europe) {
                    if (carrier.isInEurope()) {
                        unload = true;
                        reason = "Arrived in Europe";
                    }
                } else {
                    Tile destTile = au.getTransportDestination().getTile();
                    if (destTile != null && carrier.getTile() != null) {
                        if (destTile == carrier.getTile()) {
                            unload = true;
                            reason = "Arrived at " + destTile;
                        } else {
                            PathNode p = map.findPath(u, carrier.getTile(), destTile, carrier);
                            if (p != null) {
                                int d;
                                PathNode dropNode = p.getTransportDropNode();
                                if (dropNode != null && dropNode.getTile() != null && (d = dropNode.getTile().getDistanceTo(carrier.getTile())) != Integer.MIN_VALUE && d <= 1) {
                                    mission.doMission(connection);
                                    reason = "Next to drop node " + dropNode.getTile();
                                }
                            } else {
                                unload = true;
                                reason = "No path to destination: " + destTile;
                            }
                        }
                    }
                }
                if (unload && (carrier.getSettlement() != null || carrier.isInEurope())) {
                    this.unitLeavesShip(au);
                }
                if (u.getLocation() != carrier) {
                    this.removeFromTransportList(au);
                    transportListChanged = true;
                }
                if (reason == null) continue;
                logger.finest("Unloading(" + reason + "," + unload + "): " + u + " from: " + carrier + " -> " + (u.getLocation() != carrier));
                continue;
            }
            if (t instanceof AIGoods) {
                String locStr;
                AIGoods ag = (AIGoods)t;
                String string = carrier.isInEurope() ? "Europe" : (locStr = carrier.getLocation().getSettlement() != null ? carrier.getLocation().getSettlement().getName() : carrier.getLocation().toString());
                if (ag.getTransportDestination() != null && (ag.getTransportDestination() == null || ag.getTransportDestination().getTile() != carrier.getLocation().getTile())) continue;
                logger.finest(carrier + "(" + carrier.getId() + ") unloading " + ag + " at " + locStr);
                if (carrier.isInEurope()) {
                    boolean success = this.sellCargoInEurope(ag.getGoods());
                    if (!success) continue;
                    this.removeFromTransportList(ag);
                    ag.dispose();
                    transportListChanged = true;
                    continue;
                }
                boolean success = this.unloadCargoInColony(ag.getGoods());
                if (!success) continue;
                this.removeFromTransportList(ag);
                ag.dispose();
                transportListChanged = true;
                continue;
            }
            logger.warning("Unknown Transportable.");
        }
        return transportListChanged;
    }

    private boolean loadCargoAtDestination(Connection connection) {
        Unit carrier = this.getUnit();
        boolean transportListChanged = false;
        Iterator<Transportable> tli = this.transportList.iterator();
        while (tli.hasNext() && carrier.getSpaceLeft() != 0) {
            Transportable t = tli.next();
            if (this.isCarrying(t)) continue;
            if (t instanceof AIUnit) {
                AIUnit au = (AIUnit)t;
                Unit u = au.getUnit();
                if (u.getTile() != carrier.getTile() || carrier.isBetweenEuropeAndNewWorld() || !AIMessage.askEmbark(this.getAIUnit(), u)) continue;
                tli.remove();
                transportListChanged = true;
                continue;
            }
            if (t instanceof AIGoods) {
                AIGoods ag = (AIGoods)t;
                if (ag.getGoods().getTile() != carrier.getTile() || carrier.isBetweenEuropeAndNewWorld()) continue;
                if (carrier.getLocation() instanceof Europe) {
                    GoodsType goodsType = ag.getGoods().getType();
                    int goodsAmount = ag.getGoods().getAmount();
                    boolean success = AIMessage.askBuyGoods(this.getAIUnit(), goodsType, goodsAmount);
                    if (!success) continue;
                    tli.remove();
                    transportListChanged = true;
                    ag.setGoods(new Goods(this.getGame(), carrier, goodsType, goodsAmount));
                    continue;
                }
                if (!AIMessage.askLoadCargo(this.getAIUnit(), ag.getGoods())) continue;
                tli.remove();
                transportListChanged = true;
                continue;
            }
            logger.warning("Unknown Transportable.");
        }
        return transportListChanged;
    }

    public static boolean isValid(AIUnit aiUnit) {
        AIPlayer aiPlayer;
        int transportMissions;
        boolean hasCargo;
        Unit unit = aiUnit.getUnit();
        if (!unit.isNaval()) {
            return true;
        }
        if (unit.isUnderRepair()) {
            return false;
        }
        boolean bl = hasCargo = unit.getGoodsCount() > 0 || unit.getUnitCount() > 0;
        if (hasCargo) {
            return true;
        }
        if (unit.hasAbility("model.ability.piracy") && (transportMissions = TransportMission.getPlayerNavalTransportMissionCount(aiPlayer = aiUnit.getAIMain().getAIPlayer(unit.getOwner()), unit)) > 0) {
            logger.finest("Privateer (" + unit.getId() + ") at " + unit.getTile() + " does no longer have TransportMission");
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return super.isValid() && TransportMission.isValid(this.getAIUnit());
    }

    public Tile getTransportDestination() {
        return null;
    }

    public int getTransportPriority() {
        return 0;
    }

    private void inEurope(Connection connection) {
        this.restockCargoAtDestination(connection);
        this.buyCargo(connection);
        this.restockCargoAtDestination(connection);
        Unit carrier = this.getUnit();
        if (!carrier.getOwner().checkGold(600) || this.transportList.size() > 0) {
            this.moveUnitToAmerica();
        }
    }

    protected PathNode findPathToEurope(Tile start) {
        return this.getGame().getMap().findPathToEurope(this.getUnit(), start);
    }

    public static int getPlayerNavalTransportMissionCount(AIPlayer aiPlayer, Unit unitExcluded) {
        Player player = aiPlayer.getPlayer();
        int units = 0;
        for (Unit unit : player.getUnits()) {
            AIUnit aiUnit;
            if (unit == unitExcluded || !unit.isNaval() || !((aiUnit = aiPlayer.getAIMain().getAIUnit(unit)).getMission() instanceof TransportMission)) continue;
            ++units;
        }
        return units;
    }

    public String getDebuggingInfo() {
        return this.toString();
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(TransportMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        for (Transportable t : this.transportList) {
            out.writeStartElement(ELEMENT_TRANSPORTABLE);
            out.writeAttribute("ID", ((AIObject)((Object)t)).getId());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        this.transportList.clear();
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(ELEMENT_TRANSPORTABLE)) {
                String tid = in.getAttributeValue(null, "ID");
                AIObject ao = this.getAIMain().getAIObject(tid);
                if (ao == null) {
                    ao = tid.startsWith(Unit.getXMLElementTagName()) ? new AIUnit(this.getAIMain(), tid) : new AIGoods(this.getAIMain(), tid);
                }
                if (!(ao instanceof Transportable)) {
                    logger.warning("AIObject not Transportable, ID: " + in.getAttributeValue(null, "ID"));
                } else {
                    this.transportList.add((Transportable)((Object)ao));
                }
                in.nextTag();
                continue;
            }
            logger.warning("Unknown tag.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Transport list:\n");
        LinkedList<Transportable> ts = new LinkedList<Transportable>();
        for (Transportable t : this.transportList) {
            Location target;
            Locatable l = t.getTransportLocatable();
            sb.append(l.toString());
            sb.append(" (");
            if (ts.contains(t) || this.isCarrying(t)) {
                sb.append("to ");
                target = t.getTransportDestination();
            } else {
                sb.append("from ");
                target = t.getTransportSource();
            }
            if (target instanceof Europe) {
                sb.append("Europe");
            } else if (target == null) {
                sb.append("null");
            } else {
                sb.append(target.getTile().getPosition());
            }
            sb.append(")");
            sb.append("\n");
            ts.add(t);
        }
        return sb.toString();
    }

    public static String getXMLElementTagName() {
        return "transportMission";
    }

    class Destination {
        private boolean atDestination;
        private boolean moveToEurope;
        private PathNode path;

        public Destination() {
            this.atDestination = true;
            this.moveToEurope = false;
            this.path = null;
        }

        public Destination(boolean moveToEurope, PathNode path) {
            this.atDestination = false;
            this.moveToEurope = moveToEurope;
            this.path = path;
        }

        public boolean moveToEurope() {
            return this.moveToEurope;
        }

        public PathNode getPath() {
            return this.path;
        }

        public boolean isAtDestination() {
            return this.atDestination;
        }
    }
}

