/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PioneeringMission
extends Mission {
    private static final Logger logger = Logger.getLogger(PioneeringMission.class.getName());
    private PioneeringMissionState state = PioneeringMissionState.GET_TOOLS;
    private TileImprovementPlan tileImprovementPlan = null;
    private Colony colonyWithTools = null;
    private boolean invalidateMission = false;

    public PioneeringMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
        boolean hasTools = this.getUnit().hasAbility("model.ability.improveTerrain");
        this.state = hasTools ? PioneeringMissionState.IMPROVING : PioneeringMissionState.GET_TOOLS;
    }

    public PioneeringMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public PioneeringMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    @Override
    public void dispose() {
        if (this.tileImprovementPlan != null) {
            this.tileImprovementPlan.setPioneer(null);
            this.tileImprovementPlan = null;
        }
        super.dispose();
    }

    public void setTileImprovementPlan(TileImprovementPlan tileImprovementPlan) {
        this.tileImprovementPlan = tileImprovementPlan;
    }

    private void updateTileImprovementPlan() {
        Tile startTile;
        Tile improvementTarget;
        AIPlayer aiPlayer = this.getAIMain().getAIPlayer(this.getUnit().getOwner());
        Unit carrier = this.getUnit().isOnCarrier() ? (Unit)this.getUnit().getLocation() : null;
        Tile tile = improvementTarget = this.tileImprovementPlan != null ? this.tileImprovementPlan.getTarget() : null;
        if (this.tileImprovementPlan != null && improvementTarget == null) {
            logger.finest("Found invalid TileImprovementPlan, removing it and assigning a new one");
            aiPlayer.removeTileImprovementPlan(this.tileImprovementPlan);
            this.tileImprovementPlan.dispose();
            this.tileImprovementPlan = null;
        }
        if (this.tileImprovementPlan != null && improvementTarget != null && improvementTarget.hasImprovement(this.tileImprovementPlan.getType())) {
            aiPlayer.removeTileImprovementPlan(this.tileImprovementPlan);
            this.tileImprovementPlan.dispose();
            this.tileImprovementPlan = null;
        }
        if (this.tileImprovementPlan != null && improvementTarget != null) {
            return;
        }
        if (this.getUnit().getTile() == null) {
            startTile = (this.getUnit().isOnCarrier() ? (Unit)this.getUnit().getLocation() : this.getUnit()).getFullEntryLocation();
            if (startTile == null) {
                logger.warning("Unable to determine entry location for: " + this.getUnit().toString());
                return;
            }
        } else {
            startTile = this.getUnit().getTile();
        }
        TileImprovementPlan bestChoice = null;
        int bestValue = 0;
        Iterator<TileImprovementPlan> tiIterator = aiPlayer.getTileImprovementPlanIterator();
        while (tiIterator.hasNext()) {
            int value;
            TileImprovementPlan ti = tiIterator.next();
            if (ti.getPioneer() != null) continue;
            if (ti.getTarget() == null) {
                logger.finest("Found invalid TileImprovementPlan, removing it and finding a new one");
                aiPlayer.removeTileImprovementPlan(ti);
                ti.dispose();
                continue;
            }
            PathNode path = null;
            if (startTile != ti.getTarget()) {
                path = this.getGame().getMap().findPath(this.getUnit(), startTile, ti.getTarget(), carrier);
                if (path != null) {
                    value = ti.getValue() + 10000 - path.getTotalTurns() * 5;
                    PathNode pn = path;
                    while (pn != null) {
                        if (pn.getTile().getFirstUnit() != null && pn.getTile().getFirstUnit().getOwner() != this.getUnit().getOwner()) {
                            value -= 1000;
                        }
                        pn = pn.next;
                    }
                } else {
                    value = ti.getValue();
                }
            } else {
                value = ti.getValue() + 10000;
            }
            if (value <= bestValue) continue;
            bestChoice = ti;
            bestValue = value;
        }
        if (bestChoice != null) {
            this.tileImprovementPlan = bestChoice;
            bestChoice.setPioneer(this.getAIUnit());
        }
        if (this.tileImprovementPlan == null) {
            this.invalidateMission = true;
        }
    }

    @Override
    public void doMission(Connection connection) {
        logger.finest("Entering PioneeringMission.doMission()");
        Unit unit = this.getUnit();
        boolean hasTools = this.getUnit().hasAbility("model.ability.improveTerrain");
        this.state = unit.getState() == Unit.UnitState.IMPROVING || hasTools ? PioneeringMissionState.IMPROVING : PioneeringMissionState.GET_TOOLS;
        block4: while (this.isValid() && unit.getMovesLeft() > 0) {
            switch (this.state) {
                case GET_TOOLS: {
                    this.getTools(connection);
                    continue block4;
                }
                case IMPROVING: {
                    this.processImprovementPlan(connection);
                    continue block4;
                }
            }
            logger.warning("Unknown state");
            this.invalidateMission = true;
        }
    }

    private void processImprovementPlan(Connection connection) {
        int price;
        Unit unit;
        if (this.tileImprovementPlan == null) {
            this.updateTileImprovementPlan();
            if (this.tileImprovementPlan == null) {
                this.invalidateMission = true;
                return;
            }
        }
        if ((unit = this.getUnit()).getTile() == null) {
            logger.warning("Unit is in unknown location, cannot proceed with mission");
            this.invalidateMission = true;
            return;
        }
        if (this.getUnit().getTile() != this.tileImprovementPlan.getTarget()) {
            PathNode pathToTarget = this.getUnit().findPath(this.tileImprovementPlan.getTarget());
            if (pathToTarget == null) {
                this.invalidateMission = true;
                return;
            }
            Map.Direction direction = this.moveTowards(pathToTarget);
            if (direction != null && !this.moveButDontAttack(direction)) {
                return;
            }
            if (unit.getTile() != this.tileImprovementPlan.getTarget()) {
                unit.setMovesLeft(0);
            }
            if (unit.getMovesLeft() == 0) {
                return;
            }
        }
        if (unit.getTile() != this.tileImprovementPlan.getTarget()) {
            String errMsg = "Something is wrong, pioneer should be on the tile to improve, but isnt";
            logger.warning(errMsg);
            this.invalidateMission = true;
            return;
        }
        Tile target = this.tileImprovementPlan.getTarget();
        Player player = this.getUnit().getOwner();
        if (target.getOwner() != player && (price = player.getLandPrice(target)) >= 0) {
            if (price > 0 && !player.checkGold(price)) {
                price = -1;
            }
            AIMessage.askClaimLand(connection, target, null, price);
        }
        if (target.getOwner() != player) {
            this.invalidateMission = true;
            return;
        }
        this.makeImprovement(connection);
    }

    private void makeImprovement(Connection connection) {
        Unit unit = this.getUnit();
        if (unit.getState() == Unit.UnitState.IMPROVING) {
            unit.setMovesLeft(0);
            return;
        }
        if (unit.checkSetState(Unit.UnitState.IMPROVING)) {
            int price = unit.getOwner().getLandPrice(unit.getTile());
            if (price > 0) {
                // empty if block
            }
            AIMessage.askChangeWorkImprovementType(this.getAIUnit(), this.tileImprovementPlan.getType());
        }
    }

    private void getTools(Connection connection) {
        this.validateColonyWithTools();
        if (this.invalidateMission) {
            return;
        }
        Unit unit = this.getUnit();
        if (unit.getTile() != this.colonyWithTools.getTile()) {
            PathNode path = unit.findPath(this.colonyWithTools.getTile());
            if (path == null) {
                this.invalidateMission = true;
                this.colonyWithTools = null;
                return;
            }
            Map.Direction direction = this.moveTowards(path);
            if (direction == null || !this.moveButDontAttack(direction)) {
                return;
            }
            if (unit.getTile() != this.colonyWithTools.getTile()) {
                unit.setMovesLeft(0);
                return;
            }
        }
        this.equipUnitWithTools(connection);
    }

    private void equipUnitWithTools(Connection connection) {
        Unit unit = this.getUnit();
        logger.finest("About to equip " + unit + " in " + this.colonyWithTools.getName());
        AIColony ac = this.getAIMain().getAIColony(this.colonyWithTools);
        EquipmentType toolsType = this.getAIMain().getGame().getSpecification().getEquipmentType("model.equipment.tools");
        int amount = toolsType.getMaximumCount();
        for (AbstractGoods materials : toolsType.getGoodsRequired()) {
            int requiredAmount;
            int availableAmount = ac.getAvailableGoods(materials.getType());
            if (availableAmount < (requiredAmount = materials.getAmount())) {
                this.invalidateMission = true;
                return;
            }
            amount = Math.min(amount, availableAmount / requiredAmount);
        }
        logger.finest("Equipping " + unit + " at=" + this.colonyWithTools.getName() + " amount=" + amount);
        AIMessage.askEquipUnit(this.getAIUnit(), toolsType, amount);
        if (unit.getEquipmentCount(toolsType) > 0) {
            this.state = PioneeringMissionState.IMPROVING;
        }
    }

    private boolean validateColonyWithTools() {
        EquipmentType toolsType = this.getAIMain().getGame().getSpecification().getEquipmentType("model.equipment.tools");
        if (this.colonyWithTools != null && (this.colonyWithTools.isDisposed() || this.colonyWithTools.getOwner() != this.getUnit().getOwner() || !this.colonyWithTools.canBuildEquipment(toolsType))) {
            this.colonyWithTools = null;
        }
        if (this.colonyWithTools == null) {
            this.colonyWithTools = PioneeringMission.findColonyWithTools(this.getAIUnit());
            if (this.colonyWithTools == null) {
                logger.finest("No tools found");
                this.invalidateMission = true;
                return false;
            }
            logger.finest("Colony found=" + this.colonyWithTools.getName());
        }
        return true;
    }

    @Override
    public Tile getTransportDestination() {
        this.updateTileImprovementPlan();
        if (this.tileImprovementPlan == null) {
            return null;
        }
        if (this.getUnit().isOnCarrier()) {
            return this.tileImprovementPlan.getTarget();
        }
        if (this.getUnit().getTile() == this.tileImprovementPlan.getTarget()) {
            return null;
        }
        if (this.getUnit().getTile() == null || this.getUnit().findPath(this.tileImprovementPlan.getTarget()) == null) {
            return this.tileImprovementPlan.getTarget();
        }
        return null;
    }

    @Override
    public int getTransportPriority() {
        if (this.getTransportDestination() != null) {
            return 100;
        }
        return 0;
    }

    public static boolean isValid(AIUnit aiUnit) {
        boolean unitHasToolsAvail;
        if (!aiUnit.getUnit().isColonist()) {
            return false;
        }
        if (aiUnit.getUnit().getTile() == null) {
            return false;
        }
        AIPlayer aiPlayer = aiUnit.getAIMain().getAIPlayer(aiUnit.getUnit().getOwner());
        Iterator<TileImprovementPlan> tiIterator = aiPlayer.getTileImprovementPlanIterator();
        boolean foundImprovementPlan = false;
        while (tiIterator.hasNext()) {
            TileImprovementPlan ti = tiIterator.next();
            if (ti.getPioneer() != null) continue;
            foundImprovementPlan = true;
        }
        if (!foundImprovementPlan) {
            logger.finest("No Improvement plan found, PioneeringMission not valid");
            return false;
        }
        EquipmentType toolsType = aiUnit.getAIMain().getGame().getSpecification().getEquipmentType("model.equipment.tools");
        boolean bl = unitHasToolsAvail = aiUnit.getUnit().getEquipmentCount(toolsType) > 0;
        if (unitHasToolsAvail) {
            logger.finest("Tools equipped, PioneeringMission valid");
            return true;
        }
        Colony colonyWithTools = PioneeringMission.findColonyWithTools(aiUnit);
        if (colonyWithTools != null) {
            logger.finest("Tools found, PioneeringMission valid");
            return true;
        }
        logger.finest("Tools not found, PioneeringMission not valid");
        return false;
    }

    public static Colony findColonyWithTools(AIUnit aiu) {
        int MAX_TURN_DISTANCE = 10;
        Colony best = null;
        int bestValue = Integer.MIN_VALUE;
        Unit unit = aiu.getUnit();
        if (unit == null) {
            return null;
        }
        EquipmentType toolsType = aiu.getAIMain().getGame().getSpecification().getEquipmentType("model.equipment.tools");
        for (Colony colony : unit.getOwner().getColonies()) {
            AIColony ac;
            if (!colony.canBuildEquipment(toolsType) || (ac = aiu.getAIMain().getAIColony(colony)) == null) continue;
            PathNode pathNode = null;
            if (unit.getTile() != colony.getTile() && ((pathNode = unit.findPath(colony.getTile())) == null || pathNode.getTotalTurns() > 10)) continue;
            int value = 100;
            for (AbstractGoods goods : toolsType.getGoodsRequired()) {
                value += colony.getGoodsCount(goods.getType());
            }
            if (pathNode != null) {
                value -= pathNode.getTotalTurns() * 10;
            }
            if (best != null && value <= bestValue) continue;
            best = colony;
            bestValue = value;
        }
        return best;
    }

    public static List<AIUnit> getPlayerPioneers(AIPlayer aiPlayer) {
        ArrayList<AIUnit> list = new ArrayList<AIUnit>();
        AIMain aiMain = aiPlayer.getAIMain();
        for (Unit u : aiPlayer.getPlayer().getUnits()) {
            AIUnit aiu = aiMain.getAIUnit(u);
            if (aiu == null || !(aiu.getMission() instanceof PioneeringMission)) continue;
            list.add(aiu);
        }
        return list;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid() || this.getUnit().getTile() == null || this.invalidateMission) {
            return false;
        }
        switch (this.state) {
            case GET_TOOLS: {
                EquipmentType toolsType = this.getAIMain().getGame().getSpecification().getEquipmentType("model.equipment.tools");
                if (this.colonyWithTools != null && !this.colonyWithTools.isDisposed() && this.colonyWithTools.getOwner() == this.getUnit().getOwner() && this.colonyWithTools.canBuildEquipment(toolsType)) break;
                return PioneeringMission.findColonyWithTools(this.getAIUnit()) != null;
            }
            case IMPROVING: {
                Tile target;
                Tile tile = target = this.tileImprovementPlan == null ? null : this.tileImprovementPlan.getTarget();
                if (this.tileImprovementPlan != null && target != null && !target.hasImprovement(this.tileImprovementPlan.getType())) break;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getDebuggingInfo() {
        switch (this.state) {
            case IMPROVING: {
                if (this.tileImprovementPlan == null) {
                    return "No target";
                }
                String action = this.tileImprovementPlan.getType().getNameKey();
                return this.tileImprovementPlan.getTarget().getPosition().toString() + " " + action;
            }
            case GET_TOOLS: {
                if (this.colonyWithTools == null) {
                    return "No target";
                }
                return "Getting tools from " + this.colonyWithTools.getName();
            }
        }
        logger.warning("Unknown state");
        return "";
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(PioneeringMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        if (this.tileImprovementPlan != null) {
            out.writeAttribute("tileImprovementPlan", this.tileImprovementPlan.getId());
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        String tileImprovementPlanStr = in.getAttributeValue(null, "tileImprovementPlan");
        if (tileImprovementPlanStr != null) {
            this.tileImprovementPlan = (TileImprovementPlan)this.getAIMain().getAIObject(tileImprovementPlanStr);
            if (this.tileImprovementPlan == null) {
                this.tileImprovementPlan = new TileImprovementPlan(this.getAIMain(), tileImprovementPlanStr);
            }
        } else {
            this.tileImprovementPlan = null;
        }
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "tileImprovementPlanMission";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PioneeringMissionState {
        GET_TOOLS,
        IMPROVING;

    }
}

