/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.PrivateerMission;

public abstract class Mission
extends AIObject {
    private static final Logger logger = Logger.getLogger(Mission.class.getName());
    protected static final int MINIMUM_TRANSPORT_PRIORITY = 60;
    protected static final int NORMAL_TRANSPORT_PRIORITY = 100;
    protected static final int NO_PATH_TO_TARGET = -2;
    protected static final int NO_MORE_MOVES_LEFT = -1;
    private AIUnit aiUnit;

    public Mission(AIMain aiMain) {
        this(aiMain, (AIUnit)null);
    }

    public Mission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain);
        this.aiUnit = aiUnit;
    }

    protected Map.Direction moveTowards(Tile tile) {
        PathNode pathNode = this.getUnit().findPath(tile);
        return pathNode == null ? null : this.moveTowards(pathNode);
    }

    protected Map.Direction moveTowards(PathNode pathNode) {
        if (this.getUnit().getMovesLeft() <= 0) {
            return null;
        }
        while (pathNode.next != null && pathNode.getTurns() == 0) {
            if (!this.isValid()) {
                return null;
            }
            if (!this.getUnit().getMoveType(pathNode.getDirection()).isProgress()) break;
            if (!AIMessage.askMove(this.aiUnit, pathNode.getDirection()) || this.getUnit() == null || this.getUnit().isDisposed()) {
                return null;
            }
            pathNode = pathNode.next;
        }
        return pathNode.getTurns() == 0 && this.getUnit().getMoveType(pathNode.getDirection()).isLegal() ? pathNode.getDirection() : null;
    }

    protected void moveRandomly(Connection connection) {
        Unit unit = this.getUnit();
        Map.Direction[] randomDirections = Map.Direction.getRandomDirectionArray(this.getAIRandom());
        while (this.isValid() && unit.getMovesLeft() > 0) {
            Tile thisTile = this.getUnit().getTile();
            for (int j = 0; j < randomDirections.length; ++j) {
                Map.Direction direction = randomDirections[j];
                if (thisTile.getNeighbourOrNull(direction) == null || unit.getMoveType(direction) != Unit.MoveType.MOVE) continue;
                AIMessage.askMove(this.aiUnit, direction);
                break;
            }
            unit.setMovesLeft(0);
        }
    }

    protected void moveUnitToAmerica() {
        AIMessage.askMoveToAmerica(this.aiUnit);
    }

    protected void moveUnitToEurope() {
        AIMessage.askMoveToEurope(this.aiUnit);
    }

    protected boolean moveButDontAttack(Map.Direction direction) {
        if (direction != null && this.getUnit() != null && this.getUnit().getMoveType(direction).isProgress()) {
            AIMessage.askMove(this.aiUnit, direction);
        }
        return this.getUnit() != null && !this.getUnit().isDisposed();
    }

    protected PathNode findTarget(int maxTurns) {
        if (!this.getUnit().isOffensiveUnit()) {
            throw new IllegalStateException("A target can only be found for offensive units. You tried with: " + this.getUnit().toString());
        }
        GoalDecider gd = new GoalDecider(){
            private PathNode bestTarget = null;
            private int higherTension = 0;

            public PathNode getGoal() {
                return this.bestTarget;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit unit, PathNode pathNode) {
                CombatModel combatModel = Mission.this.getGame().getCombatModel();
                Tile newTile = pathNode.getTile();
                Unit defender = newTile.getDefendingUnit(unit);
                if (defender == null) {
                    return false;
                }
                if (defender.getOwner() == unit.getOwner()) {
                    return false;
                }
                if (newTile.isLand() && unit.isNaval() || !newTile.isLand() && !unit.isNaval()) {
                    return false;
                }
                int tension = unit.getOwner().getTension(defender.getOwner()).getValue();
                if (unit.getIndianSettlement() != null && unit.getIndianSettlement().hasContactedSettlement(defender.getOwner())) {
                    tension += unit.getIndianSettlement().getAlarm(defender.getOwner()).getValue();
                }
                if (defender.canCarryTreasure()) {
                    tension += Math.min(defender.getTreasureAmount() / 10, 600);
                }
                if (defender.getType().getDefence() > 0 && newTile.getSettlement() == null) {
                    tension = (int)((float)tension + (100.0f - combatModel.getDefencePower(unit, defender) * 2.0f));
                }
                if (defender.hasAbility("model.ability.expertSoldier") && !defender.isArmed()) {
                    tension = (int)((float)tension + (50.0f - combatModel.getDefencePower(unit, defender) * 2.0f));
                }
                if (unit.hasAbility("model.ability.piracy")) {
                    tension += PrivateerMission.getModifierValueForTarget(combatModel, unit, defender);
                }
                if (unit.getOwner().isIndian() && defender.getOwner().isAI()) {
                    tension -= 200;
                }
                if (tension > Tension.Level.CONTENT.getLimit()) {
                    if (this.bestTarget == null) {
                        this.bestTarget = pathNode;
                        this.higherTension = tension;
                        return true;
                    }
                    if (this.bestTarget.getTurns() == pathNode.getTurns() && tension > this.higherTension) {
                        this.bestTarget = pathNode;
                        this.higherTension = tension;
                        return true;
                    }
                }
                return false;
            }
        };
        return this.getGame().getMap().search(this.getUnit(), this.getUnit().getTile(), gd, CostDeciders.avoidIllegal(), maxTurns);
    }

    public Tile getTransportDestination() {
        if (this.getUnit().getTile() == null) {
            return (this.getUnit().isOnCarrier() ? (Unit)this.getUnit().getLocation() : this.getUnit()).getFullEntryLocation();
        }
        if (!this.getUnit().isOnCarrier()) {
            return null;
        }
        Unit carrier = (Unit)this.getUnit().getLocation();
        if (carrier.getSettlement() != null) {
            return carrier.getTile();
        }
        GoalDecider gd = new GoalDecider(){
            private PathNode bestTarget = null;

            public PathNode getGoal() {
                return this.bestTarget;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit unit, PathNode pathNode) {
                boolean hasOurSettlement;
                Tile newTile = pathNode.getTile();
                boolean bl = hasOurSettlement = newTile.getSettlement() != null && newTile.getSettlement().getOwner() == unit.getOwner();
                if (hasOurSettlement) {
                    this.bestTarget = pathNode;
                }
                return hasOurSettlement;
            }
        };
        PathNode path = this.getGame().getMap().search(carrier, carrier.getTile(), gd, CostDeciders.avoidSettlementsAndBlockingUnits(), Integer.MAX_VALUE);
        if (path != null) {
            return path.getLastNode().getTile();
        }
        return null;
    }

    public int getTransportPriority() {
        if (this.getTransportDestination() != null) {
            return 100;
        }
        return 0;
    }

    protected boolean unloadCargoInColony(Goods goods) {
        return AIMessage.askUnloadCargo(this.aiUnit, goods);
    }

    protected boolean sellCargoInEurope(Goods goods) {
        Player p = this.getUnit().getOwner();
        if (p.isAI() && this.getAIMain().getFreeColServer().isSingleplayer()) {
            p.modifyGold(p.getMarket().getSalePrice(goods));
        }
        return AIMessage.askSellGoods(this.aiUnit, goods);
    }

    public void dispose() {
    }

    public abstract void doMission(Connection var1);

    public boolean isValid() {
        return this.getUnit() != null && !this.getUnit().isDisposed();
    }

    public Unit getUnit() {
        return this.aiUnit.getUnit();
    }

    public AIUnit getAIUnit() {
        return this.aiUnit;
    }

    protected void setAIUnit(AIUnit aiUnit) {
        this.aiUnit = aiUnit;
    }

    public String getDebuggingInfo() {
        return "";
    }

    protected boolean unitLeavesShip(AIUnit aiUnit) {
        return AIMessage.askDisembark(aiUnit);
    }

    public boolean buyGoods(Connection connection, Unit carrier, GoodsType goodsType, int amount) {
        return AIMessage.askBuyGoods(this.aiUnit, goodsType, amount);
    }

    public PathNode findNearestColony(Unit unit) {
        Player player = unit.getOwner();
        PathNode nearestColony = null;
        int distToColony = Integer.MAX_VALUE;
        for (Colony colony : player.getColonies()) {
            PathNode path = unit.findPath(colony.getTile());
            if (path == null) continue;
            int dist = path.getTotalTurns();
            if (dist <= 1) {
                nearestColony = path;
                break;
            }
            if (dist >= distToColony) continue;
            nearestColony = path;
            distToColony = dist;
        }
        return nearestColony;
    }
}

