/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTradeItem;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.goal.ManageMissionariesGoal;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.CashInTreasureTrainMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtColonyMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.UnitWanderMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColonialAIPlayer
extends AIPlayer {
    private static final Logger logger = Logger.getLogger(ColonialAIPlayer.class.getName());
    private AIStrategy strategy = AIStrategy.NONE;
    private ArrayList<AIUnit> myAIUnits = new ArrayList();
    private ManageMissionariesGoal mGoal = new ManageMissionariesGoal(this, null, 1.0f);

    public ColonialAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player.getId());
        this.setPlayer(player);
    }

    public ColonialAIPlayer(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public ColonialAIPlayer(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    @Override
    public void startWorking() {
        logger.fine("Entering AI code for: " + this.getPlayer().toString() + ", year " + this.getGame().getTurn());
        if (this.getPlayer().isREF() || this.getPlayer().isIndian() || !this.getPlayer().isEuropean()) {
            throw new IllegalStateException("Player type not supported by this AI!");
        }
        this.strategy = AIStrategy.TRADE;
        this.clearAIUnits();
        this.manageMissionaries();
        this.mGoal.setNeedsPlanningRecursive(true);
        boolean furtherPlanning = true;
        while (furtherPlanning) {
            this.mGoal.doPlanning();
            furtherPlanning = this.mGoal.needsPlanning();
        }
        this.cheat();
        this.determineStances();
        this.rearrangeWorkersInColonies();
        this.abortInvalidAndOneTimeMissions();
        this.ensureCorrectMissions();
        this.giveNavalMissions();
        this.giveNormalMissions();
        this.createAIGoodsInColonies();
        this.createTransportLists();
        this.doMissions();
        this.rearrangeWorkersInColonies();
        this.abortInvalidMissions();
        this.giveNormalMissions();
        this.doMissions();
        this.rearrangeWorkersInColonies();
        this.abortInvalidMissions();
        this.ensureCorrectMissions();
        this.clearAIUnits();
    }

    @Override
    public Iterator<TileImprovementPlan> getTileImprovementPlanIterator() {
        ArrayList<TileImprovementPlan> tileImprovements = new ArrayList<TileImprovementPlan>();
        Iterator<AIColony> acIterator = this.getAIColonyIterator();
        while (acIterator.hasNext()) {
            AIColony ac = acIterator.next();
            Iterator<TileImprovementPlan> it = ac.getTileImprovementPlanIterator();
            while (it.hasNext()) {
                tileImprovements.add(it.next());
            }
        }
        return tileImprovements.iterator();
    }

    @Override
    public void removeTileImprovementPlan(TileImprovementPlan plan) {
        Iterator<AIColony> colonyIter = this.getAIColonyIterator();
        while (colonyIter.hasNext()) {
            AIColony colony = colonyIter.next();
            if (!colony.removeTileImprovementPlan(plan)) continue;
            return;
        }
        logger.warning("Not found given TileImprovementPlan to remove");
    }

    @Override
    public boolean hasFewColonies() {
        if (!this.getPlayer().canBuildColonies()) {
            return false;
        }
        int numberOfColonies = 0;
        int numberOfWorkers = 0;
        for (Colony colony : this.getPlayer().getColonies()) {
            ++numberOfColonies;
            numberOfWorkers += colony.getUnitCount();
        }
        boolean result = numberOfColonies <= 2 || numberOfColonies >= 3 && numberOfWorkers / numberOfColonies > numberOfColonies - 2;
        logger.finest("hasFewColonies = " + result);
        return result;
    }

    @Override
    public Iterator<Wish> getWishIterator() {
        ArrayList<Wish> wishList = new ArrayList<Wish>();
        Iterator<AIColony> ai = this.getAIColonyIterator();
        while (ai.hasNext()) {
            AIColony ac = ai.next();
            Iterator<Wish> wishIterator = ac.getWishIterator();
            while (wishIterator.hasNext()) {
                Wish w = wishIterator.next();
                wishList.add(w);
            }
        }
        Collections.sort(wishList);
        return wishList.iterator();
    }

    @Override
    public FoundingFather selectFoundingFather(List<FoundingFather> foundingFathers) {
        int age = this.getGame().getTurn().getAge();
        FoundingFather bestFather = null;
        int bestWeight = -1;
        for (FoundingFather father : foundingFathers) {
            int weight;
            if (father == null || (weight = father.getWeight(age)) <= bestWeight) continue;
            bestWeight = weight;
            bestFather = father;
        }
        return bestFather;
    }

    @Override
    public boolean acceptTax(int tax) {
        Goods toBeDestroyed = this.getPlayer().getMostValuableGoods();
        if (toBeDestroyed == null) {
            return false;
        }
        GoodsType goodsType = toBeDestroyed.getType();
        if (goodsType.isFoodType() || goodsType.isBreedable()) {
            return false;
        }
        if (goodsType.isMilitaryGoods() || goodsType.isTradeGoods() || goodsType.isBuildingMaterial()) {
            return this.getGame().getTurn().getAge() != 3;
        }
        int averageIncome = 0;
        int numberOfGoods = 0;
        List<GoodsType> goodsTypes = this.getGame().getSpecification().getGoodsTypeList();
        for (GoodsType type : goodsTypes) {
            if (!type.isStorable()) continue;
            averageIncome += this.getPlayer().getIncomeAfterTaxes(type);
            ++numberOfGoods;
        }
        return this.getPlayer().getIncomeAfterTaxes(toBeDestroyed.getType()) <= (averageIncome /= numberOfGoods);
    }

    @Override
    public boolean acceptIndianDemand(Unit unit, Colony colony, Goods goods, int gold) {
        return this.strategy != AIStrategy.CONQUEST;
    }

    @Override
    public boolean acceptMercenaryOffer() {
        return this.strategy == AIStrategy.CONQUEST || this.getPlayer().isAtWar();
    }

    @Override
    public boolean acceptDiplomaticTrade(DiplomaticTrade agreement) {
        Enum stance = null;
        int value = 0;
        Iterator<TradeItem> itemIterator = agreement.iterator();
        while (itemIterator.hasNext()) {
            TradeItem item = itemIterator.next();
            if (item instanceof GoldTradeItem) {
                int gold = ((GoldTradeItem)item).getGold();
                if (item.getSource() == this.getPlayer()) {
                    value -= gold;
                    continue;
                }
                value += gold;
                continue;
            }
            if (item instanceof StanceTradeItem) {
                stance = ((StanceTradeItem)item).getStance();
                continue;
            }
            if (item instanceof ColonyTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    value = Integer.MIN_VALUE;
                    break;
                }
                value += 1000;
                continue;
            }
            if (item instanceof UnitTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    value = Integer.MIN_VALUE;
                    break;
                }
                value += 100;
                continue;
            }
            if (!(item instanceof GoodsTradeItem)) continue;
            Goods goods = ((GoodsTradeItem)item).getGoods();
            if (item.getSource() == this.getPlayer()) {
                value -= this.getPlayer().getMarket().getBidPrice(goods.getType(), goods.getAmount());
                continue;
            }
            value += this.getPlayer().getMarket().getSalePrice(goods.getType(), goods.getAmount());
        }
        boolean accept = false;
        switch (4.$SwitchMap$net$sf$freecol$common$model$Player$Stance[stance.ordinal()]) {
            case 1: {
                accept = false;
                break;
            }
            case 2: {
                accept = value >= 0;
                break;
            }
            case 3: {
                accept = value >= 500;
                break;
            }
            case 4: {
                if (agreement.getSender().hasAbility("model.ability.alwaysOfferedPeace") && value >= 0) {
                    accept = true;
                    break;
                }
                if (value < 1000) break;
                accept = true;
                break;
            }
            case 5: {
                accept = value >= 2000;
            }
        }
        logger.info("Trade value is " + value + ", accept is " + accept);
        return accept;
    }

    @Override
    public void registerSellGoods(Goods goods) {
        logger.warning("registerSellGoods() not implemented for ColonialAIPlayer!");
    }

    @Override
    public int buyProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.warning("buyProposition() not implemented for ColonialAIPlayer!");
        return -1;
    }

    @Override
    public int sellProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method sellProposition");
        if (settlement instanceof Colony) {
            Colony colony = (Colony)settlement;
            Player otherPlayer = unit.getOwner();
            if (this.getPlayer().atWarWith(otherPlayer)) {
                return -1;
            }
            int amount = colony.getWarehouseCapacity() - colony.getGoodsCount(goods.getType());
            amount = Math.min(amount, goods.getAmount());
            Tension.Level tensionLevel = this.getPlayer().getTension(otherPlayer).getLevel();
            int percentage = (9 - tensionLevel.ordinal()) * 10;
            int netProfits = (100 - this.getPlayer().getTax()) * this.getPlayer().getMarket().getSalePrice(goods.getType(), amount) / 100;
            int price = netProfits * percentage / 100;
            return price;
        }
        logger.warning("ColonialAIPlayer shouldn't have indian settlement!");
        return -1;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(ColonialAIPlayer.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setPlayer((ServerPlayer)this.getAIMain().getFreeColGameObject(in.getAttributeValue(null, "ID")));
        in.nextTag();
    }

    private void cheat() {
        logger.finest("Entering method cheat");
        for (GoodsType goodsType : this.getGame().getSpecification().getGoodsTypeList()) {
            this.getPlayer().getMarket().setArrears(goodsType, 0);
        }
        if (this.getAIMain().getFreeColServer().isSingleplayer() && this.getPlayer().isAI() && this.getPlayer().getPlayerType() == Player.PlayerType.COLONIAL) {
            Europe europe = this.getPlayer().getEurope();
            List<UnitType> unitTypes = this.getGame().getSpecification().getUnitTypeList();
            if (this.getAIRandom().nextInt(10) == 1) {
                int price = 0;
                UnitType unitToTrain = null;
                for (UnitType unitType : unitTypes) {
                    if (!unitType.hasPrice()) continue;
                    int unitPrice = europe.getUnitPrice(unitType);
                    if (unitToTrain != null && unitPrice >= price) continue;
                    unitToTrain = unitType;
                    price = unitPrice;
                }
                Unit unit = null;
                if (unitToTrain != null) {
                    this.getPlayer().modifyGold(price);
                    unit = this.trainAIUnitInEurope(unitToTrain).getUnit();
                }
                if (unit != null && unit.isColonist()) {
                    Specification spec = this.getGame().getSpecification();
                    GoodsType muskets = spec.getGoodsType("model.goods.muskets");
                    GoodsType horses = spec.getGoodsType("model.goods.horses");
                    this.getPlayer().modifyGold(this.getPlayer().getMarket().getBidPrice(muskets, 50));
                    this.getPlayer().modifyGold(this.getPlayer().getMarket().getBidPrice(horses, 50));
                    AIMessage.askClearSpeciality(this.getAIUnit(unit));
                    AIMessage.askEquipUnit(this.getAIUnit(unit), spec.getEquipmentType("model.equipment.horses"), 1);
                    AIMessage.askEquipUnit(this.getAIUnit(unit), spec.getEquipmentType("model.equipment.muskets"), 1);
                }
            }
            if (this.getAIRandom().nextInt(40) == 21) {
                int total = 0;
                ArrayList<UnitType> navalUnits = new ArrayList<UnitType>();
                for (UnitType unitType : unitTypes) {
                    if (!unitType.hasAbility("model.ability.navalUnit") || !unitType.hasPrice()) continue;
                    navalUnits.add(unitType);
                    total += europe.getUnitPrice(unitType);
                }
                UnitType unitToPurchase = null;
                int random = this.getAIRandom().nextInt(total);
                total = 0;
                for (UnitType unitType : navalUnits) {
                    if (random >= (total += unitType.getPrice())) continue;
                    unitToPurchase = unitType;
                    break;
                }
                this.getPlayer().modifyGold(europe.getUnitPrice(unitToPurchase));
                this.trainAIUnitInEurope(unitToPurchase);
            }
        }
    }

    private void ensureCorrectMissions() {
        logger.finest("Entering method ensureCorrectMissions");
        Iterator<AIUnit> it = this.getAIUnitIterator();
        while (it.hasNext()) {
            AIUnit au = it.next();
            if (au.hasMission() || !(au.getUnit().getLocation() instanceof ColonyTile) && !(au.getUnit().getLocation() instanceof Building)) continue;
            AIColony ac = this.getAIColony(au.getUnit().getColony());
            au.setMission(new WorkInsideColonyMission(this.getAIMain(), au, ac));
        }
    }

    private void determineStances() {
        logger.finest("Entering method determineStances");
        Player player = this.getPlayer();
        for (Player p : this.getGame().getPlayers()) {
            if (p == player || p.isDead()) continue;
            this.determineStance(p);
        }
    }

    private void abortInvalidMissions() {
        logger.finest("Entering method abortInvalidMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.getMission() == null || aiUnit.getMission().isValid()) continue;
            aiUnit.setMission(null);
        }
    }

    private void abortInvalidAndOneTimeMissions() {
        logger.finest("Entering method abortInvalidAndOneTimeMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.getMission() == null || aiUnit.getMission().isValid() && !(aiUnit.getMission() instanceof UnitWanderHostileMission) && !(aiUnit.getMission() instanceof UnitWanderMission) && !(aiUnit.getMission() instanceof IdleAtColonyMission)) continue;
            aiUnit.setMission(null);
        }
    }

    private void giveNavalMissions() {
        logger.finest("Entering method giveNavalMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            Unit unit = aiUnit.getUnit();
            if (aiUnit.hasMission() || !unit.isNaval()) continue;
            if (PrivateerMission.isValid(aiUnit)) {
                aiUnit.setMission(new PrivateerMission(this.getAIMain(), aiUnit));
                continue;
            }
            aiUnit.setMission(new TransportMission(this.getAIMain(), aiUnit));
        }
    }

    private void rearrangeWorkersInColonies() {
        logger.finest("Entering method rearrangeWorkersInColonies");
        Iterator<AIColony> ci = this.getAIColonyIterator();
        while (ci.hasNext()) {
            AIColony c = ci.next();
            ArrayList<Tile> oldWorkTiles = new ArrayList<Tile>();
            for (ColonyTile colonyTile : c.getColony().getColonyTiles()) {
                if (colonyTile.getUnit() == null) continue;
                oldWorkTiles.add(colonyTile.getWorkTile());
            }
            c.rearrangeWorkers(this.getConnection());
        }
    }

    private void giveNormalMissions() {
        logger.finest("Entering method giveNormalMissions");
        HashMap<UnitType, ArrayList<Wish>> workerWishes = new HashMap<UnitType, ArrayList<Wish>>();
        Iterator<AIColony> aIterator = this.getAIColonyIterator();
        while (aIterator.hasNext()) {
            Iterator<Wish> wIterator = aIterator.next().getWishIterator();
            while (wIterator.hasNext()) {
                Wish w = wIterator.next();
                if (!(w instanceof WorkerWish) || w.getTransportable() != null) continue;
                UnitType unitType = ((WorkerWish)w).getUnitType();
                ArrayList<Wish> wishes = (ArrayList<Wish>)workerWishes.get(unitType);
                if (wishes == null) {
                    wishes = new ArrayList<Wish>();
                    workerWishes.put(unitType, wishes);
                }
                wishes.add(w);
            }
        }
        boolean fewColonies = this.hasFewColonies();
        boolean isPioneerReq = PioneeringMission.getPlayerPioneers(this).size() == 0;
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            boolean isExpert;
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.hasMission()) continue;
            Unit unit = aiUnit.getUnit();
            if (unit.isUninitialized()) {
                logger.warning("Trying to assign a mission to an uninitialized object: " + unit.getId());
                continue;
            }
            boolean isPioneer = unit.hasAbility("model.ability.improveTerrain") || unit.hasAbility("model.ability.expertPioneer");
            boolean bl = isExpert = unit.getSkillLevel() > 0;
            if ((isPioneer || isPioneerReq && !isExpert) && PioneeringMission.isValid(aiUnit)) {
                aiUnit.setMission(new PioneeringMission(this.getAIMain(), aiUnit));
                isPioneerReq = false;
                continue;
            }
            if (unit.canCarryTreasure()) {
                aiUnit.setMission(new CashInTreasureTrainMission(this.getAIMain(), aiUnit));
            } else if (unit.hasAbility("model.ability.scoutIndianSettlement") && ScoutingMission.isValid(aiUnit)) {
                aiUnit.setMission(new ScoutingMission(this.getAIMain(), aiUnit));
            } else if ((unit.isOffensiveUnit() || unit.isDefensiveUnit()) && (!unit.isColonist() || unit.hasAbility("model.ability.expertSoldier") || this.getGame().getTurn().getNumber() > 5)) {
                this.giveMilitaryMission(aiUnit);
            } else if (unit.isColonist()) {
                HashMap<Location, Integer> distances = new HashMap<Location, Integer>(121);
                for (ArrayList al : workerWishes.values()) {
                    for (Wish w : al) {
                        if (distances.containsKey(w.getDestination())) continue;
                        distances.put(w.getDestination(), unit.getTurnsToReach(w.getDestination()));
                    }
                }
                ArrayList wishList = (ArrayList)workerWishes.get(unit.getType());
                Wish bestWish = null;
                int bestTurns = Integer.MAX_VALUE;
                for (int i = 0; i < wishList.size(); ++i) {
                    WorkerWish ww = (WorkerWish)wishList.get(i);
                    if (ww.getTransportable() != null) {
                        wishList.remove(i);
                        --i;
                        continue;
                    }
                    int turns = (Integer)distances.get(ww.getDestination());
                    if (turns == Integer.MAX_VALUE) {
                        turns = ww.getDestination().getTile() == null ? 5 : 10;
                    } else if (turns > 5) {
                        turns = 5;
                    }
                    if (bestWish != null && ww.getValue() - turns * 2 <= bestWish.getValue() - bestTurns * 2) continue;
                    bestWish = ww;
                    bestTurns = turns;
                }
                if (bestWish != null) {
                    bestWish.setTransportable(aiUnit);
                    aiUnit.setMission(new WishRealizationMission(this.getAIMain(), aiUnit, bestWish));
                    continue;
                }
                Tile colonyTile = null;
                if (this.getPlayer().canBuildColonies()) {
                    colonyTile = BuildColonyMission.findColonyLocation(aiUnit.getUnit());
                }
                if (colonyTile != null) {
                    bestTurns = unit.getTurnsToReach(colonyTile);
                }
                if (!fewColonies || colonyTile == null || bestTurns > 10) {
                    for (int i = 0; i < workerWishes.size(); ++i) {
                        wishList = (ArrayList)workerWishes.get(i);
                        for (int j = 0; j < wishList.size(); ++j) {
                            WorkerWish ww = (WorkerWish)wishList.get(j);
                            if (ww.getTransportable() != null) {
                                wishList.remove(j);
                                --j;
                                continue;
                            }
                            int turns = (Integer)distances.get(ww.getDestination());
                            if (turns == Integer.MAX_VALUE) {
                                turns = ww.getDestination().getTile() == null ? 5 : 10;
                            } else if (turns > 5) {
                                turns = 5;
                            }
                            if (bestWish != null && ww.getValue() - turns * 2 <= bestWish.getValue() - bestTurns * 2) continue;
                            bestWish = ww;
                            bestTurns = turns;
                        }
                    }
                }
                if (bestWish != null) {
                    bestWish.setTransportable(aiUnit);
                    aiUnit.setMission(new WishRealizationMission(this.getAIMain(), aiUnit, bestWish));
                    continue;
                }
                if (colonyTile != null) {
                    BuildColonyMission mission = new BuildColonyMission(this.getAIMain(), aiUnit, colonyTile, this.getPlayer().getColonyValue(colonyTile));
                    aiUnit.setMission(mission);
                    boolean isUnitOnCarrier = aiUnit.getUnit().isOnCarrier();
                    if (!isUnitOnCarrier) continue;
                    AIUnit carrier = this.getAIUnit((Unit)aiUnit.getUnit().getLocation());
                    Mission carrierMission = carrier.getMission();
                    boolean isCarrierMissionToTransport = carrierMission instanceof TransportMission;
                    if (!isCarrierMissionToTransport) {
                        throw new IllegalStateException("Carrier carrying unit not on a transport mission");
                    }
                    ((TransportMission)carrierMission).addToTransportList(aiUnit);
                    continue;
                }
            }
            if (aiUnit.hasMission()) continue;
            if (aiUnit.getUnit().isOffensiveUnit()) {
                aiUnit.setMission(new UnitWanderHostileMission(this.getAIMain(), aiUnit));
                continue;
            }
            aiUnit.setMission(new IdleAtColonyMission(this.getAIMain(), aiUnit));
        }
    }

    private void createAIGoodsInColonies() {
        logger.finest("Entering method createAIGoodsInColonies");
        Iterator<AIColony> ci = this.getAIColonyIterator();
        while (ci.hasNext()) {
            AIColony c = ci.next();
            c.createAIGoods();
        }
    }

    private void doMissions() {
        logger.finest("Entering method doMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (!aiUnit.hasMission() || !aiUnit.getMission().isValid() || aiUnit.getUnit().isOnCarrier()) continue;
            try {
                aiUnit.doMission(this.getConnection());
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                logger.warning(sw.toString());
            }
        }
    }

    int getDefendColonyMissionValue(Unit u, Colony colony, int turns) {
        logger.finest("Entering method getDefendColonyMissionValue");
        if (colony == null) {
            return Integer.MIN_VALUE;
        }
        int value = 10025 - turns;
        int numberOfDefendingUnits = 0;
        Iterator<AIUnit> aui = this.getAIUnitIterator();
        while (aui.hasNext()) {
            Mission m = aui.next().getMission();
            if (m == null || !(m instanceof DefendSettlementMission) || ((DefendSettlementMission)m).getSettlement() != colony) continue;
            value -= 6;
            ++numberOfDefendingUnits;
        }
        if (u.getOwner().isREF()) {
            value -= 19;
            if (numberOfDefendingUnits > 0) {
                return 0;
            }
        }
        if (colony.getStockade() != null && numberOfDefendingUnits > colony.getStockade().getLevel() + 1) {
            return Math.max(0, value - 9000);
        }
        return value;
    }

    int getUnitSeekAndDestroyMissionValue(Unit unit, Tile newTile, int turns) {
        logger.finest("Entering method getUnitSeekAndDestroyMissionValue");
        Unit defender = newTile.getDefendingUnit(unit);
        if (!this.isTargetValidForSeekAndDestroy(unit, defender)) {
            return Integer.MIN_VALUE;
        }
        int value = 10020;
        CombatModel combatModel = unit.getGame().getCombatModel();
        if (this.getBestTreasureTrain(newTile) != null) {
            value += Math.min(this.getBestTreasureTrain(newTile).getTreasureAmount() / 10, 50);
        }
        if (defender.getType().getOffence() > 0 && newTile.getSettlement() == null) {
            value = (int)((float)value + (200.0f - combatModel.getDefencePower(unit, defender) * 2.0f - (float)(turns * 50)));
        }
        value = (int)((float)value + (combatModel.getOffencePower(defender, unit) - combatModel.getDefencePower(defender, unit)));
        value -= turns * 10;
        if (!defender.isNaval()) {
            if (defender.hasAbility("model.ability.expertSoldier") && !defender.isArmed()) {
                value = (int)((float)value + (10.0f - combatModel.getDefencePower(unit, defender) * 2.0f - (float)(turns * 25)));
            }
            if (newTile.getSettlement() != null) {
                value += 300;
                Iterator<Unit> dp = newTile.getUnitIterator();
                while (dp.hasNext()) {
                    Unit u = dp.next();
                    if (!u.isDefensiveUnit()) continue;
                    if (combatModel.getDefencePower(unit, u) > combatModel.getOffencePower(unit, u)) {
                        value = (int)((float)value - 100.0f * (combatModel.getDefencePower(unit, u) - combatModel.getOffencePower(unit, u)));
                        continue;
                    }
                    value = (int)((float)value - combatModel.getDefencePower(unit, u));
                }
            }
        }
        return Math.max(0, value);
    }

    boolean isTargetValidForSeekAndDestroy(Unit attacker, Unit defender) {
        Player defenderPlayer;
        if (attacker.getOwner() != this.getPlayer()) {
            logger.warning("isTargetValidForSeekAndDestroy() called for other players unit!");
            return false;
        }
        if (defender == null) {
            return false;
        }
        if (attacker.isNaval() != defender.isNaval()) {
            return false;
        }
        if (attacker.isNaval() && (attacker.getTile() == null || attacker.getTile().isLand() || defender.getTile() == null || defender.getTile().isLand())) {
            return false;
        }
        Player attackerPlayer = attacker.getOwner();
        if (attackerPlayer == (defenderPlayer = defender.getOwner())) {
            return false;
        }
        return attackerPlayer.atWarWith(defenderPlayer);
    }

    void giveMilitaryMission(AIUnit aiUnit) {
        Tile targetTile;
        int value;
        GoalDecider targetDecider;
        PathNode newTarget;
        int value2;
        PathNode ln;
        int value3;
        logger.finest("Entering method giveMilitaryMission");
        final Unit unit = aiUnit.getUnit();
        Unit carrier = unit.isOnCarrier() ? (Unit)unit.getLocation() : null;
        Map map = unit.getGame().getMap();
        Ownable bestTarget = null;
        int bestValue = Integer.MIN_VALUE;
        Tile startTile = unit.getTile();
        if (startTile == null && (startTile = (unit.isOnCarrier() ? (Unit)unit.getLocation() : unit).getFullEntryLocation()) == null) {
            logger.warning("Unable to determine entry location for: " + unit.toString());
            return;
        }
        if (unit.getColony() != null) {
            bestTarget = unit.getColony();
            bestValue = this.getDefendColonyMissionValue(unit, (Colony)bestTarget, 0);
        }
        GoalDecider gd = new GoalDecider(){
            private PathNode best = null;
            private int bestValue = Integer.MIN_VALUE;

            public PathNode getGoal() {
                return this.best;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode pathNode) {
                Tile t = pathNode.getTile();
                if (t.getColony() != null && t.getColony().getOwner() == u.getOwner()) {
                    int value = ColonialAIPlayer.this.getDefendColonyMissionValue(unit, t.getColony(), pathNode.getTurns());
                    if (value > 0 && value > this.bestValue) {
                        this.bestValue = value;
                        this.best = pathNode;
                    }
                    return true;
                }
                return false;
            }
        };
        int MAXIMUM_DISTANCE_TO_SETTLEMENT = 10;
        PathNode bestPath = map.search(unit, startTile, gd, 10, carrier);
        if (bestPath != null && (value3 = this.getDefendColonyMissionValue(unit, (ln = bestPath.getLastNode()).getTile().getColony(), ln.getTurns())) > bestValue) {
            bestTarget = ln.getTile().getColony();
            bestValue = value3;
        }
        Location bestExistingTarget = null;
        int smallestDifference = Integer.MAX_VALUE;
        Iterator<AIUnit> aui = this.getAIUnitIterator();
        while (aui.hasNext() && smallestDifference > 0) {
            int difference;
            AIUnit coAIUnit = aui.next();
            Unit coUnit = coAIUnit.getUnit();
            if (coUnit.getTile() == null || !(coAIUnit.getMission() instanceof UnitSeekAndDestroyMission)) continue;
            Location target = ((UnitSeekAndDestroyMission)coAIUnit.getMission()).getTarget();
            int ourDistance = unit.getTurnsToReach(startTile, target.getTile());
            int coUnitDistance = coUnit.getTurnsToReach(target.getTile());
            if (ourDistance == Integer.MAX_VALUE || (difference = Math.abs(ourDistance - coUnitDistance)) >= smallestDifference) continue;
            smallestDifference = difference;
            bestExistingTarget = target;
        }
        if (bestExistingTarget != null && (value2 = this.getUnitSeekAndDestroyMissionValue(unit, bestExistingTarget.getTile(), smallestDifference)) > bestValue) {
            bestValue = value2;
            bestTarget = (Ownable)((Object)bestExistingTarget);
        }
        if ((newTarget = map.search(unit, startTile, targetDecider = new GoalDecider(){
            private PathNode bestTarget = null;
            private int bestNewTargetValue = Integer.MIN_VALUE;

            public PathNode getGoal() {
                return this.bestTarget;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode pathNode) {
                int value;
                Tile newTile = pathNode.getTile();
                Unit defender = newTile.getDefendingUnit(unit);
                if (ColonialAIPlayer.this.isTargetValidForSeekAndDestroy(unit, defender) && (value = ColonialAIPlayer.this.getUnitSeekAndDestroyMissionValue(unit, pathNode.getTile(), pathNode.getTurns())) > this.bestNewTargetValue) {
                    this.bestTarget = pathNode;
                    this.bestNewTargetValue = value;
                    return true;
                }
                return false;
            }
        }, Integer.MAX_VALUE, carrier)) != null && (value = this.getUnitSeekAndDestroyMissionValue(unit, targetTile = newTarget.getLastNode().getTile(), newTarget.getTotalTurns())) > bestValue) {
            bestValue = value;
            bestTarget = targetTile.getSettlement() != null ? targetTile.getSettlement() : (this.getBestTreasureTrain(targetTile) != null ? this.getBestTreasureTrain(targetTile) : targetTile.getDefendingUnit(unit));
        }
        if (bestTarget != null && bestValue > 0) {
            if (bestTarget.getOwner() == unit.getOwner()) {
                aiUnit.setMission(new DefendSettlementMission(this.getAIMain(), aiUnit, (Settlement)bestTarget));
            } else {
                aiUnit.setMission(new UnitSeekAndDestroyMission(this.getAIMain(), aiUnit, (Location)((Object)bestTarget)));
            }
        } else {
            aiUnit.setMission(new UnitWanderHostileMission(this.getAIMain(), aiUnit));
        }
    }

    private void createTransportLists() {
        logger.finest("Entering method createTransportLists");
        ArrayList<AIObject> transportables = new ArrayList<AIObject>();
        Iterator<AIUnit> aui = this.getAIUnitIterator();
        while (aui.hasNext()) {
            AIUnit au = aui.next();
            if (au.getUnit().isNaval() || au.getTransportDestination() == null || au.getTransport() != null) continue;
            transportables.add(au);
        }
        Iterator<AIColony> aci = this.getAIColonyIterator();
        while (aci.hasNext()) {
            AIColony ac = aci.next();
            Iterator<AIGoods> iterator = ac.getAIGoodsIterator();
            while (iterator.hasNext()) {
                AIGoods ag = iterator.next();
                if (ag.getTransportDestination() == null || ag.getTransport() != null) continue;
                transportables.add(ag);
            }
        }
        if (transportables.isEmpty()) {
            return;
        }
        for (Transportable transportable : transportables) {
            transportable.increaseTransportPriority();
        }
        ArrayList<Mission> vacantTransports = new ArrayList<Mission>();
        Iterator<AIUnit> iterator = this.getAIUnitIterator();
        while (iterator.hasNext()) {
            AIUnit au = iterator.next();
            if (!au.hasMission() || !(au.getMission() instanceof TransportMission) || au.getUnit().getLocation() instanceof Europe) continue;
            vacantTransports.add(au.getMission());
        }
        if (vacantTransports.isEmpty()) {
            return;
        }
        Collections.sort(transportables, new Comparator<Transportable>(){

            @Override
            public int compare(Transportable o1, Transportable o2) {
                if (o1 == o2) {
                    return 0;
                }
                int result = o2.getTransportPriority() - o1.getTransportPriority();
                if (result == 0) {
                    result = o1.getId().compareTo(o2.getId());
                }
                return result;
            }
        });
        ArrayList iteratingList = new ArrayList(transportables);
        for (Transportable t : iteratingList) {
            Location transportableLoc = t.getTransportLocatable().getLocation();
            boolean isTransportableAlreadyOnCarrier = transportableLoc instanceof Unit;
            if (!isTransportableAlreadyOnCarrier) continue;
            AIUnit carrierAI = this.getAIUnit((Unit)transportableLoc);
            Mission m = carrierAI.getMission();
            if (m instanceof TransportMission) {
                ((TransportMission)m).addToTransportList(t);
            }
            transportables.remove(t);
        }
        while (transportables.size() > 0) {
            int i;
            Transportable t = (Transportable)transportables.get(0);
            TransportMission bestTransport = null;
            int bestTransportSpace = 0;
            int bestTransportTurns = Integer.MAX_VALUE;
            for (i = 0; i < vacantTransports.size(); ++i) {
                int transportSpace;
                TransportMission tm = (TransportMission)vacantTransports.get(i);
                if (t.getTransportSource().getTile() == tm.getUnit().getLocation().getTile()) {
                    int transportSpace2 = tm.getAvailableSpace(t);
                    if (transportSpace2 <= 0) continue;
                    bestTransport = tm;
                    bestTransportSpace = transportSpace2;
                    bestTransportTurns = 0;
                    break;
                }
                PathNode path = tm.getPath(t);
                if (path == null || path.getTotalTurns() > bestTransportTurns || (transportSpace = tm.getAvailableSpace(t)) <= 0 || path.getTotalTurns() >= bestTransportTurns && transportSpace <= bestTransportSpace) continue;
                bestTransport = tm;
                bestTransportSpace = transportSpace;
                bestTransportTurns = path.getTotalTurns();
            }
            if (bestTransport == null) break;
            bestTransport.addToTransportList(t);
            transportables.remove(t);
            vacantTransports.remove(bestTransport);
            --bestTransportSpace;
            for (i = 0; i < transportables.size() && bestTransportSpace > 0; ++i) {
                Transportable t2 = (Transportable)transportables.get(0);
                if (t2.getTransportLocatable().getLocation() != t.getTransportLocatable().getLocation()) continue;
                bestTransport.addToTransportList(t2);
                transportables.remove(t2);
                --bestTransportSpace;
            }
        }
    }

    private Unit getBestTreasureTrain(Tile tile) {
        Unit bestTreasureTrain = null;
        for (Unit unit : tile.getUnitList()) {
            if (!unit.canCarryTreasure() || bestTreasureTrain != null && bestTreasureTrain.getTreasureAmount() >= unit.getTreasureAmount()) continue;
            bestTreasureTrain = unit;
        }
        return bestTreasureTrain;
    }

    private void manageMissionaries() {
        Iterator<AIUnit> it = this.getAIUnitIterator();
        while (it.hasNext()) {
            AIUnit au = it.next();
            Unit u = au.getUnit();
            if (u.getRole() != Unit.Role.MISSIONARY) continue;
            logger.info("Found missionary unit:" + u.getId());
            this.mGoal.addUnit(au);
            it.remove();
        }
    }

    @Override
    protected Iterator<AIUnit> getAIUnitIterator() {
        logger.info("Override: getAIUnitIterator()!");
        if (this.myAIUnits.size() == 0) {
            ArrayList<AIUnit> au = new ArrayList<AIUnit>();
            Iterator<Unit> unitsIterator = this.getPlayer().getUnitIterator();
            while (unitsIterator.hasNext()) {
                Unit theUnit = unitsIterator.next();
                AIUnit a = this.getAIUnit(theUnit);
                if (a != null) {
                    if (a.getGoal() != null) continue;
                    au.add(a);
                    continue;
                }
                logger.warning("Could not find the AIUnit for: " + theUnit + " (" + theUnit.getId() + ") - " + (this.getGame().getFreeColGameObject(theUnit.getId()) != null));
            }
            this.myAIUnits = au;
        }
        return this.myAIUnits.iterator();
    }

    @Override
    protected void clearAIUnits() {
        logger.info("Override: clearAIUnits()!");
        this.myAIUnits.clear();
    }

    public static String getXMLElementTagName() {
        return "colonialAIPlayer";
    }

    static class 4 {
        static final /* synthetic */ int[] $SwitchMap$net$sf$freecol$common$model$Player$Stance;

        static {
            $SwitchMap$net$sf$freecol$common$model$Player$Stance = new int[Player.Stance.values().length];
            try {
                4.$SwitchMap$net$sf$freecol$common$model$Player$Stance[Player.Stance.UNCONTACTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$net$sf$freecol$common$model$Player$Stance[Player.Stance.WAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$net$sf$freecol$common$model$Player$Stance[Player.Stance.CEASE_FIRE.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$net$sf$freecol$common$model$Player$Stance[Player.Stance.PEACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$net$sf$freecol$common$model$Player$Stance[Player.Stance.ALLIANCE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AIStrategy {
        NONE,
        TRADE,
        IMMIGRATION,
        COOPERATION,
        CONQUEST;

    }
}

