/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.util.XMLStream;
import net.sf.freecol.server.ai.AIInGameInputHandler;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.control.Controller;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.control.InGameInputHandler;
import net.sf.freecol.server.control.PreGameController;
import net.sf.freecol.server.control.PreGameInputHandler;
import net.sf.freecol.server.control.UserConnectionHandler;
import net.sf.freecol.server.generator.MapGenerator;
import net.sf.freecol.server.generator.SimpleMapGenerator;
import net.sf.freecol.server.generator.TerrainGenerator;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.DummyConnection;
import net.sf.freecol.server.networking.Server;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FreeColServer {
    private static final Logger logger = Logger.getLogger(FreeColServer.class.getName());
    private static final int META_SERVER_UPDATE_INTERVAL = 60000;
    private static final int NUMBER_OF_HIGH_SCORES = 10;
    private static final String HIGH_SCORE_FILE = "HighScores.xml";
    public static final int SAVEGAME_VERSION = 11;
    public static final int MINIMUM_SAVEGAME_VERSION = 1;
    private GameState gameState = GameState.STARTING_GAME;
    private Server server;
    private final UserConnectionHandler userConnectionHandler;
    private final PreGameController preGameController;
    private final PreGameInputHandler preGameInputHandler;
    private final InGameInputHandler inGameInputHandler;
    private final InGameController inGameController;
    private ServerGame game;
    private AIMain aiMain;
    private MapGenerator mapGenerator;
    private boolean singleplayer;
    private String owner;
    private boolean publicServer = false;
    private final int port;
    private String name;
    private Random random = null;
    private boolean integrity = false;
    private Unit activeUnit = null;
    private List<HighScore> highScores = null;
    public static final Comparator<HighScore> highScoreComparator = new Comparator<HighScore>(){

        @Override
        public int compare(HighScore score1, HighScore score2) {
            return score2.getScore() - score1.getScore();
        }
    };
    private static final String HEX_DIGITS = "0123456789ABCDEF";

    public FreeColServer(Specification specification, boolean publicServer, boolean singleplayer, int port, String name) throws IOException, NoRouteToServerException {
        this(specification, publicServer, singleplayer, port, name, NationOptions.Advantages.SELECTABLE);
    }

    public FreeColServer(Specification specification, boolean publicServer, boolean singleplayer, int port, String name, NationOptions.Advantages advantages) throws IOException, NoRouteToServerException {
        this.publicServer = publicServer;
        this.singleplayer = singleplayer;
        this.port = port;
        this.name = name;
        this.random = new Random(FreeCol.getFreeColSeed());
        this.userConnectionHandler = new UserConnectionHandler(this);
        this.preGameController = new PreGameController(this);
        this.preGameInputHandler = new PreGameInputHandler(this);
        this.inGameInputHandler = new InGameInputHandler(this);
        this.inGameController = new InGameController(this, this.random);
        this.game = new ServerGame(specification);
        this.game.setNationOptions(new NationOptions(specification, advantages));
        this.mapGenerator = new SimpleMapGenerator(this.random, specification);
        try {
            this.server = new Server(this, port);
            this.server.start();
        }
        catch (IOException e) {
            logger.warning("Exception while starting server: " + e);
            throw e;
        }
        this.updateMetaServer(true);
        this.startMetaServerUpdateThread();
    }

    public FreeColServer(FreeColSavegameFile savegame, int port, String name) throws IOException, FreeColException, NoRouteToServerException {
        this(savegame, port, name, null);
    }

    public FreeColServer(FreeColSavegameFile savegame, int port, String name, Specification specification) throws IOException, FreeColException, NoRouteToServerException {
        this.port = port;
        this.name = name;
        this.mapGenerator = null;
        this.userConnectionHandler = new UserConnectionHandler(this);
        this.preGameController = new PreGameController(this);
        this.preGameInputHandler = new PreGameInputHandler(this);
        this.inGameInputHandler = new InGameInputHandler(this);
        try {
            this.server = new Server(this, port);
            this.server.start();
        }
        catch (IOException e) {
            logger.warning("Exception while starting server: " + e);
            throw e;
        }
        try {
            this.owner = this.loadGame(savegame, specification);
        }
        catch (FreeColException e) {
            this.server.shutdown();
            throw e;
        }
        catch (Exception e) {
            this.server.shutdown();
            FreeColException fe = new FreeColException("couldNotLoadGame");
            fe.initCause(e);
            throw fe;
        }
        if (this.random == null) {
            this.random = new Random(FreeCol.getFreeColSeed());
        }
        this.inGameController = new InGameController(this, this.random);
        this.mapGenerator = new SimpleMapGenerator(this.random, this.getSpecification());
        this.updateMetaServer(true);
        this.startMetaServerUpdateThread();
    }

    public Specification getSpecification() {
        return this.game.getSpecification();
    }

    public void startMetaServerUpdateThread() {
        if (!this.publicServer) {
            return;
        }
        Timer t = new Timer(true);
        t.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                try {
                    FreeColServer.this.updateMetaServer();
                }
                catch (NoRouteToServerException noRouteToServerException) {
                    // empty catch block
                }
            }
        }, 60000L, 60000L);
    }

    public MapGenerator getMapGenerator() {
        return this.mapGenerator;
    }

    public void setMapGenerator(MapGenerator mapGenerator) {
        this.mapGenerator = mapGenerator;
    }

    public void updateMetaServer() throws NoRouteToServerException {
        this.updateMetaServer(false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetaServer(boolean firstTime) throws NoRouteToServerException {
        Connection mc;
        if (!this.publicServer) {
            return;
        }
        try {
            mc = new Connection("meta.freecol.org", 3540, null, "FreeColServer:");
        }
        catch (IOException e) {
            logger.warning("Could not connect to meta-server.");
            return;
        }
        try {
            Element element = firstTime ? DOMMessage.createNewRootElement("register") : DOMMessage.createNewRootElement("update");
            if (this.name != null) {
                element.setAttribute("name", this.name);
            } else {
                element.setAttribute("name", mc.getSocket().getLocalAddress().getHostAddress() + ":" + Integer.toString(this.port));
            }
            element.setAttribute("port", Integer.toString(this.port));
            element.setAttribute("slotsAvailable", Integer.toString(this.getSlotsAvailable()));
            element.setAttribute("currentlyPlaying", Integer.toString(this.getNumberOfLivingHumanPlayers()));
            element.setAttribute("isGameStarted", Boolean.toString(this.gameState != GameState.STARTING_GAME));
            element.setAttribute("version", FreeCol.getVersion());
            element.setAttribute("gameState", Integer.toString(this.getGameState().ordinal()));
            Element reply = mc.ask(element);
            if (reply != null && reply.getTagName().equals("noRouteToServer")) {
                throw new NoRouteToServerException();
            }
        }
        catch (IOException e) {
            logger.warning("Network error while communicating with the meta-server.");
            return;
        }
        finally {
            try {
                mc.close();
            }
            catch (IOException e) {
                logger.warning("Could not close connection to meta-server.");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromMetaServer() {
        Connection mc;
        if (!this.publicServer) {
            return;
        }
        try {
            mc = new Connection("meta.freecol.org", 3540, null, "FreeColServer:");
        }
        catch (IOException e) {
            logger.warning("Could not connect to meta-server.");
            return;
        }
        try {
            Element element = DOMMessage.createNewRootElement("remove");
            element.setAttribute("port", Integer.toString(this.port));
            mc.send(element);
        }
        catch (IOException e) {
            logger.warning("Network error while communicating with the meta-server.");
            return;
        }
        finally {
            try {
                mc.close();
            }
            catch (IOException e) {
                logger.warning("Could not close connection to meta-server.");
                return;
            }
        }
    }

    public int getSlotsAvailable() {
        List<Player> players = this.game.getPlayers();
        int n = 0;
        for (int i = 0; i < players.size(); ++i) {
            ServerPlayer p = (ServerPlayer)players.get(i);
            if (!p.isEuropean() || p.isREF() || p.isDead() || p.isConnected() && !p.isAI()) continue;
            ++n;
        }
        return n;
    }

    public int getNumberOfLivingHumanPlayers() {
        List<Player> players = this.game.getPlayers();
        int n = 0;
        for (int i = 0; i < players.size(); ++i) {
            if (((ServerPlayer)players.get(i)).isAI() || ((ServerPlayer)players.get(i)).isDead() || !((ServerPlayer)players.get(i)).isConnected()) continue;
            ++n;
        }
        return n;
    }

    public String getOwner() {
        return this.owner;
    }

    public void saveGame(File file, String username, OptionGroup options) throws IOException {
        this.saveGame(file, username, options, null);
    }

    public void saveGame(File file, String username, OptionGroup options, BufferedImage image) throws IOException {
        ServerGame game = this.getGame();
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        ZipOutputStream fos = null;
        try {
            fos = new JarOutputStream(new FileOutputStream(file));
            if (image != null) {
                ((JarOutputStream)fos).putNextEntry(new JarEntry("thumbnail.png"));
                ImageIO.write((RenderedImage)image, "png", fos);
                fos.closeEntry();
            }
            if (options != null) {
                ((JarOutputStream)fos).putNextEntry(new JarEntry("client-options.xml"));
                options.save(fos);
                fos.closeEntry();
            }
            Properties properties = new Properties();
            properties.put("map.width", Integer.toString(game.getMap().getWidth()));
            properties.put("map.height", Integer.toString(game.getMap().getHeight()));
            ((JarOutputStream)fos).putNextEntry(new JarEntry("savegame.properties"));
            properties.store(fos, null);
            fos.closeEntry();
            ((JarOutputStream)fos).putNextEntry(new JarEntry("savegame.xml"));
            XMLStreamWriter xsw = xof.createXMLStreamWriter(fos, "UTF-8");
            xsw.writeStartDocument("UTF-8", "1.0");
            xsw.writeComment("Game version: " + FreeCol.getRevision());
            xsw.writeStartElement("savedGame");
            xsw.writeAttribute("owner", username);
            xsw.writeAttribute("publicServer", Boolean.toString(this.publicServer));
            xsw.writeAttribute("singleplayer", Boolean.toString(this.singleplayer));
            xsw.writeAttribute("version", Integer.toString(11));
            xsw.writeAttribute("randomState", this.getRandomState(this.random));
            if (this.getActiveUnit() != null) {
                xsw.writeAttribute("activeUnit", this.getActiveUnit().getId());
            }
            xsw.writeStartElement("serverObjects");
            for (ServerModelObject smo : game.getServerModelObjects()) {
                xsw.writeStartElement(smo.getServerXMLElementTagName());
                xsw.writeAttribute("ID", ((FreeColGameObject)((Object)smo)).getId());
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            game.toXML(xsw, null, true, true);
            if (this.aiMain != null) {
                this.aiMain.toXML(xsw);
            }
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException("XMLStreamException.");
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException(e.toString());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static XMLStream createXMLStreamReader(FreeColSavegameFile fis) throws IOException {
        return new XMLStream(fis.getSavegameInputStream());
    }

    public String loadGame(FreeColSavegameFile fis) throws IOException, FreeColException {
        return this.loadGame(fis, null);
    }

    public String loadGame(FreeColSavegameFile fis, Specification specification) throws IOException, FreeColException {
        boolean doNotLoadAI = false;
        XMLStream xs = null;
        try {
            xs = FreeColServer.createXMLStreamReader(fis);
            XMLStreamReader xsr = xs.getXMLStreamReader();
            xsr.nextTag();
            int savegameVersion = FreeColServer.getSavegameVersion(xsr);
            logger.info("Found savegame version " + savegameVersion);
            this.singleplayer = FreeColObject.getAttribute(xsr, "singleplayer", true);
            this.publicServer = FreeColObject.getAttribute(xsr, "publicServer", false);
            String randomState = xsr.getAttributeValue(null, "randomState");
            if (randomState != null && randomState.length() > 0) {
                try {
                    this.random = this.restoreRandomState(randomState);
                }
                catch (IOException e) {
                    logger.warning("Failed to restore random state, ignoring!");
                }
            }
            String owner = xsr.getAttributeValue(null, "owner");
            String active = xsr.getAttributeValue(null, "activeUnit");
            ArrayList<String> serverStrings = null;
            this.aiMain = null;
            while (xsr.nextTag() != 2) {
                if (xsr.getLocalName().equals("serverObjects")) {
                    serverStrings = new ArrayList<String>();
                    while (xsr.nextTag() != 2) {
                        serverStrings.add(xsr.getLocalName());
                        serverStrings.add(xsr.getAttributeValue(null, "ID"));
                        xsr.nextTag();
                    }
                    if (savegameVersion >= 11) continue;
                    FreeColServer.v11FixServerObjects(serverStrings, fis);
                    continue;
                }
                if (xsr.getLocalName().equals(Game.getXMLElementTagName())) {
                    if (savegameVersion < 9 && specification == null) {
                        logger.info("Compatibility code: providing fresh specification.");
                        specification = new FreeColTcFile("freecol").getSpecification();
                    }
                    this.game = new ServerGame(null, xsr, serverStrings, specification);
                    if (savegameVersion < 9) {
                        logger.info("Compatibility code: applying difficulty level.");
                        OptionGroup level = this.game.getDifficultyLevel();
                        if (level == null) {
                            try {
                                int levelIndex = this.game.getSpecification().getInteger("model.option.difficulty");
                                level = this.game.getSpecification().getDifficultyLevels().get(levelIndex);
                            }
                            catch (Exception e) {
                                level = this.game.getSpecification().getDifficultyLevel("model.difficulty.medium");
                            }
                        }
                        logger.fine("Difficulty level is " + level.getId());
                        this.game.getSpecification().applyDifficultyLevel(level);
                    }
                    this.game.setCurrentPlayer(null);
                    this.gameState = GameState.IN_GAME;
                    this.integrity = this.game.checkIntegrity();
                    continue;
                }
                if (xsr.getLocalName().equals(AIMain.getXMLElementTagName())) {
                    if (doNotLoadAI) {
                        this.aiMain = new AIMain(this);
                        this.game.setFreeColGameObjectListener(this.aiMain);
                        break;
                    }
                    this.aiMain = new AIMain(this, xsr);
                    if (!this.aiMain.checkIntegrity()) {
                        this.aiMain = new AIMain(this);
                        logger.info("Replacing AIMain.");
                    }
                    this.game.setFreeColGameObjectListener(this.aiMain);
                    continue;
                }
                if (xsr.getLocalName().equals("marketdata")) {
                    logger.info("Ignoring market data for compatibility.");
                    continue;
                }
                throw new XMLStreamException("Unknown tag: " + xsr.getLocalName());
            }
            for (Tile tile : this.game.getMap().getAllTiles()) {
                TerrainGenerator.encodeStyle(tile);
            }
            Collections.sort(this.game.getPlayers(), Player.playerComparator);
            if (this.aiMain == null) {
                this.aiMain = new AIMain(this);
                this.game.setFreeColGameObjectListener(this.aiMain);
            }
            Iterator<Player> playerIterator = this.game.getPlayerIterator();
            while (playerIterator.hasNext()) {
                ServerPlayer player = (ServerPlayer)playerIterator.next();
                if (!player.isAI()) continue;
                DummyConnection theConnection = new DummyConnection("Server-Server-" + player.getName(), this.getInGameInputHandler());
                DummyConnection aiConnection = new DummyConnection("Server-AI-" + player.getName(), new AIInGameInputHandler(this, player, this.aiMain));
                aiConnection.setOutgoingMessageHandler(theConnection);
                theConnection.setOutgoingMessageHandler(aiConnection);
                this.getServer().addDummyConnection(theConnection);
                player.setConnection(theConnection);
                player.setConnected(true);
            }
            xs.close();
            if (specification == null) {
                specification = this.getSpecification();
            }
            if (!specification.hasOption("model.option.monarchSupport")) {
                this.addIntegerOption("model.option.monarchSupport", 2);
            }
            if (!specification.hasOption("model.option.buildOnNativeLand")) {
                this.addStringOption("model.option.buildOnNativeLand", "model.option.buildOnNativeLand.never");
            }
            if (!specification.hasOption("model.option.guiShowDemands")) {
                this.addBooleanOption("model.option.guiShowDemands", true);
            }
            if (!specification.hasOption("model.option.guiShowGifts")) {
                this.addBooleanOption("model.option.guiShowGifts", true);
            }
            if (!specification.hasOption("model.option.guiShowGoodsMovement")) {
                this.addBooleanOption("model.option.guiShowGoodsMovement", false);
            }
            if (!specification.hasOption("model.option.amphibiousMoves")) {
                this.addBooleanOption("model.option.amphibiousMoves", false);
                this.game.getSpecification().addModifier(new Modifier("model.modifier.amphibiousAttack", Specification.AMPHIBIOUS_ATTACK_PENALTY_SOURCE, -75.0f, Modifier.Type.PERCENTAGE));
            }
            if (!specification.hasOption("model.option.settlementActionsContactChief")) {
                this.addBooleanOption("model.option.settlementActionsContactChief", false);
            }
            this.setActiveUnit(active == null || this.game == null ? null : (Unit)this.game.getFreeColGameObjectSafely(active));
            String string = owner;
            return string;
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException("XMLStreamException.");
        }
        catch (FreeColException fe) {
            StringWriter sw = new StringWriter();
            fe.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw fe;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException(e.toString());
        }
        finally {
            xs.close();
        }
    }

    private void addBooleanOption(String id, boolean defaultValue) {
        Specification spec = this.game.getSpecification();
        if (!spec.hasOption(id)) {
            BooleanOption op = new BooleanOption(id);
            op.setValue(defaultValue);
            spec.addAbstractOption(op);
        }
    }

    private void addIntegerOption(String id, int defaultValue) {
        Specification spec = this.game.getSpecification();
        if (!spec.hasOption(id)) {
            IntegerOption op = new IntegerOption(id);
            op.setValue(defaultValue);
            spec.addAbstractOption(op);
        }
    }

    private void addStringOption(String id, String defaultValue) {
        Specification spec = this.game.getSpecification();
        if (!spec.hasOption(id)) {
            StringOption op = new StringOption(id);
            op.setValue(defaultValue);
            spec.addAbstractOption(op);
        }
    }

    public static int getSavegameVersion(XMLStreamReader xsr) throws FreeColException {
        String version = xsr.getAttributeValue(null, "version");
        int savegameVersion = 0;
        try {
            savegameVersion = Integer.parseInt(version);
        }
        catch (Exception e) {
            throw new FreeColException("incompatibleVersions");
        }
        if (savegameVersion < 1) {
            throw new FreeColException("incompatibleVersions");
        }
        return savegameVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void v11FixServerObjects(List<String> serverStrings, FreeColSavegameFile fis) {
        XMLStream xs = null;
        try {
            xs = FreeColServer.createXMLStreamReader(fis);
            XMLStreamReader xsr = xs.getXMLStreamReader();
            xsr.nextTag();
            String owner = xsr.getAttributeValue(null, "owner");
            while (xsr.nextTag() != 2) {
                if (xsr.getLocalName().equals(Game.getXMLElementTagName())) {
                    ServerGame game = new ServerGame(null, xsr, new ArrayList<String>(serverStrings), new FreeColTcFile("freecol").getSpecification());
                    Iterator<FreeColGameObject> objs = game.getFreeColGameObjectIterator();
                    while (objs.hasNext()) {
                        FreeColGameObject fcgo = objs.next();
                        if (serverStrings.contains(fcgo.getId())) continue;
                        if (fcgo instanceof Europe) {
                            serverStrings.add("serverEurope");
                        } else if (fcgo instanceof Colony) {
                            serverStrings.add("serverColony");
                        } else if (fcgo instanceof Building) {
                            serverStrings.add("serverBuilding");
                        } else if (fcgo instanceof ColonyTile) {
                            serverStrings.add("serverColonyTile");
                        } else if (fcgo instanceof IndianSettlement) {
                            serverStrings.add("serverIndianSettlement");
                        } else {
                            if (!(fcgo instanceof Unit)) continue;
                            serverStrings.add("serverUnit");
                        }
                        serverStrings.add(fcgo.getId());
                    }
                    break;
                }
                while (xsr.nextTag() != 2) {
                    xsr.nextTag();
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (xs != null) {
                xs.close();
            }
        }
    }

    public static void removeAutosaves(String prefix) {
        for (File autosaveFile : FreeCol.getAutosaveDirectory().listFiles()) {
            if (!autosaveFile.getName().startsWith(prefix)) continue;
            autosaveFile.delete();
        }
    }

    public void setSingleplayer(boolean singleplayer) {
        this.singleplayer = singleplayer;
    }

    public boolean isSingleplayer() {
        return this.singleplayer;
    }

    public void revealMapForAllPlayers() {
        ServerPlayer player;
        Iterator<Player> playerIterator = this.getGame().getPlayerIterator();
        while (playerIterator.hasNext()) {
            player = (ServerPlayer)playerIterator.next();
            player.revealMap();
        }
        playerIterator = this.getGame().getPlayerIterator();
        while (playerIterator.hasNext()) {
            player = (ServerPlayer)playerIterator.next();
            Element reconnect = DOMMessage.createNewRootElement("reconnect");
            try {
                player.getConnection().send(reconnect);
            }
            catch (IOException ex) {
                logger.warning("Could not send reconnect message!");
            }
        }
    }

    public ServerPlayer getPlayer(Connection connection) {
        Iterator<Player> playerIterator = this.getGame().getPlayerIterator();
        while (playerIterator.hasNext()) {
            ServerPlayer player = (ServerPlayer)playerIterator.next();
            if (player.getConnection() != connection) continue;
            return player;
        }
        return null;
    }

    public UserConnectionHandler getUserConnectionHandler() {
        return this.userConnectionHandler;
    }

    public Controller getController() {
        if (this.getGameState() == GameState.IN_GAME) {
            return this.inGameController;
        }
        return this.preGameController;
    }

    public PreGameInputHandler getPreGameInputHandler() {
        return this.preGameInputHandler;
    }

    public InGameInputHandler getInGameInputHandler() {
        return this.inGameInputHandler;
    }

    public InGameController getInGameController() {
        return this.inGameController;
    }

    public ServerGame getGame() {
        return this.game;
    }

    public void setAIMain(AIMain aiMain) {
        this.aiMain = aiMain;
    }

    public AIMain getAIMain() {
        return this.aiMain;
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public void setGameState(GameState state) {
        this.gameState = state;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean getIntegrity() {
        return this.integrity;
    }

    public Random getServerRandom() {
        return this.random;
    }

    public Unit getUnitSafely(String unitId, ServerPlayer serverPlayer) throws IllegalStateException {
        Game game = serverPlayer.getGame();
        if (unitId == null || unitId.length() == 0) {
            throw new IllegalStateException("ID must not be empty.");
        }
        FreeColGameObject obj = game.getFreeColGameObjectSafely(unitId);
        if (obj == null) {
            throw new IllegalStateException("Not an object: " + unitId);
        }
        if (!(obj instanceof Unit)) {
            throw new IllegalStateException("Unit expected,  got " + obj.getClass() + ": " + unitId);
        }
        Unit unit = (Unit)obj;
        if (unit.getOwner() != serverPlayer) {
            throw new IllegalStateException("Not the owner of unit: " + unitId);
        }
        return unit;
    }

    public Settlement getAdjacentSettlementSafely(String settlementId, Unit unit) throws IllegalStateException {
        Game game = unit.getOwner().getGame();
        if (settlementId == null || settlementId.length() == 0) {
            throw new IllegalStateException("ID must not be empty.");
        }
        if (!(game.getFreeColGameObject(settlementId) instanceof Settlement)) {
            throw new IllegalStateException("Not a settlement ID: " + settlementId);
        }
        Settlement settlement = (Settlement)game.getFreeColGameObject(settlementId);
        if (settlement.getTile() == null) {
            throw new IllegalStateException("Settlement is not on the map: " + settlementId);
        }
        if (unit.getTile() == null) {
            throw new IllegalStateException("Unit is not on the map: " + unit.getId());
        }
        if (unit.getTile().getDistanceTo(settlement.getTile()) > 1) {
            throw new IllegalStateException("Unit " + unit.getId() + " is not adjacent to settlement: " + settlementId);
        }
        if (unit.getOwner() == settlement.getOwner()) {
            throw new IllegalStateException("Unit: " + unit.getId() + " and settlement: " + settlementId + " are both owned by player: " + unit.getOwner().getId());
        }
        return settlement;
    }

    public IndianSettlement getAdjacentIndianSettlementSafely(String settlementId, Unit unit) throws IllegalStateException {
        Settlement settlement = this.getAdjacentSettlementSafely(settlementId, unit);
        if (!(settlement instanceof IndianSettlement)) {
            throw new IllegalStateException("Not an indianSettlement: " + settlementId);
        }
        if (!unit.getOwner().hasContacted(settlement.getOwner())) {
            throw new IllegalStateException("Player has not established contact with the " + settlement.getOwner().getNation());
        }
        return (IndianSettlement)settlement;
    }

    public ServerPlayer addAIPlayer(Nation nation) {
        String name = nation.getRulerNameKey();
        DummyConnection theConnection = new DummyConnection("Server connection - " + name, this.getInGameInputHandler());
        ServerPlayer aiPlayer = new ServerPlayer(this.getGame(), name, false, nation, null, theConnection);
        aiPlayer.setAI(true);
        DummyConnection aiConnection = new DummyConnection("AI connection - " + name, new AIInGameInputHandler(this, aiPlayer, this.getAIMain()));
        aiConnection.setOutgoingMessageHandler(theConnection);
        theConnection.setOutgoingMessageHandler(aiConnection);
        this.getServer().addDummyConnection(theConnection);
        this.getGame().addPlayer(aiPlayer);
        Element addNewPlayer = DOMMessage.createNewRootElement("addPlayer");
        addNewPlayer.appendChild(aiPlayer.toXMLElement(null, addNewPlayer.getOwnerDocument()));
        this.getServer().sendToAll(addNewPlayer, theConnection);
        return aiPlayer;
    }

    public AIPlayer getAIPlayer(Player player) {
        return this.getAIMain().getAIPlayer(player);
    }

    public List<HighScore> getHighScores() {
        if (this.highScores == null) {
            try {
                this.loadHighScores();
            }
            catch (Exception e) {
                logger.warning(e.toString());
                this.highScores = new ArrayList<HighScore>();
            }
        }
        return this.highScores;
    }

    public boolean newHighScore(Player player) {
        this.getHighScores();
        if (!this.highScores.isEmpty() && player.getScore() <= this.highScores.get(this.highScores.size() - 1).getScore()) {
            return false;
        }
        this.highScores.add(new HighScore(player, new Date()));
        Collections.sort(this.highScores, highScoreComparator);
        if (this.highScores.size() == 10) {
            this.highScores.remove(9);
        }
        return true;
    }

    public void saveHighScores() throws IOException {
        if (this.highScores == null || this.highScores.isEmpty()) {
            return;
        }
        Collections.sort(this.highScores, highScoreComparator);
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(FreeCol.getDataDirectory(), HIGH_SCORE_FILE));
            XMLStreamWriter xsw = xof.createXMLStreamWriter(fos, "UTF-8");
            xsw.writeStartDocument("UTF-8", "1.0");
            xsw.writeStartElement("highScores");
            int count = 0;
            for (HighScore score : this.highScores) {
                score.toXML(xsw);
                if (++count != 10) continue;
                break;
            }
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException("XMLStreamException.");
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException(e.toString());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void loadHighScores() throws IOException, FreeColException {
        this.highScores = new ArrayList<HighScore>();
        File hsf = new File(FreeCol.getDataDirectory(), HIGH_SCORE_FILE);
        if (!hsf.exists()) {
            return;
        }
        XMLInputFactory xif = XMLInputFactory.newInstance();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(hsf);
            XMLStreamReader xsr = xif.createXMLStreamReader(fis, "UTF-8");
            xsr.nextTag();
            while (xsr.nextTag() != 2) {
                if (!xsr.getLocalName().equals("highScore")) continue;
                this.highScores.add(new HighScore(xsr));
            }
            xsr.close();
            Collections.sort(this.highScores, highScoreComparator);
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException("XMLStreamException.");
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException(e.toString());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public Unit getActiveUnit() {
        return this.activeUnit;
    }

    public void setActiveUnit(Unit unit) {
        this.activeUnit = unit;
    }

    public synchronized String getRandomState(Random random) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(random);
            oos.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("IO exception in memory!?", e);
        }
        byte[] bytes = bos.toByteArray();
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(HEX_DIGITS.charAt(b >> 4 & 0xF));
            sb.append(HEX_DIGITS.charAt(b & 0xF));
        }
        return sb.toString();
    }

    public synchronized Random restoreRandomState(String state) throws IOException {
        byte[] bytes = new byte[state.length() / 2];
        int pos = 0;
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)HEX_DIGITS.indexOf(state.charAt(pos++));
            int n = i;
            bytes[n] = (byte)(bytes[n] << 4);
            int n2 = i++;
            bytes[n2] = (byte)(bytes[n2] | (byte)HEX_DIGITS.indexOf(state.charAt(pos++)));
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            return (Random)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to restore ServerRandom!");
        }
    }

    public void shutdown() {
        this.server.shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameState {
        STARTING_GAME,
        IN_GAME,
        ENDING_GAME;

    }
}

