/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.sf.freecol.common.resources.ColorResource;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.ResourceManager;

public class ChipResource
extends Resource {
    public static final String SCHEME = "chip:";
    public static final int WIDTH = 10;
    public static final int HEIGHT = 17;
    private Color foreground = Color.BLACK;
    private Color background = Color.WHITE;
    private BufferedImage image = null;
    private final String type;
    private Map<Double, Image> scaledImages = new HashMap<Double, Image>();

    private ChipResource(String type, Color bg, Color fg) {
        this.type = type;
        this.background = bg;
        this.foreground = fg;
    }

    ChipResource(URI resourceLocator) {
        super(resourceLocator);
        String[] parts = resourceLocator.getSchemeSpecificPart().split(":");
        this.type = parts[1];
        this.background = ColorResource.getColor(parts[2]);
        this.foreground = ColorResource.getColor(parts[3]);
    }

    public void preload() {
    }

    public final Color getForeground() {
        return this.foreground;
    }

    public final void setForeground(Color newForeground) {
        this.foreground = newForeground;
        this.image = null;
    }

    public final Color getBackground() {
        return this.background;
    }

    public final void setBackground(Color newBackground) {
        this.background = newBackground;
        this.image = null;
    }

    public final String getType() {
        return this.type;
    }

    public final Image getImage() {
        if (this.image == null) {
            this.image = new BufferedImage(10, 17, 2);
            if ("color".equals(this.type)) {
                this.createColorChip();
            } else if ("mission".equals(this.type)) {
                this.createMissionChip();
            } else if ("alarm.visited".equals(this.type)) {
                this.createAlarmChip(true);
            } else if ("alarm.unvisited".equals(this.type)) {
                this.createAlarmChip(false);
            }
        }
        return this.image;
    }

    public final Image getImage(double scale) {
        Image scaledImage = this.scaledImages.get(scale);
        if (scaledImage == null) {
            Image image = this.getImage();
            int width = (int)(10.0 * scale);
            int height = (int)(17.0 * scale);
            scaledImage = image.getScaledInstance(width, height, 4);
            this.scaledImages.put(scale, scaledImage);
        }
        return scaledImage;
    }

    private void createColorChip() {
        Graphics2D g = (Graphics2D)this.image.getGraphics();
        int bw = 1;
        g.setColor(this.foreground);
        g.fillRect(0, 0, 10, 17);
        g.setColor(this.background);
        g.fillRect(bw, bw, 10 - 2 * bw, 17 - 2 * bw);
    }

    private void createMissionChip() {
        Graphics2D g = (Graphics2D)this.image.getGraphics();
        int bw = 1;
        int dw = 2;
        g.setColor(this.background);
        g.fillRect(0, 0, 10, 17);
        GeneralPath cross = new GeneralPath(0);
        cross.moveTo(2 * dw, bw);
        cross.lineTo(3 * dw, bw);
        cross.lineTo(3 * dw, 2 * dw);
        cross.lineTo(10 - bw, 2 * dw);
        cross.lineTo(10 - bw, 3 * dw);
        cross.lineTo(3 * dw, 3 * dw);
        cross.lineTo(3 * dw, 17 - bw);
        cross.lineTo(2 * dw, 17 - bw);
        cross.lineTo(2 * dw, 3 * dw);
        cross.lineTo(bw, 3 * dw);
        cross.lineTo(bw, 2 * dw);
        cross.lineTo(2 * dw, 2 * dw);
        cross.closePath();
        g.setColor(this.foreground);
        g.fill(cross);
    }

    private void createAlarmChip(boolean visited) {
        Graphics2D g = (Graphics2D)this.image.getGraphics();
        int bw = 1;
        int dw = 2;
        this.createColorChip();
        g.setColor(this.foreground);
        if (visited) {
            g.fillRect(2 * dw, bw + dw, dw, 3 * dw + bw);
        } else {
            g.fillRect(bw + dw, bw + dw, 2 * dw, dw);
            g.fillRect(3 * dw, 2 * dw, dw, dw);
            g.fillRect(2 * dw, 3 * dw, bw + dw, bw);
            g.fillRect(2 * dw, 3 * dw + bw, dw, bw + dw);
        }
        g.fillRect(2 * dw, 17 - 3 * dw, dw, dw);
    }

    public static ChipResource colorChip(Color color) {
        return new ChipResource("color", color, Color.BLACK);
    }

    public static ChipResource missionChip(Color color, boolean expert) {
        return new ChipResource("mission", expert ? ResourceManager.getColor("expertMission.background.color") : ResourceManager.getColor("mission.background.color"), color);
    }
}

