/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.option.IntegerOption;

public class PercentageOption
extends IntegerOption {
    private static Logger logger = Logger.getLogger(PercentageOption.class.getName());

    public PercentageOption(XMLStreamReader in) throws XMLStreamException {
        super(in);
        this.setMinimumValue(0);
        this.setMaximumValue(100);
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, PercentageOption.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("value", Integer.toString(this.getValue()));
        out.writeAttribute("previewEnabled", Boolean.toString(this.isPreviewEnabled()));
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        String defaultValue = in.getAttributeValue(null, "defaultValue");
        String value = in.getAttributeValue(null, "value");
        String previewEnabled = in.getAttributeValue(null, "previewEnabled");
        if (id == null && this.getId().equals("NO_ID")) {
            throw new XMLStreamException("invalid <" + PercentageOption.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        if (defaultValue == null && value == null) {
            throw new XMLStreamException("invalid <" + PercentageOption.getXMLElementTagName() + "> tag : no value nor default value found.");
        }
        if (previewEnabled != null && !previewEnabled.equals("true") && !previewEnabled.equals("false")) {
            throw new XMLStreamException("invalid <" + PercentageOption.getXMLElementTagName() + "> tag : previewEnabled should be true or false.");
        }
        if (this.getId() == "NO_ID") {
            this.setId(id);
        }
        if (value != null) {
            this.setValue(Integer.parseInt(value));
        } else {
            this.setValue(Integer.parseInt(defaultValue));
        }
        if (previewEnabled != null) {
            this.setPreviewEnabled(Boolean.parseBoolean(previewEnabled));
        }
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "percentageOption";
    }
}

