/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioMixerOption
extends AbstractOption<MixerWrapper> {
    private static Logger logger = Logger.getLogger(AudioMixerOption.class.getName());
    private static final Map<String, MixerWrapper> audioMixers = new HashMap<String, MixerWrapper>();
    public static final String AUTO = Messages.message("clientOptions.audio.audioMixer.automatic");
    private static final Mixer AUTODETECT_MIXER = AudioMixerOption.tryGetDefaultMixer();
    private static final MixerWrapper DEFAULT = new MixerWrapper(AUTO, AUTODETECT_MIXER != null ? AUTODETECT_MIXER.getMixerInfo() : null);
    private static Comparator<MixerWrapper> audioMixerComparator = new Comparator<MixerWrapper>(){

        @Override
        public int compare(MixerWrapper m1, MixerWrapper m2) {
            if (m1.equals(DEFAULT)) {
                if (m2.equals(DEFAULT)) {
                    return 0;
                }
                return -1;
            }
            if (m2.equals(DEFAULT)) {
                return 1;
            }
            return m1.getMixerInfo().getName().compareTo(m2.getMixerInfo().getName());
        }
    };
    private MixerWrapper value;

    private static Mixer tryGetDefaultMixer() {
        Mixer mixer = null;
        try {
            mixer = AudioSystem.getMixer(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return mixer;
    }

    public AudioMixerOption(XMLStreamReader in) throws XMLStreamException {
        super("NO_ID");
        this.readFromXML(in);
    }

    @Override
    public final MixerWrapper getValue() {
        return this.value;
    }

    @Override
    public final void setValue(MixerWrapper newValue) {
        MixerWrapper oldValue = this.value;
        if (newValue == null) {
            newValue = DEFAULT;
        }
        this.value = newValue;
        if (!newValue.equals(oldValue)) {
            this.firePropertyChange("value", oldValue, this.value);
        }
    }

    public MixerWrapper[] getOptions() {
        this.findAudioMixers();
        ArrayList<MixerWrapper> mixers = new ArrayList<MixerWrapper>(audioMixers.values());
        Collections.sort(mixers, audioMixerComparator);
        return mixers.toArray(new MixerWrapper[0]);
    }

    private void findAudioMixers() {
        audioMixers.clear();
        audioMixers.put(AUTO, DEFAULT);
        for (Mixer.Info mi : AudioSystem.getMixerInfo()) {
            audioMixers.put(mi.getName(), new MixerWrapper(mi.getName(), mi));
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, AudioMixerOption.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("value", this.getValue().getKey());
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        String defaultValue = in.getAttributeValue(null, "defaultValue");
        String value = in.getAttributeValue(null, "value");
        this.findAudioMixers();
        if (this.getId() == "NO_ID") {
            this.setId(id);
        }
        if (value != null) {
            this.setValue(audioMixers.get(value));
        } else if (defaultValue != null) {
            this.setValue(audioMixers.get(defaultValue));
        } else {
            this.setValue(DEFAULT);
        }
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "audioMixerOption";
    }

    public static class MixerWrapper {
        private String name;
        private Mixer.Info mixerInfo;

        MixerWrapper(String name, Mixer.Info mixerInfo) {
            this.name = name;
            this.mixerInfo = mixerInfo;
        }

        public String getKey() {
            return this.name;
        }

        public Mixer.Info getMixerInfo() {
            return this.mixerInfo;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o instanceof MixerWrapper) {
                return ((MixerWrapper)o).getKey().equals(this.getKey());
            }
            return false;
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }
    }
}

