/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class WorkMessage
extends DOMMessage {
    private String unitId;
    private String workLocationId;

    public WorkMessage(Unit unit, WorkLocation workLocation) {
        this.unitId = unit.getId();
        this.workLocationId = workLocation.getId();
    }

    public WorkMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.workLocationId = element.getAttribute("workLocation");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return DOMMessage.clientError("Unit is not on the map: " + this.unitId);
        }
        Colony colony = tile.getColony();
        if (colony == null) {
            return DOMMessage.clientError("Unit is not at a colony: " + this.unitId);
        }
        if (!(game.getFreeColGameObjectSafely(this.workLocationId) instanceof WorkLocation)) {
            return DOMMessage.clientError("Not a work location: " + this.workLocationId);
        }
        WorkLocation workLocation = (WorkLocation)game.getFreeColGameObjectSafely(this.workLocationId);
        if (workLocation.getColony() != colony) {
            return DOMMessage.clientError("Work location is not in the colony where the unit is: " + this.workLocationId);
        }
        if (!workLocation.canAdd(unit)) {
            return DOMMessage.clientError("Can not add " + unit.toString() + " to " + workLocation.toString());
        }
        return server.getInGameController().work(serverPlayer, unit, workLocation);
    }

    public Element toXMLElement() {
        Element result = WorkMessage.createNewRootElement(WorkMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("workLocation", this.workLocationId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "work";
    }
}

