/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetTradeRoutesMessage
extends DOMMessage {
    private static final String idPrefix = "shadow-";
    private List<TradeRoute> tradeRoutes;

    public SetTradeRoutesMessage(List<TradeRoute> tradeRoutes) {
        this.tradeRoutes = tradeRoutes;
    }

    public SetTradeRoutesMessage(Game game, Element element) {
        ArrayList<TradeRoute> newRoutes = new ArrayList<TradeRoute>();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            TradeRoute route = SetTradeRoutesMessage.tradeRouteFromElement(game, (Element)nodes.item(i));
            if (route == null) continue;
            newRoutes.add(route);
        }
        this.tradeRoutes = newRoutes;
    }

    public static TradeRoute tradeRouteFromElement(Game game, Element element) {
        String id = element.getAttribute("ID");
        element.setAttribute("ID", idPrefix + id);
        try {
            return new TradeRoute(game, element);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not build trade route " + id, e);
            return null;
        }
    }

    public static String getPrefix(TradeRoute route) {
        return route.getId().substring(0, idPrefix.length());
    }

    public static String removePrefix(TradeRoute route) {
        return route.getId().substring(idPrefix.length());
    }

    public static boolean hasPrefix(TradeRoute route) {
        return idPrefix.equals(SetTradeRoutesMessage.getPrefix(route));
    }

    public Element handle(FreeColServer server, Connection connection) {
        ServerGame game = server.getGame();
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ArrayList<TradeRoute> newRoutes = new ArrayList<TradeRoute>();
        String errors = "";
        for (TradeRoute tradeRoute : this.tradeRoutes) {
            if (tradeRoute.getId() == null || !SetTradeRoutesMessage.hasPrefix(tradeRoute)) {
                errors = errors + "Bogus route: " + tradeRoute.getId() + ". ";
                continue;
            }
            String id = SetTradeRoutesMessage.removePrefix(tradeRoute);
            if (!(game.getFreeColGameObject(id) instanceof TradeRoute)) {
                errors = errors + "Not a trade route: " + id + ". ";
                continue;
            }
            TradeRoute realRoute = (TradeRoute)game.getFreeColGameObject(id);
            if (tradeRoute.getOwner() == serverPlayer) continue;
            errors = errors + "Not your trade route: " + id + ". ";
        }
        if (!"".equals(errors)) {
            return DOMMessage.clientError(errors);
        }
        for (TradeRoute tradeRoute : this.tradeRoutes) {
            TradeRoute realRoute = (TradeRoute)game.getFreeColGameObject(SetTradeRoutesMessage.removePrefix(tradeRoute));
            realRoute.updateFrom(tradeRoute);
            newRoutes.add(realRoute);
            tradeRoute.dispose();
        }
        return server.getInGameController().setTradeRoutes(serverPlayer, newRoutes);
    }

    @Override
    public Element toXMLElement() {
        Element result = SetTradeRoutesMessage.createNewRootElement(SetTradeRoutesMessage.getXMLElementTagName());
        Document doc = result.getOwnerDocument();
        for (TradeRoute tradeRoute : this.tradeRoutes) {
            result.appendChild(tradeRoute.toXMLElement(null, doc));
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "setTradeRoutes";
    }
}

