/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

public class NetworkReplyObject {
    private Object response = null;
    private boolean responseGiven = false;
    private int networkReplyId;
    private boolean streamed;

    public NetworkReplyObject(int networkReplyId, boolean streamed) {
        this.networkReplyId = networkReplyId;
        this.streamed = streamed;
    }

    public boolean isStreamed() {
        return this.streamed;
    }

    public synchronized void setResponse(Object response) {
        if (response == null) {
            throw new NullPointerException();
        }
        this.response = response;
        this.responseGiven = true;
        this.notify();
    }

    public int getNetworkReplyId() {
        return this.networkReplyId;
    }

    public synchronized Object getResponse() {
        if (this.response == null) {
            try {
                while (!this.responseGiven) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.response;
    }

    public synchronized void interrupt() {
        this.responseGiven = true;
        this.notify();
    }
}

